/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.server.file;

import com.helpsystems.common.core.busobj.CommonVersionedObject;
import com.helpsystems.common.core.util.Equal;
import com.helpsystems.common.core.util.ValidationHelper;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.filechooser.FileSystemView;
import org.apache.log4j.Logger;

public class RemoteFile
extends CommonVersionedObject {
    private static final long serialVersionUID = 2428478086830628967L;
    private static final Logger logger = Logger.getLogger(RemoteFile.class);
    public static final int FLOPPY_DRIVE = 1024;
    public static final int DRIVE = 512;
    public static final int COMPUTER_NODE = 256;
    public static final int DIRECTORY = 128;
    public static final int FILE = 64;
    public static final int SHORTCUT = 2048;
    public static boolean skipFutureFailures = false;
    private static final FileSystemView FSV;
    private int type;
    private String realPath;
    private boolean exists;
    private long lastModified;
    private long size;
    private RemoteFile parentFile;
    private boolean hidden = false;
    private static Map<String, RemoteFile> rootCache;
    private static long lastCacheAccess;

    @Deprecated
    public RemoteFile() {
    }

    public RemoteFile(String string, RemoteFile remoteFile, int n, boolean bl, long l, boolean bl2) {
        this(string, remoteFile, n, bl, l, 0L, bl2);
    }

    public RemoteFile(String string, RemoteFile remoteFile, int n, boolean bl, long l, long l2, boolean bl2) {
        ValidationHelper.checkForNull((String)"Name", (Object)string);
        String string2 = "";
        String string3 = "";
        if (remoteFile != null) {
            string2 = remoteFile.getAbsolutePath().endsWith("/") ? remoteFile.getAbsolutePath() : remoteFile.getAbsolutePath() + "/";
            string3 = string2 + string;
        } else {
            string3 = n == 128 && string.length() == 0 ? "/" : string;
        }
        this.realPath = string3;
        this.parentFile = remoteFile;
        this.type = n;
        this.exists = bl;
        this.lastModified = l;
        this.size = l2;
        this.hidden = bl2;
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").indexOf("Win") > -1;
    }

    public RemoteFile(File file) {
        this(file, true);
    }

    public RemoteFile(File file, boolean bl) {
        if (RemoteFile.isWindows()) {
            try {
                this.realPath = file.getCanonicalPath();
            }
            catch (Throwable throwable) {
                this.realPath = file.getAbsolutePath();
            }
        } else {
            this.realPath = file.getAbsolutePath();
        }
        if (bl && FSV != null) {
            if (this.isFloppyDrive(file)) {
                this.type = 1024;
                if (file.isDirectory()) {
                    this.type |= 0x80;
                }
                this.exists = true;
                return;
            }
            if (RemoteFile.isComputerNode(file)) {
                this.type = 256;
                this.exists = true;
                return;
            }
            if (this.isDrive(file)) {
                this.type = 512;
                if (file.isDirectory()) {
                    this.type |= 0x80;
                }
                this.exists = true;
                return;
            }
        }
        if (file.isDirectory()) {
            this.type |= 0x80;
        }
        if (file.isFile()) {
            this.type |= 0x40;
        }
        this.exists = file.exists();
        this.lastModified = file.lastModified();
        this.size = file.length();
        this.hidden = file.isHidden();
        File file2 = new File(this.realPath);
        File file3 = file2.getParentFile();
        if (file3 != null) {
            this.parentFile = RemoteFile.cacheOrFetch(file3);
        }
    }

    private boolean isFloppyDrive(File file) {
        if (RemoteFile.isWindows()) {
            return FSV.isFloppyDrive(file);
        }
        return FSV.isFloppyDrive(file);
    }

    private static boolean isComputerNode(File file) {
        if (!skipFutureFailures) {
            try {
                return FSV.isComputerNode(file);
            }
            catch (NullPointerException nullPointerException) {
                skipFutureFailures = true;
            }
        }
        return RemoteFile.isWinComputerNode(file);
    }

    private boolean isDrive(File file) {
        if (RemoteFile.isWindows()) {
            return RemoteFile.isWinDrive(file);
        }
        return FSV.isDrive(file);
    }

    private static boolean isWinComputerNode(File file) {
        if (file == null) {
            return false;
        }
        String string = file.getPath();
        return !(!string.startsWith("\\\\") && !string.startsWith("//") || string.indexOf("\\", 2) >= 0 && string.indexOf("/", 2) >= 0);
    }

    private static boolean isWinDrive(File file) {
        if (file == null) {
            return false;
        }
        return file.getPath().endsWith(":\\") || file.getPath().endsWith(":/") || file.getPath().endsWith(":");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RemoteFile cacheOrFetch(File file) {
        Map<String, RemoteFile> map = rootCache;
        synchronized (map) {
            long l = System.currentTimeMillis();
            if (l - lastCacheAccess > 5000L) {
                rootCache.clear();
            }
            lastCacheAccess = l;
            String string = file.getAbsolutePath();
            RemoteFile remoteFile = rootCache.get(string);
            if (remoteFile != null) {
                return remoteFile;
            }
            remoteFile = new RemoteFile(file);
            rootCache.put(string, remoteFile);
            return remoteFile;
        }
    }

    public boolean exists() {
        return this.exists;
    }

    public String getAbsolutePath() {
        return this.realPath;
    }

    void setAbsolutePath(String string) {
        this.realPath = string;
    }

    public RemoteFile getParent() {
        return this.parentFile;
    }

    public int getType() {
        return this.type;
    }

    public boolean isComputerNode() {
        return (this.type & 0x100) > 0;
    }

    public boolean isFloppyDrive() {
        return (this.type & 0x400) > 0;
    }

    public boolean isDrive() {
        return (this.type & 0x200) > 0;
    }

    public boolean isDirectory() {
        return (this.type & 0x80) > 0;
    }

    public boolean isFile() {
        return (this.type & 0x40) > 0;
    }

    public boolean isShortcut() {
        return (this.type & 0x800) > 0;
    }

    public long lastModified() {
        return this.lastModified;
    }

    public long length() {
        return this.size;
    }

    public void setType(int n) {
        this.type = n;
    }

    public void setHidden(boolean bl) {
        this.hidden = bl;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isFile()) {
            stringBuffer.append("f  ");
        }
        if (this.isDirectory()) {
            stringBuffer.append("d  ");
        }
        stringBuffer.append(this.realPath);
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof RemoteFile)) {
            return false;
        }
        RemoteFile remoteFile = (RemoteFile)((Object)object);
        return Equal.isEqual((Object)this.getAbsolutePath(), (Object)remoteFile.getAbsolutePath()) && Equal.isEqual((long)this.getType(), (long)remoteFile.getType());
    }

    public void setLength(long l) {
        this.size = l;
    }

    static {
        FileSystemView fileSystemView = null;
        try {
            fileSystemView = FileSystemView.getFileSystemView();
            if (fileSystemView != null) {
                File file = new File(".");
                RemoteFile.isComputerNode(file);
            }
        }
        catch (Throwable throwable) {
            String string = "Unable to obtain a reference to the local file system view.";
            if (!"OS/400".equals(System.getProperty("os.name"))) {
                logger.debug((Object)string, throwable);
            }
        }
        finally {
            FSV = fileSystemView;
        }
        rootCache = new HashMap<String, RemoteFile>();
    }
}

