/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.server.file;

import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.common.server.file.FileBlock;
import com.helpsystems.common.server.file.FileHandle;
import java.io.IOException;
import java.io.InputStream;

public class FileHandleInputStream
extends InputStream {
    private FileHandle handle;

    public FileHandleInputStream(FileHandle fileHandle) {
        ValidationHelper.checkForNull((String)"File Handle", (Object)fileHandle);
        this.handle = fileHandle;
    }

    @Override
    public int available() throws IOException {
        return (int)(this.handle.getLength() - this.handle.getFilePointer());
    }

    @Override
    public void close() throws IOException {
        this.handle.close();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public long skip(long l) throws IOException {
        long l2 = Math.min(this.handle.getFilePointer() + l, this.handle.getLength());
        this.handle.seek(l2);
        return l2;
    }

    @Override
    public int read() throws IOException {
        FileBlock fileBlock = this.handle.read(1);
        int n = fileBlock.getLength();
        if (n > 0) {
            return fileBlock.getBytes()[0];
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        FileBlock fileBlock = this.handle.read(byArray.length);
        int n = fileBlock.getLength();
        if (n > 0) {
            System.arraycopy(fileBlock.getBytes(), 0, byArray, 0, n);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        FileBlock fileBlock = this.handle.read(n2);
        int n3 = fileBlock.getLength();
        if (n3 > 0) {
            System.arraycopy(fileBlock.getBytes(), 0, byArray, n, n3);
        }
        return n3;
    }
}

