/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.server.auth;

import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.server.auth.AbstractLoginHandlerAM;
import java.util.Hashtable;
import javax.naming.AuthenticationException;
import javax.naming.directory.InitialDirContext;
import org.apache.log4j.Logger;

public class LdapLoginHandlerAM
extends AbstractLoginHandlerAM {
    private static final Logger logger = Logger.getLogger(LdapLoginHandlerAM.class);
    private static final String ERROR_PREFIX = "AcceptSecurityContext error, data ";
    private static final String[][] ERROR_TABLE = new String[][]{{"AcceptSecurityContext error, data 525", "User was not found"}, {"AcceptSecurityContext error, data 52e", "Invalid credentials"}, {"AcceptSecurityContext error, data 530", "Not permitted to logon at this time"}, {"AcceptSecurityContext error, data 532", "Password expired"}, {"AcceptSecurityContext error, data 533", "Account disabled"}, {"AcceptSecurityContext error, data 701", "Account expired"}, {"AcceptSecurityContext error, data 773", "User must reset password"}};
    protected String principalSuffix;

    public LdapLoginHandlerAM(String string) {
        super(string);
    }

    public void setPrincipalSuffix(String string) {
        this.principalSuffix = string;
    }

    @Override
    public String validateUser(String string, char[] cArray) throws ResourceUnavailableException {
        if (string == null || string.length() == 0) {
            return "Username is missing";
        }
        String string2 = string;
        try {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            hashtable.put("java.naming.provider.url", "ldap://" + this.serverName);
            hashtable.put("java.naming.security.authentication", "simple");
            if (this.principalSuffix != null) {
                string2 = string2 + this.principalSuffix;
            }
            hashtable.put("java.naming.security.principal", string2);
            hashtable.put("java.naming.security.credentials", new String(cArray));
            InitialDirContext initialDirContext = new InitialDirContext(hashtable);
            if (initialDirContext != null) {
                return null;
            }
            return "Unable to log in, no context returned.";
        }
        catch (AuthenticationException authenticationException) {
            String string3 = authenticationException.getMessage();
            if (string3 == null) {
                throw new ResourceUnavailableException("Unable to log in", (Throwable)authenticationException);
            }
            for (int i = 0; i < ERROR_TABLE.length; ++i) {
                String string4 = ERROR_TABLE[i][0];
                String string5 = ERROR_TABLE[i][1];
                if (string3.indexOf(string4) <= -1) continue;
                string3 = string5 + " (" + string3 + ")";
                break;
            }
            logger.trace((Object)("Login failed for user '" + string2 + "'"), (Throwable)authenticationException);
            return string3;
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Unable to connect to login server " + this.serverName, (Throwable)exception);
        }
    }

    @Override
    public boolean isSystemAvailable() {
        if (!super.isSystemAvailable()) {
            return false;
        }
        return this.testPort(443);
    }
}

