/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.server.access;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.DataSet;
import com.helpsystems.common.core.access.DataSetException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.access.dataset.ArrayDataSet;
import com.helpsystems.common.core.access.dataset.CachingDataSet;
import com.helpsystems.common.core.busobj.Proxy;
import com.helpsystems.common.core.busobj.UserIdentity;
import com.helpsystems.common.core.dm.IUserListManagerDSP;
import com.helpsystems.common.core.filter.DataFilter;
import com.helpsystems.common.core.filter.GenericSortField;
import com.helpsystems.common.core.filter.SortField;
import com.helpsystems.common.core.util.ValidationHelper;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class PasswdUserListDM
extends AbstractManager
implements IUserListManagerDSP {
    public static final String DEFAULT_PATH = "/etc/passwd";
    public static final char FIELD_DELIMITER = ':';
    private String path;
    private char delimiter;

    public PasswdUserListDM() {
        this(DEFAULT_PATH, ':');
    }

    public PasswdUserListDM(String string, char c) {
        ValidationHelper.checkForNull((String)"Path", (Object)string);
        this.path = string;
        this.delimiter = c;
        this.setName("COMMON.UserListManagerDSP");
    }

    public String getPath() {
        return this.path;
    }

    public String[] getUsers(UserIdentity userIdentity, String string) throws ResourceUnavailableException {
        String[] stringArray;
        List<Proxy> list = null;
        try {
            list = this.listUsers();
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Unable to obtain a user list", (Throwable)exception);
        }
        if (string != null && string.length() > 0) {
            stringArray = string.toLowerCase();
            Iterator<Proxy> iterator = list.iterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next().getName();
                String string3 = string2.toLowerCase();
                if (string3.startsWith((String)stringArray)) continue;
                iterator.remove();
            }
        }
        stringArray = new String[list.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = list.get(i).getName();
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Proxy> listUsers() throws IOException {
        ArrayList<Proxy> arrayList = new ArrayList<Proxy>();
        String string = Character.toString(this.delimiter);
        FileReader fileReader = null;
        try {
            Object object;
            fileReader = new FileReader(this.path);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((object = bufferedReader.readLine()) != null) {
                String string2;
                String[] stringArray = ((String)object).split(string);
                if (stringArray.length <= 1 || (string2 = stringArray[0]).length() == 0 || string2.length() == 1 && !Character.isLetterOrDigit(string2.charAt(0))) continue;
                String string3 = null;
                if (stringArray.length >= 5) {
                    string3 = stringArray[4];
                }
                Proxy proxy = new Proxy();
                proxy.setName(string2);
                if (string3 != null && string3.length() > 0) {
                    String[] stringArray2 = string3.split(",");
                    if (stringArray2.length > 0) {
                        proxy.setDescription(stringArray2[0]);
                    } else {
                        proxy.setDescription("");
                    }
                }
                arrayList.add(proxy);
            }
            object = arrayList;
            return object;
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public DataSet<Proxy> getDataSet(UserIdentity userIdentity, DataFilter dataFilter, SortField sortField) throws DataSetException, ResourceUnavailableException {
        try {
            List<Proxy> list = this.listUsers();
            Object[] objectArray = new Proxy[list.size()];
            list.toArray(objectArray);
            SortField sortField2 = sortField;
            if (sortField == null) {
                sortField2 = new GenericSortField(10101, 0);
            }
            Proxy.sort((Proxy[])objectArray, (SortField)sortField2);
            return new ArrayDataSet(objectArray);
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Unable to obtain a list of users.", (Throwable)exception);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        String string = DEFAULT_PATH;
        String string2 = null;
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        if (stringArray.length > 1) {
            string2 = stringArray[1];
        }
        PasswdUserListDM passwdUserListDM = new PasswdUserListDM(string, ':');
        Object[] objectArray = passwdUserListDM.getUsers(null, string2);
        System.out.println(Arrays.toString(objectArray));
        DataSet<Proxy> dataSet = passwdUserListDM.getDataSet(null, null, (SortField)new GenericSortField(10101, 1));
        CachingDataSet cachingDataSet = new CachingDataSet(dataSet);
        for (Proxy proxy : cachingDataSet) {
            System.out.println(proxy.getName() + ": " + proxy.getDescription());
        }
    }
}

