/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.windows;

import com.helpsystems.enterprise.module.windows.Kernel32Ext;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class HandleInputStream
extends InputStream {
    private static final int BUFSIZE = 4096;
    private WinNT.HANDLE handle;
    private WinNT.HANDLE otherHandle;
    private ByteBuffer byteBuffer;
    private Memory byteMemory;
    private IntByReference dwRead;
    private IntByReference dwAvail;
    private IntByReference dwLeft;
    private boolean isClosed;

    public HandleInputStream(WinNT.HANDLE hANDLE) {
        this(hANDLE, null);
    }

    public HandleInputStream(WinNT.HANDLE hANDLE, WinNT.HANDLE hANDLE2) {
        this.handle = hANDLE;
        this.otherHandle = hANDLE2;
        this.byteBuffer = ByteBuffer.allocate(4096);
        this.byteMemory = new Memory(4096L);
        this.dwRead = new IntByReference();
        this.dwAvail = new IntByReference();
        this.dwLeft = new IntByReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() throws IOException {
        ByteBuffer byteBuffer = this.byteBuffer;
        synchronized (byteBuffer) {
            if (this.isClosed && this.byteBuffer.position() == 0) {
                throw new IOException("Stream closed.");
            }
            this.readData();
            return this.byteBuffer.position();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ByteBuffer byteBuffer = this.byteBuffer;
        synchronized (byteBuffer) {
            this.isClosed = true;
        }
        this.byteBuffer = null;
        this.byteMemory = null;
        this.dwRead = null;
        this.dwAvail = null;
        this.dwLeft = null;
        Kernel32Ext.INSTANCE.CloseHandle(this.handle);
        this.handle = null;
        if (this.otherHandle != null) {
            Kernel32Ext.INSTANCE.CloseHandle(this.otherHandle);
        }
        this.otherHandle = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        ByteBuffer byteBuffer = this.byteBuffer;
        synchronized (byteBuffer) {
            InterruptedException interruptedException = null;
            while (this.byteBuffer.position() == 0) {
                if (interruptedException != null) {
                    IOException iOException = new IOException("Interrupted block-read");
                    iOException.initCause(interruptedException);
                    throw iOException;
                }
                try {
                    Thread.sleep(250L);
                    this.readData();
                }
                catch (InterruptedException interruptedException2) {
                    interruptedException = interruptedException2;
                }
            }
            int n3 = this.byteBuffer.position();
            int n4 = Math.min(n3, n2);
            this.byteBuffer.flip();
            byte[] byArray2 = new byte[n4];
            this.byteBuffer.get(byArray2);
            if (this.byteBuffer.position() == this.byteBuffer.limit()) {
                this.byteBuffer.clear();
            } else {
                this.byteBuffer.compact().flip();
            }
            System.arraycopy(byArray2, 0, byArray, n, n4);
            return n4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        ByteBuffer byteBuffer = this.byteBuffer;
        synchronized (byteBuffer) {
            InterruptedException interruptedException = null;
            while (this.byteBuffer.position() == 0) {
                if (interruptedException != null) {
                    IOException iOException = new IOException("Interrupted read");
                    iOException.initCause(interruptedException);
                    throw iOException;
                }
                try {
                    Thread.sleep(250L);
                    this.readData();
                }
                catch (InterruptedException interruptedException2) {
                    interruptedException = interruptedException2;
                }
            }
            this.byteBuffer.flip();
            byte by = this.byteBuffer.get();
            this.byteBuffer.compact().flip();
            return by;
        }
    }

    private void readData() throws IOException {
        this.checkIfClosed();
        int n = Math.min(4096, this.byteBuffer.capacity() - this.byteBuffer.position());
        if (n == 0) {
            return;
        }
        int n2 = 0;
        if (Kernel32Ext.INSTANCE.PeekNamedPipe(this.handle, (Pointer)this.byteMemory, n, this.dwRead, this.dwAvail, this.dwLeft)) {
            if (this.dwRead.getValue() > 0) {
                this.byteMemory.setMemory(0L, this.byteMemory.size(), (byte)0);
                boolean bl = Kernel32Ext.INSTANCE.ReadFile(this.handle, (Pointer)this.byteMemory, n, this.dwRead, null);
                if (!bl) {
                    throw new IOException("Unable to read, error " + Kernel32.INSTANCE.GetLastError());
                }
                n2 = this.dwRead.getValue();
                if (n2 > 0) {
                    byte[] byArray = new byte[n2];
                    this.byteMemory.read(0L, byArray, 0, byArray.length);
                    this.byteBuffer.put(byArray);
                }
            }
        } else {
            throw new IOException("Unable to read, error " + Kernel32.INSTANCE.GetLastError());
        }
    }

    private void checkIfClosed() throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream closed.");
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

