/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.reports.jasper;

import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.enterprise.core.dm.HistoryReportRowHandler;
import com.helpsystems.enterprise.core.dm.ReportDM;
import com.helpsystems.enterprise.core.reports.ReportHelper;
import com.helpsystems.enterprise.core.reports.ReportOutput;
import com.helpsystems.enterprise.core.reports.Reports;
import com.helpsystems.enterprise.core.reports.filter.OutputDistributionHistoryReportFilter;
import com.helpsystems.enterprise.core.reports.filter.parser.OutputDistributionHistoryReportFilterParser;
import com.helpsystems.enterprise.module.reports.ReportBuilder;
import com.helpsystems.enterprise.module.reports.ReportTitleHelper;
import com.helpsystems.enterprise.module.reports.jasper.AbstractJasperReport;
import com.helpsystems.enterprise.module.reports.jasper.JasperReportData;
import com.helpsystems.enterprise.scheduler.SchedulerStatusAMImpl;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class OutputDistributionHistoryReport
extends AbstractJasperReport
implements Serializable,
HistoryReportRowHandler {
    private static final long serialVersionUID = -871313742802236807L;
    private static final String ALL_JOBS = "All Jobs";
    public static final String REPORT_NAME = "OutputDistributionHistoryReport";
    private static final Logger logger = Logger.getLogger(OutputDistributionHistoryReport.class);
    private OutputDistributionHistoryReportFilter filter = new OutputDistributionHistoryReportFilter();
    private List<String> jobList = new ArrayList<String>();
    private List<String> agentList = new ArrayList<String>();
    private List<String> tagList = new ArrayList<String>();
    final Map<String, Object> parentParams = new HashMap<String, Object>();
    private ReportBuilder dataReportBuilder = null;
    private static final String USER_NAME = "-userName";
    private static final String DATE_RANGE = "-dateRange";
    private static final String END_DATE_DURATION = "-endDateDuration";
    private static final String START_DATE_DURATION = "-startDateDuration";
    private static final String JOB_IDS = "-jobIds";

    @Override
    public String getReportName() {
        return REPORT_NAME;
    }

    public OutputDistributionHistoryReport(Locale locale, ReportOutput.OutputType outputType, String string, Object ... objectArray) {
        super(locale, outputType, string, objectArray);
        this.reportDM = (ReportDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ReportDM");
    }

    @Override
    JasperReportData buildReportData() {
        AbstractJasperReport.ReportDataBuilder reportDataBuilder = OutputDistributionHistoryReport.createReportDataBuilder();
        Long l = this.filter.getToDate();
        Long l2 = this.filter.getFromDate();
        this.parentParams.put("HEADER_REPORT_NAME", REPORT_NAME);
        this.parentParams.put("HEADER_FROM_DATE", ReportHelper.getStartDate(l2));
        this.parentParams.put("HEADER_TO_DATE", ReportHelper.getEndDate(l));
        this.parentParams.put("SKYBOT_VERSION", SchedulerStatusAMImpl.serverRelMod);
        this.parentParams.put("SERVER_HOST_NAME", ReportHelper.getServerHostName());
        this.jobList.add(ALL_JOBS);
        this.agentList.add(ALL_JOBS);
        this.tagList.add(ALL_JOBS);
        this.parentParams.put("TITLE_JOB_LIST", this.jobList);
        this.parentParams.put("TITLE_AGENT_LIST", this.agentList);
        this.parentParams.put("TITLE_TAG_LIST", this.tagList);
        this.buildParameterReport(this.parentParams);
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue("GROUPING", "HISTORY_LIST");
        this.reportDM.getOutputDistributionHistoryInPeriod(l2, l, this);
        if (this.dataReportBuilder != null) {
            this.parentParams.put("DATA_EXISTS", new Boolean(true));
            reportDataBuilder.setFieldValue("GROUP_SUBREPORT_PARAMS", this.dataReportBuilder.getParams());
            reportDataBuilder.setFieldValue("GROUP_SUBREPORT_DATA", this.dataReportBuilder.getJRDataSource());
            logger.trace((Object)"The Output Distribution  History Data List has been built.");
            reportDataBuilder.nextRow();
        } else {
            this.parentParams.put("DATA_EXISTS", new Boolean(false));
        }
        JasperReportData jasperReportData = new JasperReportData();
        jasperReportData.setParameters(this.parentParams);
        jasperReportData.setData(reportDataBuilder.toJRDataSource());
        logger.trace((Object)"Output Distribution History Report data has been built.");
        return jasperReportData;
    }

    private String buildParameterReport(Map<String, Object> map) {
        AbstractJasperReport.ReportDataBuilder reportDataBuilder = OutputDistributionHistoryReport.createReportDataBuilder();
        return ReportTitleHelper.getInstance().buildReportParameter(map, reportDataBuilder, this.filter);
    }

    @Override
    protected void parseParameters(Object ... objectArray) {
        OutputDistributionHistoryReportFilterParser outputDistributionHistoryReportFilterParser = new OutputDistributionHistoryReportFilterParser();
        this.replaceIfNotAKey(objectArray);
        outputDistributionHistoryReportFilterParser.parseParameters(this.filter, objectArray);
        this.setEmailToAddress(this.filter.getEmailToAddress());
        this.setEmailToNotificationList(this.filter.getEmailToNotificationList());
        this.setEmailToCurrentUser(this.filter.isEmailToCurrentUser());
        this.setSavedReportFileName(this.filter.getReportFileName());
        this.setSavedReportFilePath(this.filter.getReportPath());
    }

    @Override
    protected void replaceIfNotAKey(Object ... objectArray) {
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)objectArray[i];
            if (n == 0 && this.isEqualToKey(string) && ++n == 1) continue;
            if (!string.equals("-") && string.startsWith("-") && n == 1) {
                String string2 = string.replaceAll("-", "val_");
                objectArray[i] = string2;
            }
            n = 0;
        }
    }

    @Override
    protected boolean isEqualToKey(String string) {
        return string.equals(DATE_RANGE) || string.equals(END_DATE_DURATION) || string.equals(START_DATE_DURATION) || string.equals(USER_NAME) || string.equals(JOB_IDS) || string.equals("-f");
    }

    @Override
    public int getReportID() {
        return Reports.ReportType.OUTPUT_DISTRIBUTION_HISTORY_REPORT.getReportID();
    }

    @Override
    public void handleRow(ResultSet resultSet) throws SQLException {
        if (this.dataReportBuilder == null) {
            this.dataReportBuilder = new ReportBuilder();
        }
        this.dataReportBuilder.nextRow();
        this.dataReportBuilder.put("COPIED_TO_SERVER_DATE", "Server Copied Time", new Date(resultSet.getLong("copied_server_time_utc")));
        this.dataReportBuilder.put("FILE_NAME", "File Name", resultSet.getString("file_name"));
        this.dataReportBuilder.put("DISTRIBTION_TYPE", "Distribution Type", ReportHelper.getDistributionType(resultSet.getInt("distribution_type")));
        this.dataReportBuilder.put("STATUS", "Status", ReportHelper.getOutputDistributionStatus(resultSet.getInt("status")));
        this.dataReportBuilder.put("JOB_RUN_NUMBER", "Job Run Number", resultSet.getLong("job_history_id"));
        this.dataReportBuilder.put("JOB_NAME", "Job Name", resultSet.getString("job_name"));
        this.dataReportBuilder.put("AGENT", "Agent", resultSet.getString("agent_name"));
    }
}

