/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.oracle;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.enterprise.core.busobj.CommandSetCommand;
import com.helpsystems.enterprise.core.busobj.oracle.OracleConcurrentRequest;
import com.helpsystems.enterprise.core.busobj.oracle.OracleExecutable;
import com.helpsystems.enterprise.core.busobj.oracle.OracleSystemDefinition;
import com.helpsystems.enterprise.core.dm.oracle.OracleConcurrentRequestsDM;
import com.helpsystems.enterprise.core.dm.oracle.OracleServerHelperAM;
import com.helpsystems.enterprise.core.dm.oracle.OracleSystemDefinitionsDM;
import com.helpsystems.enterprise.peer.AgentPeer;
import java.security.InvalidParameterException;
import org.apache.log4j.Logger;

public class OracleServerHelperAMImpl
extends AbstractManager
implements OracleServerHelperAM {
    private static final Logger logger = Logger.getLogger(OracleServerHelperAMImpl.class);
    private OracleSystemDefinitionsDM oracleSystemDefinitionsDM;
    private OracleConcurrentRequestsDM oracleConcurrentRequestsDM;
    private AgentPeer peer;

    public OracleServerHelperAMImpl(AgentPeer agentPeer) {
        this.setName("ENTERPRISE.OracleServerHelperAM");
        this.peer = agentPeer;
    }

    public AgentPeer getPeer() {
        return this.peer;
    }

    @Override
    public OracleExecutable getOracleExecutableFromCommand(CommandSetCommand commandSetCommand, boolean bl) throws ResourceUnavailableException {
        long l = commandSetCommand.getOid();
        int n = commandSetCommand.getCommandType();
        long l2 = 0L;
        OracleExecutable oracleExecutable = new OracleExecutable();
        switch (n) {
            case 9: {
                long l3 = this.getOracleCRIDFromCommandID(l);
                OracleConcurrentRequest oracleConcurrentRequest = null;
                try {
                    oracleConcurrentRequest = this.getOracleConcurrentRequestsDM().getOracleConcurrentRequest(l3);
                }
                catch (Exception exception) {
                    throw new ResourceUnavailableException("Error obtaining OracleConcurrentRequest.", (Throwable)exception);
                }
                oracleExecutable.setOracleCommand(oracleConcurrentRequest);
                l2 = oracleConcurrentRequest.getOracleSystemDefinitionID();
                break;
            }
            default: {
                String string = "Invalid Oracle commandType of " + n + " for line number " + commandSetCommand.getLineNumber();
                throw new InvalidParameterException(string);
            }
        }
        OracleSystemDefinition oracleSystemDefinition = null;
        try {
            oracleSystemDefinition = this.getOracleSystemDefinitionsDM().getOracleSystemDefinition(l2);
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Error obtaining OracleSystemDefinition.", (Throwable)exception);
        }
        oracleExecutable.setOracleSystemDefinition(oracleSystemDefinition);
        return oracleExecutable;
    }

    private long getOracleCRIDFromCommandID(long l) throws ResourceUnavailableException {
        try {
            return this.getOracleConcurrentRequestsDM().getOracleCRIDViaCommandID(l);
        }
        catch (NoDataException noDataException) {
            throw new ResourceUnavailableException("Error obtaining Oracle Concurrent Request ID for command ID " + l, (Throwable)noDataException);
        }
    }

    private OracleConcurrentRequestsDM getOracleConcurrentRequestsDM() {
        if (this.oracleConcurrentRequestsDM == null) {
            this.oracleConcurrentRequestsDM = (OracleConcurrentRequestsDM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)this.peer.getConnectedAgentServer(), (String)"ENTERPRISE.OracleConcurrentRequestsDM");
        }
        return this.oracleConcurrentRequestsDM;
    }

    private OracleSystemDefinitionsDM getOracleSystemDefinitionsDM() {
        if (this.oracleSystemDefinitionsDM == null) {
            this.oracleSystemDefinitionsDM = (OracleSystemDefinitionsDM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)this.peer.getConnectedAgentServer(), (String)"ENTERPRISE.OracleSystemDefinitionsDM");
        }
        return this.oracleSystemDefinitionsDM;
    }
}

