/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.filetransfer;

import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.busobj.DeleteFileException;
import com.helpsystems.enterprise.core.busobj.FileTransferException;
import com.helpsystems.enterprise.core.busobj.FileTransferReturnCode;
import com.helpsystems.enterprise.core.util.RemoteFile;
import com.helpsystems.enterprise.module.exec.FTPWorker;
import com.helpsystems.enterprise.module.exec.Utils;
import com.helpsystems.enterprise.module.filetransfer.IPeerFileTransferClient;
import com.helpsystems.enterprise.peer.FileTransterUtils;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;

public class PeerSftpClient
implements IPeerFileTransferClient {
    protected FTPWorker ftpWorker = new FTPWorker();
    private ChannelSftp channelSftp = null;

    public PeerSftpClient(ChannelSftp channelSftp) {
        this.channelSftp = channelSftp;
    }

    public ChannelSftp getChannelSftp() {
        return this.channelSftp;
    }

    @Override
    public void get(String string, String string2, boolean bl, boolean bl2, int n, boolean bl3, boolean bl4, boolean bl5) throws FileNotFoundException, IOException, SftpException, FileTransferException, DeleteFileException {
        try {
            String string3 = Utils.concatToStrings("Downloading - Source:", "\"" + string + "\"", " Target: ", "\"" + string2 + "\"");
            System.out.println(string3);
            this.ftpWorker.get(this.channelSftp, string, string2, bl2, bl3, bl4, true, bl5);
            String string4 = Utils.concatToStrings("Download complete.");
            System.out.println(string4);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string5 = Utils.concatToStrings("Download of ", "\"" + string + "\"", " failed. Exception:", fileNotFoundException.getMessage());
            System.out.println(string5);
            throw fileNotFoundException;
        }
        catch (SftpException sftpException) {
            String string6 = Utils.concatToStrings("Download of ", "\"" + string + "\"", " failed. Exception:", sftpException.getMessage());
            System.out.println(string6);
            throw sftpException;
        }
        catch (FileTransferException fileTransferException) {
            String string7 = Utils.concatToStrings("Download of ", "\"" + string + "\"", " failed. Exception:", fileTransferException.getMessage());
            System.out.println(string7);
            throw fileTransferException;
        }
        catch (DeleteFileException deleteFileException) {
            String string8 = Utils.concatToStrings(deleteFileException.getMessage());
            System.out.println(string8);
            throw deleteFileException;
        }
        catch (RuntimeException runtimeException) {
            String string9 = Utils.concatToStrings("Download of ", "\"" + string + "\"", " failed. Exception:", runtimeException.getMessage());
            System.out.println(string9);
            throw runtimeException;
        }
    }

    @Override
    public void put(String string, String string2, boolean bl, int n, boolean bl2, boolean bl3) throws FileNotFoundException, IOException, SftpException, FileTransferException {
        try {
            String string3 = Utils.concatToStrings("Uploading - Source: ", "\"" + string2 + "\"", "Target file: ", "\"" + string + "\"");
            System.out.println(string3);
            this.ftpWorker.put(this.channelSftp, string, string2, bl2, bl3, true);
            String string4 = Utils.concatToStrings("Upload complete.");
            System.out.println(string4);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string5 = Utils.concatToStrings("Upload of ", "\"" + string2 + "\"", " failed. Exception:", fileNotFoundException.getMessage());
            System.out.println(string5);
            throw fileNotFoundException;
        }
        catch (SftpException sftpException) {
            String string6 = Utils.concatToStrings("Upload of ", "\"" + string2 + "\"", " failed. Exception:", sftpException.getMessage());
            System.out.println(string6);
            throw sftpException;
        }
        catch (FileTransferException fileTransferException) {
            String string7 = Utils.concatToStrings("Upload of ", "\"" + string2 + "\"", " failed. Exception:", fileTransferException.getMessage());
            System.out.println(string7);
            throw fileTransferException;
        }
        catch (RuntimeException runtimeException) {
            String string8 = Utils.concatToStrings("Upload of ", "\"" + string2 + "\"", " failed. Exception:", runtimeException.getMessage());
            System.out.println(string8);
            throw runtimeException;
        }
    }

    @Override
    public List<RemoteFile> getList(String string, boolean bl) throws SftpException {
        try {
            String string2 = "Retrieving list of files.";
            System.out.println(string2);
            List<RemoteFile> list = this.ftpWorker.getList(this.channelSftp, string, bl);
            String string3 = "List retrieved successfully.";
            System.out.println(string3);
            return list;
        }
        catch (SftpException sftpException) {
            String string4 = Utils.concatToStrings("Unable to retrieve list of files. Exception:", sftpException.getMessage());
            System.out.println(string4);
            throw sftpException;
        }
    }

    @Override
    public void makeDir(String string) throws SftpException, IOException {
        String string2 = Utils.concatToStrings("Creating folder: ", string);
        System.out.println(string2);
        int n = -1;
        try {
            n = this.ftpWorker.makeDir(this.channelSftp, string);
        }
        catch (SftpException sftpException) {
            String string3 = Utils.concatToStrings("Failed to create folder. Exception: ", sftpException.getMessage());
            System.out.println(string3);
            throw sftpException;
        }
        catch (RuntimeException runtimeException) {
            String string4 = Utils.concatToStrings("Failed to create folder. Exception: ", runtimeException.getMessage());
            System.out.println(string4);
            throw runtimeException;
        }
        if (n != 0 && n != 1) {
            String string5 = Utils.concatToStrings("Failed to create folder. Exception: Unable to create folder ", string);
            System.out.println(string5);
            throw new IOException("Unable to create folder " + string);
        }
        String string6 = Utils.concatToStrings("Folder " + string + " created successfully.");
        System.out.println(string6);
    }

    @Override
    public void validateIfFolder(String string) throws FileTransferException, IOException, SftpException {
        if (!"".equals(string) && !"/".equals(string)) {
            String string2 = string;
            if (this.isRelativePath(string2)) {
                string2 = this.getAbsolutePath(string);
            }
            String string3 = FileTransterUtils.getRemoteParentFolderPath((String)string2);
            List<ChannelSftp.LsEntry> list = null;
            try {
                list = this.ftpWorker.getFileList(this.channelSftp, string3, true);
            }
            catch (SftpException sftpException) {
                throw new FileTransferException("Host folder does not exist: " + string2, sftpException, FileTransferReturnCode.outputRemoteFolderDoesNotExist);
            }
            if (list == null || list.isEmpty()) {
                throw new FileTransferException("Host folder does not exist: " + string2, FileTransferReturnCode.outputRemoteFolderDoesNotExist);
            }
            ChannelSftp.LsEntry lsEntry = this.getFileFromListByPath(list, string2);
            if (lsEntry == null) {
                throw new FileTransferException("Host folder does not exist: " + string2, FileTransferReturnCode.outputRemoteFolderDoesNotExist);
            }
            if (!lsEntry.getAttrs().isDir()) {
                throw new FileTransferException("Host path exists, but is not a directory", FileTransferReturnCode.outputRemoteFolderIsFile);
            }
        }
    }

    private boolean isRelativePath(String string) {
        ValidationHelper.checkForNullAndBlank((String)"path", (String)string);
        char c = string.charAt(0);
        if ("/".equals(String.valueOf(c))) {
            return false;
        }
        return !"\\".equals(String.valueOf(c));
    }

    private String getAbsolutePath(String string) throws SftpException {
        ValidationHelper.checkForNullAndBlank((String)"Remote Path name", (String)string);
        if (!this.isRelativePath(string)) {
            return string;
        }
        String string2 = FileTransterUtils.getRemotePathSeparator((String)string);
        String string3 = this.channelSftp.pwd();
        if (string3.endsWith("/") || string3.endsWith("\\")) {
            return string3 + string;
        }
        return string3 + string2 + string;
    }

    private ChannelSftp.LsEntry getFileFromListByPath(List<ChannelSftp.LsEntry> list, String string) {
        ChannelSftp.LsEntry lsEntry = null;
        for (ChannelSftp.LsEntry lsEntry2 : list) {
            if (!string.endsWith(lsEntry2.getFilename())) continue;
            lsEntry = lsEntry2;
            break;
        }
        return lsEntry;
    }

    @Override
    public boolean sendSiteCommand(String string) throws IOException {
        System.out.println("Con't doing Site Command: " + string + " for sftp");
        return false;
    }
}

