/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.filetransfer;

import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.enterprise.core.busobj.DeleteFileException;
import com.helpsystems.enterprise.core.busobj.FileTransferException;
import com.helpsystems.enterprise.core.busobj.FileTransferReturnCode;
import com.helpsystems.enterprise.core.cmdlineobj.FileTransferCommand;
import com.helpsystems.enterprise.module.exec.FileTransferController;

public class FileTransferWorker {
    public static void main(String[] stringArray) throws ActionFailedException {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringArray[i].trim();
        }
        FileTransferCommand fileTransferCommand = new FileTransferCommand();
        FileTransferController fileTransferController = new FileTransferController();
        try {
            fileTransferCommand.parseParameters(stringArray);
            fileTransferController.execute(fileTransferCommand);
            int n2 = FileTransferReturnCode.successful.code();
            FileTransferWorker.exit(n2, "FTP Command completed successfully.");
        }
        catch (FileTransferException fileTransferException) {
            System.out.println("Failed. Cause: (" + fileTransferException.getReturnCode().code() + ") " + fileTransferException.getMessage());
            if (fileTransferException.getCause() != null) {
                System.out.println(fileTransferException.getCause().getMessage());
            }
            FileTransferWorker.exit(1, "FTP Command completed with errors.");
        }
        catch (DeleteFileException deleteFileException) {
            System.out.println("Failed. Cause: (" + deleteFileException.getReturnCode().code() + ") " + deleteFileException.getMessage());
            if (deleteFileException.getCause() != null) {
                System.out.println(deleteFileException.getCause().getMessage());
            }
            FileTransferWorker.exit(2, "FTP Command completed with errors.");
        }
        catch (Exception exception) {
            System.out.println("Failed. Cause: " + exception.getMessage());
            if (exception.getCause() != null) {
                System.out.println(exception.getCause().getMessage());
            }
            FileTransferWorker.exit(1, "Command failed: " + exception.getLocalizedMessage(), exception);
        }
    }

    private static void exit(int n, String string) {
        FileTransferWorker.exit(n, string, null);
    }

    private static void exit(int n, String string, Throwable throwable) {
        if (string != null) {
            System.err.println(string);
            System.err.flush();
        }
        if (throwable != null) {
            throwable.printStackTrace(System.err);
            System.err.flush();
        }
        System.exit(n);
    }
}

