/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.exec;

import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.busobj.UserIdentity;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.server.file.RemoteFile;
import com.helpsystems.common.server.file.RemoteFileAM;
import com.helpsystems.common.server.file.WindowsFileAM;
import com.helpsystems.enterprise.peer.AgentControl;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.log4j.Logger;

public class WildcardEvaluator {
    private static final Logger logger = Logger.getLogger(WildcardEvaluator.class);
    Map<String, SimpleFileInfo> fileInfoMap = new HashMap<String, SimpleFileInfo>();

    private WildcardEvaluator() {
    }

    public static RemoteFile[] evaluateWildcards(RemoteFileAM remoteFileAM, String string) throws ActionFailedException {
        return WildcardEvaluator.evaluateWildcards(remoteFileAM, string, 0);
    }

    public static RemoteFile[] evaluateWildcards(RemoteFileAM remoteFileAM, String string, int n) throws ActionFailedException {
        Object object;
        String string2 = string.replace('\\', '/');
        ArrayList<RemoteFile> arrayList = new ArrayList<RemoteFile>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(string2);
        while (arrayList2.size() > 0) {
            Object object2;
            int n2;
            int n3;
            int n4;
            object = (String)arrayList2.remove(0);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("WildcardEvaluator is processing file path: " + (String)object));
            }
            if ((n4 = ((String)object).indexOf("*")) < 0) {
                n4 = Integer.MAX_VALUE;
            }
            if ((n3 = ((String)object).indexOf("?")) < 0) {
                n3 = Integer.MAX_VALUE;
            }
            if ((n2 = Math.min(n4, n3)) > ((String)object).length()) {
                RemoteFile remoteFile = remoteFileAM.get(UserIdentity.NO_USER_SPECIFIED, (String)object, false);
                if (remoteFile.exists()) {
                    if (remoteFile.isFile() && (n == 2 || n == 0) && !remoteFile.isHidden()) {
                        arrayList.add(remoteFile);
                    }
                    if (!remoteFile.isDirectory() || n != 2 && n != 1 || remoteFile.isHidden()) continue;
                    arrayList.add(remoteFile);
                    continue;
                }
                if (!logger.isTraceEnabled()) continue;
                logger.trace((Object)("WildcardEvaluator filtered file does not exist: " + remoteFile.getAbsolutePath()));
                continue;
            }
            int n5 = n2;
            while (((String)object).charAt(n5) != '/') {
                --n5;
            }
            int n6 = ((String)object).indexOf("/", n2);
            String string3 = "";
            String string4 = null;
            if (n6 == -1) {
                string4 = ((String)object).substring(n5 + 1);
            } else {
                string4 = ((String)object).substring(n5 + 1, n6);
                string3 = ((String)object).substring(n6);
            }
            Pattern pattern = WildcardEvaluator.makePattern(string4);
            RemoteFile remoteFile = null;
            if (n5 == -1) {
                remoteFile = remoteFileAM.getDefaultDirectory();
            } else if (n5 == 0) {
                remoteFile = remoteFileAM.get(UserIdentity.NO_USER_SPECIFIED, "/", false);
            } else {
                object2 = ((String)object).substring(0, n5);
                if (object2.length() == 2 && object2.endsWith(":")) {
                    object2 = (String)object2 + "/";
                }
                remoteFile = remoteFileAM.get(UserIdentity.NO_USER_SPECIFIED, (String)object2, false);
            }
            if (!remoteFile.exists() || !remoteFile.isDirectory() && !remoteFile.isDrive() || (object2 = remoteFileAM.getFiles(UserIdentity.NO_USER_SPECIFIED, remoteFile, false)) == null || ((RemoteFile[])object2).length == 0) continue;
            boolean bl = false;
            if (string4.length() > 0 && string4.charAt(0) == '.') {
                bl = true;
            }
            for (RemoteFile remoteFile2 : object2) {
                Matcher matcher;
                String string5 = remoteFile2.getAbsolutePath().replace('\\', '/');
                String string6 = string5.substring(string5.lastIndexOf("/") + 1);
                if (!bl && string6.charAt(0) == '.' || remoteFile2.isHidden() || !(matcher = pattern.matcher(string6)).matches()) continue;
                arrayList2.add(string5 + string3);
            }
            object2 = null;
        }
        object = new RemoteFile[arrayList.size()];
        arrayList.toArray((T[])object);
        arrayList2.clear();
        arrayList.clear();
        return object;
    }

    private static Pattern makePattern(String string) {
        Pattern pattern;
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : string.toCharArray()) {
            if (c == '*') {
                stringBuilder.append(".*");
                continue;
            }
            if (c == '?') {
                stringBuilder.append(".");
                continue;
            }
            if ("+()^$.{}[]|\\".indexOf(c) != -1) {
                stringBuilder.append('\\');
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append(c);
        }
        String string2 = stringBuilder.toString();
        logger.trace((Object)MessageUtil.formatMsg((String)"Pattern = {0},  regex = {1}, isAsciiOnly = {2}.", (Object[])new Object[]{string, string2, WildcardEvaluator.isAsciiOnly(string2)}));
        try {
            if (WildcardEvaluator.isCaseSensitive()) {
                int patternSyntaxException = WildcardEvaluator.isAsciiOnly(string2) ? 2 : 66;
                pattern = Pattern.compile(string2, patternSyntaxException);
            } else {
                pattern = Pattern.compile(string2);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            logger.debug((Object)("Wildcard filename " + string + " could not be turned into a regex: " + stringBuilder.toString()), (Throwable)patternSyntaxException);
            return null;
        }
        return pattern;
    }

    private static boolean isCaseSensitive() {
        return WildcardEvaluator.isWindows();
    }

    private static boolean isWindows() {
        return AgentControl.isWindows();
    }

    private static boolean isAsciiOnly(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) <= '\u007f') continue;
            return false;
        }
        return true;
    }

    private void fireEvent(String string, String string2) {
        System.out.println("Event " + string2 + " occurred on path " + string);
    }

    private synchronized void checkFilesAdded(RemoteFile[] remoteFileArray) {
        for (RemoteFile remoteFile : remoteFileArray) {
            SimpleFileInfo simpleFileInfo = this.fileInfoMap.get(remoteFile.getAbsolutePath());
            int n = 0;
            if (simpleFileInfo == null && n == 0) {
                this.fireEvent(remoteFile.getAbsolutePath(), "File added, wait time = 0");
                simpleFileInfo = new SimpleFileInfo();
                this.fileInfoMap.put(remoteFile.getAbsolutePath(), simpleFileInfo);
            }
            if (simpleFileInfo == null || !simpleFileInfo.isNew) continue;
            long l = System.currentTimeMillis() - simpleFileInfo.whenLastChanged;
            if (l >= (long)(n * 1000)) {
                simpleFileInfo.isNew = false;
            }
            this.fireEvent(remoteFile.getAbsolutePath(), "File added, wait time = 0");
        }
    }

    void runTest() {
        String string = "/newfolder";
        String string2 = null;
        string2 = string + "/*";
        for (int i = 0; i < 60000; ++i) {
            RemoteFile[] remoteFileArray = null;
            try {
                remoteFileArray = WildcardEvaluator.evaluateWildcards((RemoteFileAM)new WindowsFileAM(), string2);
            }
            catch (ActionFailedException actionFailedException) {
                System.out.println((Object)actionFailedException);
                System.exit(-1);
            }
            System.out.println("Attempt " + i + ": Found " + remoteFileArray.length + " files that matched...");
            this.purgeAndFillMap(remoteFileArray);
            if (i <= 0) continue;
            this.checkFilesAdded(remoteFileArray);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        final WildcardEvaluator wildcardEvaluator = new WildcardEvaluator();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                wildcardEvaluator.runTest();
            }
        });
        thread.setName("Testing WildcardEvaluator 1:");
        thread.start();
    }

    private int getSubFileCount(RemoteFile remoteFile) {
        if (remoteFile.isFile()) {
            return 0;
        }
        File file = new File(remoteFile.getAbsolutePath());
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return 0;
        }
        return fileArray.length;
    }

    private long getSize(RemoteFile remoteFile) {
        if (remoteFile.isFile()) {
            return remoteFile.length();
        }
        File file = new File(remoteFile.getAbsolutePath());
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return 0L;
        }
        long l = 0L;
        for (File file2 : fileArray) {
            if (!file2.isFile()) continue;
            l += file2.length();
        }
        return l;
    }

    private void purgeAndFillMap(RemoteFile[] remoteFileArray) {
        HashMap<String, SimpleFileInfo> hashMap = new HashMap<String, SimpleFileInfo>();
        hashMap.putAll(this.fileInfoMap);
        this.fileInfoMap.clear();
        for (RemoteFile remoteFile : remoteFileArray) {
            String string = remoteFile.getAbsolutePath();
            SimpleFileInfo simpleFileInfo = (SimpleFileInfo)hashMap.get(string);
            if (simpleFileInfo == null) {
                simpleFileInfo = new SimpleFileInfo();
                simpleFileInfo.isNew = true;
            }
            simpleFileInfo.date = remoteFile.lastModified();
            simpleFileInfo.whenLastChanged = remoteFile.lastModified();
            if (remoteFile.isFile()) {
                if (simpleFileInfo.size != remoteFile.length()) {
                    simpleFileInfo.whenLastChanged = System.currentTimeMillis();
                }
                simpleFileInfo.size = remoteFile.length();
            } else if (remoteFile.isDirectory()) {
                int n = this.getSubFileCount(remoteFile);
                long l = this.getSize(remoteFile);
                if (simpleFileInfo.size != l || simpleFileInfo.subFileCount != n) {
                    simpleFileInfo.size = l;
                    simpleFileInfo.subFileCount = n;
                    simpleFileInfo.whenLastChanged = System.currentTimeMillis();
                }
            }
            this.fileInfoMap.put(string, simpleFileInfo);
        }
    }

    private class SimpleFileInfo {
        long size;
        long date;
        long whenLastChanged;
        boolean isNew;
        int subFileCount;

        private SimpleFileInfo() {
        }
    }
}

