/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.exec;

import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.common.server.file.FileBlock;
import com.helpsystems.common.server.file.FileHandle;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.enterprise.core.dm.FilePeerGatewayAM;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;
import org.apache.log4j.Logger;

public class RemoteFileCopier {
    private static final Logger logger = Logger.getLogger(RemoteFileCopier.class);
    private PeerID peerid;
    private String remoteFilename;
    private String tempSourceFilename = null;
    private String serverFilename;
    private Throwable remoteFileReadError;
    private Throwable serverWriteError;
    private boolean copyStarted;
    private boolean deleteWhenFinished;
    private boolean terminate;
    private boolean skipRemoteStuff;
    private List<String> extraStuff;
    private PeerID filePeerID;

    public RemoteFileCopier(PeerID peerID, String string) {
        ValidationHelper.checkForNull((String)"PeerID", (Object)peerID);
        ValidationHelper.checkForNull((String)"Remote Filename", (Object)string);
        this.peerid = peerID;
        this.remoteFilename = string;
        this.buildTempSourceFileName(string);
    }

    private void buildTempSourceFileName(String string) {
        if (string != null) {
            this.tempSourceFilename = string.replace('\\', '/');
            int n = this.tempSourceFilename.lastIndexOf("/");
            if (n > -1) {
                this.tempSourceFilename = this.tempSourceFilename.substring(n + 1);
            }
        }
    }

    private void checkIfCopyStarted() {
        if (this.copyStarted) {
            throw new IllegalStateException("Copying has already started.");
        }
    }

    public void setServerFilename(String string) {
        this.checkIfCopyStarted();
        this.serverFilename = string;
    }

    public void terminate() {
        this.terminate = true;
    }

    public void setSkipRemoteStuff(boolean bl) {
        this.skipRemoteStuff = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean run(boolean bl) {
        boolean bl2;
        PrintWriter printWriter;
        FileOutputStream fileOutputStream;
        FileHandle fileHandle;
        String string;
        block49: {
            OutputStreamWriter outputStreamWriter;
            File file;
            FilePeerGatewayAM filePeerGatewayAM;
            block47: {
                boolean bl3;
                block48: {
                    this.copyStarted = true;
                    string = this.peerid.getPeerDescriptor().getComputerName();
                    if (string == null) {
                        string = this.peerid.getPeerDescriptor().findPrintableAddress();
                    }
                    if (this.serverFilename == null) {
                        logger.debug((Object)("Unable to copy " + this.remoteFilename + " from agent " + string + ", no Server or Spooled File destination specified."));
                        return false;
                    }
                    filePeerGatewayAM = null;
                    fileHandle = null;
                    file = null;
                    fileOutputStream = null;
                    outputStreamWriter = null;
                    printWriter = null;
                    if (this.skipRemoteStuff) break block47;
                    try {
                        filePeerGatewayAM = (FilePeerGatewayAM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)this.peerid, (String)"ENTERPRISE.FilePeerGatewayAM");
                        fileHandle = filePeerGatewayAM.getHandle(this.filePeerID == null ? this.peerid : this.filePeerID, this.remoteFilename, "r");
                    }
                    catch (Exception exception) {
                        logger.debug((Object)("Unable to open file " + this.remoteFilename + " on " + this.peerid), (Throwable)exception);
                        this.serverWriteError = new ActionFailedException("Unable to access the file " + this.remoteFilename + " on Agent " + string, (Throwable)exception);
                        boolean bl4 = false;
                        if (fileHandle != null) {
                            try {
                                fileHandle.close();
                            }
                            catch (Exception exception2) {
                                // empty catch block
                            }
                        }
                        this.close(fileOutputStream);
                        this.close(printWriter);
                        return bl4;
                    }
                    if (fileHandle != null) break block47;
                    this.serverWriteError = new ActionFailedException("Unable to access the file " + this.remoteFilename + " on Agent " + string);
                    bl3 = false;
                    if (fileHandle == null) break block48;
                    try {
                        fileHandle.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.close(fileOutputStream);
                this.close(printWriter);
                return bl3;
            }
            if (this.serverFilename != null) {
                if (file == null) {
                    file = new File(this.serverFilename);
                }
                try {
                    if (!file.exists() && !file.createNewFile()) {
                        throw new ActionFailedException("Unable to create Enterprise Server File " + file.getAbsolutePath() + ".");
                    }
                    fileOutputStream = new FileOutputStream(file);
                }
                catch (Exception exception) {
                    this.serverWriteError = exception;
                    fileOutputStream = null;
                }
            }
            logger.trace((Object)("Start of reading file " + this.remoteFilename));
            int n = 0;
            while (bl && !this.terminate && !this.skipRemoteStuff) {
                FileBlock fileBlock = fileHandle.read(100000);
                int n2 = fileBlock.getLength();
                if (logger.isTraceEnabled()) {
                    if (n2 < 100000) {
                        logger.trace((Object)("bytesRead below 100000: " + n2));
                    }
                    if ((n += n2) % 10000000 == 0) {
                        logger.trace((Object)("Total bytes read: " + n));
                    }
                }
                if (n2 < 0) break;
                if (fileOutputStream == null) continue;
                fileOutputStream.write(fileBlock.getBytes(), 0, n2);
            }
            logger.trace((Object)("End of reading file " + this.remoteFilename + ".  Total bytes read: " + n));
            if (fileHandle != null) {
                try {
                    fileHandle.close();
                    fileHandle = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.extraStuff != null && this.extraStuff.size() > 0) {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.flush();
                        outputStreamWriter = new OutputStreamWriter(fileOutputStream);
                        printWriter = new PrintWriter(outputStreamWriter);
                    }
                    catch (Exception exception) {
                        logger.debug((Object)"Unable to append extra job log info to the log file", (Throwable)exception);
                    }
                }
                for (String string2 : this.extraStuff) {
                    if (printWriter == null) continue;
                    printWriter.println(string2);
                }
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                    outputStreamWriter = null;
                }
                if (printWriter != null) {
                    printWriter.close();
                    printWriter = null;
                }
            }
            if (this.isDeleteWhenFinished() && !this.skipRemoteStuff && !this.terminate) {
                this.close(fileOutputStream);
                this.close(outputStreamWriter);
                this.close(printWriter);
                for (int i = 0; !this.deleteFile(filePeerGatewayAM, string, i) && i < 16; ++i) {
                    try {
                        Thread.sleep(500L);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            bl2 = bl;
            if (fileHandle == null) break block49;
            try {
                fileHandle.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.close(fileOutputStream);
        this.close(printWriter);
        return bl2;
        catch (Exception exception) {
            boolean bl5;
            block50: {
                try {
                    logger.debug((Object)("Error copying file " + this.remoteFilename + " from Agent " + string + " to Server Location: " + this.serverFilename), (Throwable)exception);
                    this.remoteFileReadError = exception;
                    bl5 = false;
                    if (fileHandle == null) break block50;
                }
                catch (Throwable throwable) {
                    if (fileHandle != null) {
                        try {
                            fileHandle.close();
                        }
                        catch (Exception exception3) {
                            // empty catch block
                        }
                    }
                    this.close(fileOutputStream);
                    this.close(printWriter);
                    throw throwable;
                }
                try {
                    fileHandle.close();
                }
                catch (Exception exception4) {
                    // empty catch block
                }
            }
            this.close(fileOutputStream);
            this.close(printWriter);
            return bl5;
        }
    }

    private boolean deleteFile(FilePeerGatewayAM filePeerGatewayAM, String string, int n) {
        try {
            filePeerGatewayAM.delete(this.peerid, this.remoteFilename);
            return true;
        }
        catch (ActionFailedException actionFailedException) {
            if (n > 0) {
                logger.debug((Object)("Attempt: (" + (n + 1) + ") Unable to delete file " + this.remoteFilename + " from agent " + string));
            }
            return false;
        }
        catch (Exception exception) {
            if (exception.getCause() instanceof ActionFailedException) {
                if (n > 0) {
                    logger.debug((Object)("Attempt: (" + (n + 1) + ") Unable to delete file " + this.remoteFilename + " from agent " + string));
                }
            } else {
                logger.debug((Object)("Attempt: (" + (n + 1) + ") Unable to delete file " + this.remoteFilename + " from agent " + string), (Throwable)exception);
            }
            return false;
        }
    }

    public boolean wasServerSuccessful() {
        if (this.serverFilename == null) {
            return false;
        }
        if (this.remoteFileReadError != null) {
            return false;
        }
        if (this.serverWriteError != null) {
            return false;
        }
        return !this.terminate;
    }

    public Throwable getServerWriteError() {
        return this.serverWriteError;
    }

    public Throwable getRemoteReadError() {
        return this.remoteFileReadError;
    }

    public boolean isDeleteWhenFinished() {
        return this.deleteWhenFinished;
    }

    public void setDeleteWhenFinished(boolean bl) {
        this.deleteWhenFinished = bl;
    }

    public void setExtraStuff(List<String> list) {
        this.extraStuff = list;
    }

    public void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setFilePeerID(PeerID peerID) {
        this.filePeerID = peerID;
    }

    public PeerID getFilePeerID() {
        return this.filePeerID;
    }

    public boolean isTerminate() {
        return this.terminate;
    }
}

