/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.exec;

import com.helpsystems.common.core.util.DateTranslator;
import com.helpsystems.enterprise.core.dm.SubmitFailedException;
import com.helpsystems.enterprise.module.exec.ProcessMonitor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Date;

public class LogFileWrapper {
    private PrintWriter pw;
    private FileOutputStream fos;
    private long charCount;
    private File file;
    private boolean isWaitingOnGrowth = false;

    public LogFileWrapper(File file) throws SubmitFailedException {
        this.file = file;
        try {
            this.fos = new FileOutputStream(file);
            this.pw = new PrintWriter(new OutputStreamWriter((OutputStream)this.fos, "UTF-8"));
        }
        catch (IOException iOException) {
            this.close();
            throw new SubmitFailedException("Unable to write to job log " + file.getAbsolutePath(), iOException);
        }
        if (this.pw.checkError()) {
            this.close();
            throw new SubmitFailedException("Unable to write to job log " + file.getAbsolutePath());
        }
    }

    public File getFile() {
        return this.file;
    }

    public PrintWriter getPw() {
        return this.pw;
    }

    public void close() {
        try {
            if (this.fos != null) {
                this.fos.close();
                this.fos = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.pw != null) {
                this.pw.close();
                this.pw = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public long charCount() {
        return this.charCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String string) {
        PrintWriter printWriter = this.pw;
        synchronized (printWriter) {
            this.pw.println(string);
            this.charCount += (long)(string.length() + ProcessMonitor.LINE_SEPARATOR.length());
            this.pw.flush();
            this.pw.notifyAll();
        }
    }

    public void write(String string, Exception exception) {
        if (exception != null) {
            this.write(string + " " + this.nestedMsgText(exception));
        } else {
            this.write(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String[] stringArray) {
        PrintWriter printWriter = this.pw;
        synchronized (printWriter) {
            for (String string : stringArray) {
                this.pw.println(string);
                this.charCount += (long)(string.length() + ProcessMonitor.LINE_SEPARATOR.length());
            }
            this.pw.flush();
            this.pw.notifyAll();
        }
    }

    public void writeJobEndedAndClose() {
        this.write("");
        this.write(DateTranslator.formatDateTimeWithTZ((Date)new Date()) + " - Automate Schedule Job ended.");
        this.write("");
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeNoEOL(String string) {
        PrintWriter printWriter = this.pw;
        synchronized (printWriter) {
            this.pw.print(string);
            this.pw.flush();
            this.pw.notifyAll();
        }
    }

    public boolean isWaitingOnGrowth() {
        return this.isWaitingOnGrowth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForGrowth(long l, int n) throws InterruptedException {
        long l2 = System.currentTimeMillis();
        PrintWriter printWriter = this.pw;
        synchronized (printWriter) {
            this.isWaitingOnGrowth = true;
            while (this.charCount() <= l) {
                if (n < 1) {
                    this.pw.wait();
                    continue;
                }
                long l3 = System.currentTimeMillis() - l2;
                int n2 = (int)(l3 / 1000L);
                if (n2 >= n) {
                    return this.charCount() > l;
                }
                this.pw.wait(n - n2);
            }
            this.isWaitingOnGrowth = false;
            return this.charCount() > l;
        }
    }

    private String nestedMsgText(Exception exception) {
        String string = exception.getMessage();
        for (Throwable throwable = exception.getCause(); throwable != null; throwable = throwable.getCause()) {
            string = string + " " + throwable.getMessage();
        }
        return string;
    }
}

