/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.exec;

import com.helpsystems.common.core.access.ExistsAlreadyException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.util.DateTranslator;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Date;

public class LogFile {
    private File file;
    private FileOutputStream fos;
    private PrintWriter pw;

    public LogFile(String string, String string2, boolean bl) throws ExistsAlreadyException, NoDataException {
        this((string2 != null ? string2 : "") + "/" + (string != null ? string : "") + ".log", bl);
    }

    public LogFile(String string, boolean bl) throws ExistsAlreadyException, NoDataException {
        ValidationHelper.checkForNullAndBlank((String)"Path/name", (String)string);
        this.file = new File(string);
        if (!bl) {
            if (this.file.exists()) {
                throw new ExistsAlreadyException(MessageUtil.formatMsg((String)"Log file {0} already exists.", (Object[])new Object[]{this.file.getAbsolutePath()}));
            }
        } else if (!this.file.exists()) {
            throw new NoDataException(MessageUtil.formatMsg((String)"Log file {0} no longer exists.", (Object[])new Object[]{this.file.getAbsolutePath()}));
        }
        boolean bl2 = bl;
        try {
            this.fos = new FileOutputStream(this.file, bl2);
            this.pw = new PrintWriter(new OutputStreamWriter((OutputStream)this.fos, "UTF-8"));
        }
        catch (Exception exception) {
            this.close();
            throw new IllegalStateException("Unable to write to file " + this.file.getAbsolutePath(), exception);
        }
    }

    protected LogFile() {
    }

    public void close() {
        try {
            if (this.fos != null) {
                this.fos.close();
                this.fos = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.pw != null) {
                this.pw.close();
                this.pw = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public File getFile() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String string) {
        this.validateState();
        PrintWriter printWriter = this.pw;
        synchronized (printWriter) {
            this.pw.println(string);
            this.pw.flush();
            this.pw.notifyAll();
        }
    }

    public void write(String string, Exception exception) {
        if (exception != null) {
            this.write(string + " " + this.nestedMsgText(exception));
        } else {
            this.write(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String[] stringArray) {
        this.validateState();
        PrintWriter printWriter = this.pw;
        synchronized (printWriter) {
            for (String string : stringArray) {
                this.pw.println(string);
            }
            this.pw.flush();
            this.pw.notifyAll();
        }
    }

    public void writeJobEndedAndClose(long l) {
        String[] stringArray = new String[]{"", DateTranslator.formatDateTimeWithTZ((Date)new Date(l)) + " - Automate Schedule Job ended.", ""};
        this.write(stringArray);
        this.close();
    }

    public void writeJobEndedAndClose() {
        long l = System.currentTimeMillis();
        this.writeJobEndedAndClose(l);
    }

    private boolean isClosed() {
        return this.fos == null;
    }

    private String nestedMsgText(Exception exception) {
        String string = exception.getMessage();
        for (Throwable throwable = exception.getCause(); throwable != null; throwable = throwable.getCause()) {
            string = string + " " + throwable.getMessage();
        }
        return string;
    }

    private void validateState() {
        if (this.isClosed()) {
            throw new IllegalStateException("Program error: Attempting to write to a closed log file.");
        }
    }
}

