/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.exec;

import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.busobj.AgentJobLog;
import com.helpsystems.enterprise.core.busobj.DeleteFileException;
import com.helpsystems.enterprise.core.busobj.FileTransferException;
import com.helpsystems.enterprise.core.busobj.FileTransferReturnCode;
import com.helpsystems.enterprise.core.util.RemoteFile;
import com.helpsystems.enterprise.module.exec.SSLSessionReuseFTPSClient;
import com.helpsystems.enterprise.module.exec.Utils;
import com.helpsystems.enterprise.peer.DefaultConfigPath;
import com.helpsystems.enterprise.peer.FileTransterUtils;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.SocketException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.net.ssl.SSLException;
import org.apache.commons.net.PrintCommandListener;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.FTPSClient;

public class FTPWorker {
    private static final String SKYBOT_SFTP_PREFERRED_AUTH = "SKYBOT_SFTP_PREFERRED_AUTH";
    private static final String SKYBOT_FTP_LOCAL_MODE = "SKYBOT_FTP_LOCAL_MODE";
    private static final String SKYBOT_FTP_HIDDEN_FILES = "SKYBOT_FTP_HIDDEN_FILES";
    private static final String FTP_MODE_ACTIVE = "active";
    private static final String FTP_MODE_PASSIVE = "passive";
    private static final String SKYBOT_FTPS_DEFAULT_PROTOCOL = "SKYBOT_FTPS_DEFAULT_PROTOCOL";
    private static final String SKYBOT_FTPS_ENABLED_PROTOCOLS = "SKYBOT_FTPS_ENABLED_PROTOCOLS";
    private static final String SSL_SECURED = "SSL";
    private static final String TLS_SECURED = "TLS";
    private static final String PROT_PRIVATE = "P";
    public static final int MAKE_DIR_SUCESS = 0;
    public static final int MAKE_DIR_FAILED_FOLDER_EXSIST = 1;
    public static final int MAKE_DIR_FAILED_FILE_WITH_SAME_NAME = 2;
    public static final int MAKE_DIR_FAILED_OTHER_CACES = 2;
    private static final String FTP_FILE_SEPARATOR = "/";
    private ArrayList<String> arrayFilePaths = new ArrayList();
    private boolean verbose = true;

    public FTPWorker(boolean bl) {
        this.verbose = bl;
    }

    public FTPWorker() {
        this(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public FTPSClient connectSecure(String var1_1, Integer var2_2, String var3_3, String var4_4, boolean var5_5) throws NoSuchAlgorithmException, FileTransferException, IOException {
        ValidationHelper.checkForNullAndBlank((String)"Server name", (String)var1_1);
        ValidationHelper.checkForNullAndBlank((String)"User name", (String)var3_3);
        var6_6 = var4_4;
        var7_7 = "SSL";
        try {
            var8_8 /* !! */  = System.getenv("SKYBOT_FTPS_DEFAULT_PROTOCOL");
            if (var8_8 /* !! */  != null && var8_8 /* !! */ .trim().length() > 0) {
                var7_7 = var8_8 /* !! */ ;
                System.out.println("Using FTPS Default Protocol: " + var7_7);
            }
        }
        catch (Exception var8_9) {
            System.out.println("Error loading default protocol override.");
            var8_9.printStackTrace(System.out);
        }
        var8_8 /* !! */  = new SSLSessionReuseFTPSClient(var7_7, var5_5);
        System.out.println("Setting system property jdk.tls.useExtendedMasterSecret to false.");
        System.setProperty("jdk.tls.useExtendedMasterSecret", "false");
        try {
            var9_10 = System.getenv("SKYBOT_FTPS_ENABLED_PROTOCOLS");
            if (var9_10 != null && var9_10.trim().length() > 0) {
                System.out.println("Using FTPS enabled protocols: " + var9_10);
                var10_16 /* !! */  = var9_10.split(":");
                System.out.print("Setting enabled protocols: ");
                for (var11_18 = 0; var11_18 < var10_16 /* !! */ .length; ++var11_18) {
                    if (var11_18 > 0) {
                        System.out.print(",");
                    }
                    System.out.print(var10_16 /* !! */ [var11_18]);
                }
                System.out.println();
                var8_8 /* !! */ .setEnabledProtocols(var10_16 /* !! */ );
            }
        }
        catch (Exception var9_11) {
            System.out.println("Unable to set enabled protocols. Cause: " + var9_11.getMessage());
        }
        try {
            System.out.println("Changing charset to UTF-8");
            var8_8 /* !! */ .setControlEncoding("UTF-8");
        }
        catch (Exception var9_12) {
            System.out.println("Unable to change charset to UTF-8. Cause: " + var9_12.getMessage());
        }
        try {
            if (var2_2 == null) {
                var8_8 /* !! */ .connect(var1_1);
            } else {
                var8_8 /* !! */ .connect(var1_1, var2_2.intValue());
            }
            if (this.isVerbose()) {
                this.logTrace(new Object[]{var8_8 /* !! */ .getReplyString()});
            }
        }
        catch (SocketException var9_13) {
            var10_16 /* !! */  = Utils.concatToStrings(new Object[]{"Unable to connect to FTPS server. Exception:", var9_13.getMessage()});
            this.logTrace(new Object[]{var10_16 /* !! */ });
            throw new FileTransferException((String)var10_16 /* !! */ , var9_13, FileTransferReturnCode.remoteSystemNotResponding);
        }
        catch (IOException var9_14) {
            var10_16 /* !! */  = Utils.concatToStrings(new Object[]{"Unable to connect to FTPS server. Exception:", var9_14.getMessage()});
            this.logTrace(new Object[]{var10_16 /* !! */ });
            throw new FileTransferException((String)var10_16 /* !! */ , var9_14, FileTransferReturnCode.remoteSystemNotResponding);
        }
        var9_15 = var8_8 /* !! */ .getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)var9_15)) {
            if (this.isVerbose()) {
                var10_16 /* !! */  = Utils.concatToStrings(new Object[]{"Connection refused by FTPS server."});
                System.out.println((String)var10_16 /* !! */ );
            }
            try {
                var8_8 /* !! */ .disconnect();
                return null;
            }
            catch (Throwable var10_17) {
                // empty catch block
            }
        }
        var8_8 /* !! */ .setBufferSize(1000);
        if (var8_8 /* !! */ .login(var3_3, var6_6)) {
            if (this.isVerbose()) {
                this.logTrace(new Object[]{var8_8 /* !! */ .getReplyString()});
                this.logTrace(new Object[]{"User", var3_3, "logged into", var1_1});
            }
        } else {
            if (this.isVerbose()) {
                this.logTrace(new Object[]{var8_8 /* !! */ .getReplyString()});
            }
            var10_16 /* !! */  = Utils.concatToStrings(new Object[]{"FTPS server rejected logon for user ", var3_3});
            if (this.isVerbose()) {
                System.out.println((String)var10_16 /* !! */ );
            }
            try {
                var8_8 /* !! */ .disconnect();
            }
            catch (Throwable var11_19) {
                // empty catch block
            }
            throw new FileTransferException((String)var10_16 /* !! */ , FileTransferReturnCode.unableToLogonToRemoteSystem);
        }
        var8_8 /* !! */ .addProtocolCommandListener((ProtocolCommandListener)new PrintCommandListener(new PrintWriter(System.out)));
        if (this.useFTPMode("SKYBOT_FTP_LOCAL_MODE") == FTP_MODE.ACTIVE) {
            System.out.println("Using FTP local active mode.");
            var8_8 /* !! */ .enterLocalActiveMode();
        } else {
            System.out.println("Using FTP local passive mode.");
            var8_8 /* !! */ .enterLocalPassiveMode();
        }
        var8_8 /* !! */ .execPBSZ(0L);
        var10_16 /* !! */  = "";
        var11_18 = 0;
        try {
            var8_8 /* !! */ .execPROT("P");
            ** if (!this.isVerbose() || var11_18 == 0) goto lbl-1000
        }
        catch (SSLException var12_21) {
            try {
                var10_16 /* !! */  = var12_21.getMessage();
                var13_23 = var8_8 /* !! */ .getReplyCode();
                if (var13_23 == 534) {
                    var10_16 /* !! */  = "The server is not willing to accept the specified protection level.";
                }
                var11_18 = 1;
                ** if (!this.isVerbose() || var11_18 == 0) goto lbl-1000
            }
            catch (Throwable var14_24) {
                if (this.isVerbose() && var11_18 != 0) {
                    var15_25 = Utils.concatToStrings(new Object[]{"PROT P command failed. Reason:", var10_16 /* !! */ , "\nContinuing data transfer in non-secure mode."});
                    System.out.println(var15_25);
                }
                throw var14_24;
            }
lbl-1000:
            // 1 sources

            {
                var12_20 = Utils.concatToStrings(new Object[]{"PROT P command failed. Reason:", var10_16 /* !! */ , "\nContinuing data transfer in non-secure mode."});
                System.out.println(var12_20);
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            var12_20 = Utils.concatToStrings(new Object[]{"PROT P command failed. Reason:", var10_16 /* !! */ , "\nContinuing data transfer in non-secure mode."});
            System.out.println(var12_20);
        }
lbl-1000:
        // 2 sources

        {
        }
        var12_22 = this.resolveListHiddenFiles();
        var8_8 /* !! */ .setListHiddenFiles(var12_22);
        return var8_8 /* !! */ ;
    }

    private boolean resolveListHiddenFiles() {
        boolean bl = false;
        try {
            String string = System.getenv(SKYBOT_FTP_HIDDEN_FILES);
            if (string != null && string.trim().equalsIgnoreCase("true")) {
                System.out.println("File listing will include hidden files.");
                return true;
            }
        }
        catch (Exception exception) {
            System.out.println("Error determining hidden files option: SKYBOT_FTP_HIDDEN_FILES");
            exception.printStackTrace(System.out);
        }
        return bl;
    }

    private FTP_MODE useFTPMode(String string) {
        try {
            String string2 = System.getenv(string);
            if (string2 != null && string2.trim().length() > 0) {
                if (string2.trim().equalsIgnoreCase(FTP_MODE_ACTIVE)) {
                    return FTP_MODE.ACTIVE;
                }
                if (string2.trim().equalsIgnoreCase(FTP_MODE_PASSIVE)) {
                    return FTP_MODE.PASSIVE;
                }
                System.out.println("Invalid value '" + string2.trim() + "' for environment variable " + string);
                return FTP_MODE.UNDEFINED;
            }
        }
        catch (Exception exception) {
            System.out.println("Error determining remote active/passive mode.");
            exception.printStackTrace();
        }
        return FTP_MODE.UNDEFINED;
    }

    public FTPClient connect(String string, Integer n, String string2, String string3) throws FileTransferException, IOException {
        int n2;
        ValidationHelper.checkForNullAndBlank((String)"Server name", (String)string);
        ValidationHelper.checkForNullAndBlank((String)"User name", (String)string2);
        String string4 = string3;
        FTPClient fTPClient = new FTPClient();
        try {
            System.out.println("Changing charset to UTF-8");
            fTPClient.setControlEncoding("UTF-8");
        }
        catch (Exception exception) {
            System.out.println("Unable to change charset to UTF-8. Cause: " + exception.getMessage());
        }
        try {
            if (n == null) {
                fTPClient.connect(string);
            } else {
                fTPClient.connect(string, n.intValue());
            }
            if (this.isVerbose()) {
                this.logTrace(fTPClient.getReplyString());
            }
        }
        catch (SocketException socketException) {
            String string5 = Utils.concatToStrings("Unable to connect to FTP server. Exception:", socketException.getMessage());
            this.logTrace(string5);
            throw new FileTransferException(string5, socketException, FileTransferReturnCode.remoteSystemNotResponding);
        }
        catch (IOException iOException) {
            String string6 = Utils.concatToStrings("Unable to connect to FTP server. Exception:", iOException.getMessage());
            this.logTrace(string6);
            throw new FileTransferException(string6, iOException, FileTransferReturnCode.remoteSystemNotResponding);
        }
        if (this.isVerbose()) {
            this.logTrace(fTPClient.getReplyString());
        }
        if (!FTPReply.isPositiveCompletion((int)(n2 = fTPClient.getReplyCode()))) {
            try {
                fTPClient.disconnect();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            String string7 = Utils.concatToStrings("Connection refused by FTP server.");
            System.out.println(string7);
            return null;
        }
        if (this.isVerbose()) {
            this.logTrace(fTPClient.getReplyString());
        }
        if (fTPClient.login(string2, string4)) {
            if (this.isVerbose()) {
                this.logTrace(fTPClient.getReplyString());
                this.logTrace("User", string2, "logged into", string);
            }
        } else {
            try {
                fTPClient.disconnect();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            String string8 = Utils.concatToStrings("FTP server rejected logon for user", string2);
            System.out.println(string8);
            throw new FileTransferException(string8, FileTransferReturnCode.unableToLogonToRemoteSystem);
        }
        fTPClient.addProtocolCommandListener((ProtocolCommandListener)new PrintCommandListener(new PrintWriter(System.out)));
        if (this.useFTPMode(SKYBOT_FTP_LOCAL_MODE) == FTP_MODE.ACTIVE) {
            System.out.println("Using FTP local active mode.");
            fTPClient.enterLocalActiveMode();
        } else {
            System.out.println("Using FTP local passive mode.");
            fTPClient.enterLocalPassiveMode();
        }
        boolean bl = this.resolveListHiddenFiles();
        fTPClient.setListHiddenFiles(bl);
        return fTPClient;
    }

    public ChannelSftp connectSecureSftp(String string, Integer n, String string2, String string3, boolean bl, int n2, String string4) throws FileTransferException {
        Session session = null;
        try {
            String string5;
            Object object;
            ChannelSftp channelSftp = null;
            String string6 = System.getenv("DEBUG_SFTP");
            boolean bl2 = false;
            if (string6 != null) {
                try {
                    bl2 = Boolean.valueOf(string6);
                }
                catch (Exception exception) {
                    bl2 = false;
                }
            }
            if (bl2) {
                JSch.setLogger((Logger)new JSCHLogger());
            }
            JSch jSch = new JSch();
            ValidationHelper.checkForNullAndBlank((String)"Server name", (String)string);
            ValidationHelper.checkForNullAndBlank((String)"User name", (String)string2);
            try {
                jSch.setKnownHosts(DefaultConfigPath.getKnownHostsFile());
            }
            catch (JSchException jSchException) {
                throw new FileTransferException("Connect to SFTP host failed, cause:" + jSchException.getMessage(), jSchException, FileTransferReturnCode.knownHostFileNotFound);
            }
            try {
                if (n2 == 2) {
                    if (string3 != null) {
                        jSch.addIdentity(string4, string3.getBytes());
                    } else {
                        jSch.addIdentity(string4);
                    }
                }
                session = jSch.getSession(string2, string, n.intValue());
            }
            catch (JSchException jSchException) {
                throw new FileTransferException("Connect to SFTP host failed, cause:" + jSchException.getMessage(), jSchException, FileTransferReturnCode.remoteSystemNotResponding);
            }
            try {
                object = System.getenv(SKYBOT_SFTP_PREFERRED_AUTH);
                if (object != null && ((String)object).trim().length() > 0) {
                    string5 = "PreferredAuthentications";
                    System.out.println("Overriding " + string5 + ": " + (String)object);
                    session.setConfig(string5, ((String)object).trim());
                }
            }
            catch (Exception exception) {
                System.out.println("Error processing PreferredAuthentications override.");
                exception.printStackTrace();
            }
            object = new MyUserInfo(string3, bl);
            session.setUserInfo((UserInfo)object);
            try {
                session.connect();
                string5 = session.openChannel("sftp");
                string5.connect();
            }
            catch (JSchException jSchException) {
                throw new FileTransferException("Could not log in to SFTP server, cause:" + jSchException.getMessage(), jSchException, FileTransferReturnCode.unableToLogonToRemoteSystem);
            }
            channelSftp = (ChannelSftp)string5;
            try {
                System.out.println("Changing charset to UTF-8");
                channelSftp.setFilenameEncoding("UTF-8");
            }
            catch (Exception exception) {
                System.out.println("Unable to change charset to UTF-8. Cause: " + exception.getMessage());
            }
            return channelSftp;
        }
        catch (FileTransferException fileTransferException) {
            try {
                session.disconnect();
            }
            catch (Throwable throwable) {
                System.out.println(throwable);
            }
            throw fileTransferException;
        }
    }

    private void setFileTransferMode(FTPClient fTPClient, boolean bl) throws IOException {
        block11: {
            try {
                if (bl) {
                    if (this.isVerbose()) {
                        this.logTrace("Setting BINARY mode...");
                    }
                    fTPClient.setFileType(2);
                } else {
                    if (this.isVerbose()) {
                        this.logTrace("Setting TEXT mode...");
                    }
                    fTPClient.setFileType(0, 5);
                }
            }
            catch (IOException iOException) {
                if (this.isVerbose()) {
                    if (bl) {
                        this.logTrace("Errors occured setting BINARY mode. Exception:", iOException.getMessage());
                    } else {
                        this.logTrace("Errors occured setting TEXT mode. Exception:", iOException.getMessage());
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                if (!this.isVerbose()) break block11;
                if (bl) {
                    this.logTrace("Errors occured setting BINARY mode. Exception:", runtimeException.getMessage());
                }
                this.logTrace("Errors occured setting TEXT mode. Exception:", runtimeException.getMessage());
            }
        }
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public int makeDir(ChannelSftp channelSftp, String string) throws SftpException {
        String string2;
        int n = 2;
        String string3 = FTPWorker.getParentFolderPath(string);
        List<ChannelSftp.LsEntry> list = this.getFileList(channelSftp, string3, true);
        ChannelSftp.LsEntry lsEntry = FTPWorker.getFileByNameSftp(list, string2 = FileTransterUtils.getRemoteFileNameFromPath((String)string));
        if (lsEntry == null) {
            channelSftp.mkdir(string);
            n = 0;
        } else {
            n = lsEntry.getAttrs().isDir() ? 1 : 2;
        }
        return n;
    }

    public int makeDir(FTPClient fTPClient, String string) throws IOException {
        String string2;
        int n = 2;
        String string3 = FTPWorker.getParentFolderPath(string);
        List<FTPFile> list = this.getFileList(fTPClient, string3, true, true);
        FTPFile fTPFile = FTPWorker.getFileByName(list, string2 = this.getFileNameFromFromPath(string));
        if (fTPFile == null) {
            boolean bl = fTPClient.makeDirectory(string);
            if (!bl) {
                throw new IOException();
            }
            n = 0;
        } else {
            n = fTPFile.isDirectory() ? 1 : 2;
        }
        return n;
    }

    private String getFileNameFromFromPath(String string) {
        String string2 = null;
        string2 = string.indexOf(FTP_FILE_SEPARATOR) != -1 ? string.substring(string.indexOf(FTP_FILE_SEPARATOR) + 1) : string;
        return string2;
    }

    private static String getParentFolderPath(String string) {
        String string2 = null;
        int n = string.lastIndexOf(FTP_FILE_SEPARATOR);
        string2 = n == -1 ? "" : string.substring(0, n);
        return string2;
    }

    private static ChannelSftp.LsEntry getFileByNameSftp(List<ChannelSftp.LsEntry> list, String string) {
        if (list == null) {
            throw new IllegalArgumentException("File list is null.");
        }
        if (string == null) {
            throw new IllegalArgumentException("File name is null.");
        }
        if ("".equals(string)) {
            throw new IllegalArgumentException("File name is blank.");
        }
        ChannelSftp.LsEntry lsEntry = null;
        for (ChannelSftp.LsEntry lsEntry2 : list) {
            if (!string.equals(lsEntry2.getFilename())) continue;
            lsEntry = lsEntry2;
            break;
        }
        return lsEntry;
    }

    private static FTPFile getFileByName(List<FTPFile> list, String string) {
        if (list == null) {
            throw new IllegalArgumentException("File list is null.");
        }
        if (string == null) {
            throw new IllegalArgumentException("File name is null.");
        }
        if ("".equals(string)) {
            throw new IllegalArgumentException("File name is blank.");
        }
        FTPFile fTPFile = null;
        for (FTPFile fTPFile2 : list) {
            if (!string.equals(fTPFile2.getName())) continue;
            fTPFile = fTPFile2;
            break;
        }
        return fTPFile;
    }

    public List<RemoteFile> getList(ChannelSftp channelSftp, String string, boolean bl) throws SftpException {
        if (this.isVerbose()) {
            // empty if block
        }
        ArrayList<RemoteFile> arrayList = null;
        List<ChannelSftp.LsEntry> list = this.getFileList(channelSftp, string, bl);
        if (list != null && list.size() > 0) {
            arrayList = new ArrayList<RemoteFile>();
            for (ChannelSftp.LsEntry lsEntry : list) {
                RemoteFile remoteFile = new RemoteFile();
                remoteFile.setName(lsEntry.getFilename());
                remoteFile.setDirectory(lsEntry.getAttrs().isDir());
                arrayList.add(remoteFile);
            }
        }
        return arrayList;
    }

    public List<ChannelSftp.LsEntry> getFileList(ChannelSftp channelSftp, String string, boolean bl) throws SftpException {
        ArrayList<ChannelSftp.LsEntry> arrayList;
        block5: {
            if (this.isVerbose()) {
                // empty if block
            }
            string = this.remoteAbsolutePathSFTP(channelSftp, string);
            arrayList = new ArrayList<ChannelSftp.LsEntry>();
            String string2 = string == null || "".equals(string) ? FTP_FILE_SEPARATOR : string;
            Vector vector = channelSftp.ls(string2);
            if (vector == null || vector.size() <= 0) break block5;
            if (!bl) {
                for (Object e : vector) {
                    ChannelSftp.LsEntry lsEntry;
                    if (!(e instanceof ChannelSftp.LsEntry) || (lsEntry = (ChannelSftp.LsEntry)e).getAttrs().isDir()) continue;
                    arrayList.add(lsEntry);
                }
            } else {
                for (Object e : vector) {
                    if (!(e instanceof ChannelSftp.LsEntry)) continue;
                    ChannelSftp.LsEntry lsEntry = (ChannelSftp.LsEntry)e;
                    arrayList.add(lsEntry);
                }
            }
        }
        return arrayList;
    }

    public List<FTPFile> getFileList(FTPClient fTPClient, String string, boolean bl, boolean bl2) throws IOException {
        ArrayList<FTPFile> arrayList;
        block7: {
            if (this.isVerbose()) {
                // empty if block
            }
            arrayList = new ArrayList<FTPFile>();
            FTPFile[] fTPFileArray = fTPClient.listFiles(string);
            if (fTPFileArray == null || fTPFileArray.length <= 0) break block7;
            if (!bl) {
                for (FTPFile fTPFile : fTPFileArray) {
                    if (!fTPFile.isFile()) continue;
                    if (bl2) {
                        arrayList.add(fTPFile);
                        continue;
                    }
                    if (fTPFile.getName().equals(".") || fTPFile.getName().equals("..")) continue;
                    arrayList.add(fTPFile);
                }
            } else {
                for (FTPFile fTPFile : fTPFileArray) {
                    if (bl2) {
                        arrayList.add(fTPFile);
                        continue;
                    }
                    if (fTPFile.getName().equals(".") || fTPFile.getName().equals("..")) continue;
                    arrayList.add(fTPFile);
                }
            }
        }
        return arrayList;
    }

    public List<RemoteFile> getList(FTPClient fTPClient, String string, boolean bl) throws IOException {
        if (this.isVerbose()) {
            // empty if block
        }
        ArrayList<RemoteFile> arrayList = null;
        List<FTPFile> list = this.getFileList(fTPClient, string, bl, true);
        if (list != null && list.size() > 0) {
            arrayList = new ArrayList<RemoteFile>();
            for (FTPFile fTPFile : list) {
                RemoteFile remoteFile = new RemoteFile();
                remoteFile.setName(fTPFile.getName());
                remoteFile.setDirectory(fTPFile.isDirectory());
                arrayList.add(remoteFile);
            }
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void put(ChannelSftp channelSftp, String string, String string2, boolean bl, boolean bl2, boolean bl3) throws FileTransferException, FileNotFoundException, SftpException {
        try {
            FileInputStream fileInputStream2;
            Object file;
            CharSequence charSequence;
            Object object;
            Serializable serializable;
            block32: {
                string = this.remoteAbsolutePathSFTP(channelSftp, string);
                ValidationHelper.checkForNullAndBlank((String)"Host file name", (String)string);
                ValidationHelper.checkForNullAndBlank((String)"Agent file name", (String)string2);
                if (!channelSftp.isConnected()) {
                    throw new IllegalArgumentException("SFTP is not connected");
                }
                if (channelSftp.isClosed()) {
                    throw new IllegalArgumentException("SFTP connection is closed");
                }
                if (this.isVerbose()) {
                    this.logTrace("Uploading '", string2, "' to '", string, "'");
                }
                try {
                    serializable = channelSftp.ls(string);
                    if (serializable == null || ((Vector)serializable).size() <= 0) break block32;
                    Object e = ((Vector)serializable).get(0);
                    if (e instanceof ChannelSftp.LsEntry) {
                        object = (ChannelSftp.LsEntry)e;
                        if (!object.getAttrs().isDir()) {
                            if (!bl) {
                                StringBuilder stringBuilder = new StringBuilder();
                                stringBuilder.append("The host file ");
                                stringBuilder.append(string);
                                stringBuilder.append(" exists, and the command specified not to replace.");
                                this.logTrace(stringBuilder);
                                throw new FileTransferException(stringBuilder.toString(), FileTransferReturnCode.remoteToFileAlreadyExists);
                            }
                            break block32;
                        } else {
                            charSequence = new StringBuilder();
                            ((StringBuilder)charSequence).append("The host file ");
                            ((StringBuilder)charSequence).append(string);
                            ((StringBuilder)charSequence).append(" exists. It is a folder.");
                            this.logTrace(charSequence);
                            if (!bl2) throw new FileTransferException(((StringBuilder)charSequence).toString(), FileTransferReturnCode.remoteToFileAlreadyExistsIsFolder);
                            file = new File(string2);
                            if (((File)file).isFile()) {
                                string = string.endsWith(FTP_FILE_SEPARATOR) ? string + ((File)file).getName() : string + FTP_FILE_SEPARATOR + ((File)file).getName();
                                this.put(channelSftp, string, string2, bl, false, bl3);
                                throw new TerminateMethodException(((StringBuilder)charSequence).toString());
                            }
                        }
                        break block32;
                    }
                    if (!bl) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("The host file ");
                        stringBuilder.append(string);
                        stringBuilder.append(" exists, and the command specified not to replace.");
                        this.logTrace(stringBuilder);
                        throw new FileTransferException(stringBuilder.toString(), FileTransferReturnCode.remoteToFileAlreadyExists);
                    }
                }
                catch (SftpException sftpException) {
                    if (sftpException.id == 2 || bl) break block32;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("The host file ");
                    stringBuilder.append(string);
                    stringBuilder.append(" couldn't find if exists, and the command specified not to replace.");
                    this.logTrace(stringBuilder);
                    throw new FileTransferException(stringBuilder.toString(), FileTransferReturnCode.remoteToFileAlreadyExists);
                }
            }
            serializable = new File(string2);
            FileInputStream fileInputStream = null;
            try {
                if (!((File)serializable).exists()) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("The agent file '");
                    ((StringBuilder)object).append(string2);
                    ((StringBuilder)object).append("' does not exist.  Cannot upload '");
                    ((StringBuilder)object).append(string2);
                    ((StringBuilder)object).append("' to '");
                    ((StringBuilder)object).append(string);
                    ((StringBuilder)object).append("'.");
                    this.logTrace(object);
                    throw new FileTransferException(((StringBuilder)object).toString(), FileTransferReturnCode.systemFromFileNotFound);
                }
                if (((File)serializable).isFile()) {
                    if (!((File)serializable).canRead()) {
                        object = new StringBuilder();
                        ((StringBuilder)object).append("The agent file '");
                        ((StringBuilder)object).append(string2);
                        ((StringBuilder)object).append("' cannot be read.  Cannot upload '");
                        ((StringBuilder)object).append(string2);
                        ((StringBuilder)object).append("' to '");
                        ((StringBuilder)object).append(string);
                        ((StringBuilder)object).append("'.");
                        this.logTrace(object);
                        throw new FileTransferException(((StringBuilder)object).toString(), FileTransferReturnCode.systemFromFileCantRead);
                    }
                } else if (((File)serializable).isDirectory()) {
                    block33: {
                        if (!bl3) {
                            object = new StringBuilder();
                            ((StringBuilder)object).append("The agent file '");
                            ((StringBuilder)object).append(string2);
                            ((StringBuilder)object).append("' is a directory.  Cannot upload '");
                            ((StringBuilder)object).append(string2);
                            ((StringBuilder)object).append("' to '");
                            ((StringBuilder)object).append(string);
                            ((StringBuilder)object).append("'.");
                            this.logTrace(object);
                            throw new FileTransferException(((StringBuilder)object).toString(), FileTransferReturnCode.systemFromPathIsFolder);
                        }
                        object = ((File)serializable).listFiles();
                        charSequence = string.endsWith(FTP_FILE_SEPARATOR) ? string + ((File)serializable).getName() : string + FTP_FILE_SEPARATOR + ((File)serializable).getName();
                        try {
                            this.makeDir(channelSftp, (String)charSequence);
                        }
                        catch (Exception exception) {
                            if (bl) break block33;
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append("The host folder ");
                            stringBuilder.append((String)charSequence);
                            stringBuilder.append(" exists, and the command specified not to replace.");
                            this.logTrace(stringBuilder);
                            throw new FileTransferException(stringBuilder.toString(), FileTransferReturnCode.remoteToFileAlreadyExistsIsFolder);
                        }
                    }
                    file = object;
                    int n = ((Object)file).length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object2 = file[n2];
                        CharSequence charSequence2 = ((File)object2).isFile() ? (String)charSequence + FTP_FILE_SEPARATOR + ((File)object2).getName() : charSequence;
                        this.put(channelSftp, (String)charSequence2, ((File)object2).getAbsolutePath(), bl, bl2, bl3);
                        ++n2;
                    }
                    throw new TerminateMethodException();
                }
                fileInputStream2 = new FileInputStream((File)serializable);
                try {
                    this.logTrace("starting call ftp.put");
                    channelSftp.put((InputStream)fileInputStream2, string);
                    this.logTrace("end call ftp.put");
                }
                catch (SftpException sftpException) {
                    this.logTrace(new Object[]{sftpException, "Error occurred in Time put sftp cause: ", sftpException.getMessage()});
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append("Error uploading '");
                    ((StringBuilder)charSequence).append(string2);
                    ((StringBuilder)charSequence).append("' to '");
                    ((StringBuilder)charSequence).append(string);
                    ((StringBuilder)charSequence).append("'.");
                    throw new FileTransferException(((StringBuilder)charSequence).toString(), sftpException, FileTransferReturnCode.remoteToFileCantWrite);
                }
                if (fileInputStream2 == null) return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append("The agent file '");
                    ((StringBuilder)charSequence).append(string2);
                    ((StringBuilder)charSequence).append("' cannot be read.  Cannot upload '");
                    ((StringBuilder)charSequence).append(string2);
                    ((StringBuilder)charSequence).append("' to '");
                    ((StringBuilder)charSequence).append(string);
                    ((StringBuilder)charSequence).append("'.");
                    this.logTrace(charSequence);
                    throw new FileTransferException(((StringBuilder)charSequence).toString(), fileNotFoundException, FileTransferReturnCode.systemFromFileCantRead);
                }
                catch (Throwable throwable) {
                    if (fileInputStream == null) throw throwable;
                    try {
                        fileInputStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            try {
                fileInputStream2.close();
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }
        catch (TerminateMethodException terminateMethodException) {
            // empty catch block
        }
    }

    public void put(FTPClient fTPClient, String string, String string2, boolean bl, int n, boolean bl2, boolean bl3, boolean bl4) throws FileTransferException, IOException {
        try {
            Object object;
            Object object2;
            File file;
            List<FTPFile> list;
            ValidationHelper.checkForNullAndBlank((String)"Host file name", (String)string);
            ValidationHelper.checkForNullAndBlank((String)"Agent file name", (String)string2);
            if (!fTPClient.isConnected()) {
                throw new IllegalArgumentException("FTP(S) is not connected");
            }
            try {
                this.setFileTransferMode(fTPClient, bl);
            }
            catch (IOException iOException) {
                throw new FileTransferException("Could Not change transfer mode to " + (bl ? "Binary" : "Text"), iOException, FileTransferReturnCode.unableToChangeTransferMode);
            }
            if (this.isVerbose()) {
                this.logTrace("Uploading \"", string2, "\" to \"", string, "\"");
            }
            if ((list = this.getFileList(fTPClient, string, false, true)) != null && list.size() > 0) {
                file = list.get(0);
                if (!file.isDirectory()) {
                    if (!bl2) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("The host file ");
                        stringBuilder.append(string);
                        stringBuilder.append(" exists, and the command specified not to replace.");
                        this.logTrace(stringBuilder);
                        throw new FileTransferException(stringBuilder.toString(), FileTransferReturnCode.remoteToFileAlreadyExists);
                    }
                } else {
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("The host file ");
                    ((StringBuilder)object2).append(string);
                    ((StringBuilder)object2).append(" exists. It is a folder, and the command specified not to replace.");
                    this.logTrace(object2);
                    if (bl3) {
                        object = new File(string2);
                        if (((File)object).isFile()) {
                            string = string.endsWith(FTP_FILE_SEPARATOR) ? string + ((File)object).getName() : string + FTP_FILE_SEPARATOR + ((File)object).getName();
                            this.put(fTPClient, string, string2, bl, n, bl2, false, bl4);
                            throw new TerminateMethodException(((StringBuilder)object2).toString());
                        }
                    } else {
                        throw new FileTransferException(((StringBuilder)object2).toString(), FileTransferReturnCode.remoteToFileAlreadyExistsIsFolder);
                    }
                }
            }
            file = new File(string2);
            object2 = null;
            try {
                boolean bl5;
                if (!file.exists()) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("The agent file '");
                    ((StringBuilder)object).append(string2);
                    ((StringBuilder)object).append("' does not exist.  Cannot upload '");
                    ((StringBuilder)object).append(string2);
                    ((StringBuilder)object).append("' to '");
                    ((StringBuilder)object).append(string);
                    ((StringBuilder)object).append("'.");
                    this.logTrace(object);
                    throw new FileTransferException(((StringBuilder)object).toString(), FileTransferReturnCode.systemFromFileNotFound);
                }
                if (file.isFile()) {
                    if (!file.canRead()) {
                        object = new StringBuilder();
                        ((StringBuilder)object).append("The agent file '");
                        ((StringBuilder)object).append(string2);
                        ((StringBuilder)object).append("' cannot be read.  Cannot upload '");
                        ((StringBuilder)object).append(string2);
                        ((StringBuilder)object).append("' to '");
                        ((StringBuilder)object).append(string);
                        ((StringBuilder)object).append("'.");
                        this.logTrace(object);
                        throw new FileTransferException(((StringBuilder)object).toString(), FileTransferReturnCode.systemFromFileCantRead);
                    }
                } else if (file.isDirectory()) {
                    if (bl4) {
                        String string3;
                        block34: {
                            object = file.listFiles();
                            string3 = string.endsWith(FTP_FILE_SEPARATOR) ? string + file.getName() : string + FTP_FILE_SEPARATOR + file.getName();
                            try {
                                this.makeDir(fTPClient, string3);
                            }
                            catch (IOException iOException) {
                                if (bl2) break block34;
                                StringBuilder stringBuilder = new StringBuilder();
                                stringBuilder.append("The host folder ");
                                stringBuilder.append(string3);
                                stringBuilder.append(" exists, and the command specified not to replace.");
                                this.logTrace(stringBuilder);
                                throw new FileTransferException(stringBuilder.toString(), FileTransferReturnCode.remoteToFileAlreadyExistsIsFolder);
                            }
                        }
                        for (Object object3 : object) {
                            String string4 = ((File)object3).isFile() ? string3 + FTP_FILE_SEPARATOR + ((File)object3).getName() : string3;
                            this.put(fTPClient, string4, ((File)object3).getAbsolutePath(), bl, n, bl2, bl3, bl4);
                        }
                        throw new TerminateMethodException();
                    }
                    object = new StringBuilder();
                    ((StringBuilder)object).append("The agent file '");
                    ((StringBuilder)object).append(string2);
                    ((StringBuilder)object).append("' is a directory.  Cannot upload '");
                    ((StringBuilder)object).append(string2);
                    ((StringBuilder)object).append("' to '");
                    ((StringBuilder)object).append(string);
                    ((StringBuilder)object).append("'.");
                    this.logTrace(object);
                    throw new FileTransferException(((StringBuilder)object).toString(), FileTransferReturnCode.systemFromPathIsFolder);
                }
                object2 = new FileInputStream(file);
                if (n > 0) {
                    fTPClient.setSoTimeout(n * 1000);
                }
                if (!(bl5 = fTPClient.storeFile(string, (InputStream)object2))) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Error uploading '");
                    stringBuilder.append(string2);
                    stringBuilder.append("' to '");
                    stringBuilder.append(string);
                    stringBuilder.append("'.");
                    throw new FileTransferException(stringBuilder.toString(), FileTransferReturnCode.remoteToFileCantWrite);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("The agent file '");
                stringBuilder.append(string2);
                stringBuilder.append("' cannot be read (not found).  Cannot upload '");
                stringBuilder.append(string2);
                stringBuilder.append("' to '");
                stringBuilder.append(string);
                stringBuilder.append("'.");
                this.logTrace(stringBuilder);
                throw new FileTransferException(stringBuilder.toString(), FileTransferReturnCode.systemFromFileCantRead);
            }
            finally {
                if (object2 != null) {
                    try {
                        ((FileInputStream)object2).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (TerminateMethodException terminateMethodException) {
            // empty catch block
        }
    }

    private String doubleQuoteString(String string, boolean bl) {
        if (!bl || string == null) {
            return string;
        }
        String string2 = "\"";
        if (string.contains(" ") && !string.contains(string2)) {
            return string2 + string + string2;
        }
        return string;
    }

    public void get(FTPClient fTPClient, String string, String string2, boolean bl, boolean bl2, int n, boolean bl3, boolean bl4, boolean bl5, boolean bl6) throws FileTransferException, IOException, DeleteFileException {
        try {
            CharSequence charSequence;
            String string3;
            List<FTPFile> list;
            Object object;
            ValidationHelper.checkForNullAndBlank((String)"Host file name", (String)string);
            ValidationHelper.checkForNullAndBlank((String)"Agent file name", (String)string2);
            if (!fTPClient.isConnected()) {
                throw new IllegalArgumentException("FTP(S) is not connected");
            }
            try {
                this.setFileTransferMode(fTPClient, bl);
            }
            catch (IOException iOException) {
                throw new FileTransferException("Could Not change transfer mode to " + (bl ? "Binary" : "Text"), iOException, FileTransferReturnCode.unableToChangeTransferMode);
            }
            if (this.isVerbose()) {
                this.logTrace("");
                this.logTrace("===============================================");
                this.logTrace("Downloading \"", string, "\" to \"", string2, "\"");
            }
            boolean bl7 = false;
            String[] stringArray = fTPClient.listNames(string);
            if (string.contains(" ") && (stringArray == null || stringArray.length < 1)) {
                stringArray = fTPClient.listNames(this.doubleQuoteString(string, true));
                bl7 = true;
            }
            if (stringArray == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("The host file \"");
                stringBuilder.append(string);
                stringBuilder.append("\" does not exist or an empty directory.  Cannot download \"");
                stringBuilder.append(string);
                stringBuilder.append("\" to \"");
                stringBuilder.append(string2);
                stringBuilder.append("\".");
                this.logTrace(stringBuilder);
                throw new FileTransferException(stringBuilder.toString(), FileTransferReturnCode.remoteFromFileNotFound);
            }
            if (bl5) {
                object = FileTransterUtils.getRemoteParentFolderPath((String)string);
                list = this.getFileList(fTPClient, this.doubleQuoteString((String)object, bl7), true, true);
                charSequence = FTPWorker.getFileByName(list, string3 = FileTransterUtils.getRemoteFileNameFromPath((String)string));
                if (charSequence != null) {
                    if (charSequence.isDirectory()) {
                        String string4 = FileTransterUtils.getRemoteFileNameFromPath((String)string);
                        List<FTPFile> list2 = this.getFileList(fTPClient, this.doubleQuoteString(string, bl7), true, true);
                        String string5 = string2.endsWith(File.separator) ? string2 + string4 : string2 + File.separator + string4;
                        new File(string5).mkdir();
                        this.arrayFilePaths.add(string);
                        for (FTPFile fTPFile : list2) {
                            if (fTPFile.getName().equals(".") || fTPFile.getName().equals("..")) continue;
                            String string6 = string + FTP_FILE_SEPARATOR + fTPFile.getName();
                            String string7 = fTPFile.isDirectory() ? string5 : string5 + File.separator + fTPFile.getName();
                            this.get(fTPClient, string6, string7, bl, bl2, n, bl3, bl4, bl5, bl6);
                        }
                        if (bl6) {
                            this.deleteDirectory(fTPClient);
                        }
                        throw new TerminateMethodException();
                    }
                } else {
                    System.out.println("The host file object (" + string3 + ") was not found in " + (String)object);
                }
            }
            if (((File)(object = new File(string2))).exists()) {
                if (((File)object).isFile()) {
                    if (!bl2) {
                        list = new StringBuilder();
                        ((StringBuilder)((Object)list)).append("The file ");
                        ((StringBuilder)((Object)list)).append(string2);
                        ((StringBuilder)((Object)list)).append(" exists, and the command specified not to replace.");
                        throw new FileTransferException(((StringBuilder)((Object)list)).toString(), FileTransferReturnCode.systemToFileAlreadyExists);
                    }
                    if (!((File)object).canWrite()) {
                        list = new StringBuilder();
                        ((StringBuilder)((Object)list)).append("The file ");
                        ((StringBuilder)((Object)list)).append(string2);
                        ((StringBuilder)((Object)list)).append(" exists, but can't write on this file.");
                        throw new FileTransferException(((StringBuilder)((Object)list)).toString(), FileTransferReturnCode.systemToFileAlreadyExistsAndCantWrite);
                    }
                } else if (((File)object).isDirectory()) {
                    list = new StringBuilder();
                    ((StringBuilder)((Object)list)).append("The file ");
                    ((StringBuilder)((Object)list)).append(string2);
                    ((StringBuilder)((Object)list)).append(" exists, and is folder.");
                    if (bl4) {
                        string3 = FileTransterUtils.getRemoteFileNameFromPath((String)string);
                        string2 = string2.endsWith(File.separator) ? string2 + string3 : string2 + File.separator + string3;
                        this.get(fTPClient, string, string2, bl, bl2, n, bl3, false, bl5, bl6);
                        throw new TerminateMethodException(((StringBuilder)((Object)list)).toString());
                    }
                    throw new FileTransferException(((StringBuilder)((Object)list)).toString(), FileTransferReturnCode.systemToFileAlreadyExistsIsFolder);
                }
            }
            list = null;
            try {
                boolean bl8;
                try {
                    list = new FileOutputStream((File)object);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (!bl3) {
                        charSequence = new StringBuilder();
                        ((StringBuilder)charSequence).append("Error downloading '");
                        ((StringBuilder)charSequence).append(string);
                        ((StringBuilder)charSequence).append("' to '");
                        ((StringBuilder)charSequence).append(string2);
                        ((StringBuilder)charSequence).append("' .");
                        throw new FileTransferException(((StringBuilder)charSequence).toString(), FileTransferReturnCode.remoteFromFileCantRead);
                    }
                    charSequence = ((File)object).getParent();
                    File file = new File((String)charSequence);
                    if (AgentJobLog.isWindows()) {
                        try {
                            charSequence = file.getCanonicalPath();
                        }
                        catch (Throwable throwable) {
                            charSequence = file.getAbsolutePath();
                        }
                    } else {
                        charSequence = file.getAbsolutePath();
                    }
                    if (this.isVerbose()) {
                        this.logTrace("Attempting to create required path: ", charSequence);
                    }
                    if (new File((String)charSequence).mkdirs()) {
                        list = new FileOutputStream((File)object);
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("The file ");
                    stringBuilder.append(string2);
                    stringBuilder.append(" exists, but can't write on this file.");
                    throw new FileTransferException(stringBuilder.toString(), fileNotFoundException, FileTransferReturnCode.systemToFileAlreadyExistsAndCantWrite);
                }
                if (n > 0) {
                    fTPClient.setSoTimeout(n * 1000);
                }
                if (!(bl8 = fTPClient.retrieveFile(this.doubleQuoteString(string, bl7), (OutputStream)((Object)list)))) {
                    ((File)object).deleteOnExit();
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append("Error downloading '");
                    ((StringBuilder)charSequence).append(string);
                    ((StringBuilder)charSequence).append("' to '");
                    ((StringBuilder)charSequence).append(string2);
                    ((StringBuilder)charSequence).append("'.");
                    throw new FileTransferException(((StringBuilder)charSequence).toString(), FileTransferReturnCode.remoteFromFileCantRead);
                }
                if (bl6) {
                    if (!fTPClient.deleteFile(string)) {
                        charSequence = "Could not delete " + string + " from remote";
                        throw new DeleteFileException((String)charSequence, FileTransferReturnCode.remoteToFileCantDelete);
                    }
                    this.logTrace("File " + string + " was deleted from remote");
                    this.deleteDirectory(fTPClient);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append("Unable to create file ");
                ((StringBuilder)charSequence).append(fileNotFoundException.getMessage());
                throw new FileTransferException(((StringBuilder)charSequence).toString(), FileTransferReturnCode.systemToFileNotFound);
            }
            finally {
                if (list != null) {
                    try {
                        ((FileOutputStream)((Object)list)).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (TerminateMethodException terminateMethodException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(ChannelSftp channelSftp, String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws FileTransferException, FileNotFoundException, SftpException, DeleteFileException {
        try {
            Object object;
            String string3;
            List<ChannelSftp.LsEntry> list;
            Object object2;
            string = this.remoteAbsolutePathSFTP(channelSftp, string);
            ValidationHelper.checkForNullAndBlank((String)"Host file name", (String)string);
            ValidationHelper.checkForNullAndBlank((String)"Agent file name", (String)string2);
            if (!channelSftp.isConnected()) {
                throw new IllegalArgumentException("SFTP is not connected");
            }
            if (channelSftp.isClosed()) {
                throw new IllegalArgumentException("SFTP connection is closed");
            }
            if (this.isVerbose()) {
                this.logTrace("");
                this.logTrace("===============================================");
                this.logTrace("Downloading '", string, "' to '", string2, "'");
            }
            try {
                object2 = channelSftp.ls(string);
                if (object2 == null) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("The host file ");
                    stringBuilder.append(string);
                    stringBuilder.append(" does not exist or an empty directory.  Cannot download '");
                    stringBuilder.append(string);
                    stringBuilder.append("' to '");
                    stringBuilder.append(string2);
                    stringBuilder.append("'.");
                    this.logTrace(stringBuilder);
                    throw new FileTransferException(stringBuilder.toString(), FileTransferReturnCode.remoteFromFileNotFound);
                }
            }
            catch (SftpException sftpException) {
                if (sftpException.id == 2) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("The host file ");
                    stringBuilder.append(string);
                    stringBuilder.append(" does not exist.  Cannot download '");
                    stringBuilder.append(string);
                    stringBuilder.append("' to '");
                    stringBuilder.append(string2);
                    stringBuilder.append("'.");
                    this.logTrace(stringBuilder);
                    throw new FileTransferException(stringBuilder.toString(), FileTransferReturnCode.remoteFromFileNotFound);
                }
                throw sftpException;
            }
            if (bl4) {
                object2 = FileTransterUtils.getRemoteParentFolderPath((String)string);
                list = this.getFileList(channelSftp, (String)object2, true);
                object = FTPWorker.getFileByNameSftp(list, string3 = FileTransterUtils.getRemoteFileNameFromPath((String)string));
                if (object != null) {
                    if (object.getAttrs().isDir()) {
                        List<ChannelSftp.LsEntry> list2 = this.getFileList(channelSftp, string, true);
                        String string4 = FileTransterUtils.getRemoteFileNameFromPath((String)string);
                        String string5 = string2.endsWith(File.separator) ? string2 + string4 : string2 + File.separator + string4;
                        new File(string5).mkdir();
                        this.arrayFilePaths.add(string);
                        for (ChannelSftp.LsEntry lsEntry : list2) {
                            if (lsEntry.getFilename().equals(".") || lsEntry.getFilename().equals("..")) continue;
                            String string6 = string + FTP_FILE_SEPARATOR + lsEntry.getFilename();
                            String string7 = lsEntry.getAttrs().isDir() ? string5 : string5 + File.separator + lsEntry.getFilename();
                            this.get(channelSftp, string6, string7, bl, bl2, bl3, bl4, bl5);
                        }
                        if (bl5) {
                            this.deleteDirectory(channelSftp);
                        }
                        throw new TerminateMethodException();
                    }
                } else {
                    System.out.println("The host file object (" + string3 + ") was not found in " + (String)object2);
                }
            }
            if (((File)(object2 = new File(string2))).exists()) {
                if (((File)object2).isFile()) {
                    if (!bl) {
                        list = new StringBuilder();
                        ((StringBuilder)((Object)list)).append("The file ");
                        ((StringBuilder)((Object)list)).append(string2);
                        ((StringBuilder)((Object)list)).append(" exists, and the command specified not to replace.");
                        throw new FileTransferException(((StringBuilder)((Object)list)).toString(), FileTransferReturnCode.systemToFileAlreadyExists);
                    }
                    if (!((File)object2).canWrite()) {
                        list = new StringBuilder();
                        ((StringBuilder)((Object)list)).append("The file ");
                        ((StringBuilder)((Object)list)).append(string2);
                        ((StringBuilder)((Object)list)).append(" exists, but can't write on this file.");
                        throw new FileTransferException(((StringBuilder)((Object)list)).toString(), FileTransferReturnCode.systemToFileAlreadyExistsAndCantWrite);
                    }
                } else if (((File)object2).isDirectory()) {
                    list = new StringBuilder();
                    ((StringBuilder)((Object)list)).append("The file ");
                    ((StringBuilder)((Object)list)).append(string2);
                    ((StringBuilder)((Object)list)).append(" exists, and is folder.");
                    if (bl3) {
                        string3 = FileTransterUtils.getRemoteFileNameFromPath((String)string);
                        string2 = string2.endsWith(File.separator) ? string2 + string3 : string2 + File.separator + string3;
                        this.get(channelSftp, string, string2, bl, bl2, false, bl4, bl5);
                        throw new TerminateMethodException(((StringBuilder)((Object)list)).toString());
                    }
                    throw new FileTransferException(((StringBuilder)((Object)list)).toString(), FileTransferReturnCode.systemToFileAlreadyExistsIsFolder);
                }
            }
            list = null;
            try {
                try {
                    list = new FileOutputStream((File)object2);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (!bl2) {
                        object = new StringBuilder();
                        ((StringBuilder)object).append("Error downloading '");
                        ((StringBuilder)object).append(string);
                        ((StringBuilder)object).append("' to '");
                        ((StringBuilder)object).append(string2);
                        ((StringBuilder)object).append("'.");
                        throw new FileTransferException(((StringBuilder)object).toString(), fileNotFoundException, FileTransferReturnCode.remoteFromFileCantRead);
                    }
                    object = ((File)object2).getParent();
                    File file = new File((String)object);
                    if (AgentJobLog.isWindows()) {
                        try {
                            object = file.getCanonicalPath();
                        }
                        catch (Throwable throwable) {
                            object = file.getAbsolutePath();
                        }
                    } else {
                        object = file.getAbsolutePath();
                    }
                    if (this.isVerbose()) {
                        this.logTrace("Attempting to create required path: ", object);
                    }
                    if (new File((String)object).mkdirs()) {
                        list = new FileOutputStream((File)object2);
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("The file ");
                    stringBuilder.append(string2);
                    stringBuilder.append(" exists, but can't write on this file.");
                    throw new FileTransferException(stringBuilder.toString(), fileNotFoundException, FileTransferReturnCode.systemToFileAlreadyExistsAndCantWrite);
                }
                try {
                    this.logTrace("starting call ftp.get");
                    channelSftp.get(string, (OutputStream)((Object)list));
                    if (bl5) {
                        try {
                            channelSftp.rm(string);
                            this.logTrace("File " + string + " was deleted from remote");
                            this.deleteDirectory(channelSftp);
                        }
                        catch (Exception exception) {
                            object = "Could not delete " + string + " from remote: " + exception.getMessage();
                            throw new DeleteFileException((String)object, FileTransferReturnCode.remoteToFileCantDelete);
                        }
                    }
                    this.logTrace("starting call ftp.get");
                }
                catch (SftpException sftpException) {
                    ((File)object2).deleteOnExit();
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Error downloading '");
                    ((StringBuilder)object).append(string);
                    ((StringBuilder)object).append("' to '");
                    ((StringBuilder)object).append(string2);
                    ((StringBuilder)object).append("'.");
                    throw new FileTransferException(((StringBuilder)object).toString(), sftpException, FileTransferReturnCode.remoteFromFileCantRead);
                }
            }
            finally {
                if (list != null) {
                    try {
                        ((FileOutputStream)((Object)list)).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (TerminateMethodException terminateMethodException) {
            // empty catch block
        }
    }

    private void deleteDirectory(FTPClient fTPClient) {
        String string = "";
        try {
            Iterator<String> iterator = this.arrayFilePaths.iterator();
            while (iterator.hasNext()) {
                string = iterator.next();
                List<FTPFile> list = this.getFileList(fTPClient, this.doubleQuoteString(string, true), true, false);
                if (list != null && !list.isEmpty()) continue;
                int n = fTPClient.rmd(string);
                iterator.remove();
                switch (n) {
                    case 250: {
                        this.logTrace("File " + string + " was deleted from remote " + n);
                    }
                }
            }
        }
        catch (Exception exception) {
            this.logTrace("Could not delete " + string + " from remote. " + exception.getMessage());
        }
    }

    private void deleteDirectory(ChannelSftp channelSftp) {
        String string = "";
        try {
            Iterator<String> iterator = this.arrayFilePaths.iterator();
            while (iterator.hasNext()) {
                string = iterator.next();
                List<ChannelSftp.LsEntry> list = this.getFileList(channelSftp, string, true);
                SftpATTRS sftpATTRS = channelSftp.stat(string);
                if (!sftpATTRS.isDir() || list.size() >= 3) continue;
                channelSftp.rmdir(string);
                iterator.remove();
                this.logTrace("File " + string + " was deleted from remote");
            }
        }
        catch (Exception exception) {
            this.logTrace("Could not delete " + string + " from remote. " + exception.getMessage());
        }
    }

    private String remoteAbsolutePathSFTP(ChannelSftp channelSftp, String string) throws SftpException {
        if (!string.isEmpty() && string.charAt(0) == '/') {
            return string;
        }
        String string2 = channelSftp.getHome();
        if (string2.endsWith(FTP_FILE_SEPARATOR)) {
            return string2 + string;
        }
        return string2 + FTP_FILE_SEPARATOR + string;
    }

    public void closeSFTP(ChannelSftp channelSftp, String string) {
        if (channelSftp.isConnected()) {
            try {
                if (this.isVerbose()) {
                    this.logTrace("Quitting from: ", string);
                }
                channelSftp.quit();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (this.isVerbose()) {
                    this.logTrace("Disconnecting from: ", string);
                }
                channelSftp.disconnect();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Session session = channelSftp.getSession();
                session.disconnect();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void closeFTP(FTPClient fTPClient, String string) {
        if (fTPClient.isConnected()) {
            try {
                if (this.isVerbose()) {
                    this.logTrace("Quitting from: ", string);
                }
                fTPClient.quit();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (this.isVerbose()) {
                    this.logTrace("Disconnecting from: ", string);
                }
                fTPClient.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void closeFTPS(FTPSClient fTPSClient, String string) {
        if (fTPSClient.isConnected()) {
            try {
                if (this.isVerbose()) {
                    this.logTrace("Quitting from: ", string);
                }
                fTPSClient.quit();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (this.isVerbose()) {
                    this.logTrace("Disconnecting from: ", string);
                }
                fTPSClient.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void main(String[] stringArray) {
        FTPWorker fTPWorker = null;
        try {
            FTPClient fTPClient = fTPWorker.connect("10.137.25.216", 21, "vahan", "123456");
            int n = fTPWorker.makeDir(fTPClient, "Account/ChangePassword.aspx");
            fTPWorker.closeFTP(fTPClient, "10.137.25.216");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void logTrace(Object ... objectArray) {
        String string = Utils.concatToStrings(objectArray);
        System.out.println(string);
    }

    private class JSCHLogger
    implements Logger {
        private static final int MIN_LOG_LEVEL = 0;

        private JSCHLogger() {
        }

        public boolean isEnabled(int n) {
            return n >= 0;
        }

        public void log(int n, String string) {
            String string2 = null;
            switch (n) {
                case 0: {
                    string2 = "DEBUG";
                    break;
                }
                case 1: {
                    string2 = "INFO";
                    break;
                }
                case 2: {
                    string2 = "WARN";
                    break;
                }
                case 3: {
                    string2 = "ERROR";
                    break;
                }
                case 4: {
                    string2 = "FATAL";
                    break;
                }
                default: {
                    string2 = "UNDEFINED:" + n;
                }
            }
            System.out.println("JSCHLogger." + string2 + ": " + string);
        }
    }

    public class TerminateMethodException
    extends Exception {
        public TerminateMethodException() {
        }

        public TerminateMethodException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public TerminateMethodException(String string) {
            super(string);
        }

        public TerminateMethodException(Throwable throwable) {
            super(throwable);
        }
    }

    public static class MyUserInfo
    implements UserInfo {
        String passwd;
        boolean unknownHostChallenge;

        public MyUserInfo(String string, boolean bl) {
            this.passwd = string;
            this.unknownHostChallenge = bl;
        }

        public String getPassword() {
            return this.passwd;
        }

        public boolean promptYesNo(String string) {
            System.out.println(string + " " + (this.unknownHostChallenge ? "OK" : "Cancel"));
            return this.unknownHostChallenge;
        }

        public String getPassphrase() {
            return null;
        }

        public boolean promptPassphrase(String string) {
            System.out.println(string);
            return true;
        }

        public boolean promptPassword(String string) {
            System.out.println(string);
            return true;
        }

        public void showMessage(String string) {
            System.out.println(string);
        }
    }

    private static enum FTP_MODE {
        ACTIVE,
        PASSIVE,
        UNDEFINED;

    }
}

