/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.exec;

import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.busobj.UserIdentity;
import com.helpsystems.common.core.event.GenericEvent;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.common.server.file.RemoteFileAM;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.enterprise.core.busobj.CopyToServerResults;
import com.helpsystems.enterprise.core.busobj.JobHistory;
import com.helpsystems.enterprise.core.busobj.JobLogCopiedEvent;
import com.helpsystems.enterprise.core.busobj.JobStatusCode;
import com.helpsystems.enterprise.core.busobj.OutputDistribution;
import com.helpsystems.enterprise.core.dm.FilePeerGatewayAM;
import com.helpsystems.enterprise.core.dm.JobExecDM;
import com.helpsystems.enterprise.core.dm.JobHistoryDM;
import com.helpsystems.enterprise.core.dm.JobTrackerAM;
import com.helpsystems.enterprise.core.dm.OutputDistributionAM;
import com.helpsystems.enterprise.core.dm.OutputDistributionDM;
import com.helpsystems.enterprise.core.dm.StandbyBackupFileQueueAM;
import com.helpsystems.enterprise.core.exec.ExecutableJob;
import com.helpsystems.enterprise.core.exec.JobCompletionInfo;
import com.helpsystems.enterprise.core.scheduler.ScheduleJob;
import com.helpsystems.enterprise.core.user.file.StandbyBackupFile;
import com.helpsystems.enterprise.module.exec.RemoteFileCopier;
import com.helpsystems.enterprise.peer.AgentPeer;
import com.helpsystems.enterprise.peer.DefaultConfigPath;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class AgentOutputWorker {
    private static final Logger logger = Logger.getLogger(AgentOutputWorker.class);
    private JobCompletionInfo info;
    private ExecutableJob ej;
    private long evid;
    private List<String> extraJobLogStuff;
    private RemoteFileAM rfAM = null;
    private AgentPeer agentServer;
    private OutputDistribution[] outputDistributionList;
    private OutputDistributionAM outputDistributionAM;
    private StandbyBackupFileQueueAM standbyBackupFileQueueAM;
    private static List<JobLogCopiedEvent> jobLogCopiedEventList = new ArrayList<JobLogCopiedEvent>();
    private JobHistoryDM jobHistoryDM;

    public AgentOutputWorker(JobCompletionInfo jobCompletionInfo, AgentPeer agentPeer) {
        this.info = jobCompletionInfo;
        this.agentServer = agentPeer;
        this.standbyBackupFileQueueAM = (StandbyBackupFileQueueAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.StandbyBackupFileQueueAM");
        if (jobCompletionInfo.isSupportingOutputDistribution()) {
            long l = jobCompletionInfo.getExecutableJob().getScheduleJob().getSkybotJobNumber();
            try {
                OutputDistributionDM outputDistributionDM = (OutputDistributionDM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)agentPeer.getConnectedAgentServer(), (String)"ENTERPRISE.OutputDistributiontDM");
                this.outputDistributionList = outputDistributionDM.getByJobId(l);
            }
            catch (Exception exception) {
                String string = "Error while retrieving the output distribution for jobId = " + l;
                logger.debug((Object)string, (Throwable)exception);
            }
        } else {
            logger.debug((Object)"Output Distribution is not supported on this Agent.");
        }
        this.ej = jobCompletionInfo.getExecutableJob();
        this.extraJobLogStuff = new ArrayList<String>();
        this.outputDistributionAM = (OutputDistributionAM)ManagerRegistry.getManagerStartsWith((String)"ENTERPRISE.OutputDistributionAM");
        this.jobHistoryDM = (JobHistoryDM)ManagerRegistry.getManagerStartsWith((String)"ENTERPRISE.JobHistoryDM");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        block10: {
            int n = Integer.parseInt(this.info.getExecutableJob().getEventID());
            Object object = this;
            synchronized (object) {
                this.outputDistributionAM.terminateDistribution(n);
            }
            try {
                object = this.jobHistoryDM.get(n);
                JobStatusCode jobStatusCode = ((JobHistory)((Object)object)).getStatusCode();
                switch (jobStatusCode) {
                    case CANCELED: {
                        this.info.setCompletionCode('A');
                        break;
                    }
                    case COMPLETED: {
                        this.info.setCompletionCode('C');
                        break;
                    }
                    case FAILED: {
                        this.info.setCompletionCode('F');
                        break;
                    }
                    default: {
                        throw new IllegalStateException("The job cannot be ended with status code: " + jobStatusCode);
                    }
                }
                this.info.setTerminationReason("Job termination was requested by the server.");
            }
            catch (Exception exception) {
                if (!logger.isDebugEnabled()) break block10;
                logger.debug((Object)("Error retrieving job history for Event ID: " + n), (Throwable)exception);
            }
        }
    }

    public void run() {
        Object object;
        Object object2;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"*** Inside AgentOutputWorker.run()");
        }
        String string = this.ej.getEventID();
        this.evid = -1L;
        try {
            this.evid = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.info.setCompletionCode('F');
            String string2 = "Unable to parse event-ID " + string + ", output cannot be saved.";
            this.info.setTerminationReason(string2);
            logger.debug((Object)string2, (Throwable)numberFormatException);
            return;
        }
        try {
            this.rfAM = (RemoteFileAM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)this.info.getPeerID(), (String)"COMMON.RemoteFileAM");
        }
        catch (Exception exception) {
            object2 = "Unable to access Remote Files on Agent " + this.info.getPeerID();
            logger.debug(object2, (Throwable)exception);
            this.rfAM = null;
        }
        if (this.outputDistributionList != null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("*** Found outputDistribution for " + this.evid + " job history id"));
            }
            this.processAgentPeerCommands();
        }
        PeerID peerID = this.info.getFilePeerID();
        if (this.isAgentPresent() && peerID != null) {
            object2 = this.info.getPeerID();
            try {
                object = (FilePeerGatewayAM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)object2, (String)"ENTERPRISE.FilePeerGatewayAM");
                object.finished(peerID);
            }
            catch (Exception exception) {
                logger.debug((Object)("Unable to tell agent " + object2 + " that we're finished with " + peerID), (Throwable)exception);
            }
            this.endFilePeer();
        }
        this.info.setJobExecLogTransferred(false);
        object2 = this.ej.getScheduleJob();
        if (!this.info.isJobLogProcessFinished() && (this.ej.isCopyJobLogToServer() || ((ScheduleJob)((Object)object2)).isSendFailJobLog() || ((ScheduleJob)((Object)object2)).isSendCancelJobLog() || ((ScheduleJob)((Object)object2)).isSendCompleteJobLog() || ((ScheduleJob)((Object)object2)).isEmailJobLog() || this.info.getCompletionCode() != 'C')) {
            this.copyJobLog();
        } else {
            object = "Unable to delete agent-job-log from agent " + this.info.getPeerID();
            boolean bl = false;
            Exception exception = null;
            for (int i = 0; !bl && i < 120; ++i) {
                try {
                    if (this.rfAM != null) {
                        this.rfAM.delete(UserIdentity.NO_USER_SPECIFIED, this.info.getJobLogFilename());
                        bl = true;
                        exception = null;
                        return;
                    }
                    logger.debug(object);
                    return;
                }
                catch (Exception exception2) {
                    exception = exception2;
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
            if (exception != null) {
                logger.debug(object, exception);
            }
        }
    }

    private void processAgentPeerCommands() {
        logger.trace((Object)"*** Inside AgentOutputWorker.processAgentPeerCommands");
        if (this.info.getCompletionCode() == 'C') {
            if (this.isAgentPresent()) {
                logger.trace((Object)"*** Inside AgentOutputWorker.processAgentPeerCommands() Agent is present");
                logger.debug((Object)("Starting output distribution for EventID " + this.info.getExecutableJob().getEventID()));
                HashMap<String, CopyToServerResults> hashMap = this.outputDistributionAM.copyToServer(this.info);
                try {
                    this.outputDistributionAM.sendEmail(Long.parseLong(this.ej.getEventID()), hashMap);
                    logger.debug((Object)("Output Distribution for EventID " + this.ej.getEventID() + " has completed."));
                }
                catch (Exception exception) {
                    logger.error((Object)("Mail is not sent for jobHistoryID:" + this.ej.getEventID()), (Throwable)exception);
                }
            } else {
                this.outputDistributionAM.addToQueue(this.info);
            }
        }
    }

    private boolean isAgentPresent() {
        ValidationHelper.checkForNull((String)"PeerID on JobCompletionInfo", (Object)this.info.getPeerID());
        return this.agentServer.getPeerFromRoutingTable(this.info.getPeerID()) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendJobLog(String string) {
        List<String> list = this.extraJobLogStuff;
        synchronized (list) {
            this.extraJobLogStuff.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyJobLog() {
        Object object;
        Serializable serializable;
        Object object2;
        String string;
        ScheduleJob scheduleJob = this.ej.getScheduleJob();
        boolean bl = this.ej.isCopyJobLogToServer() || scheduleJob.isEmailJobLog();
        String string2 = this.info.getJobLogFilename();
        if (string2 == null) {
            logger.warn((Object)"Unable to copy the Agent job log to the server.  The file name was not set in the completion information sent from the Agent.");
            return;
        }
        switch (this.info.getCompletionCode()) {
            case 'C': {
                if (!scheduleJob.isSendCompleteJobLog()) break;
                bl = true;
                break;
            }
            case 'E': 
            case 'F': {
                bl = true;
                break;
            }
            case 'A': {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        RemoteFileCopier remoteFileCopier = new RemoteFileCopier(this.info.getPeerID(), string2);
        remoteFileCopier.setDeleteWhenFinished(true);
        if (!this.isAgentPresent()) {
            remoteFileCopier.setSkipRemoteStuff(true);
            this.appendJobLog("The command execution log is not available because the remote Agent is no longer connected.");
        }
        if ((string = this.info.getTerminationReason()) != null && string.length() > 0) {
            object2 = this.extraJobLogStuff;
            synchronized (object2) {
                this.extraJobLogStuff.add(string);
            }
        }
        object2 = null;
        String string3 = null;
        if (bl) {
            long l = 0L;
            try {
                l = this.info.getWhenEnded();
            }
            catch (Exception exception) {
                l = 0L;
            }
            string3 = AgentOutputWorker.getServerDirectoryName(l, true);
            object2 = DefaultConfigPath.getLogFile((String)string3, (long)this.evid, (String)this.ej.getAgent().getName(), (String)this.ej.getJobHistory().getJobName(), (long)l, (boolean)true);
            if (!(string3 == null || string3.length() <= 0 || ((File)(serializable = new File(string3))).exists() && ((File)serializable).isDirectory())) {
                String string4 = "Unable to copy the Agent JobLog to the Server, the directory " + string3 + " does not exist.";
                this.appendJobLog(string4);
                logger.debug((Object)string4);
            }
            remoteFileCopier.setServerFilename((String)object2);
            remoteFileCopier.setExtraStuff(this.extraJobLogStuff);
        }
        boolean bl2 = remoteFileCopier.run(bl);
        this.info.setJobExecLogTransferred(bl2);
        JobTrackerAM jobTrackerAM = (JobTrackerAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobTrackerAM");
        serializable = new ArrayList();
        for (int i = 0; i < jobLogCopiedEventList.size(); ++i) {
            object = jobLogCopiedEventList.get(i);
            ((JobLogCopiedEvent)((Object)object)).setCopiedFileName((String)object2);
            if (!jobTrackerAM.serviceEvent((GenericEvent)object, this.evid, this.info.wasTerminatedByServer())) continue;
            serializable.add(object);
        }
        jobLogCopiedEventList.removeAll((Collection<?>)((Object)serializable));
        Throwable throwable = remoteFileCopier.getServerWriteError();
        if (throwable != null) {
            logger.debug((Object)("Unable to copy Agent Job Output to file " + (String)object2), throwable);
        }
        if (bl2 && throwable == null) {
            object = new StandbyBackupFile();
            ((StandbyBackupFile)object).setActionType(0);
            ((StandbyBackupFile)object).setFileType(0);
            ((StandbyBackupFile)object).setServerDirName(string3);
            ((StandbyBackupFile)object).setServerFileName((String)object2);
            File file = new File((String)object2);
            ((StandbyBackupFile)object).setFullFileName(file.getAbsolutePath());
            try {
                this.standbyBackupFileQueueAM.putStandbyBackupFile((StandbyBackupFile)object);
            }
            catch (ActionFailedException actionFailedException) {
                logger.debug((Object)"Unable to put user transfer file to queue ", (Throwable)actionFailedException);
            }
        }
    }

    public static String getServerDirectoryName(long l, boolean bl) {
        String string = null;
        if (l > 0L && AgentOutputWorker.directoryExists(string = DefaultConfigPath.getJobLogDirectoryDated((long)l, (boolean)bl), false)) {
            return string;
        }
        string = DefaultConfigPath.getJobLogDirectory();
        if (!AgentOutputWorker.directoryExists(string, true)) {
            return null;
        }
        return string;
    }

    private static boolean directoryExists(String string, boolean bl) {
        File file = new File(string);
        if (!file.exists() || !file.isDirectory()) {
            if (bl) {
                logger.debug((Object)("Agent JobLog directory on from the Server named " + string + " does not exist."));
            }
            return false;
        }
        return true;
    }

    private void endFilePeer() {
        PeerID peerID = this.info.getPeerID();
        String string = this.info.getExecutableJob().getEventID();
        try {
            JobExecDM jobExecDM = (JobExecDM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)peerID, (String)"ENTERPRISE.JobExecDM");
            jobExecDM.finishJob(string);
        }
        catch (Exception exception) {
            logger.debug((Object)("Unable to notify " + peerID + " that we're finished with job " + string));
        }
    }

    public OutputDistribution[] getOutputDistributions() {
        return this.outputDistributionList;
    }

    public static void addJobLogCopiedEventToList(JobLogCopiedEvent jobLogCopiedEvent) {
        if (!jobLogCopiedEventList.contains((Object)jobLogCopiedEvent)) {
            jobLogCopiedEventList.add(jobLogCopiedEvent);
        }
    }
}

