/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.event.GenericEvent;
import com.helpsystems.common.core.event.SimpleEventListener;
import com.helpsystems.enterprise.core.busobj.CopyToServerResults;
import com.helpsystems.enterprise.core.busobj.CustomMailMessage;
import com.helpsystems.enterprise.core.busobj.EmailTargetAttachment;
import com.helpsystems.enterprise.core.busobj.JobEndedReasonCode;
import com.helpsystems.enterprise.core.busobj.JobHistory;
import com.helpsystems.enterprise.core.busobj.JobStatusCode;
import com.helpsystems.enterprise.core.busobj.MailSentEvent;
import com.helpsystems.enterprise.core.busobj.NotificationList;
import com.helpsystems.enterprise.core.busobj.OutputDistribution;
import com.helpsystems.enterprise.core.busobj.OutputDistributionException;
import com.helpsystems.enterprise.core.busobj.OutputDistributionHistory;
import com.helpsystems.enterprise.core.busobj.SystemSetup;
import com.helpsystems.enterprise.core.dm.EmailTargetAttachmentDM;
import com.helpsystems.enterprise.core.dm.EnterpriseEmailAM;
import com.helpsystems.enterprise.core.dm.JobCompletionDM;
import com.helpsystems.enterprise.core.dm.JobHistoryDM;
import com.helpsystems.enterprise.core.dm.MRHelper;
import com.helpsystems.enterprise.core.dm.NotificationListDM;
import com.helpsystems.enterprise.core.dm.OutputDistributionAM;
import com.helpsystems.enterprise.core.dm.OutputDistributionHistoryDM;
import com.helpsystems.enterprise.core.dm.ScheduleJobDM;
import com.helpsystems.enterprise.core.dm.StandbyBackupFileQueueAM;
import com.helpsystems.enterprise.core.dm.SystemSetupDM;
import com.helpsystems.enterprise.core.exec.JobCompletionInfo;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobBigProxy;
import com.helpsystems.enterprise.core.user.file.StandbyBackupFile;
import com.helpsystems.enterprise.core.util.ArrayTokenizer;
import com.helpsystems.enterprise.core.util.FileHandler;
import com.helpsystems.enterprise.core.util.OutputDistributionSetup;
import com.helpsystems.enterprise.module.exec.RemoteFileCopier;
import com.helpsystems.enterprise.peer.AgentPeer;
import com.helpsystems.enterprise.peer.DefaultConfigPath;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

public class OutputDistributionAMImpl
extends AbstractManager
implements OutputDistributionAM,
SimpleEventListener {
    private static final Logger LOGGER = Logger.getLogger(OutputDistributionAMImpl.class);
    private EmailTargetAttachmentDM emailTargetAttachmentDM = null;
    private OutputDistributionHistoryDM outputDistributionHistoryDM = null;
    private final ScheduleJobDM scheduleJobDM;
    private final JobHistoryDM jobHistoryDM;
    private final SystemSetupDM systemSetupDM;
    private NotificationListDM notificationListDM;
    private StandbyBackupFileQueueAM standbyBackupFileQueueAM;
    private JobCompletionDM jobCompletionDM;
    private final EnterpriseEmailAM enterpriseEmailAM;
    private final BlockingQueue<JobCompletionInfo> queue;
    private final AgentPeer peer;
    private Thread outputDistThread;
    private BlockingQueue<CustomMailMessage> mailQueue;
    private int maxEmailAttachmentSizeInBytes = 0;
    private List<CustomMailMessage> mailList;
    private HashMap<Long, RemoteFileCopier> currentRFCs = new HashMap();
    HashMap<Long, Boolean> activeDistributionsHM = new HashMap();

    public OutputDistributionAMImpl(AgentPeer agentPeer, EnterpriseEmailAM enterpriseEmailAM) {
        this.setName("ENTERPRISE.OutputDistributionAM");
        this.emailTargetAttachmentDM = (EmailTargetAttachmentDM)ManagerRegistry.getManagerStartsWith((String)"ENTERPRISE.EmailTargetAttachmentDM");
        this.outputDistributionHistoryDM = (OutputDistributionHistoryDM)ManagerRegistry.getManagerStartsWith((String)"ENTERPRISE.OutputDistributionHistoryDM");
        this.scheduleJobDM = (ScheduleJobDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ScheduleJobDM");
        this.jobHistoryDM = (JobHistoryDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobHistoryDM");
        this.systemSetupDM = (SystemSetupDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.SystemSetupDM");
        this.jobCompletionDM = (JobCompletionDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobCompletionDM");
        this.queue = new LinkedBlockingQueue<JobCompletionInfo>();
        this.enterpriseEmailAM = enterpriseEmailAM;
        enterpriseEmailAM.addEventListener(this);
        this.mailQueue = new LinkedBlockingQueue<CustomMailMessage>();
        this.mailList = new ArrayList<CustomMailMessage>();
        this.peer = agentPeer;
        this.outputDistThread = new Thread(new OutputDistributionQueueRunner());
        this.outputDistThread.setName("OutputDistributionQueueRunner");
        try {
            SystemSetup systemSetup = this.systemSetupDM.get();
            this.maxEmailAttachmentSizeInBytes = systemSetup.getMaxEmailAttachmentSize() * 1024 * 1024;
            int n = systemSetup.getEmailAttachmentRetryTime();
            n = n > 0 ? n : 15;
            Timer timer = new Timer();
            timer.schedule((TimerTask)new ResendMailTask(), 0L, (long)(n * 60 * 1000));
        }
        catch (DataException dataException) {
            LOGGER.info((Object)"Resend Mail process isn't start as there is problem with fetching EmailAttachmentRetryTime", (Throwable)dataException);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            LOGGER.info((Object)"Resend Mail process isn't start as there is problem with fetching EmailAttachmentRetryTime", (Throwable)resourceUnavailableException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap<String, CopyToServerResults> copyToServer(JobCompletionInfo jobCompletionInfo) {
        long l = Long.valueOf(jobCompletionInfo.getExecutableJob().getEventID());
        HashMap<String, CopyToServerResults> hashMap = new HashMap<String, CopyToServerResults>();
        if (this.checkJobCompletionInfo(jobCompletionInfo)) {
            HashMap<Long, Boolean> hashMap2;
            OutputDistribution[] outputDistributionArray = null;
            long l2 = jobCompletionInfo.getExecutableJob().getScheduleJob().getSkybotJobNumber();
            try {
                hashMap2 = MRHelper.getOutputDistributionDM();
                outputDistributionArray = hashMap2.getByJobId(l2);
            }
            catch (Exception exception) {
                String string = "Error while retrieving the output distribution for jobId = " + l2;
                throw new RuntimeException(string, exception);
            }
            hashMap2 = this.activeDistributionsHM;
            synchronized (hashMap2) {
                this.activeDistributionsHM.put(l, true);
                LOGGER.trace((Object)("activeDistributionsHM.size() = " + this.activeDistributionsHM.size()));
            }
            hashMap = this.copyToServer(jobCompletionInfo, outputDistributionArray);
            hashMap2 = this.activeDistributionsHM;
            synchronized (hashMap2) {
                this.activeDistributionsHM.remove(l);
                LOGGER.trace((Object)("activeDistributionsHM.size() = " + this.activeDistributionsHM.size()));
            }
        }
        return hashMap;
    }

    private HashMap<String, CopyToServerResults> copyToServer(JobCompletionInfo jobCompletionInfo, OutputDistribution[] outputDistributionArray) {
        HashMap<String, CopyToServerResults> hashMap = new HashMap<String, CopyToServerResults>();
        boolean bl = false;
        for (OutputDistribution outputDistribution : outputDistributionArray) {
            LOGGER.debug((Object)("Current distribution = " + outputDistribution.getFileFilter()));
            int n = 0;
            int n2 = 0;
            boolean bl2 = true;
            if (outputDistribution != null && (outputDistribution.getCopyFile() == 1 || outputDistribution.isEmailAttachment())) {
                Object object;
                long l = Long.parseLong(jobCompletionInfo.getExecutableJob().getEventID());
                List<String> list = jobCompletionInfo.getAgentOutputFile().get(outputDistribution.getOid());
                long l2 = outputDistribution.getDaysToKeep();
                long l3 = outputDistribution.getPurgeHandling();
                long l4 = -1L;
                if (l3 == 1L) {
                    l4 = 0L;
                } else if (l3 == 2L) {
                    object = Calendar.getInstance();
                    int n3 = (int)l2;
                    ((Calendar)object).add(5, n3);
                    l4 = ((Calendar)object).getTimeInMillis();
                }
                if (list == null || list.isEmpty()) {
                    if (outputDistribution.getFileFilter() != null && outputDistribution.getFileFilter().length() > 0) {
                        LOGGER.error((Object)("Unable to copy.  No files were found matching the filter: " + outputDistribution.getFileFilter()));
                    } else {
                        LOGGER.error((Object)"Unable to copy.  No files were found because the filter is blank.");
                    }
                    bl2 = false;
                } else {
                    object = null;
                    try {
                        object = OutputDistributionSetup.createDirForJobRun(l, outputDistribution.getOid());
                    }
                    catch (DataException dataException) {
                        LOGGER.error((Object)("Unable to create directory on server for coping files job history id is " + l), (Throwable)dataException);
                    }
                    catch (ResourceUnavailableException resourceUnavailableException) {
                        LOGGER.error((Object)("Unable to create directory on server for coping files job history id is " + l), (Throwable)resourceUnavailableException);
                    }
                    if (object == null || ((String)object).length() == 0) {
                        LOGGER.error((Object)("Unable to create directory on server for coping files job history id is " + l));
                        bl2 = false;
                    } else {
                        n = list.size();
                        LOGGER.debug((Object)("About to copy " + list.size() + " files to the server for distribution " + outputDistribution.getFileFilter()));
                        for (String string : list) {
                            try {
                                this.processOutputDistribution(outputDistribution, string, l, (String)object, l4, jobCompletionInfo);
                                ++n2;
                            }
                            catch (OutputDistributionException outputDistributionException) {
                                if (outputDistributionException.getReason().equals((Object)OutputDistributionException.Reason.TERMINATED)) {
                                    LOGGER.info((Object)outputDistributionException);
                                    bl2 = false;
                                    bl = true;
                                    break;
                                }
                                LOGGER.error((Object)outputDistributionException);
                                break;
                            }
                        }
                    }
                    if (object != null && new File((String)object).list().length == 0) {
                        FileHandler.deleteEmptyParentFoldersUntilGivenFolder((String)object, "attachments");
                    }
                }
            }
            if (LOGGER.isDebugEnabled()) {
                String string = "successful";
                if (!bl2) {
                    string = "unsuccessful";
                }
                LOGGER.debug((Object)("Copy to Server for Output Distribution " + outputDistribution.getFileFilter() + " was " + string + "."));
            }
            if (!bl2 && outputDistribution.isFailOnMissingFiles()) {
                jobCompletionInfo.setCompletionCode('F');
                jobCompletionInfo.setJobEndedReasonCode(JobEndedReasonCode.OUTPUT_DISTRIBUTION);
            }
            hashMap.put(String.valueOf(jobCompletionInfo.getExecutableJob().getEventID() + outputDistribution.getNotificationListId()), new CopyToServerResults(n, n2, outputDistribution.getFileFilter()));
            if (bl) break;
        }
        return hashMap;
    }

    private void processOutputDistribution(OutputDistribution outputDistribution, String string, long l, String string2, long l2, JobCompletionInfo jobCompletionInfo) throws OutputDistributionException {
        Object object;
        OutputDistributionHistory outputDistributionHistory = null;
        OutputDistributionHistory outputDistributionHistory2 = null;
        if (outputDistribution.getCopyFile() == 1) {
            outputDistributionHistory = new OutputDistributionHistory();
            outputDistributionHistory.setDistributionType(0);
            outputDistributionHistory.setFileName(FileHandler.getFileExactName(string));
            outputDistributionHistory.setJobHistoryId(l);
            outputDistributionHistory.setStatus(0);
            outputDistributionHistory.setLocation(string2);
            outputDistributionHistory.setKeepUntil(l2);
            try {
                outputDistributionHistory2 = this.outputDistributionHistoryDM.save(outputDistributionHistory);
            }
            catch (Exception exception) {
                LOGGER.error((Object)("Can't add outputDistributionHistory for job historyId:" + l), (Throwable)exception);
            }
        }
        RemoteFileCopier remoteFileCopier = new RemoteFileCopier(jobCompletionInfo.getPeerID(), string);
        remoteFileCopier.setFilePeerID(jobCompletionInfo.getFilePeerID());
        String string3 = FileHandler.getFileExactName(string);
        String string4 = string2 + File.separator + string3;
        File file = new File(string4);
        if (file.exists()) {
            if (outputDistribution.getCopyFile() == 0 || outputDistribution.getCopyDuplicate() == 0) {
                object = FileHandler.generateIncrementFileName(file);
                string4 = string2 + File.separator + (String)object;
                System.out.println("serverFileName is:" + string4);
            } else if (outputDistribution.getCopyDuplicate() == 2) {
                throw new OutputDistributionException(string3 + " file is not copied, file with this name already exists");
            }
        }
        remoteFileCopier.setServerFilename(string4);
        boolean bl = false;
        do {
            if ((object = remoteFileCopier.getServerWriteError()) != null) {
                block16: {
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException interruptedException) {
                        if (!LOGGER.isDebugEnabled()) break block16;
                        LOGGER.debug(object);
                    }
                }
                bl = true;
            }
            if (this.activeDistributionsHM.get(l).booleanValue()) {
                this.currentRFCs.put(l, remoteFileCopier);
                LOGGER.debug((Object)("About to copy " + string));
                remoteFileCopier.run(true);
                this.currentRFCs.remove(l);
                continue;
            }
            remoteFileCopier.terminate();
        } while (remoteFileCopier.getServerWriteError() != null && !remoteFileCopier.isTerminate() && !bl);
        object = remoteFileCopier.getServerWriteError();
        if (object != null && bl) {
            LOGGER.error((Object)("Unable to copy file after 2 tries " + string4), (Throwable)object);
        }
        if (remoteFileCopier.wasServerSuccessful()) {
            this.processSuccessfulRFC(outputDistribution, outputDistributionHistory2, string4, l, string2, l2);
            return;
        }
        if (outputDistributionHistory2 != null) {
            this.outputDistributionHistoryDM.updateStatus(outputDistributionHistory2.getOid(), 6);
        }
        if (remoteFileCopier.isTerminate()) {
            throw new OutputDistributionException("The RemoteFileCopier for " + string + " was terminated.", OutputDistributionException.Reason.TERMINATED);
        }
    }

    private void processSuccessfulRFC(OutputDistribution outputDistribution, OutputDistributionHistory outputDistributionHistory, String string, long l, String string2, long l2) {
        Object object;
        Object object2;
        if (outputDistribution.getCopyFile() == 1 & outputDistributionHistory != null) {
            outputDistributionHistory.setFileName(FileHandler.getFileExactName(string));
            this.outputDistributionHistoryDM.updateFileName(outputDistributionHistory.getOid(), outputDistributionHistory.getFileName());
            this.outputDistributionHistoryDM.updateStatus(outputDistributionHistory.getOid(), 1);
        }
        if (outputDistribution.isEmailAttachment()) {
            object2 = new OutputDistributionHistory();
            ((OutputDistributionHistory)((Object)object2)).setDistributionType(1);
            ((OutputDistributionHistory)((Object)object2)).setFileName(FileHandler.getFileExactName(string));
            ((OutputDistributionHistory)((Object)object2)).setJobHistoryId(l);
            ((OutputDistributionHistory)((Object)object2)).setStatus(0);
            ((OutputDistributionHistory)((Object)object2)).setLocation(string2);
            ((OutputDistributionHistory)((Object)object2)).setKeepUntil(l2);
            ((OutputDistributionHistory)((Object)object2)).setNotificationListId(outputDistribution.getNotificationListId());
            try {
                this.outputDistributionHistoryDM.save((OutputDistributionHistory)((Object)object2));
            }
            catch (Exception exception) {
                LOGGER.error((Object)("Can't add outputDistributionHistory for job historyId:" + l), (Throwable)exception);
            }
            object = new EmailTargetAttachment();
            ((EmailTargetAttachment)object).setResend(true);
            ((EmailTargetAttachment)object).setFileName(string);
            ((EmailTargetAttachment)object).setEmailStatus(0);
            ((EmailTargetAttachment)object).setJobHistoryId(l);
            ((EmailTargetAttachment)object).setNotificationListId(outputDistribution.getNotificationListId());
            ((EmailTargetAttachment)object).setDeleteOnSent(outputDistribution.getCopyFile() == 0);
            try {
                this.emailTargetAttachmentDM.save((EmailTargetAttachment)object);
            }
            catch (Exception exception) {
                LOGGER.error((Object)("Can not insert EmailTargetAttachment " + object), (Throwable)exception);
            }
        }
        object2 = new StandbyBackupFile();
        ((StandbyBackupFile)object2).setActionType(0);
        ((StandbyBackupFile)object2).setFileType(2);
        ((StandbyBackupFile)object2).setServerDirName(string2);
        object = FileHandler.getFileExactName(string);
        String string3 = string2 + File.separator + (String)object;
        ((StandbyBackupFile)object2).setServerFileName(string3);
        ((StandbyBackupFile)object2).setFullFileName(string);
        try {
            this.getStandbyBackupFileQueueAM().putStandbyBackupFile((StandbyBackupFile)object2);
        }
        catch (ActionFailedException actionFailedException) {
            LOGGER.debug((Object)"Unable to put user transfer file to queue ", (Throwable)actionFailedException);
        }
    }

    @Override
    public void addToQueue(JobCompletionInfo jobCompletionInfo) {
        this.queue.add(jobCompletionInfo);
        if (!this.outputDistThread.isAlive()) {
            this.outputDistThread.start();
        }
    }

    private boolean checkJobCompletionInfo(JobCompletionInfo jobCompletionInfo) {
        boolean bl = true;
        if (jobCompletionInfo == null) {
            bl = false;
            LOGGER.error((Object)"JobCompletionInfo is null");
        } else {
            if (jobCompletionInfo.getExecutableJob() == null) {
                bl = false;
                LOGGER.error((Object)"ExecutableJob is null in JobCompletionInfo object");
            } else if (jobCompletionInfo.getExecutableJob().getScheduleJob() == null) {
                bl = false;
                LOGGER.error((Object)"ScheduleJob is null in JobCompletionInfo.ExecutableJob");
            }
            if (jobCompletionInfo.getAgentOutputFile() == null) {
                bl = false;
                LOGGER.error((Object)"Output files info is null in JobCompletionInfo");
            }
        }
        return bl;
    }

    @Override
    public void doSend(long l, String string, String string2, String[] stringArray, Object object) {
        String[] stringArray2 = null;
        try {
            NotificationList notificationList = this.getNotificationListDM().get(l);
            LOGGER.debug((Object)("Sending joblog to notification list " + notificationList.getName() + "(" + l + ")"));
            stringArray2 = notificationList.getListOfUniqueEmails();
        }
        catch (NoDataException noDataException) {
            LOGGER.debug((Object)"Error loading notification list", (Throwable)noDataException);
        }
        catch (BadDataException badDataException) {
            LOGGER.debug((Object)"Error loading notification list", (Throwable)badDataException);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            LOGGER.debug((Object)"Error loading notification list", (Throwable)resourceUnavailableException);
        }
        if (stringArray2 != null) {
            int n = stringArray2.length;
            CustomMailMessage customMailMessage = (CustomMailMessage)object;
            if (n > 0) {
                try {
                    if (!this.mailList.contains(customMailMessage)) {
                        this.mailList.add(customMailMessage);
                    }
                    this.enterpriseEmailAM.sendMessage(stringArray2, string, string2, stringArray, customMailMessage);
                }
                catch (ResourceUnavailableException resourceUnavailableException) {
                    LOGGER.debug((Object)"Error sending email", (Throwable)resourceUnavailableException);
                }
                catch (ActionFailedException actionFailedException) {
                    LOGGER.debug((Object)"Error sending email", (Throwable)actionFailedException);
                }
            }
        } else {
            LOGGER.debug((Object)"Recipient list is empty");
        }
    }

    @Override
    public void doSend(String[] stringArray, String string, String string2, String[] stringArray2, Object object) {
        if (stringArray != null) {
            int n = stringArray.length;
            CustomMailMessage customMailMessage = (CustomMailMessage)object;
            if (n > 0) {
                try {
                    if (!this.mailList.contains(customMailMessage)) {
                        this.mailList.add(customMailMessage);
                    }
                    this.enterpriseEmailAM.sendMessage(stringArray, string, string2, stringArray2, customMailMessage);
                }
                catch (ResourceUnavailableException resourceUnavailableException) {
                    LOGGER.debug((Object)"Error sending email", (Throwable)resourceUnavailableException);
                }
                catch (ActionFailedException actionFailedException) {
                    LOGGER.debug((Object)"Error sending email", (Throwable)actionFailedException);
                }
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Recipient list is empty");
        }
    }

    public void changeStatusWhentSent(boolean bl, EmailTargetAttachment emailTargetAttachment) {
        int n = bl ? 2 : 1;
        EmailTargetAttachmentDM emailTargetAttachmentDM = (EmailTargetAttachmentDM)ManagerRegistry.getManagerStartsWith((String)"ENTERPRISE.EmailTargetAttachmentDM");
        emailTargetAttachmentDM.updateEmailStatus(emailTargetAttachment.getOid(), n, false);
    }

    @Override
    public void sendEmail(long l, HashMap<String, CopyToServerResults> hashMap) throws DataException, ResourceUnavailableException {
        LOGGER.trace((Object)("Inside sendEmail for jobHistoryId " + l));
        JobHistory jobHistory = this.jobHistoryDM.get(l);
        StringBuilder stringBuilder = new StringBuilder(jobHistory.getJobName());
        stringBuilder.append(' ').append(jobHistory.getId());
        List<Long> list = this.emailTargetAttachmentDM.getNotificationListByJobHistoryId(l);
        for (Long l2 : list) {
            EmailTargetAttachment[] emailTargetAttachmentArray = this.emailTargetAttachmentDM.getByJobHistoryAndNotificationListId(l, l2);
            String string = String.valueOf(l) + String.valueOf(l2);
            CopyToServerResults copyToServerResults = hashMap.get(string);
            if (copyToServerResults == null) {
                throw new ResourceUnavailableException("Error finding copy results for job history ID " + l + " and notification list ID " + l2);
            }
            LOGGER.debug((Object)("CopyResults for job history ID " + l + " and notification list ID " + l2 + " show " + copyToServerResults.getTotalFound() + " found and " + copyToServerResults.getTotalCopied() + " copied."));
            if (emailTargetAttachmentArray != null && emailTargetAttachmentArray.length > 0) {
                LOGGER.debug((Object)("Found " + emailTargetAttachmentArray.length + " email attachments for EventID " + l + " and NotificationListID " + l2 + "."));
                String string2 = "";
                if (copyToServerResults.getTotalCopied() < copyToServerResults.getTotalFound()) {
                    int n = copyToServerResults.getTotalCopied();
                    Object object = "were";
                    if (n == 1) {
                        object = "was";
                    }
                    string2 = "Attention: " + copyToServerResults.getTotalFound() + " files were found but only " + copyToServerResults.getTotalCopied() + " " + (String)object + " copied to the server for file distribution " + copyToServerResults.getFileFilter() + ".";
                    string2 = string2 + "  The job ended with status: " + jobHistory.getStatusCode().name();
                    JobEndedReasonCode jobEndedReasonCode = jobHistory.getJobEndedReasonCode();
                    if (jobEndedReasonCode != null) {
                        string2 = string2 + " and reason: " + jobEndedReasonCode.name();
                    }
                    string2 = string2 + ".";
                    LOGGER.warn((Object)string2);
                }
                List<CustomMailMessage> list2 = this.getCustomMailMessage(l2, stringBuilder.toString(), string2, emailTargetAttachmentArray);
                for (CustomMailMessage customMailMessage : list2) {
                    customMailMessage.setType(1);
                    this.mailList.add(customMailMessage);
                    this.sendEmail(customMailMessage);
                }
                continue;
            }
            LOGGER.info((Object)("There is no file to attach, so mail isn't sent for jobHistoryId:" + l));
        }
    }

    private List<CustomMailMessage> getCustomMailMessage(long l, String string, String string2, EmailTargetAttachment[] emailTargetAttachmentArray) {
        ArrayList<CustomMailMessage> arrayList = new ArrayList<CustomMailMessage>(1);
        int n = 1;
        long l2 = 0L;
        ArrayList<EmailTargetAttachment> arrayList2 = new ArrayList<EmailTargetAttachment>();
        StringBuilder stringBuilder = new StringBuilder(string2);
        for (EmailTargetAttachment emailTargetAttachment : emailTargetAttachmentArray) {
            long l3 = FileHandler.getFileSizeInBytes(emailTargetAttachment.getFileName());
            if (l3 > (long)this.maxEmailAttachmentSizeInBytes) {
                String string3 = this.bigAttachmentLogInfo(emailTargetAttachment.getFileName(), l3);
                LOGGER.info((Object)string3);
                stringBuilder.append("<br/>");
                stringBuilder.append(string3);
                this.updateOutputDistributionHistory(emailTargetAttachment, 6);
                continue;
            }
            if (l2 + l3 > (long)this.maxEmailAttachmentSizeInBytes) {
                arrayList.add(new CustomMailMessage(l, string + (n > 1 ? " Part" + n : ""), stringBuilder.toString(), arrayList2.toArray(new EmailTargetAttachment[arrayList2.size()])));
                l2 = l3;
                arrayList2.clear();
                arrayList2.add(emailTargetAttachment);
                stringBuilder = new StringBuilder(string2);
                ++n;
                continue;
            }
            l2 += l3;
            arrayList2.add(emailTargetAttachment);
        }
        arrayList.add(new CustomMailMessage(l, string + (n > 1 ? " Part" + n : ""), stringBuilder.toString(), arrayList2.toArray(new EmailTargetAttachment[arrayList2.size()])));
        return arrayList;
    }

    private void updateOutputDistributionHistory(EmailTargetAttachment emailTargetAttachment, int n) {
        StringBuilder stringBuilder;
        long l = emailTargetAttachment.getJobHistoryId();
        String string = emailTargetAttachment.getFileName();
        String string2 = FileHandler.getFileParentPath(string);
        OutputDistributionHistory[] outputDistributionHistoryArray = null;
        try {
            outputDistributionHistoryArray = this.outputDistributionHistoryDM.getByHistoryIdAndFileName(l, string2, FileHandler.getFileExactName(string));
        }
        catch (DataException dataException) {
            stringBuilder = new StringBuilder("Problem with retrieving ODHs for historyId:");
            stringBuilder.append(l);
            stringBuilder.append(" and file:");
            stringBuilder.append(string);
            LOGGER.warn((Object)stringBuilder.toString(), (Throwable)dataException);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            stringBuilder = new StringBuilder("Problem with retrieving ODHs for historyId:");
            stringBuilder.append(l);
            stringBuilder.append(" and file:");
            stringBuilder.append(string);
            LOGGER.warn((Object)stringBuilder.toString(), (Throwable)resourceUnavailableException);
        }
        if (outputDistributionHistoryArray != null) {
            for (OutputDistributionHistory outputDistributionHistory : outputDistributionHistoryArray) {
                outputDistributionHistory.setStatus(n);
                outputDistributionHistory.setDistributionType(1);
                try {
                    this.outputDistributionHistoryDM.save(outputDistributionHistory);
                }
                catch (ResourceUnavailableException resourceUnavailableException) {
                    LOGGER.warn((Object)("Problem with updating ODH with ODH id:" + outputDistributionHistory.getOid()), (Throwable)resourceUnavailableException);
                }
                catch (DataException dataException) {
                    LOGGER.warn((Object)("Problem with updating ODH with ODH id:" + outputDistributionHistory.getOid()), (Throwable)dataException);
                }
            }
        }
    }

    private void sendEmail(CustomMailMessage customMailMessage) throws DataException, ResourceUnavailableException {
        int n = customMailMessage.getEtaList().length;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            EmailTargetAttachment emailTargetAttachment = customMailMessage.getEtaList()[i];
            long l = emailTargetAttachment.getOid();
            emailTargetAttachment = this.emailTargetAttachmentDM.get(l);
            String string = emailTargetAttachment.getFileName();
            if (emailTargetAttachment.getEmailStatus() == 1 && !emailTargetAttachment.getResend()) continue;
            long l2 = FileHandler.getFileSizeInBytes(emailTargetAttachment.getFileName());
            if (l2 > (long)this.maxEmailAttachmentSizeInBytes) {
                LOGGER.info((Object)this.bigAttachmentLogInfo(emailTargetAttachment.getFileName(), l2));
                continue;
            }
            arrayList.add(string);
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        this.doSend(customMailMessage.getNotificationListId(), customMailMessage.getSubject(), customMailMessage.getBody(), stringArray, (Object)customMailMessage);
    }

    @Override
    public String bigAttachmentLogInfo(String string, long l) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(" file is not attached to mail as it's size is ");
        stringBuilder.append(l);
        stringBuilder.append(" which is greater than max email size:");
        stringBuilder.append(this.maxEmailAttachmentSizeInBytes);
        return stringBuilder.toString();
    }

    @Override
    public void sendJobLog(long l) {
        JobCompletionInfo jobCompletionInfo = this.jobCompletionDM.getJobCompletionInfo(String.valueOf(l));
        if (jobCompletionInfo == null) {
            LOGGER.debug((Object)"No jobInfo available.  Job Log will not be sent.");
            return;
        }
        try {
            JobHistory jobHistory = this.jobHistoryDM.get(l);
            long l2 = jobCompletionInfo.getWhenEnded();
            String string = DefaultConfigPath.getServerDirectoryName((long)l2, (boolean)false);
            String string2 = DefaultConfigPath.getLogFile((String)string, (long)l, (String)jobHistory.getAgentName(), (String)jobHistory.getJobName(), (long)l2, (boolean)false);
            StringBuilder stringBuilder = new StringBuilder(jobHistory.getJobName());
            stringBuilder.append(' ');
            stringBuilder.append(jobHistory.getId());
            stringBuilder.append(" joblog");
            ScheduleJobBigProxy scheduleJobBigProxy = this.scheduleJobDM.getScheduleJobBigProxy(jobHistory.getJobID());
            long l3 = scheduleJobBigProxy.getEmailNotificationListId();
            if (l3 > 0L) {
                String[] stringArray = new String[]{string2};
                CustomMailMessage customMailMessage = new CustomMailMessage(l3, stringBuilder.toString(), "", null);
                customMailMessage.setType(0);
                customMailMessage.setAttachmentNameList(stringArray);
                JobStatusCode jobStatusCode = jobHistory.getStatusCode();
                boolean bl = !scheduleJobBigProxy.isCopyJobLogToServer();
                JobEndedReasonCode jobEndedReasonCode = jobHistory.getJobEndedReasonCode();
                if (jobEndedReasonCode != null && jobEndedReasonCode.equals(JobEndedReasonCode.ENDED_MANUALLY)) {
                    bl = false;
                }
                if (jobStatusCode == JobStatusCode.CANCELED || jobStatusCode == JobStatusCode.FAILED) {
                    bl = false;
                }
                customMailMessage.setDeleteWhenFinished(bl);
                this.mailList.add(customMailMessage);
                long l4 = FileHandler.getFileSizeInBytes(string2);
                if (l4 > (long)this.maxEmailAttachmentSizeInBytes) {
                    String string3 = this.bigAttachmentLogInfo(string2, l4);
                    LOGGER.info((Object)string3);
                    customMailMessage.setDeleteWhenFinished(false);
                    this.doSend(l3, stringBuilder.toString(), string3, null, (Object)customMailMessage);
                } else {
                    this.doSend(l3, stringBuilder.toString(), "", stringArray, (Object)customMailMessage);
                }
            }
        }
        catch (DataException dataException) {
            LOGGER.error((Object)dataException);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            LOGGER.error((Object)resourceUnavailableException);
        }
    }

    @Override
    public void purgeOutputDistributionHistoryFiles(OutputDistributionHistory outputDistributionHistory) {
        String string;
        String string2 = outputDistributionHistory.getLocation();
        File file = new File(string2, string = outputDistributionHistory.getFileName());
        if (file != null && file.exists()) {
            if (file.delete()) {
                String string3 = outputDistributionHistory.getLocation() + File.separator + string;
                this.putStandbyBackupFileForDelete(string3);
                FileHandler.deleteEmptyParentFoldersUntilGivenFolder(string2, "attachments");
            }
        } else {
            if (LOGGER.isTraceEnabled()) {
                StringBuilder stringBuilder = new StringBuilder(string2);
                stringBuilder.append(File.separatorChar);
                stringBuilder.append(outputDistributionHistory.getFileName());
                stringBuilder.append(" file does not exist. Unable to delete.");
                LOGGER.trace((Object)stringBuilder.toString());
            }
            FileHandler.deleteEmptyParentFoldersUntilGivenFolder(string2, "attachments");
        }
    }

    public void serviceEvent(GenericEvent genericEvent) {
        MailSentEvent mailSentEvent;
        Object object;
        if (genericEvent != null && genericEvent instanceof MailSentEvent && this.mailList.contains(object = (mailSentEvent = (MailSentEvent)genericEvent).getMailObject()) && object instanceof CustomMailMessage) {
            Object object2;
            CustomMailMessage customMailMessage = (CustomMailMessage)object;
            if (customMailMessage.getType() == 0) {
                if (mailSentEvent.getSentStatus().equals((Object)MailSentEvent.MailSentStatus.SUCCESS_SENT_STATUS) && customMailMessage.isDeleteWhenFinished()) {
                    for (String string : object2 = customMailMessage.getAttachmentNameList()) {
                        new File(string).delete();
                        LOGGER.debug((Object)("Deleted file: " + string));
                    }
                }
            } else if (customMailMessage.getType() == 1) {
                switch (mailSentEvent.getSentStatus()) {
                    case SUCCESS_SENT_STATUS: {
                        this.processSuccessfulAttachments(customMailMessage, mailSentEvent.getSuccessList());
                        break;
                    }
                    case MIXED_SENT_STATUS: {
                        object2 = mailSentEvent.getSuccessList();
                        ArrayList<String> arrayList = mailSentEvent.getFailedList();
                        this.processSuccessfulAttachments(customMailMessage, (ArrayList<String>)object2);
                        this.processFailedAttachments(customMailMessage, arrayList);
                        break;
                    }
                    case FAILED_SENT_STATUS: {
                        this.processFailedAttachments(customMailMessage, null);
                    }
                }
            }
            try {
                LOGGER.debug((Object)("Finishing output distribution email: " + customMailMessage.getMailId()));
                boolean bl = this.mailList.remove(customMailMessage);
                if (!bl) {
                    LOGGER.debug((Object)("Email message was not found: " + customMailMessage.getMailId()));
                }
            }
            catch (Exception exception) {
                LOGGER.debug((Object)"Error finishing email message.", (Throwable)exception);
            }
        }
    }

    private void processFailedAttachments(CustomMailMessage customMailMessage, ArrayList<String> arrayList) {
        EmailTargetAttachment[] emailTargetAttachmentArray = customMailMessage.getEtaList();
        for (EmailTargetAttachment object : emailTargetAttachmentArray) {
            this.changeStatusWhentSent(false, object);
            this.updateOutputDistributionHistory(object, 6);
        }
        if (LOGGER.isDebugEnabled() && arrayList != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Failed to send attachments to: ");
            int n = 0;
            Iterator<String> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                if (n != 0) {
                    stringBuilder.append("; ");
                }
                String string = iterator.next();
                stringBuilder.append(string);
                n = 1;
            }
            LOGGER.debug((Object)stringBuilder);
        }
    }

    private void processSuccessfulAttachments(CustomMailMessage customMailMessage, ArrayList<String> arrayList) {
        StringBuilder stringBuilder = new StringBuilder();
        EmailTargetAttachment[] emailTargetAttachmentArray = customMailMessage.getEtaList();
        int n = emailTargetAttachmentArray.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = emailTargetAttachmentArray[i].getFileName();
        }
        String string = ArrayTokenizer.tokenateArray(stringArray);
        stringBuilder.append("Files: ");
        stringBuilder.append(string);
        stringBuilder.append(" Sent to:");
        boolean bl = false;
        Iterator<String> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            if (bl) {
                stringBuilder.append("; ");
            }
            String string2 = iterator.next();
            stringBuilder.append(string2);
            bl = true;
        }
        LOGGER.info((Object)stringBuilder);
        for (int i = 0; i < n; ++i) {
            this.updateOutputDistributionHistory(emailTargetAttachmentArray[i], 3);
            this.changeStatusWhentSent(true, emailTargetAttachmentArray[i]);
            if (!emailTargetAttachmentArray[i].isDeleteOnSent()) continue;
            String string3 = emailTargetAttachmentArray[i].getFileName();
            File file = new File(string3);
            String string4 = file.getParent();
            if (file.delete()) {
                FileHandler.deleteEmptyParentFoldersUntilGivenFolder(string4, "attachments");
                this.putStandbyBackupFileForDelete(string3);
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug((Object)(string3 + " file is deleted"));
                continue;
            }
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug((Object)(string3 + " file can not be deleted"));
        }
    }

    @Override
    public void reloadSystemSetup() {
        try {
            SystemSetup systemSetup = this.systemSetupDM.get();
            this.maxEmailAttachmentSizeInBytes = systemSetup.getMaxEmailAttachmentSize() * 1024 * 1024;
        }
        catch (DataException dataException) {
            LOGGER.warn((Object)"Error updating maxEmailAttachmentSizeInBytes", (Throwable)dataException);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            LOGGER.warn((Object)"Error updating maxEmailAttachmentSizeInBytes", (Throwable)resourceUnavailableException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminateDistribution(long l) {
        LOGGER.debug((Object)("OutputDistributionAM received request to terminate output distribution for eventID " + l));
        HashMap<Long, Boolean> hashMap = this.activeDistributionsHM;
        synchronized (hashMap) {
            if (this.activeDistributionsHM.containsKey(l)) {
                LOGGER.debug((Object)("Found active distribution for eventID " + l + ".  About to terminate."));
                this.activeDistributionsHM.put(l, false);
                if (this.currentRFCs.containsKey(l)) {
                    LOGGER.debug((Object)("Found active RFC for eventID " + l + ".  About to terminate."));
                    this.currentRFCs.get(l).terminate();
                }
            }
        }
    }

    private void putStandbyBackupFileForDelete(String string) {
        StandbyBackupFile standbyBackupFile = new StandbyBackupFile();
        standbyBackupFile.setActionType(1);
        standbyBackupFile.setFileType(2);
        standbyBackupFile.setServerFileName(string);
        try {
            this.getStandbyBackupFileQueueAM().putStandbyBackupFile(standbyBackupFile);
        }
        catch (ActionFailedException actionFailedException) {
            LOGGER.error((Object)"Can't put standby backup file in queue", (Throwable)actionFailedException);
        }
    }

    private StandbyBackupFileQueueAM getStandbyBackupFileQueueAM() {
        if (this.standbyBackupFileQueueAM == null) {
            this.standbyBackupFileQueueAM = (StandbyBackupFileQueueAM)ManagerRegistry.getManagerStartsWith((String)"ENTERPRISE.StandbyBackupFileQueueAM");
        }
        return this.standbyBackupFileQueueAM;
    }

    public NotificationListDM getNotificationListDM() {
        if (this.notificationListDM == null) {
            this.notificationListDM = (NotificationListDM)ManagerRegistry.getManagerStartsWith((String)"ENTERPRISE.NotificationListDM");
        }
        return this.notificationListDM;
    }

    class ResendMailTask
    extends TimerTask {
        ResendMailTask() {
        }

        @Override
        public void run() {
            try {
                int n = OutputDistributionAMImpl.this.mailQueue.size();
                for (int i = 0; i < n; ++i) {
                    CustomMailMessage customMailMessage = (CustomMailMessage)OutputDistributionAMImpl.this.mailQueue.take();
                    try {
                        OutputDistributionAMImpl.this.sendEmail(customMailMessage);
                        continue;
                    }
                    catch (DataException dataException) {
                        LOGGER.warn((Object)(customMailMessage.toString() + " mail can not be sent"), (Throwable)dataException);
                        continue;
                    }
                    catch (ResourceUnavailableException resourceUnavailableException) {
                        LOGGER.warn((Object)(customMailMessage.toString() + " mail can not be sent"), (Throwable)resourceUnavailableException);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                LOGGER.warn((Object)"CustomMailMessage can not be taken from queue", (Throwable)interruptedException);
            }
        }
    }

    class OutputDistributionQueueRunner
    implements Runnable {
        OutputDistributionQueueRunner() {
        }

        @Override
        public void run() {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            while (!OutputDistributionAMImpl.this.queue.isEmpty()) {
                try {
                    this.dequeue();
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"The OutputDistributionQueueRunner has encountered a severe error.  No more output distribution will be processed until the server is restarted.", (Throwable)exception);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dequeue() {
            BlockingQueue blockingQueue = OutputDistributionAMImpl.this.queue;
            synchronized (blockingQueue) {
                JobCompletionInfo jobCompletionInfo = (JobCompletionInfo)((Object)OutputDistributionAMImpl.this.queue.element());
                if (OutputDistributionAMImpl.this.peer.getPeerFromRoutingTable(jobCompletionInfo.getPeerID()) != null) {
                    LOGGER.debug((Object)("Starting output distribution for EventID " + jobCompletionInfo.getExecutableJob().getEventID()));
                    HashMap<String, CopyToServerResults> hashMap = OutputDistributionAMImpl.this.copyToServer(jobCompletionInfo);
                    try {
                        OutputDistributionAMImpl.this.sendEmail(Long.parseLong(jobCompletionInfo.getExecutableJob().getEventID()), hashMap);
                        LOGGER.debug((Object)("Output Distribution for EventID " + jobCompletionInfo.getExecutableJob().getEventID() + " has completed."));
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOGGER.debug((Object)numberFormatException);
                    }
                    catch (DataException dataException) {
                        LOGGER.error((Object)dataException);
                    }
                    catch (ResourceUnavailableException resourceUnavailableException) {
                        LOGGER.error((Object)resourceUnavailableException);
                    }
                    OutputDistributionAMImpl.this.queue.remove();
                }
            }
        }
    }
}

