/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module;

import com.helpsystems.enterprise.core.logger.Log4jID;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.module.JobQueueScheduleWorker;
import com.helpsystems.enterprise.scheduler.Drivable;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;

public class JobQueueScheduleMonitor
implements Drivable {
    private static Logger logger = Logger.getLogger(JobQueueScheduleMonitor.class);
    private static final String NAME_WITH_SPACES = "Job Queue Schedule Monitor";
    private boolean shutdown = false;
    private JobQueueScheduleWorker jqsWorker = new JobQueueScheduleWorker();

    public void start() {
        MDC.put((String)"MDC_LOG_ID", (String)Log4jID.SCHEDULER.getMDCKeyValue());
        logger.info((Object)"Starting the Job Queue Schedule Monitor.");
    }

    public void prepareForRestart() {
        logger.info((Object)"Preparing to restart the Job Queue Schedule Monitor.");
    }

    public void run() {
        try {
            long l = 0L;
            long l2 = 60000L;
            do {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Processing Job Queue Schedule Wakeup Time: " + ScheduleLogger.formatTimeStampSecs(l)));
                }
                long l3 = System.currentTimeMillis();
                this.jqsWorker.processAllJobQueues(l3);
                l = l3 / l2 * l2 + l2;
                long l4 = l - l3;
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Next Job Queue Schedule Wakeup Time: " + ScheduleLogger.formatTimeStampSecs(l) + " (" + l4 + " ms)"));
                }
                try {
                    long l5 = 15000L;
                    if (l4 < l5) {
                        l4 = l5;
                    }
                    Thread.sleep(l4);
                }
                catch (InterruptedException interruptedException) {
                    logger.debug((Object)"Job Queue Schedule Monitor thread was interrupted...");
                }
            } while (!this.shutdown);
        }
        catch (Throwable throwable) {
            logger.error((Object)"Job Queue Schedule Monitor ended in error.", throwable);
        }
    }

    public String getName() {
        return NAME_WITH_SPACES;
    }

    public void shutdown() {
        this.shutdown = true;
        logger.info((Object)("Shutting Down " + this.getName() + "."));
    }

    public boolean isShuttingDown() {
        return this.shutdown;
    }
}

