/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.webservices;

import com.helpsystems.common.core.xml.XMLSerializable;
import com.helpsystems.enterprise.core.webservices.WebServiceRequestParameter;
import com.helpsystems.enterprise.core.webservices.WebServiceRequestProperty;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;

public class WebServiceRequest
implements XMLSerializable,
Serializable {
    private static final long serialVersionUID = -6816770462720155176L;
    public static final int OUTPUT_TO_CONSOLE_NO = 0;
    public static final int OUTPUT_TO_CONSOLE_YES = 1;
    public static final int LOG_ONLY_FAILED_RESPONSES = 2;
    public static final int REQUEST_METHOD_GET = 0;
    public static final int REQUEST_METHOD_POST = 1;
    public static final int REQUEST_METHOD_PUT = 2;
    public static final int REQUEST_METHOD_DELETE = 3;
    public static final String PARM_MARKER = "?";
    public static final String PARM_SEP = "&";
    public static final String PARM_EQUAL = "=";
    private String baseUrl;
    private String appUrl = "";
    private int requestMethod = 0;
    private int outputType = 0;
    private boolean outputToFile = false;
    private String outputFileName = "";
    private boolean outputHeadersToFile = false;
    private String outputHeadersFilename = "";
    private ArrayList<WebServiceRequestProperty> props = new ArrayList();
    private ArrayList<WebServiceRequestParameter> parms = new ArrayList();
    private String stringBody = "";
    private String fileBody = "";
    public static final int MESSAGE_BODY_NONE = 0;
    public static final int MESSAGE_BODY_STRING = 1;
    public static final int MESSAGE_BODY_FILE = 2;
    private String[] envVars = new String[0];
    private long OID;
    private long commandID;
    private long webServiceDefinitionID;
    private int messageBody;
    private boolean urlEncode;
    private Timestamp createdAt;
    private Timestamp updatedAt;
    private String description = null;
    private String[] doNotInvokeList = new String[]{"getRequestParameters", "getRequestProperties", "getRuntimeEnvironmentVariables", "getRequestMethodValue", "getOutputTypeValue", "getMessageBodyValue"};

    public WebServiceRequest() {
    }

    public WebServiceRequest(String string) {
        this.appUrl = string;
    }

    public String getAppUrl() {
        return this.appUrl;
    }

    public void setAppUrl(String string) {
        this.appUrl = string;
    }

    public int getOutputType() {
        return this.outputType;
    }

    public void setOutputType(int n) {
        this.outputType = n;
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public void setOutputFileName(String string) {
        this.outputFileName = string;
    }

    public int getRequestMethod() {
        return this.requestMethod;
    }

    public void setRequestMethod(int n) {
        this.requestMethod = n;
    }

    public void addProperty(WebServiceRequestProperty webServiceRequestProperty) {
        this.props.add(webServiceRequestProperty);
    }

    public void setProperties(WebServiceRequestProperty[] webServiceRequestPropertyArray) {
        this.props.clear();
        for (int i = 0; i < webServiceRequestPropertyArray.length; ++i) {
            this.props.add(webServiceRequestPropertyArray[i]);
        }
    }

    public WebServiceRequestProperty[] getProperties() {
        return this.props.toArray(new WebServiceRequestProperty[0]);
    }

    public void addParameter(WebServiceRequestParameter webServiceRequestParameter) {
        this.parms.add(webServiceRequestParameter);
    }

    public void setParameters(WebServiceRequestParameter[] webServiceRequestParameterArray) {
        this.parms.clear();
        for (int i = 0; i < webServiceRequestParameterArray.length; ++i) {
            this.parms.add(webServiceRequestParameterArray[i]);
        }
    }

    public WebServiceRequestParameter[] getParameters() {
        return this.parms.toArray(new WebServiceRequestParameter[0]);
    }

    public String getStringBody() {
        return this.stringBody;
    }

    public void setStringBody(String string) {
        this.stringBody = string;
    }

    public String getFileBody() {
        return this.fileBody;
    }

    public void setFileBody(String string) {
        this.fileBody = string;
    }

    public String[] getEnvVars() {
        return this.envVars;
    }

    public void setEnvVars(String[] stringArray) {
        this.envVars = stringArray;
    }

    public void configRequestParameters(WebServiceRequestParameter webServiceRequestParameter) {
        this.addParameter(webServiceRequestParameter);
        this.stringBody = "";
        this.fileBody = "";
    }

    public void configStringBody(String string) {
        this.setStringBody(string);
        this.parms.clear();
        this.fileBody = "";
    }

    public void configFileBody(String string) {
        this.setFileBody(string);
        this.parms.clear();
        this.stringBody = "";
    }

    public HashMap<String, String> importEnvVars() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < this.envVars.length; ++i) {
            if (System.getenv(this.envVars[i]) == null) {
                throw new RuntimeException("Environment variable \"" + this.envVars[i] + "\" not found.");
            }
            hashMap.put(this.envVars[i], System.getenv(this.envVars[i]));
        }
        return hashMap;
    }

    public String[] doNotInvoke() {
        return this.doNotInvokeList;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String string) {
        this.baseUrl = string;
    }

    public long getOID() {
        return this.OID;
    }

    public void setOID(long l) {
        this.OID = l;
    }

    public long getCommandID() {
        return this.commandID;
    }

    public void setCommandID(long l) {
        this.commandID = l;
    }

    public long getWebServiceDefinitionID() {
        return this.webServiceDefinitionID;
    }

    public void setWebServiceDefinitionID(long l) {
        this.webServiceDefinitionID = l;
    }

    public int getMessageBody() {
        return this.messageBody;
    }

    public void setMessageBody(int n) {
        this.messageBody = n;
    }

    public boolean getOutputToFile() {
        return this.outputToFile;
    }

    public void setOutputToFile(boolean bl) {
        this.outputToFile = bl;
    }

    public Timestamp getCreatedAt() {
        return this.createdAt;
    }

    public Timestamp getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean getOutputHeadersToFile() {
        return this.outputHeadersToFile;
    }

    public void setOutputHeadersToFile(boolean bl) {
        this.outputHeadersToFile = bl;
    }

    public String getOutputHeadersFilename() {
        return this.outputHeadersFilename;
    }

    public void setOutputHeadersFilename(String string) {
        this.outputHeadersFilename = string;
    }

    public boolean getUrlEncode() {
        return this.urlEncode;
    }

    public void setUrlEncode(boolean bl) {
        this.urlEncode = bl;
    }

    public String getRequestParameters() {
        String string = "";
        for (int i = 0; i < this.parms.size(); ++i) {
            WebServiceRequestParameter webServiceRequestParameter = this.parms.get(i);
            string = string + webServiceRequestParameter.toString();
            if (i == this.parms.size() - 1) continue;
            string = string + ",";
        }
        return string;
    }

    public String getRequestProperties() {
        String string = "";
        for (int i = 0; i < this.props.size(); ++i) {
            WebServiceRequestProperty webServiceRequestProperty = this.props.get(i);
            string = string + webServiceRequestProperty.toString();
            if (i == this.props.size() - 1) continue;
            string = string + ",";
        }
        return string;
    }

    public String getRuntimeEnvironmentVariables() {
        String string = "";
        for (int i = 0; i < this.envVars.length; ++i) {
            string = string + this.envVars[i];
            if (i == this.envVars.length - 1) continue;
            string = string + ",";
        }
        return string;
    }

    public String getRequestMethodValue() {
        switch (this.requestMethod) {
            case 0: {
                return "GET";
            }
            case 1: {
                return "POST";
            }
            case 2: {
                return "PUT";
            }
            case 3: {
                return "DELETE";
            }
        }
        return "GET";
    }

    public String getOutputTypeValue() {
        switch (this.outputType) {
            case 0: {
                return "No";
            }
            case 1: {
                return "Yes";
            }
            case 2: {
                return "Log only when failing Response Codes (non-200's)";
            }
        }
        return "No";
    }

    public String getMessageBodyValue() {
        switch (this.messageBody) {
            case 0: {
                return "None";
            }
            case 1: {
                return "String";
            }
            case 2: {
                return "File Content";
            }
        }
        return "None";
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }
}

