/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.util;

import com.helpsystems.common.core.filter.CustomFilterCriteria;
import com.helpsystems.common.core.filter.DataFilterMatcher;
import java.io.Serializable;
import org.opennms.protocols.snmp.SnmpPduPacket;
import org.opennms.protocols.snmp.SnmpPduTrap;
import org.opennms.protocols.snmp.SnmpVarBind;

public class SNMPMibCriteria
extends CustomFilterCriteria {
    private static final long serialVersionUID = -3770850864144739984L;

    public SNMPMibCriteria() {
    }

    public SNMPMibCriteria(String string, Serializable serializable, int n) {
        super(string, serializable, n);
    }

    public boolean matches(Object object) {
        if (object instanceof SnmpPduTrap) {
            SnmpPduTrap snmpPduTrap = (SnmpPduTrap)object;
            return this.evaluate(snmpPduTrap.toVarBindArray());
        }
        if (object instanceof SnmpPduPacket) {
            SnmpPduPacket snmpPduPacket = (SnmpPduPacket)object;
            return this.evaluate(snmpPduPacket.toVarBindArray());
        }
        return false;
    }

    private boolean evaluate(SnmpVarBind[] snmpVarBindArray) {
        for (SnmpVarBind snmpVarBind : snmpVarBindArray) {
            if (!snmpVarBind.getName().toString().equals(this.getFieldName())) continue;
            return DataFilterMatcher.evaluate((String)this.getValue().toString(), (String)snmpVarBind.getValue().toString(), (int)this.getOperator());
        }
        return false;
    }
}

