/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.util;

import com.helpsystems.enterprise.core.util.ArrayTokenizer;
import junit.framework.TestCase;

public class ArrayTokenizerTest
extends TestCase {
    private static final boolean VERBOSE = false;

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testNullArray() {
        ArrayTokenizerTest.runTest("null array", null);
    }

    public void testEmptyArray() {
        ArrayTokenizerTest.runTest("empty array", new String[0]);
    }

    public void testSingleValue() {
        String[] stringArray = new String[]{"apple"};
        ArrayTokenizerTest.runTest("single value", stringArray);
    }

    public void testTwoValues() {
        String[] stringArray = new String[]{"apple", "jax"};
        ArrayTokenizerTest.runTest("two values", stringArray);
    }

    public void testNullValues() {
        String[] stringArray = new String[]{null, "two", null};
        ArrayTokenizerTest.runTest("null values", stringArray);
    }

    public void testBlankValues() {
        String[] stringArray = new String[]{"", "two", ""};
        ArrayTokenizerTest.runTest("blank values", stringArray);
    }

    public void testEmbeddedDelimiters() {
        String[] stringArray = new String[]{"\t", "a\tb", "\t\t", "\ta", "a\t"};
        ArrayTokenizerTest.runTest("embedded tabs", stringArray);
    }

    public void testEmbeddedBlanks() {
        String[] stringArray = new String[]{" ", "a b", " c ", "  "};
        ArrayTokenizerTest.runTest("embedded blanks", stringArray);
    }

    private static void runTest(String string, String[] stringArray) {
        ArrayTokenizerTest.log("\nStarting Test: " + string);
        ArrayTokenizerTest.log("\t********  LOGGING ORIGINAL ARRAY ***************");
        ArrayTokenizerTest.logArray(stringArray);
        ArrayTokenizerTest.log("\t********  TOKENATING ARRAY ***************");
        String string2 = ArrayTokenizer.tokenateArray(stringArray);
        ArrayTokenizerTest.log("\tTokenated String: " + string2);
        ArrayTokenizerTest.log("\t********  TOKENIZING STRING ***************");
        String[] stringArray2 = ArrayTokenizer.tokenizeString(string2);
        ArrayTokenizerTest.log("\t********  LOGGING FINAL ARRAY ***************");
        ArrayTokenizerTest.logArray(stringArray2);
        ArrayTokenizerTest.log("\t********  VALIDATING ARRAY EQUALITY  ***************");
        ArrayTokenizerTest.validate(stringArray, stringArray2);
    }

    private static void logArray(String[] stringArray) {
        if (stringArray == null) {
            ArrayTokenizerTest.log("\tThe array is null.");
            return;
        }
        ArrayTokenizerTest.log("\tArray Size: " + stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            ArrayTokenizerTest.log("\t\tItem # " + i + ": " + stringArray[i]);
        }
    }

    private static void validate(String[] stringArray, String[] stringArray2) {
        if (stringArray == null) {
            ArrayTokenizerTest.log("\tInvalid test, the original is null.");
            return;
        }
        if (stringArray2 == null) {
            throw new NullPointerException("The returned string array is null.");
        }
        if (stringArray.length != stringArray2.length) {
            String string = "The returned size (" + stringArray2.length + ") is not equal to the original size (" + stringArray.length + ").";
            ArrayTokenizerTest.fail((String)string);
        }
        for (int i = 0; i < stringArray2.length; ++i) {
            String string;
            if ((stringArray2[i] == null || stringArray[i] == null) && stringArray2[i] != null && stringArray[i] != null) {
                string = "There is a null issue for item: " + i + " Original value: " + stringArray[i] + " Returned Value: " + stringArray2[i];
                ArrayTokenizerTest.fail((String)string);
            }
            if (stringArray2[i] == null || stringArray2[i].equals(stringArray[i])) continue;
            string = "The original value was not returned for item: " + i + " Original value: " + stringArray[i] + " Returned Value: " + stringArray2[i];
            ArrayTokenizerTest.fail((String)string);
        }
        ArrayTokenizerTest.log("\tPass: The arrays are equal.");
    }

    private static void log(String string) {
    }
}

