/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.common.core.util.ValidationHelper;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class ScheduledTime {
    private int jobNumber;
    private int system;
    private Calendar nextScheduledTime;
    private Calendar consideredScheduledTime;
    private Calendar consideredAtDateTime;
    private Calendar maintainedAtDateTime;
    private int updateCounter;
    private boolean persistent = false;

    public Calendar getConsideredAtDateTime() {
        return this.consideredAtDateTime;
    }

    public Calendar getConsideredScheduledTime() {
        return this.consideredScheduledTime;
    }

    public int getJobNumber() {
        return this.jobNumber;
    }

    public Calendar getMaintainedAtDateTime() {
        return this.maintainedAtDateTime;
    }

    public Calendar getNextScheduledTime() {
        return this.nextScheduledTime;
    }

    public int getSystem() {
        return this.system;
    }

    public int getUpdateCounter() {
        return this.updateCounter;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setConsideredAtDateTime(Calendar calendar) {
        this.consideredAtDateTime = calendar;
    }

    public void setConsideredScheduledTime(Calendar calendar) {
        this.consideredScheduledTime = calendar;
    }

    public void setJobNumber(int n) {
        if (n == this.jobNumber) {
            return;
        }
        if (this.jobNumber != 0) {
            throw new IllegalStateException("Changes to the job number are not allowed.");
        }
        this.jobNumber = n;
    }

    public void setMaintainedAtDateTime(Calendar calendar) {
        this.maintainedAtDateTime = calendar;
    }

    public void setNextScheduledTime(Calendar calendar) {
        this.nextScheduledTime = calendar;
    }

    public void setSystem(int n) {
        this.system = n;
    }

    public void setUpdateCounter(int n) {
        this.updateCounter = n;
    }

    public void setPersistent(boolean bl) {
        this.persistent = bl;
    }

    public void validate() {
        ValidationHelper.validateReqFieldNotZero((String)"Job number", (int)this.jobNumber);
    }

    public String toString() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm z");
        String string = "at: ";
        if (this.consideredAtDateTime != null) {
            simpleDateFormat.setTimeZone(this.consideredAtDateTime.getTimeZone());
            string = string + simpleDateFormat.format(this.consideredAtDateTime.getTime());
        } else {
            string = string + "null";
        }
        String string2 = "|cst: ";
        if (this.consideredScheduledTime != null) {
            simpleDateFormat.setTimeZone(this.consideredScheduledTime.getTimeZone());
            string2 = string2 + simpleDateFormat.format(this.consideredScheduledTime.getTime());
        } else {
            string2 = string2 + "null";
        }
        String string3 = "|nst: ";
        if (this.nextScheduledTime != null) {
            simpleDateFormat.setTimeZone(this.nextScheduledTime.getTimeZone());
            string3 = string3 + simpleDateFormat.format(this.nextScheduledTime.getTime());
        } else {
            string3 = string3 + "null";
        }
        return string + string2 + string3;
    }
}

