/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.common.core.busobj.Proxy;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.xml.XMLSerializable;
import com.helpsystems.enterprise.core.busobj.JobType;
import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.JobHoldFlag;
import com.helpsystems.enterprise.core.scheduler.MissedJobAction;
import com.helpsystems.enterprise.core.scheduler.PersistableEnum;
import com.helpsystems.enterprise.core.scheduler.PersistanceCodeToEnumMap;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo;

public class ScheduleJobProxy
extends Proxy
implements XMLSerializable {
    private static final long serialVersionUID = -2914843227809496827L;
    private long id;
    private ScheduleType scheduleType;
    private int system;
    private int model;
    private JobHoldFlag jobHoldFlag = JobHoldFlag.NOT_HELD;
    private int holdTimes;
    private int heldCount;
    private long holdUntil;
    private long calendarID;
    private boolean holdOnFailure;
    private boolean skipOnNotCompleted;
    private boolean generateSkippedHistory;
    private CalendarObject.DayType dayType;
    private ScheduleInfo.NonWorkdayOption nonWorkdayOption;
    private boolean lateStartMonitorSelected = false;
    private JobType jobType;
    private ScheduleInfo.TargetType targetType;
    private long targetId;
    private ScheduleInfo.TimeZoneType timezoneType;
    private String jobTimezone;
    private int defaultPriority;
    private int timeRangeStart;
    private int timeRangeEnd;
    private MissedJobAction missedJobAction = MissedJobAction.MANAGE;
    private String agentEnvironmentType;
    private long jobQueueID;
    private String jobQueueName;
    private String jobParameters;

    public long getTargetId() {
        return this.targetId;
    }

    public void setTargetId(long l) {
        this.targetId = l;
    }

    public ScheduleInfo.TargetType getTargetType() {
        return this.targetType;
    }

    public void setTargetType(ScheduleInfo.TargetType targetType) {
        this.targetType = targetType;
    }

    public void setJobQueueID(long l) {
        this.jobQueueID = l;
    }

    public long getJobQueueID() {
        return this.jobQueueID;
    }

    public String getJobQueueName() {
        return this.jobQueueName;
    }

    public void setJobQueueName(String string) {
        this.jobQueueName = string;
    }

    public void setSkybotJobNumber(long l) {
        if (l == this.id) {
            return;
        }
        if (this.id != 0L) {
            throw new IllegalStateException("Changes to the job number are not allowed.");
        }
        this.id = l;
    }

    public long getSkybotJobNumber() {
        return this.id;
    }

    public ScheduleType getScheduleType() {
        super.addDoNotInvoke("getScheduleType");
        return this.scheduleType;
    }

    public void setScheduleType(ScheduleType scheduleType) {
        this.scheduleType = scheduleType;
    }

    public boolean isScheduleTypeJob() {
        return this.scheduleType == ScheduleType.DATE_LIST || this.scheduleType == ScheduleType.DAY_COUNT || this.scheduleType == ScheduleType.DAY_OF_PERIOD || this.scheduleType == ScheduleType.DAY_OF_WEEK || this.scheduleType == ScheduleType.TIMED_INTERVAL || this.scheduleType == ScheduleType.CRON_EXPRESSION;
    }

    public void setSkipOnNotCompleted(boolean bl) {
        this.skipOnNotCompleted = bl;
    }

    public boolean isSkipOnNotCompleted() {
        return this.skipOnNotCompleted;
    }

    public void setGenerateSkippedHistory(boolean bl) {
        this.generateSkippedHistory = bl;
    }

    public boolean isGenerateSkippedHistory() {
        return this.generateSkippedHistory;
    }

    public int getSystem() {
        return this.system;
    }

    public void setSystem(int n) {
        this.system = n;
    }

    public int getModel() {
        return this.model;
    }

    public void setModel(int n) {
        this.model = n;
    }

    public JobHoldFlag getJobHoldFlag() {
        return this.jobHoldFlag;
    }

    public void setJobHoldFlag(JobHoldFlag jobHoldFlag) {
        this.jobHoldFlag = jobHoldFlag;
    }

    public boolean isJobHeld() {
        if (this.jobHoldFlag == JobHoldFlag.HELD) {
            return true;
        }
        return this.jobHoldFlag == JobHoldFlag.HELD_FOR_X_TIMES && this.holdTimes > this.heldCount;
    }

    public int getHoldTimes() {
        return this.holdTimes;
    }

    public void setHoldTimes(int n) {
        this.holdTimes = n;
    }

    public int getHeldCount() {
        return this.heldCount;
    }

    public void setHeldCount(int n) {
        this.heldCount = n;
    }

    public long getHoldUntil() {
        return this.holdUntil;
    }

    public void setHoldUntil(long l) {
        this.holdUntil = l;
    }

    public long getCalendarID() {
        return this.calendarID;
    }

    public void setCalendarID(long l) {
        this.calendarID = l;
    }

    public boolean isHoldOnFailure() {
        return this.holdOnFailure;
    }

    public void setHoldOnFailure(boolean bl) {
        this.holdOnFailure = bl;
    }

    public CalendarObject.DayType getDayType() {
        return this.dayType;
    }

    public void setDayType(CalendarObject.DayType dayType) {
        this.dayType = dayType;
    }

    public void setLateStartMonitorSelected(boolean bl) {
        this.lateStartMonitorSelected = bl;
    }

    public boolean isLateStartMonitorSelected() {
        return this.lateStartMonitorSelected;
    }

    public ScheduleInfo.TimeZoneType getTimezoneType() {
        return this.timezoneType;
    }

    public void setTimezoneType(ScheduleInfo.TimeZoneType timeZoneType) {
        this.timezoneType = timeZoneType;
    }

    public String getJobTimezone() {
        return this.jobTimezone;
    }

    public void setJobTimezone(String string) {
        this.jobTimezone = string;
    }

    public MissedJobAction getMissedJobAction() {
        return this.missedJobAction;
    }

    public void setMissedJobAction(MissedJobAction missedJobAction) {
        this.missedJobAction = missedJobAction;
    }

    public String getAgentEnvironmentType() {
        return this.agentEnvironmentType;
    }

    public void setAgentEnvironmentType(String string) {
        this.agentEnvironmentType = string;
    }

    public int getDefaultPriority() {
        return this.defaultPriority;
    }

    public void setDefaultPriority(int n) {
        this.defaultPriority = n;
    }

    public JobType getJobType() {
        return this.jobType;
    }

    public void setJobType(JobType jobType) {
        this.jobType = jobType;
    }

    public boolean isSuite() {
        return this.getJobType() == JobType.SUITE;
    }

    public boolean isSuiteMember() {
        return this.getJobType() == JobType.SUITE_MEMBER;
    }

    public int getTimeRangeStart() {
        return this.timeRangeStart;
    }

    public int getTimeRangeEnd() {
        return this.timeRangeEnd;
    }

    public void setTimeRangeStart(int n) {
        this.timeRangeStart = n;
    }

    public void setTimeRangeEnd(int n) {
        this.timeRangeEnd = n;
    }

    public void setJobParameters(String string) {
        this.jobParameters = string;
    }

    public String getJobParameters() {
        return this.jobParameters;
    }

    public ScheduleInfo.NonWorkdayOption getNonWorkdayOption() {
        return this.nonWorkdayOption;
    }

    public void setNonWorkdayOption(ScheduleInfo.NonWorkdayOption nonWorkdayOption) {
        this.nonWorkdayOption = nonWorkdayOption;
    }

    public static enum ScheduleType implements PersistableEnum<String>
    {
        DAY_COUNT("DC"),
        DAY_OF_PERIOD("DP"),
        DAY_OF_WEEK("DW"),
        DATE_LIST("DL"),
        TIMED_INTERVAL("TI"),
        CRON_EXPRESSION("CE"),
        UNSCHEDULED("UJ"),
        REACTIVITY_DAY_OF_WEEK("RDW"),
        REACTIVITY_DAY_OF_PERIOD("RDP"),
        REACTIVITY_DATE_LIST("RDL"),
        SAP_RUN_INTERCEPT("SRI");

        private String persistanceCode;
        private static PersistanceCodeToEnumMap<String, ScheduleType> map;

        private ScheduleType(String string2) {
            this.persistanceCode = string2;
        }

        @Override
        public String persistanceCode() {
            return this.persistanceCode;
        }

        public static ScheduleType persistanceCodeToEnum(String string) {
            ScheduleType scheduleType = map.get(string);
            if (scheduleType == null) {
                String string2 = MessageUtil.formatMsg((String)"There is no {0} enum constant associated with code: {1}.", (Object[])new Object[]{map.getEnumName(), string});
                throw new IllegalStateException(string2);
            }
            return scheduleType;
        }

        static {
            map = new PersistanceCodeToEnumMap((Enum[])ScheduleType.values());
        }
    }
}

