/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.LocalHHMM;
import com.helpsystems.enterprise.core.scheduler.RuntimeRanges;
import com.helpsystems.enterprise.core.scheduler.RuntimeRanges_Basic;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfoTest;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo_TimedInterval;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobProxy;
import com.helpsystems.enterprise.core.scheduler.TimeRange;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class ScheduleInfo_TimedIntervalTest
extends ScheduleInfoTest {
    private ScheduleInfo_TimedInterval info;
    private RuntimeRanges_Basic ranges;
    private Calendar baseDateTime;

    public ScheduleInfo_TimedIntervalTest(String string) {
        super(string);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.info = new ScheduleInfo_TimedInterval();
        this.info.setScheduleType(ScheduleJobProxy.ScheduleType.TIMED_INTERVAL);
        this.info.setTimeZoneToUse(ScheduleInfo.TimeZoneType.SERVER);
        this.info.setCalendarObject(this.calendar);
        this.info.setOmitDates(this.omitDates);
        this.info.setTargetType(ScheduleInfo.TargetType.AGENT);
        this.ranges = new RuntimeRanges_Basic();
        TimeRange timeRange = new TimeRange(new LocalHHMM(8, 0), new LocalHHMM(18, 0));
        this.ranges.addRuntimeRange(timeRange);
        this.baseDateTime = new GregorianCalendar();
        this.baseDateTime.set(1, 2010);
        this.baseDateTime.set(2, 3);
        this.baseDateTime.set(5, 28);
        this.baseDateTime.set(11, 12);
        this.baseDateTime.set(12, 30);
    }

    @Override
    protected void tearDown() throws Exception {
        this.info = null;
        this.ranges = null;
        super.tearDown();
    }

    @Override
    public void testCreateScheduleInfoOfType() {
        super.testCreateScheduleInfoOfType();
        ScheduleInfo scheduleInfo = ScheduleInfo.createScheduleInfoOfType(ScheduleJobProxy.ScheduleType.TIMED_INTERVAL);
        ScheduleInfo_TimedIntervalTest.assertEquals((Object)ScheduleJobProxy.ScheduleType.TIMED_INTERVAL, (Object)scheduleInfo.getScheduleType());
    }

    public void testValidate() {
        this.info.setBaseDateTime(this.baseDateTime);
        this.info.setDayType(CalendarObject.DayType.WORKDAYS);
        this.info.setRuntimeRanges(this.ranges);
        this.info.validate();
    }

    public void testValidateRequiresBaseDateTime() {
        this.info.setDayType(CalendarObject.DayType.WORKDAYS);
        this.info.setRuntimeRanges(this.ranges);
        try {
            this.info.validate();
            ScheduleInfo_TimedIntervalTest.fail((String)"validate() should have thrown IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testValidateRequiresDayType() {
        this.info.setBaseDateTime(this.baseDateTime);
        this.info.setRuntimeRanges(this.ranges);
        try {
            this.info.validate();
            ScheduleInfo_TimedIntervalTest.fail((String)"validate() should have thrown IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testValidateRequiresRuntimeRanges() {
        this.info.setBaseDateTime(this.baseDateTime);
        this.info.setDayType(CalendarObject.DayType.WORKDAYS);
        try {
            this.info.validate();
            ScheduleInfo_TimedIntervalTest.fail((String)"validate() should have thrown IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testToString() {
        this.info.setDisplayPref(ScheduleInfo_TimedInterval.DisplayPref.MINUTES);
        this.info.setMinutes(45);
        this.info.setBaseDateTime(this.baseDateTime);
        this.info.setDayType(CalendarObject.DayType.ALL_DAYS);
        this.info.setRuntimeRanges(this.ranges);
        String string = "Schedule type: TIMED_INTERVAL|Timezone type: SERVER|Calendar: MyCalendar|Omit Date List: OmitDates|Interval: 45 mins|Base:2010-04-29 12:30 CDT|Day type: ALL_DAYS|Runtime ranges: [08:00 - 18:00]";
        String string2 = this.info.toString();
    }

    @Override
    public void testCalcNST() {
        this.info.setBaseDateTime(this.baseDateTime);
        this.info.setDayType(CalendarObject.DayType.WORKDAYS);
        this.info.setRuntimeRanges(this.ranges);
        this.info.setMinutes(45);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1, 2010);
        gregorianCalendar.set(2, 3);
        gregorianCalendar.set(5, 29);
        gregorianCalendar.set(11, 12);
        gregorianCalendar.set(12, 34);
        Calendar calendar = this.info.calcNST(gregorianCalendar, this.jobInfo, SERVER_TIME_ZONE);
        ScheduleInfo_TimedIntervalTest.assertEquals((int)2010, (int)calendar.get(1));
        ScheduleInfo_TimedIntervalTest.assertEquals((int)3, (int)calendar.get(2));
        ScheduleInfo_TimedIntervalTest.assertEquals((int)29, (int)calendar.get(5));
        ScheduleInfo_TimedIntervalTest.assertEquals((int)13, (int)calendar.get(11));
        ScheduleInfo_TimedIntervalTest.assertEquals((int)19, (int)calendar.get(12));
        calendar = this.info.calcNST(calendar, this.jobInfo, SERVER_TIME_ZONE);
        ScheduleInfo_TimedIntervalTest.assertEquals((int)2010, (int)calendar.get(1));
        ScheduleInfo_TimedIntervalTest.assertEquals((int)3, (int)calendar.get(2));
        ScheduleInfo_TimedIntervalTest.assertEquals((int)29, (int)calendar.get(5));
        ScheduleInfo_TimedIntervalTest.assertEquals((int)14, (int)calendar.get(11));
        ScheduleInfo_TimedIntervalTest.assertEquals((int)4, (int)calendar.get(12));
        ((Calendar)gregorianCalendar).setTimeZone(AGENT_TIME_ZONE);
        calendar = this.info.calcNST(gregorianCalendar, this.jobInfo, AGENT_TIME_ZONE);
        ScheduleInfo_TimedIntervalTest.assertEquals((int)2010, (int)calendar.get(1));
        ScheduleInfo_TimedIntervalTest.assertEquals((int)3, (int)calendar.get(2));
        ScheduleInfo_TimedIntervalTest.assertEquals((int)29, (int)calendar.get(5));
        ScheduleInfo_TimedIntervalTest.assertEquals((int)13, (int)calendar.get(11));
        ScheduleInfo_TimedIntervalTest.assertEquals((int)19, (int)calendar.get(12));
        calendar = this.info.calcNST(calendar, this.jobInfo, AGENT_TIME_ZONE);
        ScheduleInfo_TimedIntervalTest.assertEquals((int)2010, (int)calendar.get(1));
        ScheduleInfo_TimedIntervalTest.assertEquals((int)3, (int)calendar.get(2));
        ScheduleInfo_TimedIntervalTest.assertEquals((int)29, (int)calendar.get(5));
        ScheduleInfo_TimedIntervalTest.assertEquals((int)14, (int)calendar.get(11));
        ScheduleInfo_TimedIntervalTest.assertEquals((int)4, (int)calendar.get(12));
        this.baseDateTime = new GregorianCalendar();
        this.baseDateTime.set(1, 2012);
        this.baseDateTime.set(2, 3);
        this.baseDateTime.set(5, 27);
        this.baseDateTime.set(11, 12);
        this.baseDateTime.set(12, 30);
        this.info.setBaseDateTime(this.baseDateTime);
        this.info.setDayType(CalendarObject.DayType.ALL_DAYS);
        this.info.setRuntimeRanges(this.ranges);
        this.info.setMinutes(45);
    }

    public void testIsRunDay() {
        this.info.setDayType(CalendarObject.DayType.WORKDAYS);
        this.info.setRuntimeRanges(this.ranges);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1, 2010);
        gregorianCalendar.set(2, 3);
        gregorianCalendar.set(5, 29);
        gregorianCalendar.set(11, 12);
        gregorianCalendar.set(12, 35);
        ScheduleInfo_TimedIntervalTest.assertEquals((int)5, (int)gregorianCalendar.get(7));
        ScheduleInfo_TimedIntervalTest.assertTrue((boolean)this.info.isRunDay(gregorianCalendar, this.jobInfo));
    }

    public void testSetBaseDateTime() {
        this.info.setBaseDateTime(this.baseDateTime);
        Calendar calendar = this.info.getBaseDateTime();
        ScheduleInfo_TimedIntervalTest.assertEquals((int)2010, (int)calendar.get(1));
        ScheduleInfo_TimedIntervalTest.assertEquals((int)3, (int)calendar.get(2));
        ScheduleInfo_TimedIntervalTest.assertEquals((int)28, (int)calendar.get(5));
    }

    public void testSetDayType() {
        this.info.setDayType(CalendarObject.DayType.WORKDAYS);
        ScheduleInfo_TimedIntervalTest.assertEquals((Object)CalendarObject.DayType.WORKDAYS, (Object)this.info.getDayType());
    }

    public void testSetDisplayPref() {
        this.info.setDisplayPref(ScheduleInfo_TimedInterval.DisplayPref.HOURS);
        ScheduleInfo_TimedIntervalTest.assertEquals((Object)ScheduleInfo_TimedInterval.DisplayPref.HOURS, (Object)this.info.getDisplayPref());
    }

    public void testSetMinutes() {
        this.info.setMinutes(45);
        ScheduleInfo_TimedIntervalTest.assertEquals((int)45, (int)this.info.getMinutes());
    }

    public void testSetRuntimeRanges() {
        this.info.setRuntimeRanges(this.ranges);
        RuntimeRanges runtimeRanges = this.info.getRuntimeRanges();
        ScheduleInfo_TimedIntervalTest.assertEquals(RuntimeRanges_Basic.class, runtimeRanges.getClass());
    }

    @Override
    public void testGetOmitDates() {
        ScheduleInfo_TimedIntervalTest.assertEquals((Object)this.omitDates, (Object)this.info.getOmitDates());
    }

    @Override
    public void testSetLateStartJob() {
        this.info.setLateStartJob(false);
        ScheduleInfo_TimedIntervalTest.assertFalse((boolean)this.info.isLateStartJob());
        this.info.setLateStartJob(true);
        ScheduleInfo_TimedIntervalTest.assertTrue((boolean)this.info.isLateStartJob());
    }

    @Override
    public void testSetNonWorkdayOption() {
        this.info.setNonWorkdayOption(ScheduleInfo.NonWorkdayOption.DO_NOT_RUN);
        ScheduleInfo_TimedIntervalTest.assertEquals((Object)ScheduleInfo.NonWorkdayOption.DO_NOT_RUN, (Object)this.info.getNonWorkdayOption());
    }

    @Override
    public void testSetTargetID() {
        this.info.setTargetID(123456);
        ScheduleInfo_TimedIntervalTest.assertEquals((int)123456, (int)this.info.getTargetID());
    }

    @Override
    public void testSetTargetType() {
        this.info.setTargetType(ScheduleInfo.TargetType.AGENT);
        ScheduleInfo_TimedIntervalTest.assertEquals((Object)ScheduleInfo.TargetType.AGENT, (Object)this.info.getTargetType());
    }

    @Override
    public void testSetTimeZoneToUse() {
        this.info.setTimeZoneToUse(ScheduleInfo.TimeZoneType.AGENT);
        ScheduleInfo_TimedIntervalTest.assertEquals((Object)ScheduleInfo.TimeZoneType.AGENT, (Object)this.info.getTimeZoneType());
    }

    @Override
    public void testSetUpdateCounter() {
        this.info.setUpdateCounter(12345);
        ScheduleInfo_TimedIntervalTest.assertEquals((int)12345, (int)this.info.getUpdateCounter());
    }
}

