/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.JobInfo;
import com.helpsystems.enterprise.core.scheduler.LocalHHMM;
import com.helpsystems.enterprise.core.scheduler.Runtimes;
import com.helpsystems.enterprise.core.scheduler.Runtimes_Basic;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class Runtimes_DayOfPeriod
implements Runtimes {
    private CalendarObject calendarObject;
    private CalendarObject.DayType dayType;
    private Map<CalendarObject.PeriodType, Map<Integer, Runtimes_Basic>> periodTypeMap = new HashMap<CalendarObject.PeriodType, Map<Integer, Runtimes_Basic>>();

    public Runtimes_DayOfPeriod(CalendarObject calendarObject, CalendarObject.DayType dayType) {
        ValidationHelper.checkForNull((String)"Calendar Object", (Object)calendarObject);
        ValidationHelper.checkForNull((String)"Day Type", (Object)dayType);
        this.calendarObject = calendarObject;
        this.dayType = dayType;
    }

    public void addRuntime(CalendarObject.PeriodType periodType, int n, LocalHHMM localHHMM) {
        Runtimes_Basic runtimes_Basic;
        ValidationHelper.checkForNull((String)"Period Type", (Object)periodType);
        ValidationHelper.checkForNull((String)"Runtime", (Object)((Object)localHHMM));
        Map<Integer, Runtimes_Basic> map = this.periodTypeMap.get(periodType);
        if (map == null) {
            map = new HashMap<Integer, Runtimes_Basic>();
            this.periodTypeMap.put(periodType, map);
        }
        if ((runtimes_Basic = map.get(n)) == null) {
            runtimes_Basic = new Runtimes_Basic(this.calendarObject.getDayStart());
            map.put(n, runtimes_Basic);
        }
        runtimes_Basic.addRuntime(localHHMM);
    }

    @Override
    public Calendar firstRuntimeOfDay(Calendar calendar, JobInfo jobInfo) {
        ValidationHelper.checkForNull((String)"Considered Scheduled Time", (Object)calendar);
        Runtimes_Basic runtimes_Basic = null;
        for (CalendarObject.PeriodType periodType : CalendarObject.PeriodType.values()) {
            int n = this.calendarObject.relativeDayFromBeginOfPeriod(calendar, periodType, this.dayType);
            runtimes_Basic = this.combineRuntimes(runtimes_Basic, this.runtimesForRelativeDay(n, periodType));
            n = this.calendarObject.relativeDayFromEndOfPeriod(calendar, periodType, this.dayType);
            runtimes_Basic = this.combineRuntimes(runtimes_Basic, this.runtimesForRelativeDay(-n, periodType));
        }
        if (runtimes_Basic == null) {
            return null;
        }
        return runtimes_Basic.firstRuntimeOfDay(calendar, jobInfo);
    }

    @Override
    public Calendar nextRuntimeSameDay(Calendar calendar, JobInfo jobInfo) {
        ValidationHelper.checkForNull((String)"Considered Scheduled Time", (Object)calendar);
        Runtimes_Basic runtimes_Basic = null;
        for (CalendarObject.PeriodType periodType : CalendarObject.PeriodType.values()) {
            int n = this.calendarObject.relativeDayFromBeginOfPeriod(calendar, periodType, this.dayType);
            runtimes_Basic = this.combineRuntimes(runtimes_Basic, this.runtimesForRelativeDay(n, periodType));
            n = this.calendarObject.relativeDayFromEndOfPeriod(calendar, periodType, this.dayType);
            runtimes_Basic = this.combineRuntimes(runtimes_Basic, this.runtimesForRelativeDay(-n, periodType));
        }
        if (runtimes_Basic == null) {
            return null;
        }
        return runtimes_Basic.nextRuntimeSameDay(calendar, jobInfo);
    }

    @Override
    public boolean isEmpty() {
        return this.periodTypeMap.isEmpty();
    }

    public String toString() {
        return this.periodTypeMap.toString();
    }

    private Runtimes_Basic combineRuntimes(Runtimes_Basic runtimes_Basic, Runtimes_Basic runtimes_Basic2) {
        if (runtimes_Basic == null) {
            return runtimes_Basic2;
        }
        if (runtimes_Basic2 == null) {
            return runtimes_Basic;
        }
        Runtimes_Basic runtimes_Basic3 = new Runtimes_Basic(this.calendarObject.getDayStart());
        for (LocalHHMM localHHMM : runtimes_Basic.getRuntimes()) {
            runtimes_Basic3.addRuntime(localHHMM);
        }
        for (LocalHHMM localHHMM : runtimes_Basic2.getRuntimes()) {
            runtimes_Basic3.addRuntime(localHHMM);
        }
        return runtimes_Basic3;
    }

    private Runtimes_Basic runtimesForRelativeDay(int n, CalendarObject.PeriodType periodType) {
        Map<Integer, Runtimes_Basic> map = this.periodTypeMap.get(periodType);
        if (map != null) {
            return map.get(n);
        }
        return null;
    }
}

