/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.enterprise.core.scheduler.JobInfo;
import com.helpsystems.enterprise.core.scheduler.LocalHHMM;
import com.helpsystems.enterprise.core.scheduler.Runtimes_Basic;
import java.util.Calendar;
import java.util.GregorianCalendar;
import junit.framework.TestCase;

public class Runtimes_BasicTest
extends TestCase {
    private Runtimes_Basic runtimes;
    private JobInfo jobInfo = null;

    public Runtimes_BasicTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.runtimes = new Runtimes_Basic(new LocalHHMM(0, 0));
    }

    protected void tearDown() throws Exception {
        this.runtimes = null;
        super.tearDown();
    }

    public void testFirstRuntimeOfDayWithNoRuntimes() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1, 2010);
        gregorianCalendar.set(2, 3);
        gregorianCalendar.set(5, 15);
        gregorianCalendar.set(11, 8);
        gregorianCalendar.set(12, 0);
        Calendar calendar = this.runtimes.firstRuntimeOfDay(gregorianCalendar, this.jobInfo);
        Runtimes_BasicTest.assertNull((Object)calendar);
    }

    public void testFirstRuntimeOfDay() {
        this.runtimes.addRuntime(new LocalHHMM(9, 30));
        this.runtimes.addRuntime(new LocalHHMM(11, 15));
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1, 2010);
        gregorianCalendar.set(2, 3);
        gregorianCalendar.set(5, 15);
        gregorianCalendar.set(11, 8);
        gregorianCalendar.set(12, 0);
        Calendar calendar = (Calendar)((Calendar)gregorianCalendar).clone();
        calendar.set(11, 9);
        calendar.set(12, 30);
        calendar.set(13, 0);
        Calendar calendar2 = this.runtimes.firstRuntimeOfDay(gregorianCalendar, this.jobInfo);
        Runtimes_BasicTest.assertEquals((int)calendar.get(1), (int)calendar2.get(1));
        Runtimes_BasicTest.assertEquals((int)calendar.get(2), (int)calendar2.get(2));
        Runtimes_BasicTest.assertEquals((int)calendar.get(5), (int)calendar2.get(5));
        Runtimes_BasicTest.assertEquals((int)calendar.get(11), (int)calendar2.get(11));
        Runtimes_BasicTest.assertEquals((int)calendar.get(12), (int)calendar2.get(12));
        Runtimes_BasicTest.assertEquals((int)calendar.get(13), (int)calendar2.get(13));
        gregorianCalendar.set(11, 12);
        calendar2 = this.runtimes.firstRuntimeOfDay(gregorianCalendar, this.jobInfo);
        Runtimes_BasicTest.assertEquals((int)calendar.get(1), (int)calendar2.get(1));
        Runtimes_BasicTest.assertEquals((int)calendar.get(2), (int)calendar2.get(2));
        Runtimes_BasicTest.assertEquals((int)calendar.get(5), (int)calendar2.get(5));
        Runtimes_BasicTest.assertEquals((int)calendar.get(11), (int)calendar2.get(11));
        Runtimes_BasicTest.assertEquals((int)calendar.get(12), (int)calendar2.get(12));
        Runtimes_BasicTest.assertEquals((int)calendar.get(13), (int)calendar2.get(13));
        gregorianCalendar.set(11, 18);
        calendar2 = this.runtimes.firstRuntimeOfDay(gregorianCalendar, this.jobInfo);
        Runtimes_BasicTest.assertEquals((int)calendar.get(1), (int)calendar2.get(1));
        Runtimes_BasicTest.assertEquals((int)calendar.get(2), (int)calendar2.get(2));
        Runtimes_BasicTest.assertEquals((int)calendar.get(5), (int)calendar2.get(5));
        Runtimes_BasicTest.assertEquals((int)calendar.get(11), (int)calendar2.get(11));
        Runtimes_BasicTest.assertEquals((int)calendar.get(12), (int)calendar2.get(12));
        Runtimes_BasicTest.assertEquals((int)calendar.get(13), (int)calendar2.get(13));
    }

    public void testFirstRuntimeIsYesterday() {
        this.runtimes = new Runtimes_Basic(new LocalHHMM(7, 0));
        this.runtimes.addRuntime(new LocalHHMM(7, 30));
        this.runtimes.addRuntime(new LocalHHMM(8, 30));
        this.runtimes.addRuntime(new LocalHHMM(9, 30));
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1, 2010);
        gregorianCalendar.set(2, 3);
        gregorianCalendar.set(5, 15);
        gregorianCalendar.set(11, 6);
        gregorianCalendar.set(12, 30);
        Calendar calendar = (Calendar)((Calendar)gregorianCalendar).clone();
        calendar.set(5, 14);
        calendar.set(11, 7);
        calendar.set(12, 30);
        calendar.set(13, 0);
        Calendar calendar2 = this.runtimes.firstRuntimeOfDay(gregorianCalendar, this.jobInfo);
        Runtimes_BasicTest.assertEquals((int)calendar.get(1), (int)calendar2.get(1));
        Runtimes_BasicTest.assertEquals((int)calendar.get(2), (int)calendar2.get(2));
        Runtimes_BasicTest.assertEquals((int)calendar.get(5), (int)calendar2.get(5));
        Runtimes_BasicTest.assertEquals((int)calendar.get(11), (int)calendar2.get(11));
        Runtimes_BasicTest.assertEquals((int)calendar.get(12), (int)calendar2.get(12));
        Runtimes_BasicTest.assertEquals((int)calendar.get(13), (int)calendar2.get(13));
    }

    public void testFirstRuntimeBeforeDayStart() {
        this.runtimes = new Runtimes_Basic(new LocalHHMM(7, 0));
        this.runtimes.addRuntime(new LocalHHMM(5, 0));
        this.runtimes.addRuntime(new LocalHHMM(6, 0));
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1, 2010);
        gregorianCalendar.set(2, 3);
        gregorianCalendar.set(5, 15);
        gregorianCalendar.set(11, 8);
        gregorianCalendar.set(12, 0);
        Calendar calendar = (Calendar)((Calendar)gregorianCalendar).clone();
        calendar.set(5, 16);
        calendar.set(11, 5);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Calendar calendar2 = this.runtimes.firstRuntimeOfDay(gregorianCalendar, this.jobInfo);
        Runtimes_BasicTest.assertEquals((int)calendar.get(1), (int)calendar2.get(1));
        Runtimes_BasicTest.assertEquals((int)calendar.get(2), (int)calendar2.get(2));
        Runtimes_BasicTest.assertEquals((int)calendar.get(5), (int)calendar2.get(5));
        Runtimes_BasicTest.assertEquals((int)calendar.get(11), (int)calendar2.get(11));
        Runtimes_BasicTest.assertEquals((int)calendar.get(12), (int)calendar2.get(12));
        Runtimes_BasicTest.assertEquals((int)calendar.get(13), (int)calendar2.get(13));
    }

    public void testFirstRuntimeBeforeDayStartAndLastRuntimeBeforeDayStart() {
        this.runtimes = new Runtimes_Basic(new LocalHHMM(7, 0));
        this.runtimes.addRuntime(new LocalHHMM(5, 0));
        this.runtimes.addRuntime(new LocalHHMM(6, 0));
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1, 2010);
        gregorianCalendar.set(2, 3);
        gregorianCalendar.set(5, 15);
        gregorianCalendar.set(11, 6);
        gregorianCalendar.set(12, 30);
        Calendar calendar = (Calendar)((Calendar)gregorianCalendar).clone();
        calendar.set(5, 15);
        calendar.set(11, 5);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Calendar calendar2 = this.runtimes.firstRuntimeOfDay(gregorianCalendar, this.jobInfo);
        Runtimes_BasicTest.assertEquals((int)calendar.get(1), (int)calendar2.get(1));
        Runtimes_BasicTest.assertEquals((int)calendar.get(2), (int)calendar2.get(2));
        Runtimes_BasicTest.assertEquals((int)calendar.get(5), (int)calendar2.get(5));
        Runtimes_BasicTest.assertEquals((int)calendar.get(11), (int)calendar2.get(11));
        Runtimes_BasicTest.assertEquals((int)calendar.get(12), (int)calendar2.get(12));
        Runtimes_BasicTest.assertEquals((int)calendar.get(13), (int)calendar2.get(13));
    }

    public void testNextRuntimeSameDayWithNoRuntimes() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1, 2010);
        gregorianCalendar.set(2, 3);
        gregorianCalendar.set(5, 15);
        gregorianCalendar.set(11, 8);
        gregorianCalendar.set(12, 0);
        Runtimes_BasicTest.assertNull((Object)this.runtimes.nextRuntimeSameDay(gregorianCalendar, this.jobInfo));
    }

    public void testNextRuntimeSameDay() {
        this.runtimes.addRuntime(new LocalHHMM(9, 30));
        this.runtimes.addRuntime(new LocalHHMM(11, 15));
        Calendar calendar = new GregorianCalendar();
        calendar.set(1, 2010);
        calendar.set(2, 3);
        calendar.set(5, 15);
        calendar.set(11, 8);
        calendar.set(12, 0);
        Calendar calendar2 = (Calendar)((Calendar)calendar).clone();
        calendar2.set(11, 9);
        calendar2.set(12, 30);
        calendar2.set(13, 0);
        Calendar calendar3 = this.runtimes.nextRuntimeSameDay(calendar, this.jobInfo);
        Runtimes_BasicTest.assertEquals((int)calendar2.get(1), (int)calendar3.get(1));
        Runtimes_BasicTest.assertEquals((int)calendar2.get(2), (int)calendar3.get(2));
        Runtimes_BasicTest.assertEquals((int)calendar2.get(5), (int)calendar3.get(5));
        Runtimes_BasicTest.assertEquals((int)calendar2.get(11), (int)calendar3.get(11));
        Runtimes_BasicTest.assertEquals((int)calendar2.get(12), (int)calendar3.get(12));
        Runtimes_BasicTest.assertEquals((int)calendar2.get(13), (int)calendar3.get(13));
        calendar2.set(11, 11);
        calendar2.set(12, 15);
        calendar2.set(13, 0);
        calendar = (Calendar)calendar3.clone();
        calendar3 = this.runtimes.nextRuntimeSameDay(calendar, this.jobInfo);
        Runtimes_BasicTest.assertEquals((int)calendar2.get(1), (int)calendar3.get(1));
        Runtimes_BasicTest.assertEquals((int)calendar2.get(2), (int)calendar3.get(2));
        Runtimes_BasicTest.assertEquals((int)calendar2.get(5), (int)calendar3.get(5));
        Runtimes_BasicTest.assertEquals((int)calendar2.get(11), (int)calendar3.get(11));
        Runtimes_BasicTest.assertEquals((int)calendar2.get(12), (int)calendar3.get(12));
        Runtimes_BasicTest.assertEquals((int)calendar2.get(13), (int)calendar3.get(13));
        calendar = (Calendar)calendar3.clone();
        Runtimes_BasicTest.assertNull((Object)this.runtimes.nextRuntimeSameDay(calendar, this.jobInfo));
    }

    public void testNextRuntimeBetweenNowAndDayStart() {
        this.runtimes = new Runtimes_Basic(new LocalHHMM(6, 0));
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1, 2010);
        gregorianCalendar.set(2, 3);
        gregorianCalendar.set(5, 15);
        gregorianCalendar.set(11, 4);
        gregorianCalendar.set(12, 0);
        this.runtimes.addRuntime(new LocalHHMM(5, 0));
        this.runtimes.addRuntime(new LocalHHMM(7, 0));
        Calendar calendar = (Calendar)((Calendar)gregorianCalendar).clone();
        calendar.set(11, 5);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Calendar calendar2 = this.runtimes.nextRuntimeSameDay(gregorianCalendar, this.jobInfo);
        Runtimes_BasicTest.assertEquals((int)calendar.get(1), (int)calendar2.get(1));
        Runtimes_BasicTest.assertEquals((int)calendar.get(2), (int)calendar2.get(2));
        Runtimes_BasicTest.assertEquals((int)calendar.get(5), (int)calendar2.get(5));
        Runtimes_BasicTest.assertEquals((int)calendar.get(11), (int)calendar2.get(11));
        Runtimes_BasicTest.assertEquals((int)calendar.get(12), (int)calendar2.get(12));
        Runtimes_BasicTest.assertEquals((int)calendar.get(13), (int)calendar2.get(13));
    }

    public void testNextRuntimeNoneBetweenNowAndDayStart() {
        this.runtimes = new Runtimes_Basic(new LocalHHMM(6, 0));
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1, 2010);
        gregorianCalendar.set(2, 3);
        gregorianCalendar.set(5, 15);
        gregorianCalendar.set(11, 4);
        gregorianCalendar.set(12, 0);
        this.runtimes.addRuntime(new LocalHHMM(7, 0));
        this.runtimes.addRuntime(new LocalHHMM(9, 0));
        Calendar calendar = this.runtimes.nextRuntimeSameDay(gregorianCalendar, this.jobInfo);
        Runtimes_BasicTest.assertNull((Object)calendar);
    }

    public void testNextRuntimeBeforeDayStart() {
        this.runtimes = new Runtimes_Basic(new LocalHHMM(6, 0));
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1, 2010);
        gregorianCalendar.set(2, 3);
        gregorianCalendar.set(5, 15);
        gregorianCalendar.set(11, 6);
        gregorianCalendar.set(12, 1);
        this.runtimes.addRuntime(new LocalHHMM(5, 30));
        Calendar calendar = (Calendar)((Calendar)gregorianCalendar).clone();
        calendar.set(5, 16);
        calendar.set(11, 5);
        calendar.set(12, 30);
        calendar.set(13, 0);
        Calendar calendar2 = this.runtimes.nextRuntimeSameDay(gregorianCalendar, this.jobInfo);
        Runtimes_BasicTest.assertEquals((int)calendar.get(1), (int)calendar2.get(1));
        Runtimes_BasicTest.assertEquals((int)calendar.get(2), (int)calendar2.get(2));
        Runtimes_BasicTest.assertEquals((int)calendar.get(5), (int)calendar2.get(5));
        Runtimes_BasicTest.assertEquals((int)calendar.get(11), (int)calendar2.get(11));
        Runtimes_BasicTest.assertEquals((int)calendar.get(12), (int)calendar2.get(12));
        Runtimes_BasicTest.assertEquals((int)calendar.get(13), (int)calendar2.get(13));
    }

    public void testIsEmpty() {
        Runtimes_BasicTest.assertTrue((boolean)this.runtimes.isEmpty());
        this.runtimes.addRuntime(new LocalHHMM(9, 0));
        Runtimes_BasicTest.assertFalse((boolean)this.runtimes.isEmpty());
    }

    public void testToString() {
        this.runtimes.addRuntime(new LocalHHMM(8, 45));
        this.runtimes.addRuntime(new LocalHHMM(11, 15));
        this.runtimes.addRuntime(new LocalHHMM(9, 30));
        String string = "[08:45, 09:30, 11:15]";
        String string2 = this.runtimes.toString();
        Runtimes_BasicTest.assertEquals((String)string, (String)string2);
        this.runtimes = new Runtimes_Basic(new LocalHHMM(7, 0));
        this.runtimes.addRuntime(new LocalHHMM(8, 45));
        this.runtimes.addRuntime(new LocalHHMM(11, 15));
        this.runtimes.addRuntime(new LocalHHMM(9, 30));
        string = "[08:45, 09:30, 11:15] (Day start: 07:00)";
        string2 = this.runtimes.toString();
        Runtimes_BasicTest.assertEquals((String)string, (String)string2);
    }

    public void testCanAddLotsOfRuntimes() {
        for (int i = 9; i < 17; ++i) {
            for (int j = 0; j < 60; j += 10) {
                this.runtimes.addRuntime(new LocalHHMM(i, j));
            }
        }
        LocalHHMM[] localHHMMArray = this.runtimes.getRuntimes();
        Runtimes_BasicTest.assertEquals((int)48, (int)localHHMMArray.length);
    }
}

