/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.JobStatusCode;
import com.helpsystems.enterprise.core.scheduler.PersistableEnum;
import com.helpsystems.enterprise.core.scheduler.PersistanceCodeToEnumMap;
import java.util.EnumSet;

public enum MemberStatus implements PersistableEnum<String>
{
    BLANK(""),
    INITIATED(JobStatusCode.INITIATED.persistanceCode()),
    RUNNING(JobStatusCode.RUNNING.persistanceCode()),
    COMPLETED(JobStatusCode.COMPLETED.persistanceCode()),
    AGENT_FAILED("V"),
    FAILED(JobStatusCode.FAILED.persistanceCode()),
    AGENT_CANCELED("X"),
    CANCELED(JobStatusCode.CANCELED.persistanceCode()),
    AGENT_ERROR("Y"),
    ERROR(JobStatusCode.ERROR.persistanceCode()),
    SKIPPED(JobStatusCode.SKIPPED.persistanceCode()),
    WILL_NOT_RUN("Z");

    private static EnumSet<MemberStatus> FINAL_STATUSES;
    private String persistanceCode;
    private static PersistanceCodeToEnumMap<String, MemberStatus> map;

    private MemberStatus(String string2) {
        this.persistanceCode = string2;
    }

    @Override
    public String persistanceCode() {
        return this.persistanceCode;
    }

    public static MemberStatus persistanceCodeToEnum(String string) {
        MemberStatus memberStatus = map.get(string);
        if (memberStatus == null) {
            String string2 = MessageUtil.formatMsg((String)"There is no {0} enum constant associated with code: {1}.", (Object[])new Object[]{map.getEnumName(), string});
            throw new IllegalStateException(string2);
        }
        return memberStatus;
    }

    public boolean isFinal() {
        return FINAL_STATUSES.contains(this);
    }

    public static void validateKnownValues(MemberStatus[] memberStatusArray) {
        if (memberStatusArray.length > MemberStatus.values().length) {
            throw new IllegalStateException("Program error: There is a duplicate in the list of known statuses passed in by the caller of the validate method.");
        }
        for (MemberStatus memberStatus : MemberStatus.values()) {
            if (MemberStatus.isInArray(memberStatusArray, memberStatus)) continue;
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Member Status {0} is missing from the list of known statuses passed in by the caller of the validate method.", (Object[])new Object[]{memberStatus}));
        }
    }

    private static boolean isInArray(MemberStatus[] memberStatusArray, MemberStatus memberStatus) {
        for (MemberStatus memberStatus2 : memberStatusArray) {
            if (memberStatus2 != memberStatus) continue;
            return true;
        }
        return false;
    }

    static {
        FINAL_STATUSES = EnumSet.of(COMPLETED, new MemberStatus[]{FAILED, CANCELED, ERROR, SKIPPED, WILL_NOT_RUN});
        map = new PersistanceCodeToEnumMap((Enum[])MemberStatus.values());
    }
}

