/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.NotSavedException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.AgentGroupProxy;
import com.helpsystems.enterprise.core.busobj.PrereqEventType;
import com.helpsystems.enterprise.core.busobj.SpecialInstance;
import com.helpsystems.enterprise.core.forecast.ForecastPrereqEvent;
import com.helpsystems.enterprise.core.forecast.ForecastProcessInfo;
import com.helpsystems.enterprise.core.forecast.ForecastTargetInfo;
import com.helpsystems.enterprise.core.forecast.ForecastedObjectType;
import com.helpsystems.enterprise.core.scheduler.DependentObject;
import com.helpsystems.enterprise.core.scheduler.ForecastDefinition;
import com.helpsystems.enterprise.core.scheduler.ForecastFilter;
import com.helpsystems.enterprise.core.scheduler.ForecastResults;
import com.helpsystems.enterprise.core.scheduler.ForecastRun;
import com.helpsystems.enterprise.core.scheduler.ForecastableEvent;
import com.helpsystems.enterprise.core.scheduler.ForecastedEvent;
import com.helpsystems.enterprise.core.scheduler.PersistableEnum;
import com.helpsystems.enterprise.core.scheduler.PersistanceCodeToEnumMap;
import com.helpsystems.enterprise.core.scheduler.SharedResource;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface ForecastDM {
    public static final String NAME = "ENTERPRISE.ForecastDM";

    public long createForecastProcessRecord() throws NotSavedException, ResourceUnavailableException;

    public void deleteAllForecastProcessData() throws ResourceUnavailableException;

    public void deleteForecastProcessEvents(Set<ForecastableEvent> var1, long var2) throws ResourceUnavailableException;

    public void deleteObsoleteForecastProcessEvents(Set<ForecastableEvent> var1, long var2, long var4) throws ResourceUnavailableException;

    public Set<ForecastableEvent> getAllAgentTimezoneTypeJobsThatRunOnAgent(long var1) throws ResourceUnavailableException;

    public List<DependentObject> getAllDependentObjectsThatHaveAReactiveRange() throws ResourceUnavailableException;

    public ForecastableEvent[] getAllEventsThatHaveAForecastSchedule() throws ResourceUnavailableException;

    public List<ForecastableEvent> getAllEventsThatHaveAForecastScheduleThatUsesThisCalendar(long var1) throws ResourceUnavailableException;

    public Set<ForecastableEvent> getAllEventsThatHaveAForecastScheduleThatUsesThisDateList(long var1) throws ResourceUnavailableException;

    public Set<ForecastableEvent> getAllEventsThatHaveASpecialInstanceThatUsesThisDateList(long var1) throws ResourceUnavailableException;

    public Set<ForecastableEvent> getAllEventsThatReferToAgentGroup(long var1) throws ResourceUnavailableException;

    public Map<ForecastableEvent, AgentGroupProxy> getAllEventsThatRunOnAnAgentGroup() throws ResourceUnavailableException;

    public long[] getAllMembersWithExclusionPerSpecialInstanceInfo() throws ResourceUnavailableException;

    public Collection<Long> getAllMembersWithTheANYOption() throws ResourceUnavailableException;

    public long[] getAllReactiveJobsThatDoNotRunOnNonWorkDays() throws ResourceUnavailableException;

    public long getCalendarObjectID(ForecastPrereqEvent var1) throws NoDataException, ResourceUnavailableException;

    public ForecastDefinition getForecastDefinition(long var1) throws NoDataException, BadDataException, ResourceUnavailableException;

    public long getForecastScheduleID(ForecastableEvent var1) throws NoDataException, ResourceUnavailableException;

    public ForecastableEvent[] getEventsToForecast(ForecastFilter var1) throws ResourceUnavailableException;

    public long getInternalForecastProcessID() throws NoDataException, ResourceUnavailableException;

    public ForecastProcessInfo getInternalForecastProcessInfo() throws NoDataException, ResourceUnavailableException;

    public long getJobIDForMember(long var1) throws NoDataException, ResourceUnavailableException;

    public ForecastableEvent[] getJobsToForecast(ForecastFilter var1, boolean var2, boolean var3) throws ResourceUnavailableException;

    public ForecastableEvent[] getJobsToForecast(ForecastDefinition var1, ForecastFilter var2) throws ResourceUnavailableException;

    public List<Long> getJobsCreatedAfter(long var1) throws ResourceUnavailableException;

    public Map<Long, Long> getJobsThatDoNotUseTheStandardCalendar(long var1) throws ResourceUnavailableException;

    public List<Long> getJobsUpdatedAfter(long var1) throws ResourceUnavailableException;

    public long getMatchedSuiteEventID(long var1) throws ResourceUnavailableException;

    public ForecastableEvent[] getMembersToForecast() throws ResourceUnavailableException;

    public ForecastableEvent[] getMembersToForecast(ForecastDefinition var1) throws ResourceUnavailableException;

    public SpecialInstance[] getMemberSkipInstances(long var1) throws ResourceUnavailableException;

    public boolean getMemberSkipMatchedSetting(long var1) throws ResourceUnavailableException;

    public ForecastTargetInfo getTargetInfo(DependentObject var1) throws NoDataException, ResourceUnavailableException;

    public ForecastTargetInfo getTargetInfo(long var1, PrereqEventType var3) throws NoDataException, ResourceUnavailableException;

    public long getTheIdOfTheMostCommonlyUsedCalendar() throws ResourceUnavailableException;

    public boolean hasForecastSchedule(ForecastableEvent var1) throws ResourceUnavailableException;

    public boolean isJobInDatabase(long var1) throws ResourceUnavailableException;

    public boolean isMemberInDatabase(long var1) throws ResourceUnavailableException;

    public SharedResource insertForecastProcessEvent(long var1, ForecastedEvent var3, long var4, Map<ForecastableEvent, AgentGroupProxy> var6) throws NotSavedException, ResourceUnavailableException;

    public void insertForecastProcessEvent(long var1, ForecastedEvent var3, long var4, Map<ForecastableEvent, AgentGroupProxy> var6, SharedResource var7) throws NotSavedException, ResourceUnavailableException;

    public Set<ForecastableEvent> membersAssociatedWithJob(long var1) throws ResourceUnavailableException;

    public int purgeForecastProcessData(long var1) throws ResourceUnavailableException;

    public void recordForecastProcessStarted(long var1, long var3, long var5) throws NotSavedException, ResourceUnavailableException;

    public void recordForecastProcessRegenerated(long var1, long var3, long var5) throws NotSavedException, ResourceUnavailableException;

    public long recordForecastRunStarted(ForecastRun var1) throws NotSavedException, ResourceUnavailableException;

    public void setForecastProcessDataLockoutFlag(long var1, boolean var3) throws ResourceUnavailableException;

    public void updateForecastRunData(ForecastRun var1) throws NotSavedException, ResourceUnavailableException;

    public int updateIfExactMatch(long var1, long var3, ForecastedObjectType var5, long var6, ActivityMatchCode var8) throws ResourceUnavailableException;

    public int updateIfExactMatch(long var1, long var3, ForecastedObjectType var5, long var6, ActivityMatchCode var8, long var9) throws ResourceUnavailableException;

    public int updateIfExactMatch(long var1, long var3, ForecastedObjectType var5, long var6, long var8) throws ResourceUnavailableException;

    public long updateIfExactMatchAndReturnID(long var1, long var3, ForecastedObjectType var5, long var6, ActivityMatchCode var8) throws ResourceUnavailableException;

    public long updateIfExactMatchAndReturnID(long var1, long var3, ForecastedObjectType var5, long var6, ActivityMatchCode var8, long var9) throws ResourceUnavailableException;

    public long updateIfProbableMatch(long var1, long var3, ForecastedObjectType var5, long var6, ActivityMatchCode var8) throws ResourceUnavailableException;

    public int updateIfProbableMatch(long var1, long var3, ForecastedObjectType var5, long var6, long var8) throws ResourceUnavailableException;

    public int updateAllMembersAsMatched(long var1, ActivityMatchCode var3) throws ResourceUnavailableException;

    public int failInactiveForecasts() throws NotSavedException, ResourceUnavailableException;

    public void recordForecastResults(ForecastRun var1, ForecastResults var2) throws NotSavedException, ResourceUnavailableException;

    public void purgeForecasts(int var1, boolean var2) throws SQLException, ResourceUnavailableException;

    public void recordExcludedJobs(long var1, long var3) throws NotSavedException, ResourceUnavailableException;

    public static enum ActivityMatchCode implements PersistableEnum<Integer>
    {
        EXACT(1),
        PROBABLE(2),
        MANUAL(3),
        SKIPPED_PREREQS_NOT_MET(4),
        SKIPPED_HELD(5),
        SKIPPED_INTERVAL_JOB_ALREADY_ACTIVE(6),
        MISSED_IGNORED(7),
        PARENT_SUITE_MISSED(8),
        PARENT_SUITE_HELD(9),
        PARENT_SUITE_MANAGED_ENDED(10),
        PARENT_SUITE_MANAGED_DELETED(11);

        private int persistanceCode;
        private static PersistanceCodeToEnumMap<Integer, ActivityMatchCode> map;

        private ActivityMatchCode(int n2) {
            this.persistanceCode = n2;
        }

        @Override
        public Integer persistanceCode() {
            return this.persistanceCode;
        }

        public static ActivityMatchCode persistanceCodeToEnum(Integer n) {
            ActivityMatchCode activityMatchCode = map.get(n);
            if (activityMatchCode == null) {
                String string = MessageUtil.formatMsg((String)"There is no {0} enum constant associated with code: {1}.", (Object[])new Object[]{map.getEnumName(), n});
                throw new IllegalStateException(string);
            }
            return activityMatchCode;
        }

        static {
            map = new PersistanceCodeToEnumMap((Enum[])ActivityMatchCode.values());
        }
    }
}

