/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.DateRange;

public class FiscalYear
extends DateRange {
    private int year;
    private DateRange[] months;
    private DateRange[] quarters = new DateRange[4];
    private DateRange[] halfYears = new DateRange[2];

    public FiscalYear(int n, int n2) {
        super(n, n2);
    }

    public DateRange[] getMonths() {
        return this.months;
    }

    public DateRange[] getQuarters() {
        return this.quarters;
    }

    public DateRange[] getHalfYears() {
        return this.halfYears;
    }

    public int getYear() {
        return this.year;
    }

    public void setMonths(DateRange[] dateRangeArray) {
        ValidationHelper.checkForNull((String)"Months", (Object)dateRangeArray);
        this.months = dateRangeArray;
        this.constructQuarters();
        this.constructHalfYears();
    }

    public void setYear(int n) {
        this.year = n;
    }

    public DateRange periodContaining(int n, CalendarObject.PeriodType periodType) {
        ValidationHelper.checkForNull((String)"Period type", (Object)periodType);
        switch (periodType) {
            case YEAR: {
                if (this.contains(n)) {
                    return this;
                }
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Fiscal year {0} does not contain {1}.", (Object[])new Object[]{this, n}));
            }
            case MONTH: {
                if (this.months == null) break;
                for (DateRange dateRange : this.months) {
                    if (!dateRange.contains(n)) continue;
                    return dateRange;
                }
                break;
            }
            case QUARTER: {
                if (this.quarters == null) break;
                for (DateRange dateRange : this.quarters) {
                    if (!dateRange.contains(n)) continue;
                    return dateRange;
                }
                break;
            }
            case HALF_YEAR: {
                if (this.halfYears == null) break;
                for (DateRange dateRange : this.halfYears) {
                    if (!dateRange.contains(n)) continue;
                    return dateRange;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized period type: " + periodType);
            }
        }
        throw new IllegalStateException(MessageUtil.formatMsg((String)"There is no period, of type {0}, defined in fiscal year {1} that contains {2}.", (Object[])new Object[]{periodType, this, n}));
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        FiscalYear fiscalYear = (FiscalYear)object;
        return fiscalYear.year == this.year && fiscalYear.getBegin() == this.getBegin() && fiscalYear.getEnd() == this.getEnd();
    }

    @Override
    public int hashCode() {
        return this.year + this.getBegin() + this.getEnd();
    }

    @Override
    public String toString() {
        return MessageUtil.formatMsg((String)"{0}:{1}-{2}", (Object[])new Object[]{this.year, this.getBegin(), this.getEnd()});
    }

    private void constructQuarters() {
        int n = this.months.length;
        if (n == 12 || n == 13) {
            this.quarters[0] = new DateRange(this.months[0].getBegin(), this.months[2].getEnd());
            this.quarters[1] = new DateRange(this.months[3].getBegin(), this.months[5].getEnd());
            this.quarters[2] = new DateRange(this.months[6].getBegin(), this.months[8].getEnd());
            this.quarters[3] = n == 12 ? new DateRange(this.months[9].getBegin(), this.months[11].getEnd()) : new DateRange(this.months[9].getBegin(), this.months[12].getEnd());
        }
    }

    private void constructHalfYears() {
        int n = this.months.length;
        if (n == 12 || n == 13) {
            this.halfYears[0] = new DateRange(this.months[0].getBegin(), this.months[5].getEnd());
            this.halfYears[1] = n == 12 ? new DateRange(this.months[6].getBegin(), this.months[11].getEnd()) : new DateRange(this.months[6].getBegin(), this.months[12].getEnd());
        }
    }
}

