/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.busobj.PrereqEventType;
import com.helpsystems.enterprise.core.forecast.ForecastSpecificInstance;
import com.helpsystems.enterprise.core.forecast.ForecastTargetInfo;
import com.helpsystems.enterprise.core.scheduler.DependentObject;
import com.helpsystems.enterprise.core.scheduler.PrereqStatusType;
import com.helpsystems.enterprise.core.scheduler.PrerequisiteConditionsList;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo;

public class DependencyEntry {
    private DependentObject dependentObject;
    private long prerequisiteID;
    private PrereqEventType prerequisiteType;
    ForecastTargetInfo dependentTargetInfo;
    ForecastTargetInfo prereqTargetInfo;
    private int sequenceNumber;
    private PrerequisiteConditionsList.PrereqConjunction conjunction;
    private PrereqStatusType reactToStatus;
    private ForecastSpecificInstance specificInstance;
    private boolean latchStatus;

    public PrerequisiteConditionsList.PrereqConjunction getConjunction() {
        return this.conjunction;
    }

    public DependentObject getDependentObject() {
        return this.dependentObject;
    }

    public long getDependentTargetID() {
        if (this.dependentTargetInfo != null) {
            return this.dependentTargetInfo.getId();
        }
        throw new IllegalStateException("Dependent target information has not been set.");
    }

    public ForecastTargetInfo getDependentTargetInfo() {
        if (this.dependentTargetInfo != null) {
            return this.dependentTargetInfo;
        }
        throw new IllegalStateException("Dependent target information has not been set.");
    }

    public ScheduleInfo.TargetType getDependentTargetType() {
        if (this.dependentTargetInfo != null) {
            return this.dependentTargetInfo.getType();
        }
        throw new IllegalStateException("Dependent target information has not been set.");
    }

    public long getPrerequisiteID() {
        return this.prerequisiteID;
    }

    public PrereqEventType getPrerequisiteType() {
        return this.prerequisiteType;
    }

    public long getPrereqTargetID() {
        if (this.prereqTargetInfo != null) {
            return this.prereqTargetInfo.getId();
        }
        throw new IllegalStateException("Prereq target information has not been set.");
    }

    public ForecastTargetInfo getPrereqTargetInfo() {
        if (this.prereqTargetInfo != null) {
            return this.prereqTargetInfo;
        }
        throw new IllegalStateException("Prereq target information has not been set.");
    }

    public ScheduleInfo.TargetType getPrereqTargetType() {
        if (this.prereqTargetInfo != null) {
            return this.prereqTargetInfo.getType();
        }
        throw new IllegalStateException("Prereq target information has not been set.");
    }

    public PrereqStatusType getReactToStatus() {
        return this.reactToStatus;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public ForecastSpecificInstance getSpecificInstance() {
        return this.specificInstance;
    }

    public boolean isLatchStatus() {
        return this.latchStatus;
    }

    public void setConjunction(PrerequisiteConditionsList.PrereqConjunction prereqConjunction) {
        ValidationHelper.checkForNull((String)"Prerequisite conjunction", (Object)prereqConjunction);
        this.conjunction = prereqConjunction;
    }

    public void setDependentObject(DependentObject dependentObject) {
        this.dependentObject = dependentObject;
    }

    public void setDependentTargetInfo(ForecastTargetInfo forecastTargetInfo) {
        ValidationHelper.checkForNull((String)"Target Info", (Object)forecastTargetInfo);
        this.dependentTargetInfo = forecastTargetInfo;
    }

    public void setLatchStatus(boolean bl) {
        this.latchStatus = bl;
    }

    public void setPrereqTargetInfo(ForecastTargetInfo forecastTargetInfo) {
        ValidationHelper.checkForNull((String)"Target Info", (Object)forecastTargetInfo);
        this.prereqTargetInfo = forecastTargetInfo;
    }

    public void setPrerequisiteID(long l) {
        this.prerequisiteID = l;
    }

    public void setPrerequisiteType(PrereqEventType prereqEventType) {
        this.prerequisiteType = prereqEventType;
    }

    public void setReactToStatus(PrereqStatusType prereqStatusType) {
        ValidationHelper.checkForNull((String)"React To Status", (Object)prereqStatusType);
        this.reactToStatus = prereqStatusType;
    }

    public void setSequenceNumber(int n) {
        this.sequenceNumber = n;
    }

    public void setSpecificInstance(ForecastSpecificInstance forecastSpecificInstance) {
        this.specificInstance = forecastSpecificInstance;
    }

    public boolean isDependentTargetInfoSet() {
        return this.dependentTargetInfo != null;
    }

    public boolean isPrereqTargetInfoSet() {
        return this.prereqTargetInfo != null;
    }

    public boolean isReactToSpecificInstanceOnly() {
        return this.specificInstance != null;
    }

    public void validate() {
        ValidationHelper.validateReqFieldNotNull((String)"Prerequisite conjunction", (Object)this.conjunction);
    }

    public String toString() {
        String string = this.dependentObject.getType() == DependentObject.DependentObjectType.MEMBER_JOB ? "mbr " + this.dependentObject.getID() : Long.toString(this.dependentObject.getID());
        String string2 = this.prerequisiteType == PrereqEventType.JOB_SUITE_MEMBER_STATUS_CHANGE ? "mbr " + this.prerequisiteID : Long.toString(this.prerequisiteID);
        return "dep:" + string + "|pre:" + string2 + "|" + this.sequenceNumber + "|" + this.conjunction;
    }
}

