/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.reports;

import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.scheduler.PersistableEnum;
import com.helpsystems.enterprise.core.scheduler.PersistanceCodeToEnumMap;

public class Reports {
    public static final int GOOD_MORNING_REPORT_ID = 0;
    public static final String GOOD_MORNING_REPORT_NAME = "GoodMorningReport";
    public static final int JOB_SETUP_REPORT_ID = 100;
    public static final String JOB_SETUP_REPORT_NAME = "JobSetupReport";
    public static final int JOB_HISTORY_REPORT_ID = 1000;
    public static final String JOB_HISTORY_REPORT_NAME = "JobHistoryReport";
    public static final int AGENT_EVENT_HISTORY_REPORT_ID = 1001;
    public static final String AGENT_EVENT_HISTORY_REPORT_NAME = "AgentEventHistoryReport";
    public static final int JOB_MONITOR_HISTORY_REPORT_ID = 1002;
    public static final String JOB_MONITOR_HISTORY_REPORT_NAME = "JobMonitorHistoryReport";
    public static final int OUTPUT_DISTRIBUTION_HISTORY_REPORT_ID = 1003;
    public static final String OUTPUT_DISTRIBUTION_HISTORY_REPORT_NAME = "OutputDistributionHistoryReport";
    public static final int SNMP_TRAP_MONITOR_HISTORY_REPORT_ID = 1004;
    public static final String SNMP_TRAP_MONITOR_HISTORY_REPORT_NAME = "SNMPTrapMonitorHistoryReport";
    public static final int AUDIT_HISTORY_REPORT_ID = 1005;
    public static final String AUDIT_HISTORY_REPORT_NAME = "AuditHistoryReport";
    public static final int FORECAST_JOB_RUNS_REPORT_ID = 1006;
    public static final String FORECAST_JOB_RUNS_REPORT_NAME = "ForecastedJobRunsReport";
    public static final int SERVER_HISTORY_REPORT_ID = 1007;
    public static final String SERVER_HISTORY_REPORT_NAME = "ServerHistoryReport";
    public static final int IMPORT_VALIDATION_REPORT_ID = 1008;
    public static final String IMPORT_VALIDATION_REPORT_NAME = "ImportValidationReport";
    public static final String SAP_SYSTEM_DEFINITION_REPORT_NAME = "SAPSystemDefinitionReport";
    public static final int SAP_SYSTEM_DEFINITION_REPORT_ID = 1009;
    public static final String SAP_JOB_DEFINITION_REPORT_NAME = "SAPJobDefinitionReport";
    public static final int SAP_JOB_DEFINITION_REPORT_ID = 1010;
    public static final String SAP_ABAP_STEP_SET_REPORT_NAME = "SAPAbapStepSetReport";
    public static final int SAP_ABAP_STEP_SET_REPORT_ID = 1011;
    public static final String SAP_INTERCEPTED_JOB_HISTORY_REPORT_NAME = "SAPInterceptedJobHistoryReport";
    public static final int SAP_INTERCEPTED_JOB_HISTORY_REPORT_ID = 1012;
    public static final String SAP_RUN_INTERCEPTED_JOBS_REPORT_NAME = "SAPRunInterceptedJobsReport";
    public static final int SAP_RUN_INTERCEPTED_JOBS_REPORT_ID = 1013;
    public static final String SECURITY_REPORT_NAME = "SecurityReport";
    public static final int SECURITY_REPORT_ID = 1014;
    public static final String USER_NAME_PARAM = "-userName";
    private static final int USER_NAME_PARAM_ID = 1;

    public static String getReportNameByID(int n) {
        switch (n) {
            case 0: {
                return GOOD_MORNING_REPORT_NAME;
            }
            case 100: {
                return JOB_SETUP_REPORT_NAME;
            }
            case 1000: {
                return JOB_HISTORY_REPORT_NAME;
            }
            case 1001: {
                return AGENT_EVENT_HISTORY_REPORT_NAME;
            }
            case 1002: {
                return JOB_MONITOR_HISTORY_REPORT_NAME;
            }
            case 1003: {
                return OUTPUT_DISTRIBUTION_HISTORY_REPORT_NAME;
            }
            case 1004: {
                return SNMP_TRAP_MONITOR_HISTORY_REPORT_NAME;
            }
            case 1005: {
                return AUDIT_HISTORY_REPORT_NAME;
            }
            case 1006: {
                return FORECAST_JOB_RUNS_REPORT_NAME;
            }
            case 1007: {
                return SERVER_HISTORY_REPORT_NAME;
            }
            case 1008: {
                return IMPORT_VALIDATION_REPORT_NAME;
            }
            case 1009: {
                return SAP_SYSTEM_DEFINITION_REPORT_NAME;
            }
            case 1010: {
                return SAP_JOB_DEFINITION_REPORT_NAME;
            }
            case 1011: {
                return SAP_ABAP_STEP_SET_REPORT_NAME;
            }
            case 1012: {
                return SAP_INTERCEPTED_JOB_HISTORY_REPORT_NAME;
            }
            case 1013: {
                return SAP_RUN_INTERCEPTED_JOBS_REPORT_NAME;
            }
            case 1014: {
                return SECURITY_REPORT_NAME;
            }
        }
        throw new IllegalStateException("Invalid report ID: " + n);
    }

    public static String getUserName(Object ... objectArray) {
        String string = null;
        int n = -1;
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            String string2 = (String)object;
            if (USER_NAME_PARAM.equalsIgnoreCase(string2)) {
                n = 1;
                string = "";
                continue;
            }
            if (string2.startsWith("-")) {
                n = -1;
                continue;
            }
            if (1 != n) continue;
            string = string2;
            break;
        }
        return string;
    }

    public static enum ReportType implements PersistableEnum<Integer>
    {
        GOOD_MORNING_REPORT(0, "GoodMorningReport"),
        JOB_SETUP_REPORT(100, "JobSetupReport"),
        JOB_HISTORY_REPORT(1000, "JobHistoryReport"),
        AGENT_EVENT_HISTORY_REPORT(1001, "AgentEventHistoryReport"),
        JOB_MONITOR_HISTORY_REPORT(1002, "JobMonitorHistoryReport"),
        OUTPUT_DISTRIBUTION_HISTORY_REPORT(1003, "OutputDistributionHistoryReport"),
        SNMP_TRAP_MONITOR_HISTORY_REPORT(1004, "SNMPTrapMonitorHistoryReport"),
        AUDIT_HISTORY_REPORT(1005, "AuditHistoryReport"),
        FORECAST_JOB_RUNS_REPORT(1006, "ForecastedJobRunsReport"),
        SERVER_HISTORY_REPORT(1007, "ServerHistoryReport"),
        IMPORT_VALIDATION_REPORT(1008, "ImportValidationReport"),
        SAP_SYSTEM_DEFINITION_REPORT(1009, "SAPSystemDefinitionReport"),
        SAP_JOB_DEFINITION_REPORT(1010, "SAPJobDefinitionReport"),
        SAP_ABAP_STEP_SET_REPORT(1011, "SAPAbapStepSetReport"),
        SAP_INTERCEPTED_JOB_HISTORY_REPORT(1012, "SAPInterceptedJobHistoryReport"),
        SAP_RUN_INTERCEPTED_JOBS_REPORT(1013, "SAPRunInterceptedJobsReport"),
        SECURITY_REPORT(1014, "SecurityReport");

        private int reportType;
        private String reportName;
        private static PersistanceCodeToEnumMap<Integer, ReportType> map;

        private ReportType(int n2, String string2) {
            this.reportType = n2;
            this.reportName = string2;
        }

        @Override
        public Integer persistanceCode() {
            return this.reportType;
        }

        public String getReportName() {
            return this.reportName;
        }

        public static ReportType persistanceCodeToEnum(int n) {
            ReportType reportType = map.get(n);
            if (reportType == null) {
                String string = MessageUtil.formatMsg((String)"There is no {0} enum constant associated with code: {1}.", (Object[])new Object[]{map.getEnumName(), n});
                throw new IllegalStateException(string);
            }
            return reportType;
        }

        public static ReportType getReportType(String string) {
            ValidationHelper.checkForNullAndBlank((String)"Report ID", (String)string);
            int n = Integer.parseInt(string);
            return ReportType.getReportType(n);
        }

        public static ReportType getReportType(int n) {
            switch (n) {
                case 0: {
                    return GOOD_MORNING_REPORT;
                }
                case 100: {
                    return JOB_SETUP_REPORT;
                }
                case 1000: {
                    return JOB_HISTORY_REPORT;
                }
                case 1001: {
                    return AGENT_EVENT_HISTORY_REPORT;
                }
                case 1002: {
                    return JOB_MONITOR_HISTORY_REPORT;
                }
                case 1003: {
                    return OUTPUT_DISTRIBUTION_HISTORY_REPORT;
                }
                case 1004: {
                    return SNMP_TRAP_MONITOR_HISTORY_REPORT;
                }
                case 1005: {
                    return AUDIT_HISTORY_REPORT;
                }
                case 1006: {
                    return FORECAST_JOB_RUNS_REPORT;
                }
                case 1007: {
                    return SERVER_HISTORY_REPORT;
                }
                case 1008: {
                    return IMPORT_VALIDATION_REPORT;
                }
                case 1009: {
                    return SAP_SYSTEM_DEFINITION_REPORT;
                }
                case 1010: {
                    return SAP_JOB_DEFINITION_REPORT;
                }
                case 1011: {
                    return SAP_ABAP_STEP_SET_REPORT;
                }
                case 1013: {
                    return SAP_RUN_INTERCEPTED_JOBS_REPORT;
                }
                case 1012: {
                    return SAP_INTERCEPTED_JOB_HISTORY_REPORT;
                }
                case 1014: {
                    return SECURITY_REPORT;
                }
            }
            throw new IllegalStateException("The Report type " + n + " is not supported.");
        }

        public int getReportID() {
            return this.reportType;
        }

        static {
            map = new PersistanceCodeToEnumMap((Enum[])ReportType.values());
        }
    }
}

