/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.reports;

import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.enterprise.core.busobj.AgentEventMonitor;
import com.helpsystems.enterprise.core.dm.EnterpriseServerAM;
import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.LocalHHMM;
import com.helpsystems.enterprise.core.scheduler.MissedJobAction;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobProxy;
import java.lang.reflect.Array;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ReportHelper {
    private static final DateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
    private static final DateFormat dateFilterFromatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static final Logger logger = Logger.getLogger(ReportHelper.class);
    public static final String ALL_JOBS = "All Jobs";
    public static final String SUITE = "Suite";
    public static final String MEMBER_JOB = "MemberJob";
    public static final String HEADER_REPORT_NAME = "HEADER_REPORT_NAME";
    public static final String HEADER_FROM_DATE = "HEADER_FROM_DATE";
    public static final String HEADER_TO_DATE = "HEADER_TO_DATE";
    public static final String SKYBOT_VERSION = "SKYBOT_VERSION";
    public static final String REPORT_OUTPUT_TYPE = "REPORT_OUTPUT_TYPE";
    public static final String SAP_SYSTEM_DEFINITION_NAME = "SAP_SYSTEM_DEFINITION_NAME";
    public static final String JOB_RUN_NUMBER = "JOB_RUN_NUMBER";
    public static final String JOB_NAME = "JOB_NAME";
    public static final String JOB_DESC = "JOB_DESC";
    public static final String AGENT = "AGENT";
    public static final String AGENT_GROUP = "AGENT_GROUP";
    public static final String JOB_TYPE = "JOB_TYPE";
    public static final String JOB_SUITE_NAME = "JOB_SUITE_NAME";
    public static final String SERVER_START_TIME = "SERVER_START_TIME";
    public static final String SERVER_END_TIME = "SERVER_END_TIME";
    public static final String SERVER_RUN_TIME = "SERVER_RUN_TIME";
    public static final String JOB_STATUS = "JOB_STATUS";
    public static final String JOB_ENDED_REASON_CODE = "JOB_ENDED_REASON_CODE";
    public static final String EVENT_ID = "EVENT_ID";
    public static final String EVENT_NAME = "EVENT_NAME";
    public static final String AGENT_TIME = "AGENT_TIME";
    public static final String SERVER_TIME = "SERVER_TIME";
    public static final String EVENT_TYPE = "EVENT_TYPE";
    public static final String EVENT_NOTE = "EVENT_NOTE";
    public static final String EVENT_DATA = "EVENT_DATA";
    public static final String AGENT_DESC = "AGENT_DESC";
    public static final String AGENT_STATUS = "AGENT_STATUS";
    public static final String SERVER_SCHEDULED_TIME = "SERVER_SCHEDULED_TIME";
    public static final String SERVER_SUBMITTIED_TIME = "SERVER_SUBMITTIED_TIME";
    public static final String INACTIVE = "Inactive";
    public static final String ONELINEFIELD = "ONELINEFIELD";
    public static final String NAMEFIELD = "NAMEFIELD";
    public static final String VALUEFIELD = "VALUEFIELD";
    public static final String JOB_MONITOR_TYPE = "JOB_MONITOR_TYPE";
    public static final String LABEL_JOB_MONITOR_TYPE = "Monitor Type";
    public static final String SERVER_HISTORY_DATE = "SERVER_HISTORY_DATE";
    public static final String SERVER_HISTORY_MESSAGE = "SERVER_HISTORY_MESSAGE";
    public static final String IMPORT_FILE_NAME = "IMPORT_FILE_NAME";
    public static final String VALIDATION_OBJECT_TYPE = "VALIDATION_OBJECT_TYPE";
    public static final String VALIDATION_OBJECT_MESSAGE = "VALIDATION_OBJECT_MESSAGE";
    public static final String LABEL_JOB_RUN_NUMBER = "Job Run Number";
    public static final String LABEL_JOB_NAME = "Job Name";
    public static final String LABEL_JOB_DESC = "Description";
    public static final String LABEL_AGENT = "Agent";
    public static final String LABEL_AGENT_GROUP = "Agent Group";
    public static final String LABEL_SERVER_START_TIME = "Server Start Time";
    public static final String LABEL_SERVER_END_TIME = "Server End Time";
    public static final String LABEL_SERVER_RUN_TIME = "Actual Run-time";
    public static final String LABEL_JOB_STATUS = "Job Status";
    public static final String LABEL_EVENT_ID = "Event ID";
    public static final String LABEL_EVENT_NAME = "Event Name";
    public static final String LABEL_AGENT_TIME = "Agent Time";
    public static final String LABEL_SERVER_TIME = "Server Time";
    public static final String LABEL_EVENT_TYPE = "Event Type";
    public static final String LABEL_EVENT_NOTE = "Note";
    public static final String LABEL_AGENT_DESC = "Agent Description";
    public static final String LABEL_AGENT_STATUS = "Agent Status";
    public static final String LABEL_SERVER_SCHEDULED_TIME = "Server Scheduled Time";
    public static final String LABEL_SERVER_SUBMITTIED_TIME = "Server Submittied Time";
    public static final String LABEL_JOB_SUITE_NAME = "Suite Name";
    public static final String INITIATED = "Initiated";
    public static final String SUBMITTED = "Submitted";
    public static final String ERROR = "Error";
    public static final String RUNNING = "Running";
    public static final String COMPLETED = "Completed";
    public static final String FAILED = "Failed";
    public static final String MANAGED = "Managed";
    public static final String CANCELED = "Canceled";
    public static final String CONDITION_RETRY_WAIT = "Condition Retry-Wait";
    public static final String CONDITION_CHECK = "Condition Check";
    public static final String SKIPPED = "Skipped";
    public static final String MEMBER_FAILED = "Member Failed";
    public static final String MEMBER_CANCELED = "Member Canceled";
    public static final String INITIALIZATION_FAILURE = "Initiated";
    public static final String COMMAND_FAILURE = "Command Failure";
    public static final String TIME_RANGE_VIOLATION = "Allowable Time Range";
    public static final String MISSED_JOB_ACTION = "Missed Action";
    public static final String INVALID_LICENSE = "Invalid License";
    public static final String ENDED_MANUALLY = "Ended Manually";
    public static final String REMOVED_MANUALLY = "Removed Manually";
    public static final String MANAGED_JOB_ACTION = "Managed Job Action";
    public static final String JOB_MONITOR_ACTION = "Job Monitor Action";
    public static final String AGENT_MISSING = "Agent Missing";
    public static final String AGENT_ENDED = "Agent Ended";
    public static final String CONDITION_NOT_MET = "Condition Not Met";
    public static final String AGENT_UPDATE_REQUIRED = "Agent Update Required";
    public static final String OUTPUT_DISTRIBUTION = "Output Distribution";
    public static final String PLATFORM_COMMAND_MISMATCH = "Command/Platform Mismatch";
    public static final String AGENT_INCOMPLETE_PATH_SPECIFIED_FOR_THE_CONDITION = "Condition Failure";
    public static final String COMMAND_NOT_FOUND = "Command not Found";
    public static final String COMMAND_NOT_EXECUTABLE = "Access Denied";
    public static final String PREREQUISITE_NOT_MET = "Prerequisite Not Met";
    public static final String ALREADY_ACTIVE = "Already Active";
    public static final String PARENT_SUITE_ENDED = "Suite Ended";
    public static final String EXEC_AS_AGENT_USER_DISABLED = "Agent User Disabled";
    public static final String PROHIBITED_COMMAND = "Prohibited Command";
    public static final String LABEL_EVENT_DATA_ACTIONS = "Actions Performed";
    public static final String LABEL_EVENT_DATA = "Event Data(first 250 characters)";
    public static final String GROUP_SUBREPORT_PARAMS = "GROUP_SUBREPORT_PARAMS";
    public static final String GROUP_SUBREPORT_DATA = "GROUP_SUBREPORT_DATA";
    public static final String HISTORY_LIST = "HISTORY_LIST";
    public static final String GROUPING = "GROUPING";
    public static final String TITLE_JOB_LIST = "TITLE_JOB_LIST";
    public static final String TITLE_AGENT_LIST = "TITLE_AGENT_LIST";
    public static final String TITLE_TAG_LIST = "TITLE_TAG_LIST";
    public static final String COPIED_TO_SERVER_DATE = "COPIED_TO_SERVER_DATE";
    public static final String FILE_NAME = "FILE_NAME";
    public static final String DISTRIBTION_TYPE = "DISTRIBTION_TYPE";
    public static final String STATUS = "STATUS";
    public static final String LABEL_COPIED_TO_SERVER_DATE = "Server Copied Time";
    public static final String LABEL_FILE_NAME = "File Name";
    public static final String LABEL_DISTRIBTION_TYPE = "Distribution Type";
    public static final String LABEL_STATUS = "Status";
    public static final String MONITOR_NAME = "MONITOR_NAME";
    public static final String IP_ADDRESS = "IP_ADDRESS";
    public static final String LABEL_MONITOR_NAME = "Monitor Name";
    public static final String LABEL_IP_ADDRESS = "IP Address";
    public static final String AUDIT_DATE = "AUDIT_DATE";
    public static final String AUDIT_AREA = "AUDIT_AREA";
    public static final String AUDIT_ACTION = "AUDIT_ACTION";
    public static final String AUDIT_TYPE = "AUDIT_TYPE";
    public static final String AUDIT_USER = "AUDIT_USER";
    public static final String AUDIT_CHANGE = "AUDIT_CHANGE";
    public static final String AUDIT_CHANGE_TYPE = "AUDIT_CHANGE_TYPE";
    public static final String AUDIT_CHANGE_FIELD = "AUDIT_CHANGE_FIELD";
    public static final String AUDIT_CHANGE_VALUE = "AUDIT_CHANGE_VALUE";
    public static final String AUDIT_CHANGE_NEW_VALUE = "AUDIT_CHANGE_NEW_VALUE";
    public static final String LABEL_AUDIT_DATE = "Date";
    public static final String LABEL_AUDIT_AREA = "Area";
    public static final String LABEL_AUDIT_ACTION = "Action";
    public static final String LABEL_AUDIT_TYPE = "Type";
    public static final String LABEL_AUDIT_USER = "User";
    public static final String LABEL_AUDIT_CHANGE = "Changes";
    public static final String FORECAST_DEF = "FORECAST_DEF";
    public static final String GEN_TIME = "GEN_TIME";
    public static final String FORECAST_JOB_RUNS = "FORECAST_JOB_RUNS";
    public static final String COLUMN_NAMES = "REPORT_COLUMN_NAMES";
    public static final String ROW_DATA = "ROW_DATA";
    public static final String MEMBER_SKIPPED_PER_SPECIAL_INSTANCE = "MEMBER_SKIPPED_PER_SPECIAL_INSTANCE";
    public static final String PAGE_MANAGED_MISSED_JOBS = "Manage Missed Jobs";
    public static final String PAGE_JOB_HISTORY = "Job History";
    public static final String PAGE_JOB_MONITOR_HISTORY = "Job Monitor History";
    public static final String PAGE_SAP_INTERCEPTED_JOB_HISTORY = "SAP Intercepted Job History";
    private static final String STATUS_DESTROY = "destroy";
    private static final String STATUS_DELETE = "Delete";
    private static final String STATUS_DELETED = "Deleted";
    public static final String SCHEDULED_DATE = "SCHEDULED_DATE";
    public static final String LABEL_SCHEDULED_DATE = "Scheduled Time";
    public static final String TIME_DETECTED = "TIME_DETECTED";
    public static final String LABEL_TIME_DETECTED = "Time Detected";
    public static final String INIT_CODE = "INIT_CODE";
    public static final String LABEL_INIT_CODE = "Initiation Code";
    public static final String INITIATED_DATE = "INITIATED_DATE";
    public static final String LABEL_INITIATED_DATE = "Server Initiated Time";
    public static final String GROUP_SIMPLE_CHANGES = "SIMPLE_CHANGES";
    public static final String GROUP_UPDATE_CHANGES = "UPDATE_CHANGES";
    public static final String RECORD_LEVEL = "RECORD_LEVEL";
    public static final String DETAIL_H = "DETAIL_H";
    public static final String DETAIL = "DETAIL";
    public static final String CHANGE_H = "CHANGE_H";
    public static final String CHANGE = "CHANGE";
    public static final String UPDATE_CHANGE_H = "UPDATE_CHANGE_H";
    public static final String UPDATE_CHANGE = "UPDATE_CHANGE";
    public static final String EMPTY_LINE = "EMPTY_LINE";
    public static final String START_TIME = "START_TIME";
    public static final String LABEL_START_TIME = "Start Time";
    public static final String END_TIME = "END_TIME";
    public static final String LABEL_END_TIME = "End Time";
    public static final String TOTAL_DURATION = "TOTAL_DURATION";
    public static final String LABEL_TOTAL_DURATION = "Total Duration";
    public static final String SERVER_HOST_NAME = "SERVER_HOST_NAME";
    public static final String LABEL_REPORT_NAME = "REPORT_NAME";
    public static final String BOOKMARK = "BoOkMaRk";
    public static final String TOC_INDEX = "TOC_INDEX_INDEX";
    public static final String TARGET_AGENT_NAME = "Agent";
    public static final String TARGET_AGENT_GROUP_NAME = "AgentGroup";
    public static final String TARGET_TYPE = "TARGET_TYPE";
    public static final String TARGET_NAME = "TARGET_NAME";
    public static final String SYSTEM_DEFINITION = "SYSTEM_DEFINITION";
    public static final String ENVIORNMENT = "ENVIORNMENT";
    public static final String DEFINITION_NAME = "NAME";
    public static final String DEFINITION_DECSRIPTION = "DESC";
    public static final String SYSTEM_ID = "SYSTEM_ID";
    public static final String SYSTEM_NUMBER = "SYSTEM_NUMBER";
    public static final String ROUTERS = "ROUTERS";
    public static final String SLD_REGISTERED = "SLD_REGISTERED";
    public static final String POLLING = "POLLING";
    public static final String POLLING_INTERVAL = "POLLING_INTERVAL";
    public static final String APPLICATION_SERVER = "APP_SERVER";
    public static final String XML_AUDIT_LEVEL = "AUDIT_LEVEL";
    public static final String ENVIRONMENT_NAME = "ENVIRONMENT_NAME";
    public static final String ENVIRONMENT_DESC = "ENVIRONMENT_DESC";
    public static final String LANG_CODE_ID = "LANG_CODE_ID";
    public static final String SAP_CLIENT_CODE = "SAP_CLIENT_CODE";
    public static final String SAP_USERNAME = "SAP_USERNAME";
    public static final String LICENSE_POINTS = "LICENSE_POINTS";
    public static final String ALLOCATE_LICENSE = "ALLOCATE_LICENSE";
    public static final String JOB_DEFINITION_NAME = "JOB_DEFINITION_NAME";
    public static final String JOB_DEFINITION_DESC = "JOB_DEFINITION_DESC";
    public static final String JOB_DEFINITION_ID = "JOB_DEFINITION_ID";
    public static final String SYSTEM_DEFINITION_NAME = "SYSTEM_DEFINITION_NAME";
    public static final String DEFINED_IN_SKYBOT = "DEFINED_IN_SKYBOT";
    public static final String SCHEDULED_IN_SKYBOT = "SCHEDULED_IN_SKYBOT";
    public static final String SAP_JOB_CLASS = "SAP_JOB_CLASS";
    public static final String START_IMMEDIATELY = "START_IMMEDIATELY";
    public static final String SAP_ABAP_STEP_SET = "SAP_ABAP_STEP_SET";
    public static final String TAGS = "TAGS";
    public static final String SAP_EXEC_TARGET = "SAP_EXEC_TARGET";
    public static final String RECIPIENT_TYPE = "RECIPIENT_TYPE";
    public static final String EMAIL_ADDRESS = "Email Address";
    public static final String SEND_CONFIRMATION = "SEND_CONFIRMATION";
    public static final String SAP_SPOOL_LIST_RECP = "SAP_SPOOL_LIST_RECP";
    public static final String WAIT_FOR_CHILD = "WAIT_FOR_CHILD";
    public static final String RECIPIENT_ATTRIBUTES = "RECIPIENT_ATTRIBUTES";
    public static final String ENABLE = "ENABLE";
    public static final String ABAP_STEP_SET_ID = "ABAP_STEP_SET_ID";
    public static final String ABAP_STEP_SET_NAME = "ABAP_STEP_SET_NAME";
    public static final String ABAP_STEP_SET_DESC = "ABAP_STEP_SET_DESC";
    public static final String ABAP_STEP_LINE_NUM = "ABAP_STEP_LINE_NUM";
    public static final String ABAP_STEP_LANG_CODE_ID = "ABAP_STEP_LANG_CODE_ID";
    public static final String ABAP_STEP_VARIANT_NAME = "ABAP_STEP_VARIANT_NAME";
    public static final String ABAP_STEP_USER_NAME = "ABAP_STEP_USER_NAME";
    public static final String ABAP_STEP_PRINT_PARAM_ID = "ABAP_STEP_PRINT_PARAM_ID";
    public static final String ABAP_STEP_PROGRAM_NAME = "ABAP_STEP_PROGRAM_NAME";
    public static final String PRINT_PARAM_OUTPUT_DEVICE = "PRINT_PARAM_OUTPUT_DEVICE";
    public static final String PRINT_PARAM_NUMBER_OF_COPIES = "PRINT_PARAM_NUMBER_OF_COPIES";
    public static final String PRINT_PARAM_SPOOL_REQUEST_NAME = "PRINT_PARAM_SPOOL_REQUEST_NAME";
    public static final String PRINT_PARAM_COVER_PAGE_TEXT = "PRINT_PARAM_COVER_PAGE_TEXT";
    public static final String PRINT_PARAM_PRINT_IMMEDIATELY = "PRINT_PARAM_PRINT_IMMEDIATELY";
    public static final String PRINT_PARAM_DELETE_AFTER_PRINTING = "PRINT_PARAM_DELETE_AFTER_PRINTING";
    public static final String PRINT_PARAM_NEW_SPOOL_REQUEST = "PRINT_PARAM_NEW_SPOOL_REQUEST";
    public static final String PRINT_PARAM_SPOOL_RETENTION_PERIOD = "PRINT_PARAM_SPOOL_RETENTION_PERIOD";
    public static final String PRINT_PARAM_PAGE_LENGTH_OF_LIST = "PRINT_PARAM_PAGE_LENGTH_OF_LIST";
    public static final String PRINT_PARAM_LINE_WIDTH_OF_LIST = "PRINT_PARAM_LINE_WIDTH_OF_LIST";
    public static final String PRINT_PARAM_PRINT_FORMAT = "PRINT_PARAM_PRINT_FORMAT";
    public static final String PRINT_PARAM_COVER_PAGE_SELECTION = "PRINT_PARAM_COVER_PAGE_SELECTION";
    public static final String PRINT_PARAM_PRINT_SAP_COVER_PAGE = "PRINT_PARAM_PRINT_SAP_COVER_PAGE";
    public static final String PRINT_PARAM_RECIPIENT = "PRINT_PARAM_RECIPIENT";
    public static final String PRINT_PARAM_COVER_PAGE_DEPARTMENT = "PRINT_PARAM_COVER_PAGE_DEPARTMENT";
    public static final String PRINT_PARAM_SAP_AUTHORIZATION = "PRINT_PARAM_SAP_AUTHORIZATION";
    public static final String PRINT_PARAM_NAME_OF_SPOOL_FILE = "PRINT_PARAM_NAME_OF_SPOOL_FILE";
    public static final String PRINT_PARAM_TYPE_OF_SPOOL_REQUEST = "PRINT_PARAM_TYPE_OF_SPOOL_REQUEST";
    public static final String PRINT_PARAM_ARCHIVING_MODE = "PRINT_PARAM_ARCHIVING_MODE";
    public static final String PRINT_PARAM_SPOOL_REQUEST_PRIORITY = "PRINT_PARAM_SPOOL_REQUEST_PRIORITY";
    public static final String PRINT_PARAM_PRINT_HOST_COVER_PAGE = "PRINT_PARAM_PRINT_HOST_COVER_PAGE";
    public static final String PRINT_PARAM_ARCHIVE_OBJECT = "PRINT_PARAM_ARCHIVE_OBJECT";
    public static final String PRINT_PARAM_ARCHIVE_DOCUMENT = "PRINT_PARAM_ARCHIVE_DOCUMENT";
    public static final String PRINT_PARAM_ARCHIVE_INFORMATION = "PRINT_PARAM_ARCHIVE_INFORMATION";
    public static final String PRINT_PARAM_ARCHIVE_TEXT = "PRINT_PARAM_ARCHIVE_TEXT";
    public static final String PRINT_PARAM = "PRINT_PARAM";
    public static final String PRINT_PARAM_NAME = "PRINT_PARAM_NAME";
    public static final String AGENT_NAME = "AGENT_NAME";
    public static final String SAP_SYSTEM_DEFINITION = "SAP_SYSTEM_DEFINITION";
    public static final String SAP_JOB_NAME = "SAP_JOB_NAME";
    public static final String SAP_JOB_OWNER = "SAP_JOB_OWNER";
    public static final String SAP_CLIENT = "SAP_CLIENT";
    public static final String ALLOWED_FROM = "ALLOWED_FROM";
    public static final String ALLOWED_TO = "ALLOWED_TO";
    public static final String RESTRICTED_DAYS = "RESTRICTED_DAYS";
    public static final String HOLD_STATUS = "HOLD_STATUS";
    public static final String LABEL_HOLD_STATUS = "Held/Skipped";
    public static final String SAP_JOB_COUNT = "SAP_JOB_COUNT";
    public static final String SAP_PLANNED_START = "SAP_PLANNED_START";
    public static final String SKYBOT_JOB_NAME = "SKYBOT_JOB_NAME";
    public static final String SKYBOT_AGENT = "SKYBOT_AGENT";
    public static final String SKYBOT_SCHEDULED_RELEASE = "SKYBOT_SCHEDULED_RELEASE";
    public static final String JOB_HISTORY_ID = "JOB_HISTORY_ID";
    public static final String START_DATE_PARAM = "START_DATE_PARAM";
    public static final String END_DATE_PARAM = "END_DATE_PARAM";
    public static final String HEADER_PARAM_NAME = "HEADER_PARAM_NAME";
    private static HashMap<String, String> PERMISSIONS = null;
    private static HashMap<String, String> FLD_MAPPING = null;
    public static final String ROLE_NAME = "ROLE_NAME";
    public static final String ROLE = "ROLE";
    public static final String ROLE_MEMBER = "ROLE_MEMBER";
    public static final String ROLE_PERMISSION = "ROLE_PERMISSION";
    public static final String ROLE_SECURABLE_NAME = "ROLE_SECURABLE_TYPE";
    public static final String ROLE_SECURABLE_ID = "ROLE_SECURABLE_ID";

    public static String getJobStatus(String string) {
        if (string.equals("F")) {
            return FAILED;
        }
        if (string.equals("N")) {
            return "Initiated";
        }
        if (string.equals("S")) {
            return SUBMITTED;
        }
        if (string.equals("E")) {
            return ERROR;
        }
        if (string.equals("R")) {
            return RUNNING;
        }
        if (string.equals("C")) {
            return COMPLETED;
        }
        if (string.equals("M")) {
            return MANAGED;
        }
        if (string.equals("A")) {
            return CANCELED;
        }
        if (string.equals("W")) {
            return CONDITION_RETRY_WAIT;
        }
        if (string.equals("H")) {
            return CONDITION_CHECK;
        }
        if (string.equals("K")) {
            return SKIPPED;
        }
        if (string.equals("V")) {
            return MEMBER_FAILED;
        }
        if (string.equals("X")) {
            return MEMBER_CANCELED;
        }
        return "Unknown - " + string;
    }

    public static String getJobEndedReasonCode(String string) {
        if (string.equals("I")) {
            return "Initiated";
        }
        if (string.equals("C")) {
            return COMMAND_FAILURE;
        }
        if (string.equals("T")) {
            return TIME_RANGE_VIOLATION;
        }
        if (string.equals("M")) {
            return MISSED_JOB_ACTION;
        }
        if (string.equals("L")) {
            return INVALID_LICENSE;
        }
        if (string.equals("E")) {
            return ENDED_MANUALLY;
        }
        if (string.equals("R")) {
            return REMOVED_MANUALLY;
        }
        if (string.equals("N")) {
            return MANAGED_JOB_ACTION;
        }
        if (string.equals("J")) {
            return JOB_MONITOR_ACTION;
        }
        if (string.equals("A")) {
            return AGENT_MISSING;
        }
        if (string.equals("G")) {
            return AGENT_ENDED;
        }
        if (string.equals("D")) {
            return CONDITION_NOT_MET;
        }
        if (string.equals("U")) {
            return AGENT_UPDATE_REQUIRED;
        }
        if (string.equals("O")) {
            return OUTPUT_DISTRIBUTION;
        }
        if (string.equals("P")) {
            return PLATFORM_COMMAND_MISMATCH;
        }
        if (string.equals("X")) {
            return AGENT_INCOMPLETE_PATH_SPECIFIED_FOR_THE_CONDITION;
        }
        if (string.equals("Y")) {
            return COMMAND_NOT_FOUND;
        }
        if (string.equals("Z")) {
            return COMMAND_NOT_EXECUTABLE;
        }
        if (string.equals("Q")) {
            return PREREQUISITE_NOT_MET;
        }
        if (string.equals("V")) {
            return ALREADY_ACTIVE;
        }
        if (string.equals("S")) {
            return PARENT_SUITE_ENDED;
        }
        if (string.equals("B")) {
            return EXEC_AS_AGENT_USER_DISABLED;
        }
        if (string.equals("H")) {
            return PROHIBITED_COMMAND;
        }
        return "Unknown - " + string;
    }

    public static String getJobFullSatusString(String string, String string2) {
        String string3 = "";
        if (string != null && !string.equals("")) {
            string3 = string3 + ReportHelper.getJobStatus(string);
            if (string2 != null && !string2.equals("")) {
                string3 = string3 + " - " + ReportHelper.getJobEndedReasonCode(string2);
            }
        }
        return string3;
    }

    public static long getDateAsLong(String string, String string2) {
        long l = 0L;
        GregorianCalendar gregorianCalendar = null;
        Date date = null;
        String[] stringArray = string.split(" ");
        try {
            if (stringArray.length == 2) {
                String[] stringArray2 = stringArray[0].split("/");
                String string3 = stringArray2[0];
                String string4 = stringArray2[1];
                String string5 = stringArray2[2];
                int n = Integer.parseInt(string3);
                int n2 = Integer.parseInt(string4);
                int n3 = Integer.parseInt(string5);
                String[] stringArray3 = stringArray[1].split("_");
                int n4 = Integer.parseInt(stringArray3[0]);
                int n5 = Integer.parseInt(stringArray3[1]);
                gregorianCalendar = new GregorianCalendar(n3, n2 - 1, n, n4, n5);
                date = new Date(gregorianCalendar.getTimeInMillis());
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Using " + string2 + ": " + date.toString()));
                }
                l = date.getTime();
            }
        }
        catch (Exception exception) {
            logger.debug((Object)("Unable to get the passed in date " + string2 + " value of " + string + "."), (Throwable)exception);
            l = 0L;
        }
        return l;
    }

    public static final void main(String[] stringArray) {
        String string = "PARMS:06/02/2011 00_00:06/04/2011 00_01";
        String[] stringArray2 = string.split(":");
        for (int i = 0; i < stringArray2.length; ++i) {
            System.out.println("Parm [" + i + "] = " + stringArray2[i]);
        }
        String string2 = stringArray2[1];
        String string3 = stringArray2[2];
        Date date = new Date(ReportHelper.getDateAsLong(string2, "Test From Date"));
        System.out.println(string2 + " is " + date.toString());
        date = new Date(ReportHelper.getDateAsLong(string3, "Test To Date"));
        System.out.println(string3 + " is " + date.toString());
        String string4 = "changed";
        System.out.println(string4);
        System.out.println(ReportHelper.capFirst(string4));
        String[] stringArray3 = new String[]{"Element 1", "Element 2"};
        System.out.println("strings: " + ReportHelper.arrayToString(stringArray3));
        String[] stringArray4 = new String[]{"Some Field Changed:"};
        String[] stringArray5 = new String[]{"from", "to"};
        String[][] stringArrayArray = new String[][]{stringArray4, stringArray5};
        System.out.println("Multiple Arrays: " + ReportHelper.arrayToString(stringArrayArray));
    }

    public static Object getEventType(int n) {
        return AgentEventMonitor.getTypeDescription(n);
    }

    public static String getEventStatusError(int n) {
        switch (n) {
            case 0: {
                return "";
            }
            case 1: {
                return "Missing Event ID";
            }
            case 2: {
                return "Invalid Agent Name";
            }
            case 3: {
                return "Outside Time Range";
            }
            case 4: {
                return "Event is held";
            }
        }
        return "Unknown status " + n;
    }

    public static Object getDistributionType(Integer n) {
        switch (n) {
            case 0: {
                return "Copy To Server";
            }
            case 1: {
                return "Email";
            }
            case 2: {
                return "Report";
            }
        }
        return "Unknown Type";
    }

    public static Object getOutputDistributionStatus(Integer n) {
        switch (n) {
            case 2: {
                return COMPLETED;
            }
            case 1: {
                return "Copied";
            }
            case 6: {
                return FAILED;
            }
            case 5: {
                return "Finished";
            }
            case 0: {
                return "Pending";
            }
            case 4: {
                return RUNNING;
            }
            case 3: {
                return "Sent";
            }
        }
        return "Unknown";
    }

    public static String getSNMPTrapNotes(int n) {
        switch (n) {
            case 0: {
                return "";
            }
            case 2: {
                return "Event Held";
            }
            case 1: {
                return "Outside Time Range";
            }
        }
        return "";
    }

    public static String capFirst(String string) {
        if (string == null) {
            return "";
        }
        if (string.trim().length() == 1) {
            return string.toUpperCase();
        }
        String string2 = string.substring(0, 1);
        StringBuffer stringBuffer = new StringBuffer(string2.toUpperCase());
        stringBuffer.append(string.substring(1));
        return stringBuffer.toString();
    }

    public static String getStartDate(Long l) {
        if (l != null && l != 0L) {
            return dateFilterFromatter.format(new Date(l));
        }
        return "Earliest available data";
    }

    public static String getEndDate(Long l) {
        if (l != null && l != 0L) {
            return dateFilterFromatter.format(new Date(l));
        }
        return dateFilterFromatter.format(new Date());
    }

    public static String getRowLimitMessage(int n, int n2, String string) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        DecimalFormat decimalFormat = (DecimalFormat)numberFormat;
        decimalFormat.applyPattern("###,###");
        String string2 = decimalFormat.format(n2);
        String string3 = "Showing " + n + " of " + string2 + " records.  To display the full list see the Automate Schedule browser " + string + " page.";
        return string3;
    }

    public static String getFormatedDate(Date date) {
        return dateFormatter.format(date);
    }

    public static String arrayToString(Object object) {
        if (object == null) {
            return "";
        }
        if (!object.getClass().isArray()) {
            return object.toString();
        }
        StringBuilder stringBuilder = new StringBuilder("[");
        int n = Array.getLength(object);
        for (int i = 0; i < n; ++i) {
            Object object2 = Array.get(object, i);
            if (object2 != null && object2.getClass().isArray()) {
                stringBuilder.append(ReportHelper.arrayToString(object2));
            } else {
                stringBuilder.append(object2);
            }
            if (i <= n - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static String getActionString(String string) {
        String string2 = string;
        if (string2 == null || string2.trim().length() < 2) {
            return "Missing";
        }
        if (string2.equalsIgnoreCase(STATUS_DESTROY)) {
            return STATUS_DELETE;
        }
        return ReportHelper.capFirst(string);
    }

    public static String getActionStringAction(String string) {
        String string2 = string;
        if (string2 == null || string2.trim().length() < 2) {
            return "Missing";
        }
        if (string2.equalsIgnoreCase(STATUS_DESTROY)) {
            return STATUS_DELETED;
        }
        string = string + "d";
        return ReportHelper.capFirst(string);
    }

    public static String getInitiationCode(int n) {
        switch (n) {
            case 0: {
                return "Schedule";
            }
            case 1: {
                return "Reactive";
            }
            case 2: {
                return LABEL_AUDIT_USER;
            }
            case 3: {
                return "Restart";
            }
            case 4: {
                return "Sched/Prereq";
            }
            case 6: {
                return "Suite Member";
            }
        }
        return "Unknown";
    }

    public static String getForecastInitCode(int n) {
        switch (n) {
            case 0: {
                return "Schedule";
            }
            case 1: {
                return "Reactive";
            }
            case 2: {
                return LABEL_AUDIT_USER;
            }
            case 3: {
                return "Restart";
            }
            case 4: {
                return "Sched/Prereq";
            }
            case 5: {
                return "Forecast Schedule";
            }
            case 6: {
                return "Suite Member";
            }
        }
        return "Unknown - " + n;
    }

    public static String getFTPDirection(int n) {
        switch (n) {
            case 0: {
                return "pull";
            }
            case 1: {
                return "push";
            }
        }
        return "Unknown - " + n;
    }

    public static String getPrivateOrShared(int n) {
        switch (n) {
            case 1: {
                return "private";
            }
            case 2: {
                return "shared";
            }
        }
        return "Unknown - " + n;
    }

    public static String getCommandTransferType(int n) {
        switch (n) {
            case 0: {
                return "text";
            }
            case 1: {
                return "binary";
            }
        }
        return "Unknown - " + n;
    }

    public static String getTransferType(int n) {
        switch (n) {
            case 0: {
                return "FTP";
            }
            case 2: {
                return "FTPS";
            }
            case 1: {
                return "SFTP";
            }
        }
        return "Unknown - " + n;
    }

    public static String getScheduleTypeName(ScheduleJobProxy.ScheduleType scheduleType) {
        switch (scheduleType) {
            case DAY_OF_WEEK: {
                return "Day of Week";
            }
            case DAY_OF_PERIOD: {
                return "Day of Period";
            }
            case DATE_LIST: {
                return "Date List";
            }
            case TIMED_INTERVAL: {
                return "Timed Interval";
            }
            case DAY_COUNT: {
                return "Daily Interval";
            }
            case UNSCHEDULED: {
                return "Unscheduled Job";
            }
            case REACTIVITY_DATE_LIST: {
                return "React only during Date List range";
            }
            case REACTIVITY_DAY_OF_WEEK: {
                return "React only during Day of Week range";
            }
            case REACTIVITY_DAY_OF_PERIOD: {
                return "React only during Day of Period range";
            }
            case CRON_EXPRESSION: {
                return "Cron Exrpession";
            }
            case SAP_RUN_INTERCEPT: {
                return "SAP Run Intercepted Job";
            }
        }
        return null;
    }

    public static String getYesNo(boolean bl) {
        if (bl) {
            return "yes";
        }
        return "no";
    }

    public static String getTimeZoneType(String string) {
        if ("A".equals(string)) {
            return "agent timezone";
        }
        if ("S".equals(string)) {
            return "server timezone";
        }
        return "unknown - " + string;
    }

    public static String getCondFailAction(int n) {
        switch (n) {
            case 0: {
                return "Fail";
            }
            case 1: {
                return "Cancel";
            }
            case 2: {
                return "Run anyway";
            }
        }
        return "Unknown type - " + n;
    }

    public static String getWorkDaysName(CalendarObject.DayType dayType) {
        switch (dayType) {
            case NON_WORKDAYS: {
                return "Non-Working Days";
            }
            case ALL_DAYS: {
                return "All Days";
            }
            case WORKDAYS: {
                return "Working Days";
            }
        }
        return null;
    }

    public static String getMissedActionType(int n) {
        try {
            MissedJobAction missedJobAction = MissedJobAction.persistanceCodeToEnum(n);
            return ReportHelper.getMissedActionType(missedJobAction);
        }
        catch (Exception exception) {
            return "Unknown - " + n;
        }
    }

    public static String getMissedActionType(MissedJobAction missedJobAction) {
        switch (missedJobAction) {
            case MANAGE: {
                return "Manually manage all missed run times.";
            }
            case RUN_ALL: {
                return "Run all missed run times.";
            }
            case RUN_ONCE_MANAGE_OTHERS: {
                return "Run the first missed run time, manually manage others.";
            }
            case RUN_ONCE_IGNORE_OTHERS: {
                return "Run the first missed run time, Ignore others.";
            }
            case RUN_ONCE_FAIL_OTHERS: {
                return "Run the first missed run time, mark others Failed.";
            }
            case RUN_ONCE_COMPLETE_OTHERS: {
                return "Run the first missed run time, mark others Completed.";
            }
            case IGNORE: {
                return "Ignore all missed run times.";
            }
            case FAIL: {
                return "Mark all missed run times as Failed.";
            }
            case COMPLETE: {
                return "Mark all missed run times as Completed.";
            }
        }
        return null;
    }

    public static String getFormattedTime(int n) {
        if (n == -1) {
            n = 0;
        }
        int n2 = n / 100;
        int n3 = n - n2 * 100;
        return LocalHHMM.formatHHMM(n2, n3);
    }

    public static String getTimedIntervalDisplay(String string) {
        if ("M".equals(string)) {
            return "minutes";
        }
        return "hours";
    }

    public static String getWorkDaysName(String string) {
        CalendarObject.DayType dayType = null;
        try {
            dayType = CalendarObject.DayType.persistanceCodeToEnum(string);
            return ReportHelper.getWorkDaysName(dayType);
        }
        catch (Exception exception) {
            return "Unknown - " + string;
        }
    }

    public static String getDurationOption(int n) {
        switch (n) {
            case 0: {
                return "hours";
            }
            case 1: {
                return "days";
            }
        }
        return "unknown type - " + n;
    }

    public static String getStartingTimeOption(int n) {
        switch (n) {
            case 0: {
                return "generation time";
            }
            case 1: {
                return "specific time";
            }
        }
        return "unknown type - " + n;
    }

    public static String getStartingDateOption(int n) {
        switch (n) {
            case 0: {
                return "today";
            }
            case 1: {
                return "tomorrow";
            }
            case 2: {
                return "specific date";
            }
        }
        return "unknown type - " + n;
    }

    public static String getMonitorOption(int n, int n2) {
        if (n2 == 0) {
            return "Do not monitor";
        }
        switch (n) {
            case 2: {
                if (n2 == 1) {
                    return "Maximum Duration";
                }
                return "Must Complete by";
            }
            case 1: {
                return "Minimum Duration";
            }
            case 3: {
                if (n2 == 1) {
                    return "Later than scheduled by";
                }
                return "Must start by";
            }
        }
        return "Unknown type - " + Integer.toString(n2);
    }

    public static String getDurationTime(int n) {
        if (n < 1) {
            return " ";
        }
        if (n == 1) {
            return "1 Minute";
        }
        if (n < 60) {
            return n + " Minutes";
        }
        int n2 = n / 60;
        if (n2 == 1) {
            return "1 Hour";
        }
        return n2 + " Hours";
    }

    public static <T> T[] arrayMerge(T[] ... TArray) {
        int n = 0;
        Class<?> clazz = null;
        for (T[] TArray2 : TArray) {
            n += TArray2.length;
            if (clazz != null || TArray2.length <= 0) continue;
            clazz = TArray2[0].getClass();
        }
        if (n == 0) {
            return null;
        }
        T[][] TArray3 = (Object[])Array.newInstance(clazz, n);
        int n2 = 0;
        for (T[] TArray4 : TArray) {
            System.arraycopy(TArray4, 0, TArray3, n2, TArray4.length);
            n2 += TArray4.length;
        }
        return (Object[])TArray3;
    }

    public static String getServerHostName() {
        EnterpriseServerAM enterpriseServerAM = (EnterpriseServerAM)ManagerRegistry.getManager((String)"ENTERPRISE.EnterpriseServerAM");
        return enterpriseServerAM.getServerHostName();
    }

    public static String getUnderlinedValue(String string) {
        for (char c : string.toCharArray()) {
            if (!Character.isUpperCase(c)) continue;
            string = string.replaceAll("" + c, "_" + Character.toLowerCase(c));
        }
        return string.substring(1);
    }

    public static String getPureString(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        if (string.startsWith("\"") && string.endsWith("\"")) {
            if (string.length() < 3) {
                return "";
            }
            string2 = string.substring(1, string.length() - 1);
        }
        return string2;
    }

    public static String replace(String string, String string2, String string3) {
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n2 = string.indexOf(string2, n)) >= 0) {
            stringBuffer.append(string.substring(n, n2));
            stringBuffer.append(string3);
            n = n2 + string2.length();
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    public static <T> T[] concatArrays(T[] TArray, T[] TArray2) {
        T[] TArray3 = Arrays.copyOf(TArray, TArray.length + TArray2.length);
        System.arraycopy(TArray2, 0, TArray3, TArray.length, TArray2.length);
        return TArray3;
    }

    public static String formatTimeDuration(long l, long l2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (l != 0L && l2 != 0L) {
            long l3 = (l2 - l) / 1000L;
            long l4 = l3 / 86400L;
            long l5 = l3 % 86400L / 3600L;
            long l6 = l3 % 3600L / 60L;
            long l7 = l3 % 60L;
            String string = ReportHelper.rightJustify(2, Long.toString(l6), "0");
            String string2 = ReportHelper.rightJustify(2, Long.toString(l7), "0");
            String string3 = ReportHelper.rightJustify(2, Long.toString(l5), "0");
            String string4 = "";
            if (l4 == 1L) {
                string4 = l4 + " day ";
            } else if (l4 >= 2L) {
                string4 = l4 + " days ";
            }
            stringBuilder.append(string4);
            stringBuilder.append(string3);
            stringBuilder.append(":");
            stringBuilder.append(string);
            stringBuilder.append(":");
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    public static String rightJustify(int n, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string.length();
        if (n2 < n) {
            for (int i = 0; i < n - n2; ++i) {
                stringBuilder.append(string2);
            }
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }
}

