/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.messages;

import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ExistsAlreadyException;
import com.helpsystems.common.core.access.IAbstractManager;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.NotSavedException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.RelMod;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.EnterpriseSNMPTrapManager;
import com.helpsystems.enterprise.core.busobj.User;
import com.helpsystems.enterprise.core.busobj.traps.EnterpriseSNMPTrap;
import com.helpsystems.enterprise.core.dm.EnterpriseSNMPTrapAM;
import com.helpsystems.enterprise.core.dm.UserDM;
import com.helpsystems.enterprise.core.messages.SystemMessage;
import com.helpsystems.enterprise.core.messages.SystemMessageDM;
import com.helpsystems.enterprise.core.messages.SystemMessageQueue;
import java.sql.Connection;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;
import junit.framework.TestCase;

public class SystemMessageQueueTest
extends TestCase {
    private SystemMessageQueue queue;

    protected void setUp() throws Exception {
        super.setUp();
        this.queue = new SystemMessageQueue();
    }

    protected void tearDown() throws Exception {
        this.queue = null;
        super.tearDown();
    }

    public void testFormatTimeStampCalendar() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        ((Calendar)gregorianCalendar).setTimeZone(TimeZone.getTimeZone("CDT"));
        gregorianCalendar.set(2010, 5, 15, 17, 14, 16);
        String string = SystemMessageQueue.formatTimeStamp(gregorianCalendar);
        String string2 = "2010-06-15 12:14 CDT";
        SystemMessageQueueTest.assertEquals((String)string2, (String)string);
        gregorianCalendar = null;
        SystemMessageQueueTest.assertEquals((String)"", (String)SystemMessageQueue.formatTimeStamp(gregorianCalendar));
    }

    public void testFormatTimeStampLong() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        ((Calendar)gregorianCalendar).setTimeZone(TimeZone.getTimeZone("CDT"));
        gregorianCalendar.set(2010, 5, 15, 17, 14, 16);
        long l = gregorianCalendar.getTimeInMillis();
        String string = SystemMessageQueue.formatTimeStamp(l);
        String string2 = "2010-06-15 12:14 CDT";
        SystemMessageQueueTest.assertEquals((String)string2, (String)string);
    }

    public void testFormatTimeStampDate() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        ((Calendar)gregorianCalendar).setTimeZone(TimeZone.getTimeZone("CDT"));
        gregorianCalendar.set(2010, 5, 15, 17, 14, 16);
        Date date = new Date(gregorianCalendar.getTimeInMillis());
        String string = SystemMessageQueue.formatTimeStamp(date);
        String string2 = "2010-06-15 12:14 CDT";
        SystemMessageQueueTest.assertEquals((String)string2, (String)string);
        date = null;
        SystemMessageQueueTest.assertEquals((String)"", (String)SystemMessageQueue.formatTimeStamp(date));
    }

    public void testMakeMessage() {
        RosettaMsg rosettaMsg = RosettaMsg.AGENT_EVENT_OCCURRED;
        SystemMessage systemMessage = SystemMessageQueue.makeMessage(rosettaMsg);
        SystemMessageQueueTest.assertEquals((Object)((Object)rosettaMsg), (Object)((Object)systemMessage.getMessage()));
    }

    public void testWriteMessage() {
        TestSystemMessageDM testSystemMessageDM = new TestSystemMessageDM();
        testSystemMessageDM.setAllowSave(true);
        ManagerRegistry.registerManager((IAbstractManager)testSystemMessageDM);
        TestEnterpriseSNMPTrapAM testEnterpriseSNMPTrapAM = new TestEnterpriseSNMPTrapAM();
        ManagerRegistry.registerManager((IAbstractManager)testEnterpriseSNMPTrapAM);
        TestUserDM testUserDM = new TestUserDM();
        ManagerRegistry.registerManager((IAbstractManager)testUserDM);
        RosettaMsg rosettaMsg = RosettaMsg.AGENT_EVENT_OCCURRED;
        SystemMessageQueueTest.assertEquals((int)0, (int)testSystemMessageDM.getSaveCount());
        this.queue.write(rosettaMsg);
        SystemMessageQueueTest.assertEquals((int)1, (int)testSystemMessageDM.getSaveCount());
        testSystemMessageDM.setAllowSave(false);
        this.queue.write(rosettaMsg);
        SystemMessageQueueTest.assertEquals((int)1, (int)testSystemMessageDM.getSaveCount());
        testEnterpriseSNMPTrapAM.setTrapCount(0);
        testEnterpriseSNMPTrapAM.setAllowSend(true);
        this.queue.write(rosettaMsg);
        SystemMessageQueueTest.assertEquals((int)1, (int)testEnterpriseSNMPTrapAM.getTrapCount());
        testEnterpriseSNMPTrapAM.setAllowSend(false);
        this.queue.write(rosettaMsg);
        SystemMessageQueueTest.assertEquals((int)1, (int)testEnterpriseSNMPTrapAM.getTrapCount());
    }

    class TestUserDM
    implements UserDM {
        User[] notifyUsers;

        public TestUserDM() {
            User user = new User();
            user.setID(12345L);
            user.setEmailAddress("some_name@some_address.com");
            this.notifyUsers = new User[]{user};
        }

        @Override
        public User get(long l) throws DataException, ResourceUnavailableException {
            return this.notifyUsers[0];
        }

        @Override
        public User get(long l, Connection connection) throws DataException, ResourceUnavailableException {
            return this.notifyUsers[0];
        }

        @Override
        public User getUserByName(String string) throws DataException, ResourceUnavailableException {
            return this.notifyUsers[0];
        }

        @Override
        public User[] getNotifyUsers() throws DataException, ResourceUnavailableException {
            return this.notifyUsers;
        }

        public RelMod getInterfaceVersion() {
            return new RelMod(5, 5);
        }

        public RelMod getManagerVersion() {
            return new RelMod(5, 5);
        }

        public String getName() {
            return "ENTERPRISE.UserDM";
        }

        public void managerRemoved() {
        }

        @Override
        public User getUserByNameOrAdmin(String string) throws DataException, ResourceUnavailableException {
            int n = 1;
            String string2 = "some_name@some_address.com";
            String string3 = "bobofet";
            if (string == null || string.trim().length() < 1) {
                n = 1;
                string2 = "admin@myFiles.com";
                string3 = "admin";
            } else {
                n = 12345;
            }
            User user = new User();
            user.setName(string3);
            user.setID(n);
            user.setEmailAddress(string2);
            return user;
        }
    }

    class TestEnterpriseSNMPTrapAM
    implements EnterpriseSNMPTrapAM {
        boolean allowSend;
        int trapCount;

        TestEnterpriseSNMPTrapAM() {
        }

        public void setTrapCount(int n) {
            this.trapCount = n;
        }

        public int getTrapCount() {
            return this.trapCount;
        }

        public void setAllowSend(boolean bl) {
            this.allowSend = bl;
        }

        public boolean isAllowSend() {
            return this.allowSend;
        }

        @Override
        public void reloadManagers() throws ResourceUnavailableException, ActionFailedException {
        }

        @Override
        public long sendColdStart(EnterpriseSNMPTrapManager enterpriseSNMPTrapManager) throws ResourceUnavailableException, ActionFailedException {
            return 0L;
        }

        @Override
        public void sendSNMPTrap(EnterpriseSNMPTrap enterpriseSNMPTrap) throws ResourceUnavailableException, ActionFailedException {
            if (!this.allowSend) {
                throw new ActionFailedException(enterpriseSNMPTrap.getText());
            }
            ++this.trapCount;
        }

        @Override
        public void sendSNMPTrapNow(EnterpriseSNMPTrap enterpriseSNMPTrap) throws ResourceUnavailableException, ActionFailedException {
            ++this.trapCount;
        }

        public RelMod getInterfaceVersion() {
            return new RelMod(5, 5);
        }

        public RelMod getManagerVersion() {
            return new RelMod(5, 5);
        }

        public String getName() {
            return "ENTERPRISE.EnterpriseSNMPTrapAM";
        }

        public void managerRemoved() {
        }
    }

    class TestSystemMessageDM
    implements SystemMessageDM {
        Set<SystemMessage> savedMessages = new HashSet<SystemMessage>();
        private boolean allowSave;
        private int saveCount;

        TestSystemMessageDM() {
        }

        public void setAllowSave(boolean bl) {
            this.allowSave = bl;
        }

        public boolean isAllowSave() {
            return this.allowSave;
        }

        public int getSaveCount() {
            return this.saveCount;
        }

        public void setSaveCount(int n) {
            this.saveCount = n;
        }

        @Override
        public int purge(int n) throws ResourceUnavailableException {
            this.saveCount = 0;
            return 0;
        }

        @Override
        public void save(SystemMessage systemMessage) throws NotSavedException, ExistsAlreadyException, ResourceUnavailableException {
            if (!this.allowSave) {
                throw new NotSavedException(systemMessage.toString());
            }
            if (this.savedMessages.contains(systemMessage)) {
                throw new ExistsAlreadyException(systemMessage.toString());
            }
            this.savedMessages.add(systemMessage);
            ++this.saveCount;
        }

        public RelMod getInterfaceVersion() {
            return new RelMod(5, 5);
        }

        public RelMod getManagerVersion() {
            return new RelMod(5, 5);
        }

        public String getName() {
            return "ENTERPRISE.SystemMessageDM";
        }

        public void managerRemoved() {
        }
    }
}

