/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.messages;

import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.util.ArrayTokenizer;

public class SystemMessage {
    private long id = 0L;
    private long timestampUTC = System.currentTimeMillis();
    private RosettaMsg message;
    private String[] messageVariables;
    private boolean acknowledged = false;
    private long acknowledgedTimestampUTC = 0L;
    private long acknowledgedByUserID = 0L;

    public SystemMessage() {
    }

    public SystemMessage(RosettaMsg rosettaMsg) {
        this();
        this.message = rosettaMsg;
    }

    public SystemMessage(RosettaMsg rosettaMsg, String string) {
        this();
        this.message = rosettaMsg;
        String[] stringArray = new String[]{string};
        this.messageVariables = stringArray;
    }

    public SystemMessage(RosettaMsg rosettaMsg, String[] stringArray) {
        this();
        this.message = rosettaMsg;
        this.messageVariables = stringArray;
    }

    public RosettaMsg getMessage() {
        return this.message;
    }

    public String getMessageText() {
        return RosettaMsg.getMsgText(this.message, this.messageVariables);
    }

    public void setMessageText(String string) {
        throw new RuntimeException("Setting message text as a Text is not supported!");
    }

    public String getMessageVarsString() {
        return ArrayTokenizer.tokenateArray(this.messageVariables);
    }

    public void setMessageVarsString(String string) {
        throw new RuntimeException("Setting message variables as a String is not supported!");
    }

    public String getMessageID() {
        return this.message.toString();
    }

    public void setMessageID(String string) {
        throw new RuntimeException("Setting message ID is not supported!");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Id->" + this.id);
        stringBuffer.append(" TimestampUTC->" + this.timestampUTC);
        stringBuffer.append(" Msg->");
        if (this.message == null) {
            stringBuffer.append("<null>");
        } else {
            stringBuffer.append(this.message.toString());
        }
        return stringBuffer.toString();
    }

    public long getId() {
        return this.id;
    }

    public void setId(long l) {
        this.id = l;
    }

    public long getTimestampUTC() {
        return this.timestampUTC;
    }

    public void setTimestampUTC(long l) {
        this.timestampUTC = l;
    }

    public boolean isAcknowledged() {
        return this.acknowledged;
    }

    public boolean getAcknowledged() {
        return this.isAcknowledged();
    }

    public void setAcknowledged(boolean bl) {
        this.acknowledged = bl;
    }

    public long getAcknowledgedByUserID() {
        return this.acknowledgedByUserID;
    }

    public void setAcknowledgedByUserID(long l) {
        this.acknowledgedByUserID = l;
    }

    public long getAcknowledgedTimestampUTC() {
        return this.acknowledgedTimestampUTC;
    }

    public void setAcknowledgedTimestampUTC(long l) {
        this.acknowledgedTimestampUTC = l;
    }

    public void setMessage(RosettaMsg rosettaMsg) {
        this.message = rosettaMsg;
    }
}

