/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.ibmi;

public class IBMiAgent {
    private static ConnectionMode connectionMode = ConnectionMode.REMOTE;
    public static final String PROPERTY_PRODLIB = "skybot.iagent.prodlib";
    public static final String PROPERTY_ASPGRP = "skybot.iagent.aspgrp";
    public static final String PROPERTY_ASPDEV = "skybot.iagent.aspdev";
    public static final String PROPERTY_SBSD = "skybot.iagent.sbsd";
    public static final String PROPERTY_SYSLIB = "skybot.iagent.syslib";
    public static final String PROPERTY_DBNAME = "skybot.iagent.database";
    public static final String PROPERTY_IFSPATH = "skybot.iagent.path";
    private static final String TEST_SYSTEM = "CYBRKING";
    private static final String TEST_USER = "SKYAGENT";
    private static final String TEST_PWD = "bF741$xx";
    private static final String TEST_PRODLIB = "ABSKYLIB";

    public static boolean isIBMiOS() {
        String string = System.getProperty("os.name");
        if (string != null) {
            return string.toLowerCase().indexOf("400") > -1;
        }
        return false;
    }

    public static String getPropertyKey(AgentProperty agentProperty) {
        switch (agentProperty) {
            case PRODLIB: {
                return PROPERTY_PRODLIB;
            }
            case ASPGRP: {
                return PROPERTY_ASPGRP;
            }
            case ASPDEV: {
                return PROPERTY_ASPDEV;
            }
            case SBSD: {
                return PROPERTY_SBSD;
            }
            case SYSLIB: {
                return PROPERTY_SYSLIB;
            }
            case DATABASE: {
                return PROPERTY_DBNAME;
            }
            case IFSPATH: {
                return PROPERTY_IFSPATH;
            }
        }
        throw new IllegalStateException("Undefined agent property: " + (Object)((Object)agentProperty));
    }

    public static String getPropertyValue(AgentProperty agentProperty) {
        String string = IBMiAgent.getPropertyKey(agentProperty);
        return System.getProperty(string);
    }

    public static String getProdlib() {
        String string = IBMiAgent.getPropertyValue(AgentProperty.PRODLIB);
        if (string != null && string.trim().length() > 0) {
            return string.trim();
        }
        return TEST_PRODLIB;
    }

    public static String getJDBCDriver() {
        if (connectionMode == ConnectionMode.LOCAL) {
            return "com.ibm.db2.jdbc.app.DB2Driver";
        }
        return "com.ibm.as400.access.AS400JDBCDriver";
    }

    public static String getJDBCConnectionURL(String string) {
        String string2 = ";sort=hex;translate binary=true;prompt=false";
        String string3 = IBMiAgent.getDatabaseName();
        if (string3 != null && string3.trim().length() > 0) {
            string2 = string2 + ";database name=" + string3;
        }
        if (connectionMode == ConnectionMode.LOCAL) {
            return "jdbc:db2:" + string + string2;
        }
        return "jdbc:as400://" + string + string2;
    }

    private static String getDatabaseName() {
        String string = IBMiAgent.getPropertyValue(AgentProperty.DATABASE);
        if (string != null && string.trim().length() > 0) {
            return string.trim();
        }
        String string2 = IBMiAgent.getPropertyValue(AgentProperty.ASPDEV);
        if (string2 != null && string2.trim().length() > 0 && !string2.trim().equalsIgnoreCase("*SYSBAS")) {
            return string2.trim();
        }
        return null;
    }

    public static String getJDBCSystemName() {
        if (connectionMode == ConnectionMode.LOCAL) {
            return "*local";
        }
        return TEST_SYSTEM;
    }

    public static String getJDBCUserName() {
        if (connectionMode == ConnectionMode.LOCAL) {
            return null;
        }
        return TEST_USER;
    }

    public static String getJDBCPassword() {
        if (connectionMode == ConnectionMode.LOCAL) {
            return null;
        }
        return TEST_PWD;
    }

    public static String getAS400SystemName() {
        if (connectionMode == ConnectionMode.LOCAL) {
            return "localhost";
        }
        return TEST_SYSTEM;
    }

    public static String getAS400UserName() {
        if (connectionMode == ConnectionMode.LOCAL) {
            return "*CURRENT";
        }
        return TEST_USER;
    }

    public static String getAS400Password() {
        if (connectionMode == ConnectionMode.LOCAL) {
            return "*CURRENT";
        }
        return TEST_PWD;
    }

    static {
        if (System.getProperty(PROPERTY_PRODLIB) != null) {
            connectionMode = ConnectionMode.LOCAL;
        }
    }

    public static enum AgentProperty {
        PRODLIB,
        ASPGRP,
        ASPDEV,
        SBSD,
        SYSLIB,
        DATABASE,
        IFSPATH;

    }

    public static enum ConnectionMode {
        LOCAL,
        REMOTE;

    }
}

