/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.exec;

import com.helpsystems.common.tl.PeerID;
import com.helpsystems.enterprise.core.busobj.Agent;
import com.helpsystems.enterprise.core.busobj.AgentEnvironment;
import com.helpsystems.enterprise.core.busobj.AgentEventHistoryInfo;
import com.helpsystems.enterprise.core.busobj.EnterpriseVersionedObject;
import com.helpsystems.enterprise.core.busobj.JobCondition;
import com.helpsystems.enterprise.core.busobj.JobHistory;
import com.helpsystems.enterprise.core.busobj.oracle.OracleCommand;
import com.helpsystems.enterprise.core.busobj.oracle.OracleStatusCode;
import com.helpsystems.enterprise.core.scheduler.ScheduleJob;
import java.util.HashMap;
import java.util.Map;

public class ExecutableJob
extends EnterpriseVersionedObject {
    private static final long serialVersionUID = 513464877997821427L;
    private String eventID;
    private String jobUser;
    private ScheduleJob scheduleJob;
    private AgentEnvironment privateAgentEnvironment;
    private AgentEnvironment sharedAgentEnvironment;
    private AgentEventHistoryInfo[] eventHistory = null;
    private Agent agent;
    private PeerID serverPeerID;
    private boolean copyJobLogToServer;
    private long serverRunningTime;
    private long agentStartedTime;
    private JobCondition[] jobConditions;
    private boolean conditional;
    private boolean condRetry;
    private int condRetryDelay;
    private int condRetryCount;
    private int conditionFailStatus;
    private boolean ignoreConditions;
    private JobHistory jobHistory;
    private boolean runImmediately = false;
    private HashMap<Integer, OracleCommand> oracleRequestsHM = new HashMap();
    private boolean includingOutputDistributions;

    public JobCondition[] getJobConditions() {
        return this.jobConditions;
    }

    public void setJobConditions(JobCondition[] jobConditionArray) {
        this.jobConditions = jobConditionArray;
    }

    public boolean isConditional() {
        return this.conditional;
    }

    public void setConditional(boolean bl) {
        this.conditional = bl;
    }

    public boolean isCondRetry() {
        return this.condRetry;
    }

    public void setCondRetry(boolean bl) {
        this.condRetry = bl;
    }

    public int getCondRetryDelay() {
        return this.condRetryDelay;
    }

    public void setCondRetryDelay(int n) {
        this.condRetryDelay = n;
    }

    public int getCondRetryCount() {
        return this.condRetryCount;
    }

    public void setCondRetryCount(int n) {
        this.condRetryCount = n;
    }

    public int getConditionFailStatus() {
        return this.conditionFailStatus;
    }

    public void setConditionFailStatus(int n) {
        this.conditionFailStatus = n;
    }

    public String getEventID() {
        return this.eventID;
    }

    public void setEventID(String string) {
        this.eventID = string;
    }

    public ScheduleJob getScheduleJob() {
        return this.scheduleJob;
    }

    public void setScheduleJob(ScheduleJob scheduleJob) {
        this.scheduleJob = scheduleJob;
    }

    public AgentEnvironment getPrivateAgentEnvironment() {
        return this.privateAgentEnvironment;
    }

    public void setPrivateAgentEnvironment(AgentEnvironment agentEnvironment) {
        this.privateAgentEnvironment = agentEnvironment;
    }

    public AgentEnvironment getSharedAgentEnvironment() {
        return this.sharedAgentEnvironment;
    }

    public void setSharedAgentEnvironment(AgentEnvironment agentEnvironment) {
        this.sharedAgentEnvironment = agentEnvironment;
    }

    public PeerID getServerPeerID() {
        return this.serverPeerID;
    }

    public void setServerPeerID(PeerID peerID) {
        this.serverPeerID = peerID;
    }

    public void setCopyJobLogToServer(boolean bl) {
        this.copyJobLogToServer = bl;
    }

    public boolean getCopyJobLogToServer() {
        return this.copyJobLogToServer;
    }

    public boolean isCopyJobLogToServer() {
        return this.copyJobLogToServer;
    }

    public String getJobUser() {
        if (this.jobUser == null) {
            return "";
        }
        return this.jobUser;
    }

    public void setJobUser(String string) {
        this.jobUser = string == null ? null : string.trim();
    }

    public Agent getAgent() {
        return this.agent;
    }

    public void setAgent(Agent agent) {
        this.agent = agent;
    }

    public void setEventHistory(AgentEventHistoryInfo[] agentEventHistoryInfoArray) {
        this.eventHistory = agentEventHistoryInfoArray;
    }

    public AgentEventHistoryInfo[] getEventHistory() {
        return this.eventHistory;
    }

    public Map<String, String> getEventEnvVars() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (AgentEventHistoryInfo agentEventHistoryInfo : this.eventHistory) {
            hashMap.putAll(agentEventHistoryInfo.getEnvironmentVariables());
        }
        return hashMap;
    }

    public boolean isIgnoreConditions() {
        return this.ignoreConditions;
    }

    public void setIgnoreConditions(boolean bl) {
        this.ignoreConditions = bl;
    }

    public long getServerRunningTime() {
        return this.serverRunningTime;
    }

    public void setServerRunningTime(long l) {
        this.serverRunningTime = l;
    }

    public long getAgentStartedTime() {
        return this.agentStartedTime;
    }

    public void setAgentStartedTime(long l) {
        this.agentStartedTime = l;
    }

    public void setJobHistory(JobHistory jobHistory) {
        this.jobHistory = jobHistory;
    }

    public JobHistory getJobHistory() {
        return this.jobHistory;
    }

    public void setRunImmediately(boolean bl) {
        this.runImmediately = bl;
    }

    public boolean isRunImmediately() {
        return this.runImmediately;
    }

    public HashMap<Integer, OracleCommand> getOracleRequestsHM() {
        return this.oracleRequestsHM;
    }

    public void addOracleRequest(int n, OracleCommand oracleCommand) {
        this.oracleRequestsHM.put(n, oracleCommand);
    }

    public void updateOracleRequest(int n, OracleStatusCode oracleStatusCode) throws Exception {
        if (!this.oracleRequestsHM.containsKey(n)) {
            throw new Exception("RequestID " + n + " does not exist in the HashMap");
        }
        this.oracleRequestsHM.get(n).setStatusCode(oracleStatusCode);
    }

    public boolean isIncludingOutputDistributions() {
        return this.includingOutputDistributions;
    }

    public void setIncludingOutputDistributions(boolean bl) {
        this.includingOutputDistributions = bl;
    }
}

