/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.dm.informatica.axis_override;

import java.net.Socket;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.axis.AxisFault;
import org.apache.axis.AxisProperties;
import org.apache.axis.MessageContext;
import org.apache.axis.components.net.BooleanHolder;
import org.apache.axis.components.net.DefaultSocketFactory;
import org.apache.axis.components.net.SocketFactory;
import org.apache.axis.transport.http.HTTPSender;
import org.apache.axis.transport.http.SocketHolder;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SkybotHttpSender
extends HTTPSender {
    public static final String ENVVAR_OVERRIDE_AXIS_DEFAULTS = "INFO_AXIS_OVERRIDE";
    public static final String ENVVAR_OVERRIDE_AXIS_SOCKET_TIMEOUT = "INFO_AXIS_SOCKET_TIMEOUT";
    public static final String ENVVAR_OVERRIDE_AXIS_CONNECT_TIMEOUT = "INFO_AXIS_CONNECT_TIMEOUT";
    private static final int SECOND = 1000;
    private static final int MINUTE = 60000;
    private static final int HOUR = 3600000;
    protected static final long serialVersionUID = 87698464629847L;
    private static SocketFactory socketFactory = null;
    private static final int defaultSocketTimeout = 14400000;
    private static int socketTimeoutOverride = 0;
    private static int connectTimeoutOverride = 0;

    public static void install() {
        String string;
        String string2 = "com/helpsystems/enterprise/core/dm/informatica/axis_override/skybot-client-config.wsdd";
        System.out.println("Installing Axis Configuration Override File: " + string2);
        AxisProperties.setProperty((String)"axis.ClientConfigFile", (String)string2);
        try {
            System.out.println("Loading wait request socket timeout override from environment variable: INFO_AXIS_SOCKET_TIMEOUT");
            string = System.getenv(ENVVAR_OVERRIDE_AXIS_SOCKET_TIMEOUT);
            if (string != null && string.trim().length() > 0) {
                try {
                    socketTimeoutOverride = Integer.parseInt(string);
                    System.out.println("Axis Socket Timeout override - milliseconds (INFO_AXIS_SOCKET_TIMEOUT): " + socketTimeoutOverride);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("INFO_AXIS_SOCKET_TIMEOUT value is not a valid numeric milliseconds value: " + string);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Error loading socket timeout override.");
            exception.printStackTrace();
        }
        try {
            System.out.println("Loading connect timeout override from environment variable: INFO_AXIS_CONNECT_TIMEOUT");
            string = System.getenv(ENVVAR_OVERRIDE_AXIS_CONNECT_TIMEOUT);
            if (string != null && string.trim().length() > 0) {
                try {
                    connectTimeoutOverride = Integer.parseInt(string);
                    System.out.println("Axis Connect Timeout override - milliseconds (INFO_AXIS_CONNECT_TIMEOUT): " + connectTimeoutOverride);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("INFO_AXIS_CONNECT_TIMEOUT value is not a valid numeric milliseconds value: " + string);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Error loading connect timeout override.");
            exception.printStackTrace();
        }
        socketFactory = new DefaultSocketFactory((Hashtable)SkybotHttpSender.getSocketFactoryProperties());
    }

    public void invoke(MessageContext messageContext) throws AxisFault {
        super.invoke(messageContext);
    }

    protected void getSocket(SocketHolder socketHolder, MessageContext messageContext, String string, String string2, int n, int n2, StringBuffer stringBuffer, BooleanHolder booleanHolder) throws Exception {
        if (socketFactory == null) {
            throw new IllegalStateException("socketFactory is null.  SkybotHttpSender.install() has not configured the environment yet.");
        }
        Socket socket = socketFactory.create(string2, n, stringBuffer, booleanHolder);
        int n3 = n2;
        Node node = SkybotHttpSender.getWaitRequestNode(messageContext.getMessage().getSOAPBody().getParentNode());
        if (node != null) {
            n3 = 14400000;
            if (socketTimeoutOverride > 0) {
                n3 = socketTimeoutOverride;
            }
        }
        socket.setSoTimeout(n3);
        socketHolder.setSocket(socket);
    }

    private static void logNode(Node node, String string) {
        String string2 = string + node.getNodeName();
        System.out.println("  " + string2);
        SkybotHttpSender.logNodeList(node.getChildNodes(), string2);
    }

    private static void logNodeList(NodeList nodeList, String string) {
        if (nodeList == null) {
            return;
        }
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 + 1 <= n) {
            SkybotHttpSender.logNode(nodeList.item(n2), string + ".");
            ++n2;
        }
    }

    private static Node getWaitRequestNode(Node node) {
        if (node == null) {
            return null;
        }
        String string = node.getNodeName();
        if (string != null && node.getNodeName().startsWith("WaitTill")) {
            return node;
        }
        NodeList nodeList = node.getChildNodes();
        if (nodeList == null) {
            return null;
        }
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 + 1 <= n) {
            Node node2 = SkybotHttpSender.getWaitRequestNode(nodeList.item(n2));
            if (node2 != null) {
                return node2;
            }
            ++n2;
        }
        return null;
    }

    protected static Properties getSocketFactoryProperties() {
        Properties properties = new Properties();
        if (connectTimeoutOverride > 0) {
            properties.setProperty(DefaultSocketFactory.CONNECT_TIMEOUT, Integer.toString(connectTimeoutOverride));
        }
        return properties;
    }
}

