/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.dm;

import com.helpsystems.common.core.access.DataSet;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.UserIdentity;
import com.helpsystems.enterprise.core.busobj.Agent;
import com.helpsystems.enterprise.core.busobj.AgentProxy;
import com.helpsystems.enterprise.core.dm.AgentDM;
import com.helpsystems.enterprise.core.dm.AgentEventMonitorDM;
import com.helpsystems.enterprise.core.dm.DMTestCase;
import java.util.HashSet;

public abstract class AgentDMTest
extends DMTestCase {
    private AgentDM agentDM;

    public AgentDMTest(String string) {
        super(string);
    }

    public abstract AgentEventMonitorDM createAgentEventMonitorDM();

    public abstract UserIdentity getUserIdentity();

    public abstract AgentDM createAgentDM();

    public void testGetDataSet() throws Exception {
        this.agentDM = this.createAgentDM();
        try {
            DataSet<AgentProxy> dataSet = this.agentDM.getDataSet(this.getUserIdentity(), null, null);
            AgentDMTest.assertNotNull(dataSet);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            resourceUnavailableException.printStackTrace();
        }
    }

    public void testGet() throws Exception {
        this.agentDM = this.createAgentDM();
        DataSet<AgentProxy> dataSet = this.agentDM.getDataSet(this.getUserIdentity(), null, null);
        if (dataSet.size() == 0) {
            AgentDMTest.fail((String)"There are no Agents...test cannot be performed.");
        }
        for (int i = 0; i < dataSet.size(); ++i) {
            AgentProxy agentProxy = ((AgentProxy[])dataSet.get(i, 1))[0];
            Agent agent = this.agentDM.get(agentProxy.getOid());
            AgentDMTest.assertNotNull((Object)((Object)agent));
        }
    }

    public void testGetByHardwareHash() throws Exception {
        this.agentDM = this.createAgentDM();
        DataSet<AgentProxy> dataSet = this.agentDM.getDataSet(this.getUserIdentity(), null, null);
        if (dataSet.size() == 0) {
            AgentDMTest.fail((String)"There are no Agents...test cannot be performed.");
        }
        Agent[] agentArray = new Agent[dataSet.size()];
        for (int i = 0; i < dataSet.size(); ++i) {
            AgentProxy agentProxy = ((AgentProxy[])dataSet.get(i, 1))[0];
            agentArray[i] = this.agentDM.get(agentProxy.getOid());
        }
        for (int i = 0; i < dataSet.size(); ++i) {
            Agent agent = this.agentDM.getByHardwareHashAndInstanceIdentifier(agentArray[i].getHardwareHash(), agentArray[i].getInstanceIdentifier());
            AgentDMTest.assertEquals((Object)((Object)agentArray[i]), (Object)((Object)agent));
        }
    }

    public void testGetByHardwareHashNotFoundReturnsNull() throws Exception {
        this.agentDM = this.createAgentDM();
        Agent agent = this.agentDM.getByHardwareHashAndInstanceIdentifier("oeunthrcjqrc", "aonetuahuhnta");
        AgentDMTest.assertNull((Object)((Object)agent));
    }

    public void testGetByState() throws Exception {
        int n;
        this.agentDM = this.createAgentDM();
        DataSet<AgentProxy> dataSet = this.agentDM.getDataSet(this.getUserIdentity(), null, null);
        HashSet<Agent> hashSet = new HashSet<Agent>();
        HashSet<Agent> hashSet2 = new HashSet<Agent>();
        HashSet<Agent> hashSet3 = new HashSet<Agent>();
        block5: for (int i = 0; i < dataSet.size(); ++i) {
            AgentProxy agentProxy = ((AgentProxy[])dataSet.get(i, 1))[0];
            Agent agent = this.agentDM.get(agentProxy.getOid());
            AgentDMTest.assertNotNull((Object)((Object)agent));
            switch (agent.getRuntimeState()) {
                case 1: {
                    hashSet.add(agent);
                    continue block5;
                }
                case 2: {
                    hashSet2.add(agent);
                    continue block5;
                }
                case 3: {
                    hashSet3.add(agent);
                    continue block5;
                }
                default: {
                    AgentDMTest.fail((String)"Found an agent with unknown RuntimeState");
                }
            }
        }
        Agent[] agentArray = this.agentDM.getByState(1);
        Agent[] agentArray2 = this.agentDM.getByState(2);
        Agent[] agentArray3 = this.agentDM.getByState(3);
        AgentDMTest.assertEquals((int)agentArray.length, (int)hashSet.size());
        for (n = 0; n < agentArray.length; ++n) {
            AgentDMTest.assertTrue((boolean)hashSet.contains((Object)agentArray[n]));
        }
        AgentDMTest.assertEquals((int)agentArray2.length, (int)hashSet2.size());
        for (n = 0; n < agentArray2.length; ++n) {
            AgentDMTest.assertTrue((boolean)hashSet2.contains((Object)agentArray2[n]));
        }
        AgentDMTest.assertEquals((int)agentArray3.length, (int)hashSet3.size());
        for (n = 0; n < agentArray3.length; ++n) {
            AgentDMTest.assertTrue((boolean)hashSet3.contains((Object)agentArray3[n]));
        }
    }
}

