/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.cmdlineobj;

import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.enterprise.core.cmdlineobj.SendMessageCommand;
import junit.framework.TestCase;

public class SendMessageCommandTest
extends TestCase {
    private SendMessageCommand cmd;

    protected void setUp() throws Exception {
        super.setUp();
        this.cmd = new SendMessageCommand();
    }

    protected void tearDown() throws Exception {
        this.cmd = null;
        super.tearDown();
    }

    public void testConstructor() {
        long l = System.currentTimeMillis();
        this.cmd = new SendMessageCommand(l);
        SendMessageCommandTest.assertEquals((long)l, (long)this.cmd.getRequestTimestamp());
    }

    public void testGetCommandInfo() {
        this.cmd.setMode("SKYBOT");
        this.cmd.setR_parm("R");
        this.cmd.setT_parm("T");
        this.cmd.setC_parm("C");
        this.cmd.setJ_parm("J");
        this.cmd.setS_parm("S");
        String string = "Mode: SKYBOT R-Parm: R T-Parm: T C-Parm: C J-Parm: J S-Parm: S";
        String string2 = this.cmd.getCommandInfo();
        SendMessageCommandTest.assertEquals((String)string, (String)string2);
    }

    public void testGetCommandName() {
        SendMessageCommandTest.assertEquals((String)"SENDMSG", (String)this.cmd.getCommandName());
    }

    public void testValidate() {
        this.cmd = new SendMessageCommand();
        this.cmd.setMode("EMAIL");
        this.cmd.setR_parm("recipient");
        this.cmd.setS_parm("subject");
        this.cmd.setT_parm("text");
        try {
            this.cmd.validate();
        }
        catch (Exception exception) {
            SendMessageCommandTest.fail((String)"validate() failed for valid EMAIL command");
        }
        this.cmd = new SendMessageCommand();
        this.cmd.setMode("SKYBOT");
        this.cmd.setR_parm("job name");
        this.cmd.setJ_parm("job number");
        this.cmd.setC_parm("T");
        try {
            this.cmd.validate();
        }
        catch (Exception exception) {
            SendMessageCommandTest.fail((String)"validate() failed for valid ROBOT command");
        }
        this.cmd = new SendMessageCommand();
        this.cmd.setMode("TRAP");
        this.cmd.setT_parm("text");
        this.cmd.setC_parm("AT");
        try {
            this.cmd.validate();
        }
        catch (Exception exception) {
            SendMessageCommandTest.fail((String)"validate() failed for valid TRAP command");
        }
        this.cmd = new SendMessageCommand();
        this.cmd.setMode("SNDMSG");
        this.cmd.setR_parm("user profile");
        this.cmd.setT_parm("text");
        try {
            this.cmd.validate();
        }
        catch (Exception exception) {
            SendMessageCommandTest.fail((String)"validate() failed for valid SNDMSG command");
        }
    }

    public void testValidateWithoutModeFails() {
        try {
            this.cmd.validate();
        }
        catch (ActionFailedException actionFailedException) {
            // empty catch block
        }
    }

    public void testValidateModeEmailRequiresRST() {
        this.cmd = new SendMessageCommand();
        this.cmd.setMode("EMAIL");
        this.cmd.setR_parm("recipient");
        this.cmd.setS_parm("subject");
        this.cmd.setT_parm("text");
        try {
            this.cmd.setR_parm(null);
            this.cmd.validate();
            SendMessageCommandTest.fail((String)"Allowed EMAIL command without to-recipient (null)");
        }
        catch (ActionFailedException actionFailedException) {
            // empty catch block
        }
        try {
            this.cmd.setR_parm("");
            this.cmd.validate();
            SendMessageCommandTest.fail((String)"Allowed EMAIL command without to-recipient (empty)");
        }
        catch (ActionFailedException actionFailedException) {
            // empty catch block
        }
        try {
            this.cmd.setR_parm("   ");
            this.cmd.validate();
            SendMessageCommandTest.fail((String)"Allowed EMAIL command without to-recipient (blanks)");
        }
        catch (ActionFailedException actionFailedException) {
            // empty catch block
        }
        this.cmd.setR_parm("recipient");
        try {
            this.cmd.setS_parm(null);
            this.cmd.validate();
            SendMessageCommandTest.fail((String)"Allowed EMAIL command without subject (null)");
        }
        catch (ActionFailedException actionFailedException) {
            // empty catch block
        }
        try {
            this.cmd.setS_parm("");
            this.cmd.validate();
            SendMessageCommandTest.fail((String)"Allowed EMAIL command without subject (empty)");
        }
        catch (ActionFailedException actionFailedException) {
            // empty catch block
        }
        try {
            this.cmd.setS_parm("   ");
            this.cmd.validate();
            SendMessageCommandTest.fail((String)"Allowed EMAIL command without subject (blanks)");
        }
        catch (ActionFailedException actionFailedException) {
            // empty catch block
        }
        this.cmd.setS_parm("subject");
        try {
            this.cmd.setT_parm(null);
            this.cmd.validate();
            SendMessageCommandTest.fail((String)"Allowed EMAIL command without message text (null)");
        }
        catch (ActionFailedException actionFailedException) {
            // empty catch block
        }
        try {
            this.cmd.setT_parm("");
            this.cmd.validate();
            SendMessageCommandTest.fail((String)"Allowed EMAIL command without message text (empty)");
        }
        catch (ActionFailedException actionFailedException) {
            // empty catch block
        }
        try {
            this.cmd.setT_parm("   ");
            this.cmd.validate();
            SendMessageCommandTest.fail((String)"Allowed EMAIL command without message text (blanks)");
        }
        catch (ActionFailedException actionFailedException) {
            // empty catch block
        }
    }

    public void testValidateModeRobotRequiresRorJandValidC() {
        this.cmd = new SendMessageCommand();
        this.cmd.setMode("SKYBOT");
        this.cmd.setR_parm("job name");
        this.cmd.setJ_parm("job number");
        this.cmd.setC_parm("completion code");
        try {
            this.cmd.setR_parm(null);
            this.cmd.setJ_parm(null);
            this.cmd.validate();
            SendMessageCommandTest.fail((String)"Allowed ROBOT command without Job Name or Job Number (null)");
        }
        catch (ActionFailedException actionFailedException) {
            // empty catch block
        }
        try {
            this.cmd.setR_parm("");
            this.cmd.setJ_parm("");
            this.cmd.validate();
            SendMessageCommandTest.fail((String)"Allowed ROBOT command without Job Name or Job Number (empty)");
        }
        catch (ActionFailedException actionFailedException) {
            // empty catch block
        }
        try {
            this.cmd.setR_parm("   ");
            this.cmd.setJ_parm("   ");
            this.cmd.validate();
            SendMessageCommandTest.fail((String)"Allowed ROBOT command without Job Name or Job Number (blanks)");
        }
        catch (ActionFailedException actionFailedException) {
            // empty catch block
        }
        this.cmd.setR_parm("job name");
        this.cmd.setJ_parm("job number");
        try {
            this.cmd.setC_parm(null);
            this.cmd.validate();
            SendMessageCommandTest.fail((String)"Allowed ROBOT command without Completion Code (null)");
        }
        catch (ActionFailedException actionFailedException) {
            // empty catch block
        }
        try {
            this.cmd.setC_parm("");
            this.cmd.validate();
            SendMessageCommandTest.fail((String)"Allowed ROBOT command without Completion Code (empty)");
        }
        catch (ActionFailedException actionFailedException) {
            // empty catch block
        }
        try {
            this.cmd.setC_parm("   ");
            this.cmd.validate();
            SendMessageCommandTest.fail((String)"Allowed ROBOT command without Completion Code (blanks)");
        }
        catch (ActionFailedException actionFailedException) {
            // empty catch block
        }
        try {
            this.cmd.setC_parm("!");
            this.cmd.validate();
            SendMessageCommandTest.fail((String)"Allowed ROBOT command with invalid Completion Code");
        }
        catch (RuntimeException runtimeException) {
        }
        catch (Exception exception) {
            SendMessageCommandTest.fail((String)"validate() threw an unexpected exception for invalid Completion Code");
        }
    }

    public void testValidateModeTrapRequiresTandValidC() {
        this.cmd = new SendMessageCommand();
        this.cmd.setMode("TRAP");
        this.cmd.setT_parm("text");
        this.cmd.setC_parm("AT");
        try {
            this.cmd.setT_parm(null);
            this.cmd.validate();
            SendMessageCommandTest.fail((String)"Allowed TRAP command without message text (null)");
        }
        catch (ActionFailedException actionFailedException) {
            // empty catch block
        }
        try {
            this.cmd.setT_parm("");
            this.cmd.validate();
            SendMessageCommandTest.fail((String)"Allowed TRAP command without message text (empty)");
        }
        catch (ActionFailedException actionFailedException) {
            // empty catch block
        }
        try {
            this.cmd.setT_parm("   ");
            this.cmd.validate();
            SendMessageCommandTest.fail((String)"Allowed TRAP command without message text (blanks)");
        }
        catch (ActionFailedException actionFailedException) {
            // empty catch block
        }
        this.cmd.setT_parm("text");
        try {
            this.cmd.setC_parm(null);
            this.cmd.validate();
            SendMessageCommandTest.fail((String)"Allowed TRAP command without severity (null)");
        }
        catch (ActionFailedException actionFailedException) {
            // empty catch block
        }
        try {
            this.cmd.setC_parm("");
            this.cmd.validate();
            SendMessageCommandTest.fail((String)"Allowed TRAP command without severity (empty)");
        }
        catch (ActionFailedException actionFailedException) {
            // empty catch block
        }
        try {
            this.cmd.setC_parm("   ");
            this.cmd.validate();
            SendMessageCommandTest.fail((String)"Allowed TRAP command without severity (blanks)");
        }
        catch (ActionFailedException actionFailedException) {
            // empty catch block
        }
        try {
            this.cmd.setC_parm("BOGUS");
            this.cmd.validate();
            SendMessageCommandTest.fail((String)"Allowed TRAP command with invalid severity");
        }
        catch (RuntimeException runtimeException) {
        }
        catch (Exception exception) {
            SendMessageCommandTest.fail((String)"validate() threw an unexpected exception for invalid severity");
        }
    }

    public void testValidateModeSndmsgRequiresRT() {
        this.cmd = new SendMessageCommand();
        this.cmd.setMode("SNDMSG");
        this.cmd.setR_parm("user profile");
        this.cmd.setT_parm("text");
        try {
            this.cmd.setR_parm(null);
            this.cmd.validate();
            SendMessageCommandTest.fail((String)"Allowed SNDMSG command without user profile (null)");
        }
        catch (ActionFailedException actionFailedException) {
            // empty catch block
        }
        try {
            this.cmd.setR_parm("");
            this.cmd.validate();
            SendMessageCommandTest.fail((String)"Allowed SNDMSG command without user profile (empty)");
        }
        catch (ActionFailedException actionFailedException) {
            // empty catch block
        }
        try {
            this.cmd.setR_parm("   ");
            this.cmd.validate();
            SendMessageCommandTest.fail((String)"Allowed SNDMSG command without user profile (blanks)");
        }
        catch (ActionFailedException actionFailedException) {
            // empty catch block
        }
        this.cmd.setR_parm("user profile");
        try {
            this.cmd.setT_parm(null);
            this.cmd.validate();
            SendMessageCommandTest.fail((String)"Allowed SNDMSG command without message text (null)");
        }
        catch (ActionFailedException actionFailedException) {
            // empty catch block
        }
        try {
            this.cmd.setT_parm("");
            this.cmd.validate();
            SendMessageCommandTest.fail((String)"Allowed SNDMSG command without message text (empty)");
        }
        catch (ActionFailedException actionFailedException) {
            // empty catch block
        }
        try {
            this.cmd.setT_parm("   ");
            this.cmd.validate();
            SendMessageCommandTest.fail((String)"Allowed SNDMSG command without message text (blanks)");
        }
        catch (ActionFailedException actionFailedException) {
            // empty catch block
        }
    }

    public void testParseParameters() throws Exception {
        this.cmd.parseParameters(new String[]{"-m", "EMAIL", "-r", "R", "-t", "T", "-c", "C", "-j", "J", "-s", "S"});
        SendMessageCommandTest.assertEquals((String)"EMAIL", (String)this.cmd.getMode());
        SendMessageCommandTest.assertEquals((String)"R", (String)this.cmd.getR_parm());
        SendMessageCommandTest.assertEquals((String)"T", (String)this.cmd.getT_parm());
        SendMessageCommandTest.assertEquals((String)"C", (String)this.cmd.getC_parm());
        SendMessageCommandTest.assertEquals((String)"J", (String)this.cmd.getJ_parm());
        SendMessageCommandTest.assertEquals((String)"S", (String)this.cmd.getS_parm());
    }

    public void testParseRequiresValueForEachParameter() {
        try {
            this.cmd.parseParameters(new String[]{"-m"});
            SendMessageCommandTest.fail((String)"parseParameters() allowed parameter without value");
        }
        catch (ActionFailedException actionFailedException) {
            // empty catch block
        }
    }

    public void testParseRequiresValidOptionParameters() {
        try {
            this.cmd.parseParameters(new String[]{"-z", "Z"});
            SendMessageCommandTest.fail((String)"parseParameters() allowed invalid option parameter");
        }
        catch (ActionFailedException actionFailedException) {
            // empty catch block
        }
    }

    public void testParseRequiresValidModeIfSet() {
        try {
            this.cmd.parseParameters(new String[]{"-m", "BOGUS_MODE"});
            SendMessageCommandTest.fail((String)"parseParameters() allowed invalid value for mode");
        }
        catch (ActionFailedException actionFailedException) {
            // empty catch block
        }
    }

    public void testSetMode() {
        this.cmd.setMode("EMAIL");
        SendMessageCommandTest.assertEquals((String)"EMAIL", (String)this.cmd.getMode());
        this.cmd.setMode("SKYBOT");
        SendMessageCommandTest.assertEquals((String)"SKYBOT", (String)this.cmd.getMode());
        this.cmd.setMode("TRAP");
        SendMessageCommandTest.assertEquals((String)"TRAP", (String)this.cmd.getMode());
        this.cmd.setMode("SNDMSG");
        SendMessageCommandTest.assertEquals((String)"SNDMSG", (String)this.cmd.getMode());
        try {
            this.cmd.setMode(null);
            SendMessageCommandTest.fail((String)"setMode() allowed null value");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.cmd.setMode("BOGUS_MODE");
            SendMessageCommandTest.fail((String)"setMode() allowed bogus value");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSetR_parm() {
        this.cmd.setR_parm("some_value");
        SendMessageCommandTest.assertEquals((String)"some_value", (String)this.cmd.getR_parm());
    }

    public void testSetT_parm() {
        this.cmd.setT_parm("some_value");
        SendMessageCommandTest.assertEquals((String)"some_value", (String)this.cmd.getT_parm());
    }

    public void testSetC_parm() {
        this.cmd.setC_parm("some_value");
        SendMessageCommandTest.assertEquals((String)"some_value", (String)this.cmd.getC_parm());
    }

    public void testSetJ_parm() {
        this.cmd.setJ_parm("some_value");
        SendMessageCommandTest.assertEquals((String)"some_value", (String)this.cmd.getJ_parm());
    }

    public void testSetS_parm() {
        this.cmd.setS_parm("some_value");
        SendMessageCommandTest.assertEquals((String)"some_value", (String)this.cmd.getS_parm());
    }
}

