/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.cmdlineobj;

import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.enterprise.core.busobj.informatica.ConsoleLogger;
import com.helpsystems.enterprise.core.busobj.informatica.InformaticaRepository;
import com.helpsystems.enterprise.core.busobj.informatica.InformaticaWorkflowCommand;
import com.helpsystems.enterprise.core.busobj.informatica.SkybotParam;
import com.helpsystems.enterprise.core.busobj.informatica.dataintegration.ETaskRunMode;
import com.helpsystems.enterprise.core.busobj.informatica.dataintegration.Parameter;
import com.helpsystems.enterprise.core.cmdlineobj.InfaCmdParamMarker;
import com.helpsystems.enterprise.core.scheduler.AbstractBusinessObject;
import java.util.ArrayList;
import java.util.HashSet;

public class InformaticaDetails
extends AbstractBusinessObject {
    private static final long serialVersionUID = -3657904517276259795L;
    public static String COMMAND_NAME = "INFA";
    private InformaticaRepository repo;
    private InformaticaWorkflowCommand wfCmd;
    private SkybotParam skybotParam;

    public void parseParameters(String[] stringArray) throws ActionFailedException {
        String string = null;
        String string2 = null;
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        this.repo = new InformaticaRepository();
        this.wfCmd = new InformaticaWorkflowCommand();
        this.skybotParam = new SkybotParam();
        HashSet<String> hashSet = InfaCmdParamMarker.getEnumValueSet();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] stringArray2;
            ConsoleLogger.printlnDebug("Processing Parameter: " + stringArray[i]);
            if (stringArray[i].equals(InfaCmdParamMarker.PARAM.persistanceCode())) {
                stringArray2 = new Parameter();
                String string3 = stringArray[i + 1];
                String string4 = stringArray[i + 2];
                String string5 = stringArray[i + 3];
                if (!hashSet.contains(string3)) {
                    stringArray2.setName(string3);
                } else {
                    stringArray2.setName("");
                }
                if (!hashSet.contains(string4)) {
                    stringArray2.setValue(string4);
                } else {
                    stringArray2.setValue("");
                }
                if (!hashSet.contains(string5)) {
                    stringArray2.setScope(string5);
                } else {
                    stringArray2.setScope("");
                }
                arrayList.add((Parameter)stringArray2);
                continue;
            }
            stringArray2 = stringArray[i].split(":");
            int n2 = stringArray2.length;
            if (n2 > 0) {
                string = stringArray2[0].trim();
            }
            if (n2 == 2) {
                string2 = stringArray2[1];
            } else if (n2 > 2) {
                int n3 = stringArray2[0].length();
                string2 = stringArray[i].substring(n3 + 1);
            } else {
                string2 = null;
            }
            try {
                if (!hashSet.contains(string)) continue;
                InfaCmdParamMarker infaCmdParamMarker = InfaCmdParamMarker.persistanceCodeToEnum(string);
                switch (infaCmdParamMarker) {
                    case DOMAIN: {
                        this.repo.setDomain(string2);
                        break;
                    }
                    case PORT: {
                        this.repo.setPort(Integer.parseInt(string2));
                        break;
                    }
                    case SYSTEM_NAME: {
                        this.repo.setSystemName(string2);
                        break;
                    }
                    case USERNAME: {
                        this.repo.setInfaUserName(string2);
                        break;
                    }
                    case PASSWORD: {
                        this.repo.setEncryptedPassword(string2);
                        break;
                    }
                    case PASSWORD_SALT: {
                        this.repo.setPasswordSalt(string2);
                        break;
                    }
                    case SECURITY_DOMAIN: {
                        this.repo.setSecurityDomain(string2);
                        break;
                    }
                    case REPO_NAME: {
                        this.repo.setRepoName(string2);
                        break;
                    }
                    case USE_HTTPS: {
                        if (!string2.equalsIgnoreCase("yes")) break;
                        this.repo.setUseHTTPS(true);
                        break;
                    }
                    case INT_SVC_NAME: {
                        this.wfCmd.setIntegrationSvcName(string2);
                        break;
                    }
                    case FOLDER_NAME: {
                        this.wfCmd.setFolderName(string2);
                        break;
                    }
                    case WF_NAME: {
                        this.wfCmd.setWorkflowName(string2);
                        break;
                    }
                    case RUN_INSTANCE_NAME: {
                        this.wfCmd.setRunInstanceName(string2);
                        break;
                    }
                    case TASK_INSTANCE_PATH: {
                        this.wfCmd.setTaskInstancePath(string2);
                        break;
                    }
                    case RUN_ONLY: {
                        if (!string2.equalsIgnoreCase("yes")) break;
                        this.wfCmd.setRunTask(true);
                        break;
                    }
                    case OS_USER: {
                        this.wfCmd.setOsUser(string2);
                        break;
                    }
                    case PARAM_FILE: {
                        this.wfCmd.setParameterFile(string2);
                        break;
                    }
                    case ABORT: {
                        if (!string2.equalsIgnoreCase("yes")) break;
                        this.wfCmd.setAbort(true);
                        break;
                    }
                    case RETRIEVE_LOG: {
                        if (!string2.equalsIgnoreCase("yes")) break;
                        this.wfCmd.setRetrieveLog(true);
                        break;
                    }
                    case REQUEST_MODE: {
                        if (string2.equals(ETaskRunMode.RECOVERY.toString())) {
                            this.wfCmd.setRequestMode(ETaskRunMode.RECOVERY);
                            break;
                        }
                        if (string2.equals(ETaskRunMode.NORMAL.toString())) break;
                        throw new RuntimeException("Error parsing request mode from parameter: " + string2);
                    }
                    case JOB_NUMBER: {
                        this.skybotParam.setSkybotJobNumber(Long.parseLong(string2));
                        break;
                    }
                    case JOB_NAME: {
                        this.skybotParam.setSkybotJobName(string2);
                        break;
                    }
                    default: {
                        throw new ActionFailedException("Invalid option parameter: " + string + " full parm: " + stringArray[i]);
                    }
                }
                this.wfCmd.setParameterList(arrayList);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ActionFailedException(illegalArgumentException.getMessage(), (Throwable)illegalArgumentException);
            }
        }
    }

    protected String getCommandInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.repo.toString());
        stringBuilder.append(this.wfCmd.toString());
        stringBuilder.append(this.skybotParam.toString());
        return stringBuilder.toString();
    }

    public InformaticaRepository getRepo() {
        return this.repo;
    }

    public void setRepo(InformaticaRepository informaticaRepository) {
        this.repo = informaticaRepository;
    }

    public InformaticaWorkflowCommand getWfCmd() {
        return this.wfCmd;
    }

    public void setWfCmd(InformaticaWorkflowCommand informaticaWorkflowCommand) {
        this.wfCmd = informaticaWorkflowCommand;
    }

    public SkybotParam getSkybotParam() {
        return this.skybotParam;
    }

    public void setSkybotParam(SkybotParam skybotParam) {
        this.skybotParam = skybotParam;
    }

    public static enum ParameterMarker {

    }
}

