/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.cmdlineobj;

import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.enterprise.core.cmdlineobj.GetActivityCommand;
import junit.framework.TestCase;

public class GetActivityCommandTest
extends TestCase {
    private GetActivityCommand cmd;

    protected void setUp() throws Exception {
        super.setUp();
        this.cmd = new GetActivityCommand();
    }

    protected void tearDown() throws Exception {
        this.cmd = null;
        super.tearDown();
    }

    public void testGetCommandName() {
        GetActivityCommandTest.assertEquals((String)"GETACTIVITY", (String)this.cmd.getCommandName());
    }

    public void testIsJobListRequested() {
        this.cmd.setJobListRequested(false);
        GetActivityCommandTest.assertFalse((boolean)this.cmd.isJobListRequested());
        this.cmd.setJobListRequested(true);
        GetActivityCommandTest.assertTrue((boolean)this.cmd.isJobListRequested());
    }

    public void testIsEventListRequested() {
        this.cmd.setEventListRequested(false);
        GetActivityCommandTest.assertFalse((boolean)this.cmd.isEventListRequested());
        this.cmd.setEventListRequested(true);
        GetActivityCommandTest.assertTrue((boolean)this.cmd.isEventListRequested());
    }

    public void testIsFileTransfersRequested() {
        this.cmd.setFileTransfersRequested(false);
        GetActivityCommandTest.assertFalse((boolean)this.cmd.isFileTransfersRequested());
        this.cmd.setFileTransfersRequested(true);
        GetActivityCommandTest.assertTrue((boolean)this.cmd.isFileTransfersRequested());
    }

    public void testValidateAlwaysPasses() throws Exception {
        this.cmd.validate();
    }

    public void testParseParametersRecognizesValidParameters() throws Exception {
        String[] stringArray = new String[]{"-m", "-t", "-j"};
        this.cmd.parseParameters(stringArray);
        GetActivityCommandTest.assertTrue((boolean)this.cmd.isEventListRequested());
        GetActivityCommandTest.assertTrue((boolean)this.cmd.isFileTransfersRequested());
        GetActivityCommandTest.assertTrue((boolean)this.cmd.isJobListRequested());
    }

    public void testParseParametersTreatsNoParmsAsGiveMeEverything() throws Exception {
        this.cmd.parseParameters(new String[0]);
        GetActivityCommandTest.assertTrue((boolean)this.cmd.isEventListRequested());
        GetActivityCommandTest.assertTrue((boolean)this.cmd.isFileTransfersRequested());
        GetActivityCommandTest.assertTrue((boolean)this.cmd.isJobListRequested());
    }

    public void testParseParametersEventListOnly() throws Exception {
        this.cmd.parseParameters(new String[]{"-m"});
        GetActivityCommandTest.assertTrue((boolean)this.cmd.isEventListRequested());
        GetActivityCommandTest.assertFalse((boolean)this.cmd.isFileTransfersRequested());
        GetActivityCommandTest.assertFalse((boolean)this.cmd.isJobListRequested());
    }

    public void testParseParametersFileTransfersOnly() throws Exception {
        this.cmd.parseParameters(new String[]{"-t"});
        GetActivityCommandTest.assertFalse((boolean)this.cmd.isEventListRequested());
        GetActivityCommandTest.assertTrue((boolean)this.cmd.isFileTransfersRequested());
        GetActivityCommandTest.assertFalse((boolean)this.cmd.isJobListRequested());
    }

    public void testParseParametersOKWithRepeats() throws Exception {
        this.cmd.parseParameters(new String[]{"-m", "-j", "-m"});
        GetActivityCommandTest.assertTrue((boolean)this.cmd.isEventListRequested());
        GetActivityCommandTest.assertFalse((boolean)this.cmd.isFileTransfersRequested());
        GetActivityCommandTest.assertTrue((boolean)this.cmd.isJobListRequested());
    }

    public void testParseParametersHandlesBogusFlag() throws Exception {
        String[] stringArray = new String[]{"-t", "-q"};
        try {
            this.cmd.parseParameters(stringArray);
            GetActivityCommandTest.fail((String)"parseParameters didn't spot bogus flag -q");
        }
        catch (ActionFailedException actionFailedException) {
            // empty catch block
        }
    }

    public void testGetLogDescriptionHasTheGoods() throws Exception {
        String[] stringArray = new String[]{"-m", "-t", "-j"};
        this.cmd.parseParameters(stringArray);
        String string = this.cmd.getLogDescription();
        GetActivityCommandTest.assertEquals((String)string, (String)this.cmd.toString());
    }

    public void testNothingMeansEverything() throws Exception {
        String string = this.cmd.getLogDescription();
        GetActivityCommandTest.assertEquals((String)string, (String)this.cmd.toString());
    }
}

