/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj.traps;

import com.helpsystems.common.core.util.Equal;
import com.helpsystems.enterprise.core.busobj.traps.EnterpriseSNMPTrap;

public class SAPEventSNMPTrap
extends EnterpriseSNMPTrap {
    private long eventID;
    private String eventName;
    private String serverName;
    private String eventData;
    private static final int EVENT_DATA_MAX_LENGTH = 64;

    public SAPEventSNMPTrap() {
        this.setSeverity("IN");
        this.setType(34);
    }

    public String getEventName() {
        return this.eventName;
    }

    public long getEventID() {
        return this.eventID;
    }

    public String getEventData() {
        return this.eventData;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setEventName(String string) {
        if (string != null) {
            this.eventName = string;
            this.addVariableBinding("1.3.6.1.4.1.6872.2.1.1.11", string);
        } else {
            this.addVariableBinding("1.3.6.1.4.1.6872.2.1.1.11", " ");
        }
    }

    public void setServerName(String string) {
        if (string != null && string.trim().length() > 0) {
            this.serverName = string;
            this.addVariableBinding("1.3.6.1.4.1.6872.2.1.1.16", string);
        } else {
            this.addVariableBinding("1.3.6.1.4.1.6872.2.1.1.16", " ");
        }
    }

    public void setEventID(long l) {
        this.eventID = l;
        this.addVariableBinding("1.3.6.1.4.1.6872.2.1.1.10", Long.toString(l));
    }

    public void setEventData(String string) {
        if (string != null) {
            this.eventData = string.length() <= 64 ? string : string.substring(0, 64);
            this.addVariableBinding("1.3.6.1.4.1.6872.2.1.1.12", string);
        } else {
            this.addVariableBinding("1.3.6.1.4.1.6872.2.1.1.12", " ");
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof EnterpriseSNMPTrap)) {
            return false;
        }
        SAPEventSNMPTrap sAPEventSNMPTrap = (SAPEventSNMPTrap)((Object)object);
        return super.equals(object) && Equal.isEqual((long)this.eventID, (long)sAPEventSNMPTrap.eventID) && Equal.isEqual((Object)this.eventName, (Object)sAPEventSNMPTrap.eventName) && Equal.isEqual((Object)this.eventData, (Object)sAPEventSNMPTrap.eventData) && Equal.isEqual((Object)this.serverName, (Object)sAPEventSNMPTrap.serverName);
    }
}

