/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj.traps;

import com.helpsystems.common.core.util.Equal;
import com.helpsystems.enterprise.core.busobj.traps.EnterpriseSNMPTrap;
import com.helpsystems.enterprise.core.scheduler.JobSuiteStatus;

public class JobSuitesStatusSNMPTrap
extends EnterpriseSNMPTrap {
    private String jobSuiteName;
    private long jobSuiteID;
    private long suiteRunID;
    private String jobName;
    private long jobID;
    private long runID;
    private String agentName;
    private long agentID;

    public JobSuitesStatusSNMPTrap(JobSuiteStatus jobSuiteStatus) {
        if (jobSuiteStatus.equals(JobSuiteStatus.RUNNING)) {
            this.setType(28);
            this.setSeverity("IN");
            return;
        }
        if (jobSuiteStatus.equals(JobSuiteStatus.COMPLETED)) {
            this.setType(29);
            this.setSeverity("IN");
        }
        if (jobSuiteStatus.equals(JobSuiteStatus.MEMBER_CANCELED)) {
            this.setType(26);
            this.setSeverity("WR");
        }
        if (jobSuiteStatus.equals(JobSuiteStatus.MEMBER_FAILED)) {
            this.setType(27);
            this.setSeverity("AT");
        }
        if (jobSuiteStatus.equals(JobSuiteStatus.SKIPPED)) {
            this.setType(30);
            this.setSeverity("IN");
        }
    }

    public String getJobSuiteName() {
        return this.jobSuiteName;
    }

    public void setJobSuiteName(String string) {
        if (string != null) {
            this.jobSuiteName = string;
            this.addVariableBinding("1.3.6.1.4.1.6872.2.1.1.17", string);
        } else {
            this.addVariableBinding("1.3.6.1.4.1.6872.2.1.1.17", " ");
        }
    }

    public long getJobSuiteID() {
        return this.jobSuiteID;
    }

    public void setJobSuiteID(long l) {
        this.jobSuiteID = l;
        this.addVariableBinding("1.3.6.1.4.1.6872.2.1.1.18", Long.toString(l));
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String string) {
        if (string != null) {
            this.jobName = string;
            this.addVariableBinding("1.3.6.1.4.1.6872.2.1.1.4", string);
        } else {
            this.addVariableBinding("1.3.6.1.4.1.6872.2.1.1.4", " ");
        }
    }

    public long getJobID() {
        return this.jobID;
    }

    public void setJobID(long l) {
        this.jobID = l;
        this.addVariableBinding("1.3.6.1.4.1.6872.2.1.1.3", Long.toString(l));
    }

    public long getRunID() {
        return this.runID;
    }

    public void setRunID(long l) {
        this.runID = l;
        this.addVariableBinding("1.3.6.1.4.1.6872.2.1.1.14", Long.toString(l));
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof EnterpriseSNMPTrap)) {
            return false;
        }
        JobSuitesStatusSNMPTrap jobSuitesStatusSNMPTrap = (JobSuitesStatusSNMPTrap)((Object)object);
        return super.equals(object) && Equal.isEqual((Object)this.jobName, (Object)jobSuitesStatusSNMPTrap.jobName) && Equal.isEqual((long)this.jobID, (long)jobSuitesStatusSNMPTrap.jobID) && Equal.isEqual((Object)this.jobSuiteName, (Object)jobSuitesStatusSNMPTrap.jobSuiteName) && Equal.isEqual((long)this.jobSuiteID, (long)jobSuitesStatusSNMPTrap.jobSuiteID) && Equal.isEqual((long)this.runID, (long)jobSuitesStatusSNMPTrap.runID);
    }

    public String getAgentName() {
        return this.agentName;
    }

    public void setAgentName(String string) {
        if (string != null) {
            this.agentName = string;
            this.addVariableBinding("1.3.6.1.4.1.6872.2.1.1.2", string);
        } else {
            this.addVariableBinding("1.3.6.1.4.1.6872.2.1.1.2", " ");
        }
    }

    public long getSuiteRunID() {
        return this.suiteRunID;
    }

    public void setSuiteRunID(long l) {
        this.suiteRunID = l;
        this.addVariableBinding("1.3.6.1.4.1.6872.2.1.1.15", Long.toString(l));
    }

    public long getAgentID() {
        return this.agentID;
    }

    public void setAgentID(long l) {
        this.agentID = l;
        this.addVariableBinding("1.3.6.1.4.1.6872.2.1.1.1", Long.toString(l));
    }
}

