/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj.traps;

import com.helpsystems.enterprise.core.busobj.JobStatusCode;
import com.helpsystems.enterprise.core.busobj.traps.JobStatusSNMPTrap;
import java.sql.Timestamp;
import junit.framework.TestCase;

public class JobStatusSNMPTrapTest
extends TestCase {
    public static final String VB_ID_SKYBOT_SCHEDULER = "1.3.6.1.4.1.6872.2.1.1";
    protected static final String VB_ID_AGENT_ID = "1.3.6.1.4.1.6872.2.1.1.1";
    protected static final String VB_ID_AGENT_NAME = "1.3.6.1.4.1.6872.2.1.1.2";
    protected static final String VB_ID_JOB_ID = "1.3.6.1.4.1.6872.2.1.1.3";
    protected static final String VB_ID_JOB_NAME = "1.3.6.1.4.1.6872.2.1.1.4";
    protected static final String VB_ID_DATE = "1.3.6.1.4.1.6872.2.1.1.5";
    protected static final String VB_ID_TIME = "1.3.6.1.4.1.6872.2.1.1.6";
    protected static final String VB_ID_TEXT = "1.3.6.1.4.1.6872.2.1.1.7";
    protected static final String VB_ID_END_CODE = "1.3.6.1.4.1.6872.2.1.1.8";
    protected static final String VB_ID_SEVERITY = "1.3.6.1.4.1.6872.2.1.1.9";
    protected static final String VB_ID_EVENT_ID = "1.3.6.1.4.1.6872.2.1.1.10";
    protected static final String VB_ID_EVENT_NAME = "1.3.6.1.4.1.6872.2.1.1.11";
    protected static final String VB_ID_EVENT_DATA = "1.3.6.1.4.1.6872.2.1.1.12";
    protected static final String VB_ID_EVENT_TYPE = "1.3.6.1.4.1.6872.2.1.1.13";
    protected static final String VB_ID_RUN_ID = "1.3.6.1.4.1.6872.2.1.1.14";
    protected static final String EMPTY_VALUE = " ";
    private JobStatusSNMPTrap trap;

    protected void setUp() throws Exception {
        super.setUp();
        this.trap = new JobStatusSNMPTrap(JobStatusCode.SUBMITTED);
    }

    protected void tearDown() throws Exception {
        this.trap = null;
        super.tearDown();
    }

    public void testConstructorHandlesAllValidJobStatusCodes() {
        JobStatusSNMPTrap jobStatusSNMPTrap = null;
        jobStatusSNMPTrap = new JobStatusSNMPTrap(JobStatusCode.SUBMITTED);
        JobStatusSNMPTrapTest.assertEquals((int)3, (int)jobStatusSNMPTrap.getType());
        JobStatusSNMPTrapTest.assertEquals((String)"IN", (String)jobStatusSNMPTrap.getSeverity());
        jobStatusSNMPTrap = new JobStatusSNMPTrap(JobStatusCode.RUNNING);
        JobStatusSNMPTrapTest.assertEquals((int)4, (int)jobStatusSNMPTrap.getType());
        JobStatusSNMPTrapTest.assertEquals((String)"IN", (String)jobStatusSNMPTrap.getSeverity());
        jobStatusSNMPTrap = new JobStatusSNMPTrap(JobStatusCode.COMPLETED);
        JobStatusSNMPTrapTest.assertEquals((int)5, (int)jobStatusSNMPTrap.getType());
        JobStatusSNMPTrapTest.assertEquals((String)"IN", (String)jobStatusSNMPTrap.getSeverity());
        jobStatusSNMPTrap = new JobStatusSNMPTrap(JobStatusCode.ERROR);
        JobStatusSNMPTrapTest.assertEquals((int)6, (int)jobStatusSNMPTrap.getType());
        JobStatusSNMPTrapTest.assertEquals((String)"AT", (String)jobStatusSNMPTrap.getSeverity());
        jobStatusSNMPTrap = new JobStatusSNMPTrap(JobStatusCode.FAILED);
        JobStatusSNMPTrapTest.assertEquals((int)6, (int)jobStatusSNMPTrap.getType());
        JobStatusSNMPTrapTest.assertEquals((String)"AT", (String)jobStatusSNMPTrap.getSeverity());
        jobStatusSNMPTrap = new JobStatusSNMPTrap(JobStatusCode.CANCELED);
        JobStatusSNMPTrapTest.assertEquals((int)7, (int)jobStatusSNMPTrap.getType());
        JobStatusSNMPTrapTest.assertEquals((String)"WR", (String)jobStatusSNMPTrap.getSeverity());
    }

    public void testGetAgentName() {
        this.trap.setAgentName("agent_name");
        JobStatusSNMPTrapTest.assertEquals((String)"agent_name", (String)this.trap.getAgentName());
        JobStatusSNMPTrapTest.assertEquals((String)"agent_name", (String)this.trap.getVariableBinding(VB_ID_AGENT_NAME));
        this.trap.setAgentName(null);
        JobStatusSNMPTrapTest.assertEquals((String)"agent_name", (String)this.trap.getAgentName());
        JobStatusSNMPTrapTest.assertEquals((String)EMPTY_VALUE, (String)this.trap.getVariableBinding(VB_ID_AGENT_NAME));
    }

    public void testGetAgentID() {
        this.trap.setAgentID(23456L);
        JobStatusSNMPTrapTest.assertEquals((long)23456L, (long)this.trap.getAgentID());
        JobStatusSNMPTrapTest.assertEquals((String)"23456", (String)this.trap.getVariableBinding(VB_ID_AGENT_ID));
        this.trap.setAgentID(0L);
        JobStatusSNMPTrapTest.assertEquals((long)0L, (long)this.trap.getAgentID());
        JobStatusSNMPTrapTest.assertEquals((String)"0", (String)this.trap.getVariableBinding(VB_ID_AGENT_ID));
    }

    public void testGetJobName() {
        this.trap.setJobName("job_name");
        JobStatusSNMPTrapTest.assertEquals((String)"job_name", (String)this.trap.getJobName());
        JobStatusSNMPTrapTest.assertEquals((String)"job_name", (String)this.trap.getVariableBinding(VB_ID_JOB_NAME));
        this.trap.setJobName(null);
        JobStatusSNMPTrapTest.assertEquals((String)"job_name", (String)this.trap.getJobName());
        JobStatusSNMPTrapTest.assertEquals((String)EMPTY_VALUE, (String)this.trap.getVariableBinding(VB_ID_JOB_NAME));
    }

    public void testGetJobID() {
        this.trap.setJobID(56789L);
        JobStatusSNMPTrapTest.assertEquals((long)56789L, (long)this.trap.getJobID());
        JobStatusSNMPTrapTest.assertEquals((String)"56789", (String)this.trap.getVariableBinding(VB_ID_JOB_ID));
        this.trap.setJobID(0L);
        JobStatusSNMPTrapTest.assertEquals((long)0L, (long)this.trap.getJobID());
        JobStatusSNMPTrapTest.assertEquals((String)"0", (String)this.trap.getVariableBinding(VB_ID_JOB_ID));
    }

    public void testGetRunID() {
        this.trap.setRunID(2345L);
        JobStatusSNMPTrapTest.assertEquals((long)2345L, (long)this.trap.getRunID());
        JobStatusSNMPTrapTest.assertEquals((String)"2345", (String)this.trap.getVariableBinding(VB_ID_RUN_ID));
        this.trap.setRunID(0L);
        JobStatusSNMPTrapTest.assertEquals((long)0L, (long)this.trap.getRunID());
        JobStatusSNMPTrapTest.assertEquals((String)"0", (String)this.trap.getVariableBinding(VB_ID_RUN_ID));
    }

    public void testEqualsObject() {
        this.trap.setAgentName("agent_name");
        this.trap.setAgentID(23456L);
        this.trap.setJobName("job_name");
        this.trap.setJobID(56789L);
        this.trap.setRunID(2345L);
        JobStatusSNMPTrapTest.assertTrue((boolean)this.trap.equals((Object)this.trap));
        JobStatusSNMPTrapTest.assertFalse((boolean)this.trap.equals(null));
        JobStatusSNMPTrapTest.assertFalse((boolean)this.trap.equals(new Object()));
        JobStatusSNMPTrap jobStatusSNMPTrap = new JobStatusSNMPTrap(JobStatusCode.SUBMITTED);
        jobStatusSNMPTrap.setAgentName("agent_name");
        jobStatusSNMPTrap.setAgentID(23456L);
        jobStatusSNMPTrap.setJobName("job_name");
        jobStatusSNMPTrap.setJobID(56789L);
        jobStatusSNMPTrap.setRunID(2345L);
        Timestamp timestamp = Timestamp.valueOf("2009-01-02 03:04:05.123456789");
        this.trap.setType(10);
        this.trap.setServerDateTime(timestamp);
        this.trap.setSeverity("IN");
        this.trap.setText("text");
        jobStatusSNMPTrap.setType(10);
        jobStatusSNMPTrap.setServerDateTime(timestamp);
        jobStatusSNMPTrap.setSeverity("IN");
        jobStatusSNMPTrap.setText("text");
        JobStatusSNMPTrapTest.assertTrue((boolean)this.trap.equals((Object)jobStatusSNMPTrap));
        JobStatusSNMPTrapTest.assertTrue((boolean)jobStatusSNMPTrap.equals((Object)this.trap));
        jobStatusSNMPTrap.setAgentName("different_name");
        JobStatusSNMPTrapTest.assertFalse((boolean)this.trap.equals((Object)jobStatusSNMPTrap));
        jobStatusSNMPTrap.setAgentName("agent_name");
        jobStatusSNMPTrap.setAgentID(65432L);
        JobStatusSNMPTrapTest.assertFalse((boolean)this.trap.equals((Object)jobStatusSNMPTrap));
        jobStatusSNMPTrap.setAgentID(23456L);
        jobStatusSNMPTrap.setJobName("different_job_name");
        JobStatusSNMPTrapTest.assertFalse((boolean)this.trap.equals((Object)jobStatusSNMPTrap));
        jobStatusSNMPTrap.setJobName("job_name");
        jobStatusSNMPTrap.setJobID(98765L);
        JobStatusSNMPTrapTest.assertFalse((boolean)this.trap.equals((Object)jobStatusSNMPTrap));
        jobStatusSNMPTrap.setJobID(56789L);
        jobStatusSNMPTrap.setRunID(5432L);
        JobStatusSNMPTrapTest.assertFalse((boolean)this.trap.equals((Object)jobStatusSNMPTrap));
        jobStatusSNMPTrap.setRunID(2345L);
        JobStatusSNMPTrapTest.assertTrue((boolean)this.trap.equals((Object)jobStatusSNMPTrap));
    }
}

