/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj.traps;

import com.helpsystems.common.core.util.Equal;
import com.helpsystems.enterprise.core.busobj.JobStatusCode;
import com.helpsystems.enterprise.core.busobj.traps.EnterpriseSNMPTrap;

public class JobStatusSNMPTrap
extends EnterpriseSNMPTrap {
    private String jobName;
    private long jobID;
    private String agentName;
    private long agentID;
    private long runID;
    private String jobSuiteName;
    private long jobSuiteID;
    private long jobSuiteRunID;

    public JobStatusSNMPTrap(JobStatusCode jobStatusCode) {
        if (jobStatusCode.equals(JobStatusCode.SUBMITTED)) {
            this.setType(3);
            this.setSeverity("IN");
            return;
        }
        if (jobStatusCode.equals(JobStatusCode.RUNNING)) {
            this.setType(4);
            this.setSeverity("IN");
            return;
        }
        if (jobStatusCode.equals(JobStatusCode.COMPLETED)) {
            this.setType(5);
            this.setSeverity("IN");
            return;
        }
        if (jobStatusCode.equals(JobStatusCode.ERROR) || jobStatusCode.equals(JobStatusCode.FAILED)) {
            this.setType(6);
            this.setSeverity("AT");
            return;
        }
        if (jobStatusCode.equals(JobStatusCode.CANCELED)) {
            this.setType(7);
            this.setSeverity("WR");
            return;
        }
        if (jobStatusCode.equals(JobStatusCode.CONDITION_RETRY_WAIT)) {
            this.setType(8);
            this.setSeverity("IN");
            return;
        }
        if (jobStatusCode.equals(JobStatusCode.SKIPPED)) {
            this.setType(25);
            this.setSeverity("IN");
            return;
        }
    }

    public String getAgentName() {
        return this.agentName;
    }

    public long getAgentID() {
        return this.agentID;
    }

    public String getJobName() {
        return this.jobName;
    }

    public long getJobID() {
        return this.jobID;
    }

    public long getRunID() {
        return this.runID;
    }

    public String getJobSuiteName() {
        return this.jobSuiteName;
    }

    public long getJobSuiteID() {
        return this.jobSuiteID;
    }

    public long getJobSuiteRunID() {
        return this.jobSuiteRunID;
    }

    public void setAgentID(long l) {
        this.agentID = l;
        this.addVariableBinding("1.3.6.1.4.1.6872.2.1.1.1", Long.toString(l));
    }

    public void setAgentName(String string) {
        if (string != null) {
            this.agentName = string;
            this.addVariableBinding("1.3.6.1.4.1.6872.2.1.1.2", string);
        } else {
            this.addVariableBinding("1.3.6.1.4.1.6872.2.1.1.2", " ");
        }
    }

    public void setJobID(long l) {
        this.jobID = l;
        this.addVariableBinding("1.3.6.1.4.1.6872.2.1.1.3", Long.toString(l));
    }

    public void setRunID(long l) {
        this.runID = l;
        this.addVariableBinding("1.3.6.1.4.1.6872.2.1.1.14", Long.toString(l));
    }

    public void setJobName(String string) {
        if (string != null) {
            this.jobName = string;
            this.addVariableBinding("1.3.6.1.4.1.6872.2.1.1.4", string);
        } else {
            this.addVariableBinding("1.3.6.1.4.1.6872.2.1.1.4", " ");
        }
    }

    public void setJobSuiteID(long l) {
        this.jobSuiteID = l;
        this.addVariableBinding("1.3.6.1.4.1.6872.2.1.1.18", Long.toString(l));
    }

    public void setJobSuiteRunID(long l) {
        this.jobSuiteRunID = l;
        this.addVariableBinding("1.3.6.1.4.1.6872.2.1.1.15", Long.toString(l));
    }

    public void setJobSuiteName(String string) {
        if (string != null) {
            this.jobSuiteName = string;
            this.addVariableBinding("1.3.6.1.4.1.6872.2.1.1.17", string);
        } else {
            this.addVariableBinding("1.3.6.1.4.1.6872.2.1.1.17", " ");
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof EnterpriseSNMPTrap)) {
            return false;
        }
        JobStatusSNMPTrap jobStatusSNMPTrap = (JobStatusSNMPTrap)((Object)object);
        return super.equals(object) && Equal.isEqual((Object)this.jobName, (Object)jobStatusSNMPTrap.jobName) && Equal.isEqual((long)this.jobID, (long)jobStatusSNMPTrap.jobID) && Equal.isEqual((Object)this.jobSuiteName, (Object)jobStatusSNMPTrap.jobSuiteName) && Equal.isEqual((long)this.jobSuiteID, (long)jobStatusSNMPTrap.jobSuiteID) && Equal.isEqual((long)this.runID, (long)jobStatusSNMPTrap.runID) && Equal.isEqual((long)this.agentID, (long)jobStatusSNMPTrap.agentID) && Equal.isEqual((Object)this.agentName, (Object)jobStatusSNMPTrap.agentName);
    }
}

