/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj.sap;

import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.enterprise.core.busobj.EnterpriseProxy;
import java.util.Date;
import java.util.GregorianCalendar;

public class SAPSystemSetup
extends EnterpriseProxy
implements BasicIdentifier {
    private static final long serialVersionUID = -1L;
    public static final int NONE = 0;
    public static final int ALL = 1;
    public static final int SPECIFIC = 2;
    public static final int DAYS = 0;
    public static final int HOURS = 1;
    public static final int MINUTES = 2;
    public static final int SECONDS = 3;
    public static final int DEFAULT_HISTORY_DAYS = 30;
    long sapssoid;
    int readBackType = 0;
    int readBackValue = 0;
    int readBackUnitOfMeasure = 0;
    int daysToKeepHistory = 30;

    public long getOID() {
        return this.sapssoid;
    }

    public void setOID(long l) {
        this.sapssoid = l;
    }

    public void setReadBackType(int n) {
        if (n >= 0 && n <= 2) {
            this.readBackType = n;
        }
    }

    public int getReadBacktype() {
        return this.readBackType;
    }

    public void setReadBackValue(int n) {
        if (n >= 0 && n <= 9999) {
            this.readBackValue = n;
        }
    }

    public int getReadBackValue() {
        return this.readBackValue;
    }

    public int getReadBackUnitOfMeasure() {
        return this.readBackUnitOfMeasure;
    }

    public void setReadBackUnitOfMeasure(int n) {
        this.readBackUnitOfMeasure = n;
    }

    public void setDaysToRetainHistory(int n) {
        this.daysToKeepHistory = n;
    }

    public int getDaysToRetainHistory() {
        return this.daysToKeepHistory;
    }

    public static final long getStartDate(int n, int n2, int n3, long l) {
        long l2 = 0L;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(l);
        if (n == 1) {
            return 0L;
        }
        if (n == 0) {
            if (l <= 0L) {
                return System.currentTimeMillis();
            }
            return l;
        }
        int n4 = 12;
        switch (n3) {
            case 2: {
                n4 = 12;
                break;
            }
            case 0: {
                n4 = 5;
                break;
            }
            case 1: {
                n4 = 11;
                break;
            }
            case 3: {
                n4 = 13;
            }
        }
        gregorianCalendar.add(n4, 0 - n2);
        l2 = gregorianCalendar.getTimeInMillis();
        return l2;
    }

    public static final void main(String[] stringArray) {
        System.out.println("Testing date routines...");
        Date date = new Date(System.currentTimeMillis());
        Date date2 = new Date(0L);
        int n = date.getDate();
        System.out.println("Using time of:        " + date);
        long l = SAPSystemSetup.getStartDate(0, -1, 2, date.getTime());
        System.out.println("Same time:            " + new Date(l));
        l = SAPSystemSetup.getStartDate(1, -1, 2, date.getTime());
        System.out.println("Should be Inception:  " + new Date(l).toGMTString());
        l = SAPSystemSetup.getStartDate(2, 1, 2, date.getTime());
        System.out.println("One minute ealier:    " + new Date(l));
        l = SAPSystemSetup.getStartDate(2, 2, 0, date.getTime());
        System.out.println("Two days earlier:     " + new Date(l));
        l = SAPSystemSetup.getStartDate(2, 3, 1, date.getTime());
        System.out.println("Three hours earlier:  " + new Date(l));
        l = SAPSystemSetup.getStartDate(2, 4, 3, date.getTime());
        System.out.println("Four seconds earlier: " + new Date(l));
        l = SAPSystemSetup.getStartDate(2, n, 0, date.getTime());
        String string = "";
        if (n < 10) {
            string = " ";
        }
        System.out.println(n + " days earlier:      " + string + new Date(l));
    }
}

