/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj.sap;

import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.core.busobj.EnterpriseProxy;
import com.helpsystems.enterprise.core.busobj.sap.SAPSecuritySetting;
import com.helpsystems.enterprise.core.busobj.sap.SAPXBPVersion;
import com.helpsystems.enterprise.core.busobj.sap.SAPXMIAuditLevel;
import com.helpsystems.enterprise.core.util.UnacodeMash;

public class SAPSystemDefinition
extends EnterpriseProxy {
    private static final long serialVersionUID = -1L;
    public static final int USE_DEFAULT = -1;
    private long OID;
    private String ashost;
    private String systemNumber;
    private String r3name;
    private String router;
    private boolean useSNC;
    private String sncName;
    private SAPSecuritySetting securitySetting;
    private long registeredWithSLDMS;
    private int licensePoints;
    private boolean allocateLicense;
    private boolean pollInterceptedJobs;
    private int pollInterceptIntervalSeconds;
    private long defaultEnvironmentID;
    private SAPXMIAuditLevel xMIAuditLevel = SAPXMIAuditLevel.CHANGE_0;
    private boolean pollJobs;
    private int pollJobIntervalSeconds;
    private SAPXBPVersion xbpVersion = SAPXBPVersion.XBP_20;
    private int connectionType = 1;
    private String messageServer;
    private String groupOrServer;
    private boolean useSystemSettingDefaults = false;
    private int readbackType = -1;
    private int readbackValue = 0;
    private int readbackUnitOfMeasure;
    private String sLDLocalSystemName;
    private String sLDComputerName;
    private String sLDHost;
    private int sLDPort;
    private String sLDUser;
    private String sLDEncryptedPassword;
    private String sLDPasswordSalt;
    private boolean sLDEnabled;
    private String timeZoneString;

    public void setOID(long l) {
        this.OID = l;
    }

    public long getOID() {
        return this.OID;
    }

    public void setAshost(String string) {
        this.ashost = string;
    }

    public String getAshost() {
        return this.ashost;
    }

    public void setSystemNumber(String string) {
        this.systemNumber = string;
    }

    public String getSystemNumber() {
        return this.systemNumber;
    }

    public void setR3name(String string) {
        this.r3name = string;
    }

    public String getR3name() {
        return this.r3name;
    }

    public void setRouter(String string) {
        this.router = string;
    }

    public String getRouter() {
        return this.router;
    }

    public boolean isUseSNC() {
        return this.useSNC;
    }

    public void setUseSNC(boolean bl) {
        this.useSNC = bl;
    }

    public String getSncName() {
        return this.sncName;
    }

    public void setSncName(String string) {
        this.sncName = string;
    }

    public SAPSecuritySetting getSecuritySetting() {
        return this.securitySetting;
    }

    public void setSecuritySetting(SAPSecuritySetting sAPSecuritySetting) {
        this.securitySetting = sAPSecuritySetting;
    }

    public long getRegisteredWithSLDMS() {
        return this.registeredWithSLDMS;
    }

    public void setRegisteredWithSLDMS(long l) {
        this.registeredWithSLDMS = l;
    }

    public int getLicensePoints() {
        return this.licensePoints;
    }

    public void setLicensePoints(int n) {
        this.licensePoints = n;
    }

    public boolean isAllocateLicense() {
        return this.allocateLicense;
    }

    public void setAllocateLicense(boolean bl) {
        this.allocateLicense = bl;
    }

    public boolean isPollInterceptedJobs() {
        return this.pollInterceptedJobs;
    }

    public void setPollInterceptedJobs(boolean bl) {
        this.pollInterceptedJobs = bl;
    }

    public int getPollInterceptIntervalSeconds() {
        return this.pollInterceptIntervalSeconds;
    }

    public void setPollInterceptIntervalSeconds(int n) {
        this.pollInterceptIntervalSeconds = n;
    }

    public void setDefaultEnvironmentID(long l) {
        this.defaultEnvironmentID = l;
    }

    public long getDefaultEnvironmentID() {
        return this.defaultEnvironmentID;
    }

    public SAPXMIAuditLevel getXMIAuditLevel() {
        return this.xMIAuditLevel;
    }

    public void setXMIAuditLevel(SAPXMIAuditLevel sAPXMIAuditLevel) {
        this.xMIAuditLevel = sAPXMIAuditLevel;
    }

    public boolean isPollJobs() {
        return this.pollJobs;
    }

    public void setPollJobs(boolean bl) {
        this.pollJobs = bl;
    }

    public SAPXBPVersion getXbpVersion() {
        return this.xbpVersion;
    }

    public void setXbpVersion(SAPXBPVersion sAPXBPVersion) {
        this.xbpVersion = sAPXBPVersion;
    }

    public String toString() {
        return super.toString() + " OID:" + this.OID + " ashost:" + this.ashost + " systemNumber:" + this.systemNumber + " r3name:" + this.r3name + " router:" + this.router + " useSNC:" + this.useSNC + " sncName:" + this.sncName + " securitySetting:" + this.securitySetting.name() + " registeredWithSLDMS:" + this.registeredWithSLDMS + " licensePoints:" + this.licensePoints + " allocateLicense:" + this.allocateLicense + " pollInterceptedJobs:" + this.pollInterceptedJobs + " pollInterceptIntervalSeconds:" + this.pollInterceptIntervalSeconds + " defaultEnvironmentID:" + this.defaultEnvironmentID + " xMIAuditLevel:" + this.xMIAuditLevel + " pollJobs:" + this.pollJobs + " pollJobIntervalSeconds:" + this.pollJobIntervalSeconds + " xbpVersion:" + this.xbpVersion;
    }

    public int getPollJobIntervalSeconds() {
        return this.pollJobIntervalSeconds;
    }

    public void setPollJobIntervalSeconds(int n) {
        this.pollJobIntervalSeconds = n;
    }

    public boolean isUseStartupDefaults() {
        return this.useSystemSettingDefaults;
    }

    public void setUseStartupDefaults(boolean bl) {
        this.useSystemSettingDefaults = bl;
    }

    public int getReadBackValue() {
        return this.readbackValue;
    }

    public void setStartupValue(int n) {
        this.readbackValue = n;
    }

    public int getReadbackUnitOfMeasure() {
        return this.readbackUnitOfMeasure;
    }

    public void setReadbackUnitOfMeasure(int n) {
        this.readbackUnitOfMeasure = n;
    }

    public void setReadBackType(int n) {
        this.readbackType = n;
    }

    public int getReadBackType() {
        return this.readbackType;
    }

    public String getSLDLocalSystemName() {
        return this.sLDLocalSystemName;
    }

    public void setSLDLocalSystemName(String string) {
        this.sLDLocalSystemName = string;
    }

    public String getSLDComputerName() {
        return this.sLDComputerName;
    }

    public void setSLDComputerName(String string) {
        this.sLDComputerName = string;
    }

    public String getSLDHost() {
        return this.sLDHost;
    }

    public void setSLDHost(String string) {
        this.sLDHost = string;
    }

    public int getSLDPort() {
        return this.sLDPort;
    }

    public void setSLDPort(int n) {
        this.sLDPort = n;
    }

    public String getSLDUser() {
        return this.sLDUser;
    }

    public void setSLDUser(String string) {
        this.sLDUser = string;
    }

    public String getSLDEncryptedPassword() {
        return this.sLDEncryptedPassword;
    }

    public void setSLDEncryptedPassword(String string) {
        this.sLDEncryptedPassword = string;
    }

    public String getSLDPasswordSalt() {
        return this.sLDPasswordSalt;
    }

    public void setSLDPasswordSalt(String string) {
        this.sLDPasswordSalt = string;
    }

    public String getDecryptedSLDPassword() throws ResourceUnavailableException {
        String string = UnacodeMash.unMash(this.getSLDEncryptedPassword());
        return string.replaceAll(this.getSLDPasswordSalt(), "");
    }

    public boolean isSLDEnabled() {
        return this.sLDEnabled;
    }

    public void setSLDEnabled(boolean bl) {
        this.sLDEnabled = bl;
    }

    public String getTimeZoneString() {
        return this.timeZoneString;
    }

    public void setTimeZoneString(String string) {
        this.timeZoneString = string;
    }

    public String getMessageServer() {
        return this.messageServer;
    }

    public int getConnectionType() {
        return this.connectionType;
    }

    public void setConnectionType(int n) {
        this.connectionType = n;
    }

    public void setMessageServer(String string) {
        this.messageServer = string;
    }

    public String getGroupOrServer() {
        return this.groupOrServer;
    }

    public void setGroupOrServer(String string) {
        this.groupOrServer = string;
    }

    public int getPollJobIntervalInMinutes() {
        return this.pollJobIntervalSeconds / 60;
    }

    public int getPollInterceptIntervalInMinutes() {
        return this.pollInterceptIntervalSeconds / 60;
    }

    public String getSLDURLString() {
        return "http://" + this.sLDHost + ":" + this.sLDPort + "/sld/ds";
    }
}

