/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj.sap;

import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.core.busobj.sap.SAPObject;
import com.helpsystems.enterprise.core.busobj.sap.SAPSystemDefinition;
import com.helpsystems.enterprise.core.busobj.sap.SAPSystemEnvironment;
import com.helpsystems.enterprise.core.busobj.sap.SAPXBPVersion;
import com.helpsystems.enterprise.core.busobj.sap.SAPXMIAuditLevel;
import com.helpsystems.enterprise.core.util.UnacodeMash;

public class SAPSystem
implements SAPObject {
    private static final long serialVersionUID = -1L;
    public static final int CUSTOM_APPLICATION_SERVER = 1;
    public static final int GROUP_SERVER_SELECTION = 2;
    private SAPSystemDefinition sapSystemDefinition;
    private SAPSystemEnvironment sapSystemEnvironment;

    public SAPSystem(SAPSystemDefinition sAPSystemDefinition, SAPSystemEnvironment sAPSystemEnvironment) {
        this.sapSystemDefinition = sAPSystemDefinition;
        this.sapSystemEnvironment = sAPSystemEnvironment;
    }

    public String getAshost() {
        return this.sapSystemDefinition.getAshost();
    }

    public String getClient() {
        return this.sapSystemEnvironment.getClientCode();
    }

    public String getSystemNumber() {
        return this.sapSystemDefinition.getSystemNumber();
    }

    public String getR3name() {
        return this.sapSystemDefinition.getR3name();
    }

    public String getUser() {
        return this.sapSystemEnvironment.getSapUserName();
    }

    public String getEncryptedPassword() {
        return this.sapSystemEnvironment.getEncryptedPassword();
    }

    public String getPasswordSalt() {
        return this.sapSystemEnvironment.getPasswordSalt();
    }

    public String getDecryptedPassword() throws ResourceUnavailableException {
        if (this.sapSystemEnvironment.isPasswordEncrypted()) {
            String string = UnacodeMash.unMash(this.getEncryptedPassword());
            return string.replaceAll(this.getPasswordSalt(), "");
        }
        return this.sapSystemEnvironment.getEncryptedPassword();
    }

    public String getLanguage() {
        return this.sapSystemEnvironment.getLanguageCode();
    }

    public String getRouter() {
        return this.sapSystemDefinition.getRouter();
    }

    public int getSAPConnectionType() {
        return this.sapSystemDefinition.getConnectionType();
    }

    public String getMessageServer() {
        return this.sapSystemDefinition.getMessageServer();
    }

    public String getGroupOrServer() {
        return this.sapSystemDefinition.getGroupOrServer();
    }

    public String getUniqueIdentifier() {
        return this.getSapSystemName() + ":" + this.sapSystemEnvironment.getName() + ":" + this.sapSystemEnvironment.getSapUserName() + ":" + this.sapSystemEnvironment.getClientCode() + ":" + this.sapSystemEnvironment.getLanguageCode();
    }

    public String toString() {
        return " system name = '" + this.getSapSystemName() + "' description = '" + this.getDescription() + "' ashost = '" + this.getAshost() + "' systemNumber = '" + this.getSystemNumber() + "' r3name = '" + this.getR3name() + "' router = '" + this.getRouter() + "' connectionType = '" + this.getSAPConnectionType() + "' messageServer = '" + this.getMessageServer() + "' groupOrServer = '" + this.getGroupOrServer() + "' client = '" + this.getClient() + "' user = '" + this.getUser() + "' encryptedPassword = '" + this.getEncryptedPassword() + "' language = '" + this.getLanguage() + "' uniqueIdentifer = '" + this.getUniqueIdentifier() + "'";
    }

    public SAPXMIAuditLevel getXMIAuditLevel() {
        return this.sapSystemDefinition.getXMIAuditLevel();
    }

    public SAPXBPVersion getXBPVersion() {
        return this.sapSystemDefinition.getXbpVersion();
    }

    public long getSystemDefinitionID() {
        return this.sapSystemDefinition.getOID();
    }

    public long getSystemEnvironmentID() {
        return this.sapSystemEnvironment.getOID();
    }

    public String getSapSystemName() {
        return this.sapSystemDefinition.getName();
    }

    public String getDescription() {
        return this.sapSystemDefinition.getDescription();
    }

    public String getTimeZoneString() {
        return this.sapSystemDefinition.getTimeZoneString();
    }
}

