/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj.sap;

import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.scheduler.PersistableEnum;
import com.helpsystems.enterprise.core.scheduler.PersistanceCodeToEnumMap;

public enum SAPProcessStatus implements PersistableEnum<String>
{
    FAILED("R"),
    FINISHED("G"),
    JOB_FINISHED("F"),
    CANCELLED("X"),
    ACTIVE("A"),
    UNKNOWN("");

    private String persistanceCode;
    private static PersistanceCodeToEnumMap<String, SAPProcessStatus> map;

    private SAPProcessStatus(String string2) {
        this.persistanceCode = string2;
    }

    @Override
    public String persistanceCode() {
        return this.persistanceCode;
    }

    public static SAPProcessStatus persistanceCodeToEnum(String string) {
        SAPProcessStatus sAPProcessStatus = map.get(string);
        if (sAPProcessStatus == null) {
            String string2 = MessageUtil.formatMsg((String)"There is no {0} enum constant associated with code: {1}.", (Object[])new Object[]{map.getEnumName(), string});
            throw new IllegalStateException(string2);
        }
        return sAPProcessStatus;
    }

    public boolean isTerminal() {
        return this.equals(FAILED) || this.equals(FINISHED) || this.equals(JOB_FINISHED) || this.equals(CANCELLED) || this.equals(UNKNOWN);
    }

    public boolean isFailure() {
        return this.equals(CANCELLED) || this.equals(FAILED);
    }

    static {
        map = new PersistanceCodeToEnumMap((Enum[])SAPProcessStatus.values());
    }
}

