/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj.sap;

import com.helpsystems.enterprise.core.busobj.sap.SAPField;
import com.helpsystems.enterprise.core.busobj.sap.SAPParameters;
import java.security.InvalidParameterException;

public class SAPJobSelectParameters
extends SAPParameters {
    private static final long serialVersionUID = -1L;
    public static final String STRUCTURE_NAME = "BAPIXMJSEL";
    private String jobName;
    private String jobCount;
    private String jobGroup;
    private String userName;
    private String schedul;
    private String prelim;
    private String ready;
    private String running;
    private String finished;
    private String aborted;
    private String fromDate;
    private String eventID;

    public SAPJobSelectParameters() {
    }

    public SAPJobSelectParameters(String string, String string2) {
        this.initDefaults();
        this.setField(JobSelectField.JOBNAME, string);
        this.setField(JobSelectField.JOBCOUNT, string2);
        this.setField(JobSelectField.USERNAME, "*");
    }

    public SAPJobSelectParameters(String string, String string2, String string3) {
        this.initDefaults();
        this.setField(JobSelectField.JOBNAME, string);
        this.setField(JobSelectField.JOBCOUNT, string2);
        this.setField(JobSelectField.USERNAME, string3);
    }

    private void initDefaults() {
        this.setField(JobSelectField.JOBNAME, JobSelectField.JOBNAME.defaultValue);
        this.setField(JobSelectField.JOBCOUNT, JobSelectField.JOBCOUNT.defaultValue);
        this.setField(JobSelectField.JOBGROUP, JobSelectField.JOBGROUP.defaultValue);
        this.setField(JobSelectField.USERNAME, JobSelectField.USERNAME.defaultValue);
        this.setField(JobSelectField.SCHEDUL, JobSelectField.SCHEDUL.defaultValue);
        this.setField(JobSelectField.PRELIM, JobSelectField.PRELIM.defaultValue);
        this.setField(JobSelectField.READY, JobSelectField.READY.defaultValue);
        this.setField(JobSelectField.RUNNING, JobSelectField.RUNNING.defaultValue);
        this.setField(JobSelectField.FINISHED, JobSelectField.FINISHED.defaultValue);
        this.setField(JobSelectField.ABORTED, JobSelectField.ABORTED.defaultValue);
        this.setField(JobSelectField.FROM_DATE, JobSelectField.FROM_DATE.defaultValue);
        this.setField(JobSelectField.EVENTID, JobSelectField.EVENTID.defaultValue);
    }

    public void setField(JobSelectField jobSelectField, Object object) {
        switch (jobSelectField) {
            case JOBNAME: {
                this.setJobName(this.getStringFromValue(object, jobSelectField));
                break;
            }
            case JOBCOUNT: {
                this.setJobCount(this.getStringFromValue(object, jobSelectField));
                break;
            }
            case JOBGROUP: {
                this.setJobGroup(this.getStringFromValue(object, jobSelectField));
                break;
            }
            case USERNAME: {
                this.setUserName(this.getStringFromValue(object, jobSelectField));
                break;
            }
            case SCHEDUL: {
                this.setSchedul(this.getStringFromValue(object, jobSelectField));
                break;
            }
            case PRELIM: {
                this.setPrelim(this.getStringFromValue(object, jobSelectField));
                break;
            }
            case READY: {
                this.setReady(this.getStringFromValue(object, jobSelectField));
                break;
            }
            case RUNNING: {
                this.setRunning(this.getStringFromValue(object, jobSelectField));
                break;
            }
            case FINISHED: {
                this.setFinished(this.getStringFromValue(object, jobSelectField));
                break;
            }
            case ABORTED: {
                this.setAborted(this.getStringFromValue(object, jobSelectField));
                break;
            }
            case FROM_DATE: {
                this.setFromDate(this.getStringFromValue(object, jobSelectField));
                break;
            }
            case EVENTID: {
                this.setEventID(this.getStringFromValue(object, jobSelectField));
                break;
            }
            default: {
                throw new InvalidParameterException("The field " + jobSelectField + " is not defined in the setField method.");
            }
        }
    }

    @Override
    public String getBooleanFieldAsString(SAPField sAPField) {
        throw new IllegalArgumentException("The SAP structure BAPIXMJSEL does not contain any boolean fields.");
    }

    @Override
    public Object getField(SAPField sAPField) {
        JobSelectField jobSelectField = (JobSelectField)sAPField;
        switch (jobSelectField) {
            case JOBNAME: {
                return this.getJobName();
            }
            case JOBCOUNT: {
                return this.getJobCount();
            }
            case JOBGROUP: {
                return this.getJobGroup();
            }
            case USERNAME: {
                return this.getUserName();
            }
            case SCHEDUL: {
                return this.getSchedul();
            }
            case PRELIM: {
                return this.getPrelim();
            }
            case READY: {
                return this.getReady();
            }
            case RUNNING: {
                return this.getRunning();
            }
            case FINISHED: {
                return this.getFinished();
            }
            case ABORTED: {
                return this.getAborted();
            }
            case FROM_DATE: {
                return this.getFromDate();
            }
            case EVENTID: {
                return this.getEventID();
            }
        }
        throw new InvalidParameterException("The field " + jobSelectField + " is not defined in the getField method.");
    }

    private String getJobName() {
        return this.jobName;
    }

    private void setJobName(String string) {
        this.jobName = string;
    }

    private String getJobCount() {
        return this.jobCount;
    }

    private void setJobCount(String string) {
        this.jobCount = string;
    }

    private String getJobGroup() {
        return this.jobGroup;
    }

    private void setJobGroup(String string) {
        this.jobGroup = string;
    }

    private String getUserName() {
        return this.userName;
    }

    private void setUserName(String string) {
        this.userName = string;
    }

    private String getSchedul() {
        return this.schedul;
    }

    private void setSchedul(String string) {
        this.schedul = string;
    }

    private String getPrelim() {
        return this.prelim;
    }

    private void setPrelim(String string) {
        this.prelim = string;
    }

    private void setFromDate(String string) {
        this.fromDate = string;
    }

    private String getFromDate() {
        return this.fromDate;
    }

    private void setEventID(String string) {
        this.eventID = string;
    }

    private String getEventID() {
        return this.eventID;
    }

    private void setReady(String string) {
        this.ready = string;
    }

    private String getReady() {
        return this.ready;
    }

    private void setRunning(String string) {
        this.running = string;
    }

    private String getRunning() {
        return this.running;
    }

    private void setFinished(String string) {
        this.finished = string;
    }

    private String getFinished() {
        return this.finished;
    }

    private void setAborted(String string) {
        this.aborted = string;
    }

    private String getAborted() {
        return this.aborted;
    }

    public String toString() {
        return "jobName:" + this.jobName + " jobCount:" + this.jobCount + " userName:" + this.userName + " schedul:" + this.schedul + " prelim:" + this.prelim + " ready:" + this.ready + " running:" + this.running + " finished:" + this.finished + " aborted:" + this.aborted + " fromDate:" + this.fromDate + " eventID:" + this.eventID;
    }

    public void setAllStatuses(boolean bl) {
        String string = "X";
        if (!bl) {
            string = "";
        }
        this.setField(JobSelectField.PRELIM, string);
        this.setField(JobSelectField.SCHEDUL, string);
        this.setField(JobSelectField.READY, string);
        this.setField(JobSelectField.RUNNING, string);
        this.setField(JobSelectField.FINISHED, string);
        this.setField(JobSelectField.ABORTED, string);
    }

    public static enum JobSelectField implements SAPField
    {
        JOBNAME(SAPField.ParameterType.STRING, 1, 32, "", "Job Name"),
        JOBCOUNT(SAPField.ParameterType.STRING, 1, 8, "", "Job Count"),
        JOBGROUP(SAPField.ParameterType.STRING, 0, 12, "", "Job Group"),
        USERNAME(SAPField.ParameterType.STRING, 0, 12, "", "User Name"),
        SCHEDUL(SAPField.ParameterType.STRING, 0, 1, "", "Scheduled"),
        PRELIM(SAPField.ParameterType.STRING, 0, 1, "", "Preliminary"),
        READY(SAPField.ParameterType.STRING, 0, 1, "", "Ready"),
        RUNNING(SAPField.ParameterType.STRING, 0, 1, "", "Running"),
        FINISHED(SAPField.ParameterType.STRING, 0, 1, "", "Finished"),
        ABORTED(SAPField.ParameterType.STRING, 0, 1, "", "Aborted"),
        FROM_DATE(SAPField.ParameterType.DATS, 0, 8, "", "From Date"),
        EVENTID(SAPField.ParameterType.STRING, 0, 32, "", "Event ID");

        private SAPField.ParameterType parameterType;
        private int maxValue;
        private int minValue;
        private Object defaultValue;
        private String description;

        private JobSelectField(SAPField.ParameterType parameterType, int n2, int n3, Object object, String string2) {
            this.parameterType = parameterType;
            this.minValue = n2;
            this.maxValue = n3;
            this.defaultValue = object;
            this.description = string2;
        }

        @Override
        public SAPField.ParameterType getParameterType() {
            return this.parameterType;
        }

        @Override
        public int getMinValue() {
            return this.minValue;
        }

        @Override
        public int getMaxValue() {
            return this.maxValue;
        }

        @Override
        public Object getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public String getName() {
            return this.name();
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

