/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj.informatica;

import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.enterprise.core.scheduler.AbstractBusinessObject;
import com.helpsystems.enterprise.core.util.UnacodeMash;
import org.apache.log4j.Logger;

public class InformaticaRepository
extends AbstractBusinessObject
implements BasicIdentifier {
    private static final long serialVersionUID = 5825077097049477945L;
    private long OID;
    private String systemName;
    private int port = 7333;
    private String domain;
    private String repoName;
    private String infaUserName;
    private String securityDomain;
    private String passwordSalt;
    private String encryptedPassword;
    private boolean useHTTPS = false;
    private static String HTTP_PROTOCOL = "http";
    private static String HTTPS_PROTOCOL = "https";
    private static String COLON = ":";
    private static String REPO_META_DATA = "/wsh/services/BatchServices/Metadata";
    private static String DOUBLE_SLASH = "//";
    private static String DI_META_DATA = "/wsh/services/BatchServices/DataIntegration";
    private static final Logger LOGGER = Logger.getLogger(InformaticaRepository.class);

    public long getOID() {
        return this.OID;
    }

    public void setOID(long l) {
        this.OID = l;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public void setSystemName(String string) {
        this.systemName = string;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String string) {
        this.domain = string;
    }

    public String getRepoName() {
        return this.repoName;
    }

    public void setRepoName(String string) {
        this.repoName = string;
    }

    public String getInfaUserName() {
        return this.infaUserName;
    }

    public void setInfaUserName(String string) {
        this.infaUserName = string;
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public void setSecurityDomain(String string) {
        this.securityDomain = string;
    }

    public String getPasswordSalt() {
        return this.passwordSalt;
    }

    public void setPasswordSalt(String string) {
        this.passwordSalt = string;
    }

    public String getEncryptedPassword() {
        return this.encryptedPassword;
    }

    public void setEncryptedPassword(String string) {
        this.encryptedPassword = string;
    }

    public String getRepoWSHUrl() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.useHTTPS) {
            stringBuilder.append(HTTPS_PROTOCOL);
        } else {
            stringBuilder.append(HTTP_PROTOCOL);
        }
        stringBuilder.append(COLON);
        stringBuilder.append(DOUBLE_SLASH);
        stringBuilder.append(this.systemName);
        stringBuilder.append(COLON);
        stringBuilder.append(this.port);
        stringBuilder.append(REPO_META_DATA);
        return stringBuilder.toString();
    }

    public String getDIWSHUrl() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.useHTTPS) {
            stringBuilder.append(HTTPS_PROTOCOL);
        } else {
            stringBuilder.append(HTTP_PROTOCOL);
        }
        stringBuilder.append(COLON);
        stringBuilder.append(DOUBLE_SLASH);
        stringBuilder.append(this.systemName);
        stringBuilder.append(COLON);
        stringBuilder.append(this.port);
        stringBuilder.append(DI_META_DATA);
        return stringBuilder.toString();
    }

    public String getDecryptedPassword() {
        String string = null;
        try {
            string = UnacodeMash.unMash(this.getEncryptedPassword());
            string = string.replaceAll(this.getPasswordSalt(), "");
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            LOGGER.error((Object)"An error occurred while decrypting a password.", (Throwable)resourceUnavailableException);
        }
        return string;
    }

    public boolean isUseHTTPS() {
        return this.useHTTPS;
    }

    public void setUseHTTPS(boolean bl) {
        this.useHTTPS = bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append("Name = ");
        stringBuilder.append(super.getName());
        stringBuilder.append("Description = ");
        stringBuilder.append(super.getDescription());
        stringBuilder.append("SystemName = ");
        stringBuilder.append(this.systemName);
        stringBuilder.append("port = ");
        stringBuilder.append(this.port);
        stringBuilder.append("domain = ");
        stringBuilder.append(this.domain);
        stringBuilder.append("repoName = ");
        stringBuilder.append(this.repoName);
        stringBuilder.append("InfaUserName = ");
        stringBuilder.append(this.infaUserName);
        stringBuilder.append("SecurityDomain = ");
        stringBuilder.append(this.securityDomain);
        stringBuilder.append("EncryptedPassword = ");
        stringBuilder.append(this.encryptedPassword);
        stringBuilder.append("PasswrdSalt = ");
        stringBuilder.append(this.passwordSalt);
        stringBuilder.append("SystemName = ");
        return stringBuilder.toString();
    }
}

